#ifndef MHI_H
#define MHI_H

#include "opencv/cv.h"
#include "opencv/highgui.h"
#include "time.h"
#include <QTime>

class Mhi
{
public:
    Mhi(int );

    void update_mhi( IplImage* src, IplImage* dst_color, IplImage* dst_gray,
                               int threshold, double MHI_DURATION);

private:
    int Nframes;

    // ring image buffer
    IplImage **buf;
    int last;

    // temporary images
    IplImage *mhi; // MHI
    IplImage *mask; // valid orientation mask

    CvMemStorage* storage; // temporary storage
};

#endif // MHI_H
