#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>

#include <opencv/cv.h>
#include <opencv/highgui.h>

#include "mhi.h"
#include "dialogajuda.h"
#include "dialogsobre.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    
public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    
    void setLastDir(const char* dir);

private slots:

    void preview_quad();

    void on_pushButton_down_horizontal_clicked();

    void on_pushButton_up_horizontal_clicked();

    void on_pushButton_down_vertical_clicked();

    void on_pushButton_up_vertical_clicked();

    void on_pushButton_load_clicked();

    void on_spinBox_buffer_size_valueChanged(int arg1);

    void on_pushButton_qt_clicked();

    void on_spinBox_fps_valueChanged(int arg1);

    void on_horizontalSlider_threshold_MHI_valueChanged(int value);

    void save_results();

    void show_about();

    void show_help();

    void show_doc();


private:
    Ui::MainWindow *ui;

    QString dir;
    QString dir_aux;

    DialogAjuda *obj_ajuda;
    DialogSobre *obj_sobre;

    bool not_first;

    // OpenCV objects
    IplImage *img;
    IplImage *aux;
    IplImage *sat;
    IplImage *cont;
    IplImage *homo;

    // QLists
    QList<int> integerDivisors_vertical;
    QList<int> integerDivisors_horizontal;
    QStringList filesName;
    QString lastdir;

    // Variables
    int pos_list_horizontal;
    int pos_list_vertical;

    // Functions
    IplImage* quadImage(IplImage *image, int horizontal_step,
                          int vertical_step);
    IplImage* saturation_test(IplImage* image, int percentagem);
    IplImage* contrast_test(IplImage* image);
    IplImage* coloreImagem(IplImage *image);
    IplImage* homogeneity_test(int lar_ROI, int alt_ROI);
    IplImage* scale();

    QList<int> findIntegerDivisors(int number);
    QList<int> histogram_threshold(IplImage *image, int threshold_min,
                                   int threshold_max);

    int color_situation_check(IplImage* image, int percentagem,
                              int total_pixel_ROI);

    double calc_homogeneity(QList<int> list);

    void check_pushbuttons();
    void initialize();

};

#endif // MAINWINDOW_H
