#include <QApplication>
#include "mainwindow.h"

void help(void);

int main(int argc, char *argv[])
{
    QApplication a(argc, argv);
    MainWindow w;

    if(argc>=2)
    {
        if(strcmp(argv[1],"-v")==0)
        {
            printf("%s %s\n",APP_TARGET,APP_VERSION);
            return EXIT_SUCCESS;
        }
        if(strcmp(argv[1],"-h")==0)
        {
            help();
            return EXIT_SUCCESS;
        }
    
        w.setLastDir(argv[1]);

    }

    w.show();
    
    return a.exec();
}

void help(void)
{
    printf("\t\n");
    printf("%s -[vh] [directory]\n",APP_TARGET);
    printf("\t\n");
    printf("\t-v\tReturns the program name and version.\n");
    printf("\t-h\tReturns this help text.\n");
    printf("\t\n");
    printf("Examples:\t\n");
    #ifdef __OS_UNIX__
    printf("\t%s /route/to/photos/directory\n",APP_TARGET);
    #endif
    #ifdef __OS_WINDOWS__
    printf("\t%s C:\\route\\to\\photos\\directory\n",APP_TARGET);
    #endif
    printf("\t%s -v\n",APP_TARGET);
    printf("\t%s -h\n",APP_TARGET);
    printf("\t\n");
}
