/**CFile*******************************************************************
  PackageName [Bdd Scout]
  Synopsis    [Bdd Scout]

  FileName    [bddscoutIFIP.c]
  Revision    [$Revision: 29 $]
  Date        [$Date: 2013-04-05 11:18:53 +0200 (pet, 05 apr 2013) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description []
  SeeAlso     [bddscout.h]

  Copyright   [This file is part of Bdd Scout package.
               Copyright (C) 2008, 2013 UM-FERI
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               Bdd Scout is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               Bdd Scout is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

#include "bddscout.h"

/* on tcl 8.3 use #define USECONST */
/* on tcl 8.4 use #define USECONST const*/
/* this is defined in Makefile */

/*-----------------------------------------------------------------------*/
/* Structure declarations                                                */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Variable declarations                                                 */
/*-----------------------------------------------------------------------*/

int SCAN_RESULT; /* used in readln macro */

/*-----------------------------------------------------------------------*/
/* Functions                                                             */
/*-----------------------------------------------------------------------*/

/**Function****************************************************************
  Synopsis    [Function Bddscout_BenchmarkIFIP]
  Description []
  SideEffects [Implemented long time ago (1995). Not comprehensible.]
  SeeAlso     []
  ************************************************************************/

#define readln(f,s) SCAN_RESULT = fscanf(f," %[^\n] ",s)

static Biddy_String makeFunction(FILE *f, Biddy_String line, Biddy_String prefix);
static Biddy_String upCase(Biddy_String s);

Biddy_String
Bddscout_BenchmarkIFIP(FILE *f)
{
  Biddy_String line;
  Biddy_String s1;
  Biddy_String var;
  Biddy_String name;
  Biddy_String *nameTable;
  int nameNumber;
  Biddy_Boolean *eqvTable;
  Biddy_Boolean ok,usedcs;
  Biddy_Edge bdd1,bdd2,dcs;
  Biddy_Edge tmp;
  Biddy_String report;
  int len;
  int i,n;

  line = (Biddy_String) malloc(4096);

  /* @BE1 */

  do {
    readln(f,line);
  } while (strstr(line, "@BE1") != line);

  do {
    readln(f,line);
  } while (strstr(line,"@invar") != line);

  /* @invar  */

  readln(f,line);
  s1 = strdup(line);
  readln(f,line);

  while (strstr(line,"@sub") != line &&
         strstr(line,"@out") != line)
  {
    n = strlen(s1)+strlen(line)+1+1;
    s1 = (char *) realloc(s1, sizeof(char) * n);
    strcat(s1," ");
    strcat(s1,line);
    readln(f,line);
  }

  upCase(s1);

  var = strtok(&s1[1]," \t)");
  while (var) {

    /*
    printf("VARIABLE: <%s>\n",var);
    */

    if (Bddscout_FindFormula(var,&tmp)) {
      printf("Warning: Variable %s will not be used because Boolean function with the same name already exists.\n",var);
    } else {
      Biddy_FoaTerminal(var);
    }
    var = strtok(NULL," \t)");
   }

  free(s1);

  while (strstr(line,"@sub") != line &&
         strstr(line,"@out") != line)
  {
    readln(f,line);
  }

  /* @sub */

  if (strstr(line,"@sub") == line) {
    readln(f,line);
    do {
      name = makeFunction(f,line,NULL);
      free(name);
    } while (strstr(line,"@out") != line);
  }

  /* @out */

  nameTable = NULL;
  nameNumber = 0;

  readln(f,line);
  do {
    name = makeFunction(f,line,(Biddy_String) "BE1");

    if (!nameTable) {
      nameTable = (Biddy_String *) malloc(sizeof(Biddy_String));
    } else {
      nameTable = (Biddy_String *) realloc(nameTable,sizeof(Biddy_String)*(nameNumber+1));
    }
    nameTable[nameNumber] = strdup(&name[4]);
    nameNumber++;
    free(name);

  } while (strstr(line,"@end") != line);


  /* @BE2 */

  do {
    readln(f,line);
  } while (strstr(line,"@BE2") != line);


  do {
    readln(f,line);
  } while (strstr(line,"@sub") != line &&
           strstr(line,"@out") != line);

  /* @sub */

  if (strstr(line,"@sub") == line) {
    readln(f,line);
    do {
      name = makeFunction(f,line,NULL);
      free(name);
    } while (strstr(line,"@out") != line);
  }

  /* @out */

  readln(f,line);
  do {
    name = makeFunction(f,line,(Biddy_String) "BE2");

    ok = FALSE;
    for (i=0; (i<nameNumber) && (!ok); i++) {
      if (!strcmp(&name[4],nameTable[i])) {
        ok = TRUE;
      }
    }

    free(name);
    if (!ok) printf("ERROR: missing function in @BE2");

  } while (strstr(line, "@end") != line);

  /* @DCS */

  usedcs = FALSE;
  if (!feof(f)) {
    do {
      readln(f, line);
    } while (!feof(f) && strstr(line,"@DCS") != line);
  }

  if (strstr(line, "@DCS") == line) {
    readln(f,line);
    name = makeFunction(f,line,(Biddy_String) "DCS");
    free(name);
    usedcs = TRUE;
  }

  if (line) free(line);

  /* CHECK EQUIVALENCE */

  if (usedcs) {
    Bddscout_FindFormula((Biddy_String) "DCS",&dcs);
  } else {
    dcs = biddy_zero;
  }

  ok = TRUE;
  eqvTable = (Biddy_Boolean *) malloc(sizeof(Biddy_Boolean)*nameNumber);
  for (i=0; i<nameNumber; i++) {
    len = strlen(nameTable[i])+4+1;
    name = strdup("BE1_");
    name = (Biddy_String) realloc(name,len);
    strcat(name,nameTable[i]);
    Bddscout_FindFormula(name,&bdd1);
    name[2] = '2';
    Bddscout_FindFormula(name,&bdd2);
    free(name);
    eqvTable[i] = Biddy_isEqv(
      Biddy_ITE(dcs,biddy_zero,bdd1),
      Biddy_ITE(dcs,biddy_zero,bdd2)
    );
    if (!eqvTable[i]) ok = FALSE;
  }

  report = (Biddy_String) malloc(255);
  if (!ok) {
    sprintf(report,"%s 0 %d %d ",Tcl_GetHostName(),Biddy_NodeTableMax(),Biddy_NodeTableGarbage());
  } else {
    sprintf(report,"%s 1 %d %d ",Tcl_GetHostName(),Biddy_NodeTableMax(),Biddy_NodeTableGarbage());
  }

  for (i=0; i<nameNumber; i++) {
    len = strlen(report)+strlen(nameTable[i])+3+1;
    report = (Biddy_String) realloc(report,len);
    strcat(report,nameTable[i]);
    strcat(report," ");
    if (eqvTable[i]) {
      strcat(report,"1");
    } else {
      strcat(report,"0");
    }
    strcat(report," ");
  }

  free(nameTable);
  free(eqvTable);

  return report;
}

static Biddy_String
makeFunction(FILE *f, Biddy_String line, Biddy_String prefix)
{
  Biddy_Edge fun;
  Biddy_String s1,s2,name;
  unsigned int len;
  unsigned int x,y;

  x = strcspn(line, "=");
  if (x == strlen(line)) {
    s1 = NULL;                 /* s1 = left part of the expression */
    s2 = strdup(line);         /* s2 = right part of the expression */
  } else {

    s1 = (Biddy_String) strdup(line);
    s1[x] = 0; /* strndup is not supported everywhere */
    if (x != strlen(line)-1) {
      y = strspn(&line[x+1], " \t");
      s2 = strdup(&line[x+1+y]);
    } else {
      s2 = NULL;
    }
  }

  if (!s1) {
    name = (Biddy_String) strdup(prefix);
  } else {
    x = strspn(s1," \t");
    y = strcspn(&s1[x]," \t\n");

    if (!prefix) {
      name = (Biddy_String) strdup(&s1[x]);
      name[y] = 0; /* strndup is not supported everywhere */
    } else {
      len = strlen(prefix)+1+y+1;
      name = strdup(prefix);
      name = (Biddy_String) realloc(name,len);
      strcat(name,"_");
      strncat(name,&s1[x],y);
      free(s1);
    }
  }

  upCase(name);

  if (!feof(f)) {
    readln(f,line);
    x = strcspn(line,"=");
  } else {
    strcpy(line,"@end");
    x = 0;
  }
  while (x == strlen(line) &&
         strstr(line, "@out") != line &&
         strstr(line, "@end") != line)
  {
    if (s2 != NULL) {
      len = strlen(s2)+strlen(line)+1;
      s2 = (Biddy_String) realloc(s2, len+1);
      strcat(s2," ");
      strcat(s2,line);
    } else {
      s2 = strdup(line);
    }

    if (!feof(f)) {
      readln(f,line);
      x = strcspn(line, "=");
    } else {
      strcpy(line,"@end");
      x = 0;
    }
  }

  upCase(s2);

  /*
  printf("FUNCTION NAME: <%s>\n",name);
  printf("FUNCTION DEF: <%s>\n",s2);
  */

  fun = Bddscout_ParseString(s2);

  /* USE THIS TO ENABLE GARBAGE COLLECTION */
  /*
  Biddy_Fortify(fun);
  Biddy_IncCounter();
  */

  Bddscout_AddFormula(name,fun);
  free(s2);

  return name;
}

static Biddy_String
upCase(Biddy_String s)
{
  Biddy_String p;

  p = s;
  while (p[0]) {
    p[0] = toupper(p[0]);
    p = &p[1];
  }
  return s;
}

/*-----------------------------------------------------------------------*/
/* TCL related functions                                                 */
/*-----------------------------------------------------------------------*/

/**Function****************************************************************
  Synopsis    [Function BddscoutIfip_Init.]
  Description [This function is used by Tcl/Tk only.]
  SideEffects []
  SeeAlso     []
  ************************************************************************/

static int BddscoutParseIfipCmd(ClientData clientData, Tcl_Interp *interp,
                          int argc, USECONST char **argv);

#ifdef __cplusplus
extern "C" {
#endif

int
Bddscoutifip_Init(Tcl_Interp *interp)
{

#ifdef USE_TCL_STUBS
  if (Tcl_InitStubs(interp, "8.1", 0) == NULL) {
    return TCL_ERROR;
  }
#endif

#ifdef USE_BDDSCOUT_STUBS
  if (Bddscout_InitStubs(interp, (char *) "1.0", 0) == NULL) {
    return TCL_ERROR;
  }
#endif

  Tcl_CreateCommand(interp, "bddscout_parseIFIP", BddscoutParseIfipCmd,
                     (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);

  return Tcl_PkgProvide(interp, "bddscoutIFIP", "1.0");
}

#ifdef __cplusplus
}
#endif

static int
BddscoutParseIfipCmd(ClientData clientData, Tcl_Interp *interp, int argc,
                    USECONST char **argv)
{
  Biddy_String s1;
  FILE *funfile;
  Biddy_String report;

  if (argc != 2) {
    Tcl_SetResult(interp, (char *) "wrong # args", TCL_STATIC);
    return TCL_ERROR;
  }

  s1 = strdup(argv[1]);

  funfile = fopen(s1,"r");
  if (!funfile) {
    printf("BddscoutParseIfipCmd: File error (%s)!\n",s1);
    return TCL_ERROR;
  }

  report = Bddscout_BenchmarkIFIP(funfile);

  fclose(funfile);

  free(s1);

  Tcl_SetResult(interp, report, TCL_VOLATILE);
  free(report);

  return TCL_OK;
}
