#! /bin/sh
# check script for Arg_parser - POSIX/GNU command-line argument parser.
# Copyright (C) 2011-2025 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute, and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
PARSER="${objdir}"/arg_parser
CPARSER="${objdir}"/carg_parser
framework_failure() { echo "failure in testing framework" ; exit 1 ; }

if [ ! -f "${PARSER}" ] || [ ! -x "${PARSER}" ] ; then
	echo "${PARSER}: cannot execute"
	exit 1
fi
if [ ! -f "${CPARSER}" ] || [ ! -x "${CPARSER}" ] ; then
	echo "${CPARSER}: cannot execute"
	exit 1
fi

if [ -d tmp ] ; then rm -rf tmp ; fi
mkdir tmp
cd "${objdir}"/tmp || framework_failure

in="${testdir}"/test.txt
fail=0
test_failed() { fail=1 ; printf "\n$1" ; [ -z "$2" ] || printf "($2)" ; }

printf "testing arg_parser-%s..." "$2"

for i in "${PARSER}" "${CPARSER}" ; do
  "$i" -h > /dev/null || test_failed $LINENO "$i"
  "$i" --help > /dev/null || test_failed $LINENO "$i"
  "$i" -V > /dev/null || test_failed $LINENO "$i"
  "$i" --version > /dev/null || test_failed $LINENO "$i"
  "$i" -h -v > /dev/null || test_failed $LINENO "$i"
  "$i" -v -h > /dev/null || test_failed $LINENO "$i"

  "$i" --append -a -b 5 --block 10 -c -carg --casual= --casual=arg -e "" \
       -earg --empty= --emp=arg -H -o file --l -q --verbos file1 file2 > out ||
    test_failed $LINENO "$i"
  cmp "${in}" out || test_failed $LINENO "$i"

  "$i" file1 file2 --append -ab5 --block=10 -c -carg --casu --casu=arg -e "" \
       -earg --empty="" --empty=arg -H -ofile --long-o -q --verbose > out ||
    test_failed $LINENO "$i"
  cmp "${in}" out || test_failed $LINENO "$i"

  "$i" --append -a file1 -b 5 --block 10 -c -carg --casual --casua=arg -e "" \
       -e arg --empty "" --empty arg -H -o file file2 --lon -q --verbo > out ||
    test_failed $LINENO "$i"
  cmp "${in}" out || test_failed $LINENO "$i"

  "$i" --append -a -b5 --block=10 -c -carg --cas= --cas=arg -e "" file1 \
       -e arg --emp "" --emp arg -H -ofile --long-only -q --verb file2 > out ||
    test_failed $LINENO "$i"
  cmp "${in}" out || test_failed $LINENO "$i"
done

"${PARSER}" --int-min --int-max > out || test_failed $LINENO
"${CPARSER}" --int-min --int-max > cout || test_failed $LINENO
cmp out cout || test_failed $LINENO

printf "\ntesting bad input..."

for i in "${PARSER}" "${CPARSER}" ; do
	"$i" --v 2> /dev/null				# ambiguous option
	[ $? = 1 ] || test_failed $LINENO "$i"

	"$i" --ve 2> /dev/null
	[ $? = 1 ] || test_failed $LINENO "$i"

	"$i" --ver 2> /dev/null
	[ $? = 1 ] || test_failed $LINENO "$i"

	"$i" --unrecognized 2> /dev/null		# unrecognized option
	[ $? = 1 ] || test_failed $LINENO "$i"

	"$i" -x 2> /dev/null				# invalid option
	[ $? = 1 ] || test_failed $LINENO "$i"

	"$i" -aARG 2> /dev/null				# argument not allowed
	[ $? = 1 ] || test_failed $LINENO "$i"

	"$i" -b 2> /dev/null				# argument required
	[ $? = 1 ] || test_failed $LINENO "$i"

	"$i" --block 2> /dev/null
	[ $? = 1 ] || test_failed $LINENO "$i"

	"$i" --block= 2> /dev/null
	[ $? = 1 ] || test_failed $LINENO "$i"

	"$i" -e"" 2> /dev/null
	[ $? = 1 ] || test_failed $LINENO "$i"

	"$i" -u 2> /dev/null				# uncaught option
	[ $? = 3 ] || test_failed $LINENO "$i"
done

echo
if [ ${fail} = 0 ] ; then
	echo "tests completed successfully."
	cd "${objdir}" && rm -r tmp
else
	echo "tests failed."
fi
exit ${fail}
