/*
 *  Status monitor for Canon CAPT Printer.
 *  Copyright (C) 2004-2013 CANON INC.
 *  All Rights Reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * DO NOT EDIT THIS FILE - it is generated by Glade.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

GtkWidget*
create_CaptStatusMonitorWnd (void)
{
  GtkWidget *CaptStatusMonitorWnd;
  GtkWidget *vbox28;
  GtkWidget *menubar1;
  GtkWidget *job1;
  GtkWidget *job1_menu;
  GtkWidget *pause_job;
  GtkWidget *resume_job;
  GtkWidget *cancel_job;
  GtkWidget *options;
  GtkWidget *options_menu;
  GtkWidget *consumable_counters1;
  GtkWidget *consumables_information1;
  GtkWidget *counters;
  GtkWidget *cleaning;
  GtkWidget *utility1;
  GtkWidget *utility1_menu;
  GtkWidget *cleaning1;
  GtkWidget *cleaning2;
  GtkWidget *printing_position_adjustment_print1;
  GtkWidget *calibration1;
  GtkWidget *register_colors_correction1;
  GtkWidget *color_mismatch_correction1;
  GtkWidget *cleaning3;
  GtkWidget *toner_cartridge_replacement1;
  GtkWidget *device_settings1;
  GtkWidget *device_settings2;
  GtkWidget *device_settings2_menu;
  GtkWidget *register_paper_size_in_cassettes1;
  GtkWidget *drawer_settings;
  GtkWidget *cassette_settings;
  GtkWidget *cassette_settings_1;
  GtkWidget *drawer_settings_1;
  GtkWidget *cassette_settings_2;
  GtkWidget *drawer_settings_2;
  GtkWidget *multi_purpose_tray_settings1;
  GtkWidget *printing_position_adjustment1;
  GtkWidget *settings_of_the_cancel_job_key1;
  GtkWidget *sleep_settings1;
  GtkWidget *power_save_settings;
  GtkWidget *reset_part_counters1;
  GtkWidget *startup_settings1;
  GtkWidget *network_settings1;
  GtkWidget *assisting_print_setting1;
  GtkWidget *calibration_settings1;
  GtkWidget *separator1;
  GtkWidget *hide_statusmonitor;
  GtkWidget *CaptStatusUIHide_hbuttonbox;
  GtkWidget *CAPTStatusUIHide_button;
  GtkWidget *vbox29;
  GtkWidget *frame28;
  GtkWidget *CaptStatusUI_label;
  GtkWidget *label1;
  GtkWidget *scrolledwindow1;
  GtkWidget *CaptStatusUI_text;
  GtkWidget *frame43;
  GtkWidget *hbox55;
  GtkWidget *label122;
  GtkWidget *CaptStatusUIPause_togglebutton;
  GtkWidget *CaptStatusUIResume_togglebutton;
  GtkWidget *CaptStatusUICancel_button;

  CaptStatusMonitorWnd = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_default_size (GTK_WINDOW (CaptStatusMonitorWnd), 480, 360);
  gtk_window_set_resizable (GTK_WINDOW (CaptStatusMonitorWnd), FALSE);

  vbox28 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox28);
  gtk_container_add (GTK_CONTAINER (CaptStatusMonitorWnd), vbox28);

  menubar1 = gtk_menu_bar_new ();
  gtk_widget_show (menubar1);
  gtk_box_pack_start (GTK_BOX (vbox28), menubar1, FALSE, FALSE, 0);

  job1 = gtk_menu_item_new_with_mnemonic (_("Job"));
  gtk_widget_show (job1);
  gtk_container_add (GTK_CONTAINER (menubar1), job1);

  job1_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (job1), job1_menu);

  pause_job = gtk_menu_item_new_with_mnemonic (_("Pause Job"));
  gtk_widget_show (pause_job);
  gtk_container_add (GTK_CONTAINER (job1_menu), pause_job);

  resume_job = gtk_menu_item_new_with_mnemonic (_("Resume Job"));
  gtk_widget_show (resume_job);
  gtk_container_add (GTK_CONTAINER (job1_menu), resume_job);

  cancel_job = gtk_menu_item_new_with_mnemonic (_("Cancel Job"));
  gtk_widget_show (cancel_job);
  gtk_container_add (GTK_CONTAINER (job1_menu), cancel_job);

  options = gtk_menu_item_new_with_mnemonic (_("Options"));
  gtk_widget_show (options);
  gtk_container_add (GTK_CONTAINER (menubar1), options);

  options_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (options), options_menu);

  consumable_counters1 = gtk_menu_item_new_with_mnemonic (_("Consumables/Counters..."));
  gtk_container_add (GTK_CONTAINER (options_menu), consumable_counters1);

  consumables_information1 = gtk_menu_item_new_with_mnemonic (_("Consumables Information..."));
  gtk_container_add (GTK_CONTAINER (options_menu), consumables_information1);

  counters = gtk_menu_item_new_with_mnemonic (_("Counter Information..."));
  gtk_container_add (GTK_CONTAINER (options_menu), counters);

  cleaning = gtk_menu_item_new_with_mnemonic (_("Cleaning"));
  gtk_container_add (GTK_CONTAINER (options_menu), cleaning);

  utility1 = gtk_menu_item_new_with_mnemonic (_("Utility"));
  gtk_container_add (GTK_CONTAINER (options_menu), utility1);

  utility1_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (utility1), utility1_menu);

  cleaning1 = gtk_menu_item_new_with_mnemonic (_("Cleaning 1..."));
  gtk_container_add (GTK_CONTAINER (utility1_menu), cleaning1);

  cleaning2 = gtk_menu_item_new_with_mnemonic (_("Cleaning 2..."));
  gtk_container_add (GTK_CONTAINER (utility1_menu), cleaning2);

  printing_position_adjustment_print1 = gtk_menu_item_new_with_mnemonic (_("Printing Position Adjustment Print..."));
  gtk_container_add (GTK_CONTAINER (utility1_menu), printing_position_adjustment_print1);

  calibration1 = gtk_menu_item_new_with_mnemonic (_("Calibration..."));
  gtk_container_add (GTK_CONTAINER (utility1_menu), calibration1);

  register_colors_correction1 = gtk_menu_item_new_with_mnemonic (_("Out-of-Register Colors Correction..."));
  gtk_container_add (GTK_CONTAINER (utility1_menu), register_colors_correction1);

  color_mismatch_correction1 = gtk_menu_item_new_with_mnemonic (_("Color Mismatch Correction..."));
  gtk_container_add (GTK_CONTAINER (utility1_menu), color_mismatch_correction1);

  cleaning3 = gtk_menu_item_new_with_mnemonic (_("Cleaning..."));
  gtk_container_add (GTK_CONTAINER (utility1_menu), cleaning3);

  toner_cartridge_replacement1 = gtk_menu_item_new_with_mnemonic (_("Toner Cartridge Replacement..."));
  gtk_container_add (GTK_CONTAINER (utility1_menu), toner_cartridge_replacement1);

  device_settings1 = gtk_menu_item_new_with_mnemonic (_("Device Settings..."));
  gtk_container_add (GTK_CONTAINER (options_menu), device_settings1);

  device_settings2 = gtk_menu_item_new_with_mnemonic (_("Device Settings"));
  gtk_container_add (GTK_CONTAINER (options_menu), device_settings2);

  device_settings2_menu = gtk_menu_new ();
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (device_settings2), device_settings2_menu);

  register_paper_size_in_cassettes1 = gtk_menu_item_new_with_mnemonic (_("Register Paper Size in Cassettes..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), register_paper_size_in_cassettes1);

  drawer_settings = gtk_menu_item_new_with_mnemonic (_("Drawer Settings..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), drawer_settings);

  cassette_settings = gtk_menu_item_new_with_mnemonic (_("Cassette Settings..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), cassette_settings);

  cassette_settings_1 = gtk_menu_item_new_with_mnemonic (_("Cassette Settings 1..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), cassette_settings_1);

  drawer_settings_1 = gtk_menu_item_new_with_mnemonic (_("Drawer Settings 1..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), drawer_settings_1);

  cassette_settings_2 = gtk_menu_item_new_with_mnemonic (_("Cassette Settings 2..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), cassette_settings_2);

  drawer_settings_2 = gtk_menu_item_new_with_mnemonic (_("Drawer Settings 2..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), drawer_settings_2);

  multi_purpose_tray_settings1 = gtk_menu_item_new_with_mnemonic (_("Multi-purpose Tray Settings..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), multi_purpose_tray_settings1);

  printing_position_adjustment1 = gtk_menu_item_new_with_mnemonic (_("Printing Position Adjustment..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), printing_position_adjustment1);

  settings_of_the_cancel_job_key1 = gtk_menu_item_new_with_mnemonic (_("Settings of the Cancel Job Key..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), settings_of_the_cancel_job_key1);

  sleep_settings1 = gtk_menu_item_new_with_mnemonic (_("Sleep Settings..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), sleep_settings1);

  power_save_settings = gtk_menu_item_new_with_mnemonic (_("Power Save Settings..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), power_save_settings);

  reset_part_counters1 = gtk_menu_item_new_with_mnemonic (_("Reset Part Counters..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), reset_part_counters1);

  startup_settings1 = gtk_menu_item_new_with_mnemonic (_("Startup Settings..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), startup_settings1);

  network_settings1 = gtk_menu_item_new_with_mnemonic (_("Network Settings..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), network_settings1);

  assisting_print_setting1 = gtk_menu_item_new_with_mnemonic (_("Assisting Print Settings..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), assisting_print_setting1);

  calibration_settings1 = gtk_menu_item_new_with_mnemonic (_("Calibration Settings..."));
  gtk_container_add (GTK_CONTAINER (device_settings2_menu), calibration_settings1);

  separator1 = gtk_separator_menu_item_new ();
  gtk_widget_show (separator1);
  gtk_container_add (GTK_CONTAINER (options_menu), separator1);
  gtk_widget_set_sensitive (separator1, FALSE);

  hide_statusmonitor = gtk_menu_item_new_with_mnemonic (_("Hide Statusmonitor"));
  gtk_widget_show (hide_statusmonitor);
  gtk_container_add (GTK_CONTAINER (options_menu), hide_statusmonitor);

  CaptStatusUIHide_hbuttonbox = gtk_hbutton_box_new ();
  gtk_widget_show (CaptStatusUIHide_hbuttonbox);
  gtk_box_pack_start (GTK_BOX (vbox28), CaptStatusUIHide_hbuttonbox, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (CaptStatusUIHide_hbuttonbox), GTK_BUTTONBOX_END);
  gtk_box_set_spacing (GTK_BOX (CaptStatusUIHide_hbuttonbox), 30);

  CAPTStatusUIHide_button = gtk_button_new_with_mnemonic (_("Hide Statusmonitor"));
  gtk_widget_show (CAPTStatusUIHide_button);
  gtk_container_add (GTK_CONTAINER (CaptStatusUIHide_hbuttonbox), CAPTStatusUIHide_button);
  GTK_WIDGET_SET_FLAGS (CAPTStatusUIHide_button, GTK_CAN_DEFAULT);

  vbox29 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox29);
  gtk_box_pack_start (GTK_BOX (vbox28), vbox29, FALSE, FALSE, 0);

  frame28 = gtk_frame_new (NULL);
  gtk_widget_show (frame28);
  gtk_box_pack_start (GTK_BOX (vbox29), frame28, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame28), 5);

  CaptStatusUI_label = gtk_label_new ("");
  gtk_widget_show (CaptStatusUI_label);
  gtk_container_add (GTK_CONTAINER (frame28), CaptStatusUI_label);
  gtk_widget_set_size_request (CaptStatusUI_label, 46, 50);
  gtk_label_set_justify (GTK_LABEL (CaptStatusUI_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (CaptStatusUI_label), 0.1, 0.2);

  label1 = gtk_label_new (_("Message"));
  gtk_widget_show (label1);
  gtk_frame_set_label_widget (GTK_FRAME (frame28), label1);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox29), scrolledwindow1, TRUE, TRUE, 0);
  gtk_widget_set_size_request (scrolledwindow1, 380, 180);
  gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 5);
  GTK_WIDGET_UNSET_FLAGS (scrolledwindow1, GTK_CAN_FOCUS);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_SHADOW_IN);

  CaptStatusUI_text = gtk_text_view_new ();
  gtk_widget_show (CaptStatusUI_text);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), CaptStatusUI_text);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (CaptStatusUI_text), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (CaptStatusUI_text), GTK_WRAP_WORD);

  frame43 = gtk_frame_new (NULL);
  gtk_widget_show (frame43);
  gtk_box_pack_start (GTK_BOX (vbox28), frame43, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame43), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame43), GTK_SHADOW_NONE);

  hbox55 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox55);
  gtk_container_add (GTK_CONTAINER (frame43), hbox55);

  label122 = gtk_label_new ("");
  gtk_widget_show (label122);
  gtk_box_pack_start (GTK_BOX (hbox55), label122, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label122), GTK_JUSTIFY_CENTER);

  CaptStatusUIPause_togglebutton = gtk_toggle_button_new_with_mnemonic (_("Pause Job"));
  gtk_widget_show (CaptStatusUIPause_togglebutton);
  gtk_box_pack_start (GTK_BOX (hbox55), CaptStatusUIPause_togglebutton, FALSE, FALSE, 0);
  gtk_widget_set_sensitive (CaptStatusUIPause_togglebutton, FALSE);

  CaptStatusUIResume_togglebutton = gtk_toggle_button_new_with_mnemonic (_("Resume Job"));
  gtk_widget_show (CaptStatusUIResume_togglebutton);
  gtk_box_pack_start (GTK_BOX (hbox55), CaptStatusUIResume_togglebutton, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (CaptStatusUIResume_togglebutton), TRUE);

  CaptStatusUICancel_button = gtk_button_new_with_mnemonic (_("Cancel Job"));
  gtk_widget_show (CaptStatusUICancel_button);
  gtk_box_pack_start (GTK_BOX (hbox55), CaptStatusUICancel_button, FALSE, FALSE, 3);
  gtk_widget_set_sensitive (CaptStatusUICancel_button, FALSE);

  g_signal_connect ((gpointer) CaptStatusMonitorWnd, "destroy",
                    G_CALLBACK (on_CaptStatusMonitorWnd_destroy),
                    NULL);
  g_signal_connect ((gpointer) CaptStatusMonitorWnd, "delete_event",
                    G_CALLBACK (on_CaptStatusMonitorWnd_delete_event),
                    NULL);
  g_signal_connect ((gpointer) job1, "activate",
                    G_CALLBACK (on_job1_activate),
                    NULL);
  g_signal_connect ((gpointer) pause_job, "activate",
                    G_CALLBACK (on_pause_job_activate),
                    NULL);
  g_signal_connect ((gpointer) resume_job, "activate",
                    G_CALLBACK (on_resume_job_activate),
                    NULL);
  g_signal_connect ((gpointer) cancel_job, "activate",
                    G_CALLBACK (on_cancel_job_activate),
                    NULL);
  g_signal_connect ((gpointer) options, "activate",
                    G_CALLBACK (on_options_activate),
                    NULL);
  g_signal_connect ((gpointer) consumable_counters1, "activate",
                    G_CALLBACK (on_consumable_counters1_activate),
                    NULL);
  g_signal_connect ((gpointer) consumables_information1, "activate",
                    G_CALLBACK (on_consumables_information1_activate),
                    NULL);
  g_signal_connect ((gpointer) counters, "activate",
                    G_CALLBACK (on_counters_activate),
                    NULL);
  g_signal_connect ((gpointer) cleaning, "activate",
                    G_CALLBACK (on_cleaning_activate),
                    NULL);
  g_signal_connect ((gpointer) cleaning1, "activate",
                    G_CALLBACK (on_cleaning1_activate),
                    NULL);
  g_signal_connect ((gpointer) cleaning2, "activate",
                    G_CALLBACK (on_cleaning2_activate),
                    NULL);
  g_signal_connect ((gpointer) printing_position_adjustment_print1, "activate",
                    G_CALLBACK (on_printing_position_adjustment_print1_activate),
                    NULL);
  g_signal_connect ((gpointer) calibration1, "activate",
                    G_CALLBACK (on_calibration1_activate),
                    NULL);
  g_signal_connect ((gpointer) register_colors_correction1, "activate",
                    G_CALLBACK (on_register_colors_correction1_activate),
                    NULL);
  g_signal_connect ((gpointer) color_mismatch_correction1, "activate",
                    G_CALLBACK (on_color_mismatch_correction1_activate),
                    NULL);
  g_signal_connect ((gpointer) cleaning3, "activate",
                    G_CALLBACK (on_cleaning3_activate),
                    NULL);
  g_signal_connect ((gpointer) toner_cartridge_replacement1, "activate",
                    G_CALLBACK (on_toner_cartridge_replacement1_activate),
                    NULL);
  g_signal_connect ((gpointer) device_settings1, "activate",
                    G_CALLBACK (on_device_settings1_activate),
                    NULL);
  g_signal_connect ((gpointer) register_paper_size_in_cassettes1, "activate",
                    G_CALLBACK (on_register_paper_size_in_cassettes1_activate),
                    NULL);
  g_signal_connect ((gpointer) drawer_settings, "activate",
                    G_CALLBACK (on_drawer_settings_activate),
                    NULL);
  g_signal_connect ((gpointer) cassette_settings, "activate",
                    G_CALLBACK (on_cassette_settings_activate),
                    NULL);
  g_signal_connect ((gpointer) cassette_settings_1, "activate",
                    G_CALLBACK (on_cassette_settings_1_activate),
                    NULL);
  g_signal_connect ((gpointer) drawer_settings_1, "activate",
                    G_CALLBACK (on_drawer_settings_1_activate),
                    NULL);
  g_signal_connect ((gpointer) cassette_settings_2, "activate",
                    G_CALLBACK (on_cassette_settings_2_activate),
                    NULL);
  g_signal_connect ((gpointer) drawer_settings_2, "activate",
                    G_CALLBACK (on_drawer_settings_2_activate),
                    NULL);
  g_signal_connect ((gpointer) multi_purpose_tray_settings1, "activate",
                    G_CALLBACK (on_multi_purpose_tray_activate),
                    NULL);
  g_signal_connect ((gpointer) printing_position_adjustment1, "activate",
                    G_CALLBACK (on_printing_position_adjustment_activate),
                    NULL);
  g_signal_connect ((gpointer) settings_of_the_cancel_job_key1, "activate",
                    G_CALLBACK (on_settings_of_the_cancel_job_key1_activate),
                    NULL);
  g_signal_connect ((gpointer) sleep_settings1, "activate",
                    G_CALLBACK (on_sleep_settings1_activate),
                    NULL);
  g_signal_connect ((gpointer) power_save_settings, "activate",
                    G_CALLBACK (on_power_save_settings_activate),
                    NULL);
  g_signal_connect ((gpointer) reset_part_counters1, "activate",
                    G_CALLBACK (on_reset_unit_activate),
                    NULL);
  g_signal_connect ((gpointer) startup_settings1, "activate",
                    G_CALLBACK (on_startup_settings1_activate),
                    NULL);
  g_signal_connect ((gpointer) network_settings1, "activate",
                    G_CALLBACK (on_network_settings1_activate),
                    NULL);
  g_signal_connect ((gpointer) assisting_print_setting1, "activate",
                    G_CALLBACK (on_assisting_print_setting1_activate),
                    NULL);
  g_signal_connect ((gpointer) calibration_settings1, "activate",
                    G_CALLBACK (on_calibration_settings1_activate),
                    NULL);
  g_signal_connect ((gpointer) hide_statusmonitor, "activate",
                    G_CALLBACK (on_hide_statusmonitor_activate),
                    NULL);
  g_signal_connect ((gpointer) CAPTStatusUIHide_button, "clicked",
                    G_CALLBACK (on_CAPTStatusUIHide_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) CaptStatusUIPause_togglebutton, "toggled",
                    G_CALLBACK (on_CaptStatusUIPause_togglebutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) CaptStatusUIResume_togglebutton, "toggled",
                    G_CALLBACK (on_CaptStatusUIResume_togglebutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) CaptStatusUICancel_button, "clicked",
                    G_CALLBACK (on_CaptStatusUICancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (CaptStatusMonitorWnd, CaptStatusMonitorWnd, "CaptStatusMonitorWnd");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, vbox28, "vbox28");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, menubar1, "menubar1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, job1, "job1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, job1_menu, "job1_menu");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, pause_job, "pause_job");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, resume_job, "resume_job");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, cancel_job, "cancel_job");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, options, "options");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, options_menu, "options_menu");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, consumable_counters1, "consumable_counters1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, consumables_information1, "consumables_information1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, counters, "counters");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, cleaning, "cleaning");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, utility1, "utility1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, utility1_menu, "utility1_menu");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, cleaning1, "cleaning1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, cleaning2, "cleaning2");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, printing_position_adjustment_print1, "printing_position_adjustment_print1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, calibration1, "calibration1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, register_colors_correction1, "register_colors_correction1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, color_mismatch_correction1, "color_mismatch_correction1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, cleaning3, "cleaning3");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, toner_cartridge_replacement1, "toner_cartridge_replacement1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, device_settings1, "device_settings1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, device_settings2, "device_settings2");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, device_settings2_menu, "device_settings2_menu");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, register_paper_size_in_cassettes1, "register_paper_size_in_cassettes1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, drawer_settings, "drawer_settings");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, cassette_settings, "cassette_settings");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, cassette_settings_1, "cassette_settings_1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, drawer_settings_1, "drawer_settings_1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, cassette_settings_2, "cassette_settings_2");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, drawer_settings_2, "drawer_settings_2");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, multi_purpose_tray_settings1, "multi_purpose_tray_settings1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, printing_position_adjustment1, "printing_position_adjustment1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, settings_of_the_cancel_job_key1, "settings_of_the_cancel_job_key1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, sleep_settings1, "sleep_settings1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, power_save_settings, "power_save_settings");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, reset_part_counters1, "reset_part_counters1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, startup_settings1, "startup_settings1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, network_settings1, "network_settings1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, assisting_print_setting1, "assisting_print_setting1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, calibration_settings1, "calibration_settings1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, separator1, "separator1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, hide_statusmonitor, "hide_statusmonitor");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, CaptStatusUIHide_hbuttonbox, "CaptStatusUIHide_hbuttonbox");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, CAPTStatusUIHide_button, "CAPTStatusUIHide_button");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, vbox29, "vbox29");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, frame28, "frame28");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, CaptStatusUI_label, "CaptStatusUI_label");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, label1, "label1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, scrolledwindow1, "scrolledwindow1");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, CaptStatusUI_text, "CaptStatusUI_text");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, frame43, "frame43");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, hbox55, "hbox55");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, label122, "label122");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, CaptStatusUIPause_togglebutton, "CaptStatusUIPause_togglebutton");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, CaptStatusUIResume_togglebutton, "CaptStatusUIResume_togglebutton");
  GLADE_HOOKUP_OBJECT (CaptStatusMonitorWnd, CaptStatusUICancel_button, "CaptStatusUICancel_button");

  return CaptStatusMonitorWnd;
}

GtkWidget*
create_PPAP_dialog (void)
{
  GtkWidget *PPAP_dialog;
  GtkWidget *dialog_vbox1;
  GtkWidget *frame44;
  GtkWidget *vbox30;
  GtkWidget *frame45;
  GtkWidget *label123;
  GtkWidget *frame46;
  GtkWidget *vbox31;
  GtkWidget *PPAPDlg_MltT_radiobutton;
  GSList *PPAPDlg_MltT_radiobutton_group = NULL;
  GtkWidget *PPAPDlg_Cas1_radiobutton;
  GtkWidget *PPAPDlg_Cas2_radiobutton;
  GtkWidget *PPAPDlg_Cas3_radiobutton;
  GtkWidget *PPAPDlg_Cas4_radiobutton;
  GtkWidget *label124;
  GtkWidget *CheckDuplexUnit_checkbutton;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbuttonbox1;
  GtkWidget *PPAPDlg_OK_button;
  GtkWidget *PPAPDlg_Cancel_button;

  PPAP_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (PPAP_dialog), _("Printing Position Adjustment Print"));
  gtk_window_set_position (GTK_WINDOW (PPAP_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (PPAP_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (PPAP_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (PPAP_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox1 = GTK_DIALOG (PPAP_dialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  frame44 = gtk_frame_new (NULL);
  gtk_widget_show (frame44);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame44, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame44), 1);

  vbox30 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox30);
  gtk_container_add (GTK_CONTAINER (frame44), vbox30);

  frame45 = gtk_frame_new (NULL);
  gtk_widget_show (frame45);
  gtk_box_pack_start (GTK_BOX (vbox30), frame45, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame45), 1);

  label123 = gtk_label_new (_("Print a pattern for Printing Position Adjustment.\nSelect the paper source to check and click [OK].\nWhen adjusting the printing position after printing,\nadjust it in the [Device Settings] dialog in the [Option] menu.\n"));
  gtk_widget_show (label123);
  gtk_container_add (GTK_CONTAINER (frame45), label123);
  gtk_widget_set_size_request (label123, 375, -1);
  gtk_label_set_line_wrap (GTK_LABEL (label123), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label123), 0.2, 0.96);

  frame46 = gtk_frame_new (NULL);
  gtk_widget_show (frame46);
  gtk_box_pack_start (GTK_BOX (vbox30), frame46, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame46), 5);

  vbox31 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox31);
  gtk_container_add (GTK_CONTAINER (frame46), vbox31);

  PPAPDlg_MltT_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Multi-purpose Tray"));
  gtk_widget_show (PPAPDlg_MltT_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox31), PPAPDlg_MltT_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (PPAPDlg_MltT_radiobutton), PPAPDlg_MltT_radiobutton_group);
  PPAPDlg_MltT_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (PPAPDlg_MltT_radiobutton));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (PPAPDlg_MltT_radiobutton), TRUE);

  PPAPDlg_Cas1_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Cassette 1"));
  gtk_widget_show (PPAPDlg_Cas1_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox31), PPAPDlg_Cas1_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (PPAPDlg_Cas1_radiobutton), PPAPDlg_MltT_radiobutton_group);
  PPAPDlg_MltT_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (PPAPDlg_Cas1_radiobutton));

  PPAPDlg_Cas2_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Cassette 2"));
  gtk_widget_show (PPAPDlg_Cas2_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox31), PPAPDlg_Cas2_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (PPAPDlg_Cas2_radiobutton), PPAPDlg_MltT_radiobutton_group);
  PPAPDlg_MltT_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (PPAPDlg_Cas2_radiobutton));

  PPAPDlg_Cas3_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Cassette 3"));
  gtk_widget_show (PPAPDlg_Cas3_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox31), PPAPDlg_Cas3_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (PPAPDlg_Cas3_radiobutton), PPAPDlg_MltT_radiobutton_group);
  PPAPDlg_MltT_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (PPAPDlg_Cas3_radiobutton));

  PPAPDlg_Cas4_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Cassette 4"));
  gtk_widget_show (PPAPDlg_Cas4_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox31), PPAPDlg_Cas4_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (PPAPDlg_Cas4_radiobutton), PPAPDlg_MltT_radiobutton_group);
  PPAPDlg_MltT_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (PPAPDlg_Cas4_radiobutton));

  label124 = gtk_label_new (_("Paper Source"));
  gtk_widget_show (label124);
  gtk_frame_set_label_widget (GTK_FRAME (frame46), label124);

  CheckDuplexUnit_checkbutton = gtk_check_button_new_with_mnemonic (_("Check Duplex Unit Also"));
  gtk_widget_show (CheckDuplexUnit_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox30), CheckDuplexUnit_checkbutton, FALSE, FALSE, 0);

  dialog_action_area1 = GTK_DIALOG (PPAP_dialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox1);
  gtk_container_add (GTK_CONTAINER (dialog_action_area1), hbuttonbox1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_END);

  PPAPDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (PPAPDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), PPAPDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (PPAPDlg_OK_button, GTK_CAN_DEFAULT);

  PPAPDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (PPAPDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox1), PPAPDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (PPAPDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) PPAP_dialog, "destroy",
                    G_CALLBACK (on_PPAP_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) PPAP_dialog, "delete_event",
                    G_CALLBACK (on_PPAP_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) PPAPDlg_MltT_radiobutton, "toggled",
                    G_CALLBACK (on_PPAPDlg_MltT_radiobutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) PPAPDlg_Cas1_radiobutton, "toggled",
                    G_CALLBACK (on_PPAPDlg_Cas1_radiobutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) PPAPDlg_Cas2_radiobutton, "toggled",
                    G_CALLBACK (on_PPAPDlg_Cas2_radiobutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) PPAPDlg_Cas3_radiobutton, "toggled",
                    G_CALLBACK (on_PPAPDlg_Cas3_radiobutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) PPAPDlg_Cas4_radiobutton, "toggled",
                    G_CALLBACK (on_PPAPDlg_Cas4_radiobutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) CheckDuplexUnit_checkbutton, "toggled",
                    G_CALLBACK (on_CheckDuplexUnit_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) PPAPDlg_OK_button, "clicked",
                    G_CALLBACK (on_PPAPDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) PPAPDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_PPAPDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (PPAP_dialog, PPAP_dialog, "PPAP_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (PPAP_dialog, dialog_vbox1, "dialog_vbox1");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, frame44, "frame44");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, vbox30, "vbox30");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, frame45, "frame45");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, label123, "label123");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, frame46, "frame46");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, vbox31, "vbox31");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, PPAPDlg_MltT_radiobutton, "PPAPDlg_MltT_radiobutton");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, PPAPDlg_Cas1_radiobutton, "PPAPDlg_Cas1_radiobutton");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, PPAPDlg_Cas2_radiobutton, "PPAPDlg_Cas2_radiobutton");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, PPAPDlg_Cas3_radiobutton, "PPAPDlg_Cas3_radiobutton");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, PPAPDlg_Cas4_radiobutton, "PPAPDlg_Cas4_radiobutton");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, label124, "label124");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, CheckDuplexUnit_checkbutton, "CheckDuplexUnit_checkbutton");
  GLADE_HOOKUP_OBJECT_NO_REF (PPAP_dialog, dialog_action_area1, "dialog_action_area1");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, hbuttonbox1, "hbuttonbox1");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, PPAPDlg_OK_button, "PPAPDlg_OK_button");
  GLADE_HOOKUP_OBJECT (PPAP_dialog, PPAPDlg_Cancel_button, "PPAPDlg_Cancel_button");

  return PPAP_dialog;
}

GtkWidget*
create_DevS_dialog (void)
{
  GtkWidget *DevS_dialog;
  GtkWidget *dialog_vbox2;
  GtkWidget *vbox32;
  GtkWidget *frame47;
  GtkWidget *vbox33;
  GtkWidget *DevDlg_2Mode_checkbutton;
  GtkWidget *DevDlg_GraMode_checkbutton;
  GtkWidget *DevDlg_FlkMode_checkbutton;
  GtkWidget *hseparator1;
  GtkWidget *vbox34;
  GtkWidget *label124;
  GtkWidget *frame48;
  GtkWidget *vbox35;
  GtkWidget *DevDlg_MltT_hbox;
  GtkWidget *label125;
  GtkObject *DevDlg_MltT_spinbutton_adj;
  GtkWidget *DevDlg_MltT_spinbutton;
  GtkWidget *label126;
  GtkWidget *DevDlg_Cas1_hbox;
  GtkWidget *label127;
  GtkObject *DevDlg_Cas1_spinbutton_adj;
  GtkWidget *DevDlg_Cas1_spinbutton;
  GtkWidget *label128;
  GtkWidget *DevDlg_Cas2_hbox;
  GtkWidget *label129;
  GtkObject *DevDlg_Cas2_spinbutton_adj;
  GtkWidget *DevDlg_Cas2_spinbutton;
  GtkWidget *label130;
  GtkWidget *DevDlg_Cas3_hbox;
  GtkWidget *label131;
  GtkObject *DevDlg_Cas3_spinbutton_adj;
  GtkWidget *DevDlg_Cas3_spinbutton;
  GtkWidget *label132;
  GtkWidget *DevDlg_Cas4_hbox;
  GtkWidget *label133;
  GtkObject *DevDlg_Cas4_spinbutton_adj;
  GtkWidget *DevDlg_Cas4_spinbutton;
  GtkWidget *label134;
  GtkWidget *DevDlg_Dplx_hbox;
  GtkWidget *label135;
  GtkObject *DevDlg_Dplx_spinbutton_adj;
  GtkWidget *DevDlg_Dplx_spinbutton;
  GtkWidget *label136;
  GtkWidget *dialog_action_area2;
  GtkWidget *hbuttonbox2;
  GtkWidget *DevDlg_OK_button;
  GtkWidget *DevDlg_Cancel_button;

  DevS_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (DevS_dialog), _("Device Settings"));
  gtk_window_set_position (GTK_WINDOW (DevS_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (DevS_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (DevS_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (DevS_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox2 = GTK_DIALOG (DevS_dialog)->vbox;
  gtk_widget_show (dialog_vbox2);

  vbox32 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox32);
  gtk_box_pack_start (GTK_BOX (dialog_vbox2), vbox32, TRUE, TRUE, 0);

  frame47 = gtk_frame_new (NULL);
  gtk_widget_show (frame47);
  gtk_box_pack_start (GTK_BOX (vbox32), frame47, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame47), 3);

  vbox33 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox33);
  gtk_container_add (GTK_CONTAINER (frame47), vbox33);

  DevDlg_2Mode_checkbutton = gtk_check_button_new_with_mnemonic (_("2-sided Special Mode"));
  gtk_widget_show (DevDlg_2Mode_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox33), DevDlg_2Mode_checkbutton, FALSE, FALSE, 0);

  DevDlg_GraMode_checkbutton = gtk_check_button_new_with_mnemonic (_("Graphics Special Mode"));
  gtk_widget_show (DevDlg_GraMode_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox33), DevDlg_GraMode_checkbutton, FALSE, FALSE, 0);

  DevDlg_FlkMode_checkbutton = gtk_check_button_new_with_mnemonic (_("Lighten Flicker Mode"));
  gtk_widget_show (DevDlg_FlkMode_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox33), DevDlg_FlkMode_checkbutton, FALSE, FALSE, 0);

  hseparator1 = gtk_hseparator_new ();
  gtk_widget_show (hseparator1);
  gtk_box_pack_start (GTK_BOX (vbox32), hseparator1, FALSE, FALSE, 3);

  vbox34 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox34);
  gtk_box_pack_start (GTK_BOX (vbox32), vbox34, TRUE, TRUE, 0);

  label124 = gtk_label_new (_("Printing Position Adjustment"));
  gtk_widget_show (label124);
  gtk_box_pack_start (GTK_BOX (vbox34), label124, FALSE, FALSE, 2);
  gtk_misc_set_alignment (GTK_MISC (label124), 0.05, 0.5);

  frame48 = gtk_frame_new (NULL);
  gtk_widget_show (frame48);
  gtk_box_pack_start (GTK_BOX (vbox34), frame48, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame48), 2);

  vbox35 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox35);
  gtk_container_add (GTK_CONTAINER (frame48), vbox35);

  DevDlg_MltT_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (DevDlg_MltT_hbox);
  gtk_box_pack_start (GTK_BOX (vbox35), DevDlg_MltT_hbox, TRUE, TRUE, 0);

  label125 = gtk_label_new (_("Multi-purpose Tray:"));
  gtk_widget_show (label125);
  gtk_box_pack_start (GTK_BOX (DevDlg_MltT_hbox), label125, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label125, 140, -1);
  gtk_misc_set_alignment (GTK_MISC (label125), 0.1, 0.5);

  DevDlg_MltT_spinbutton_adj = gtk_adjustment_new (0, -5, 5, 0.5, 1, 10);
  DevDlg_MltT_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (DevDlg_MltT_spinbutton_adj), 1, 1);
  gtk_widget_show (DevDlg_MltT_spinbutton);
  gtk_box_pack_start (GTK_BOX (DevDlg_MltT_hbox), DevDlg_MltT_spinbutton, TRUE, TRUE, 0);

  label126 = gtk_label_new (_("  mm (-5.0 to 5.0)  "));
  gtk_widget_show (label126);
  gtk_box_pack_start (GTK_BOX (DevDlg_MltT_hbox), label126, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label126), GTK_JUSTIFY_CENTER);

  DevDlg_Cas1_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (DevDlg_Cas1_hbox);
  gtk_box_pack_start (GTK_BOX (vbox35), DevDlg_Cas1_hbox, TRUE, TRUE, 0);

  label127 = gtk_label_new (_("Cassette 1:"));
  gtk_widget_show (label127);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas1_hbox), label127, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label127, 140, -1);
  gtk_misc_set_alignment (GTK_MISC (label127), 0.1, 0.5);

  DevDlg_Cas1_spinbutton_adj = gtk_adjustment_new (0, -5, 5, 0.5, 1, 10);
  DevDlg_Cas1_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (DevDlg_Cas1_spinbutton_adj), 1, 1);
  gtk_widget_show (DevDlg_Cas1_spinbutton);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas1_hbox), DevDlg_Cas1_spinbutton, TRUE, TRUE, 0);

  label128 = gtk_label_new (_("  mm (-5.0 to 5.0)  "));
  gtk_widget_show (label128);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas1_hbox), label128, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label128), GTK_JUSTIFY_CENTER);

  DevDlg_Cas2_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (DevDlg_Cas2_hbox);
  gtk_box_pack_start (GTK_BOX (vbox35), DevDlg_Cas2_hbox, TRUE, TRUE, 0);

  label129 = gtk_label_new (_("Cassette 2:"));
  gtk_widget_show (label129);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas2_hbox), label129, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label129, 140, -1);
  gtk_misc_set_alignment (GTK_MISC (label129), 0.1, 0.5);

  DevDlg_Cas2_spinbutton_adj = gtk_adjustment_new (0, -5, 5, 0.5, 1, 10);
  DevDlg_Cas2_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (DevDlg_Cas2_spinbutton_adj), 1, 1);
  gtk_widget_show (DevDlg_Cas2_spinbutton);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas2_hbox), DevDlg_Cas2_spinbutton, TRUE, TRUE, 0);

  label130 = gtk_label_new (_("  mm (-5.0 to 5.0)  "));
  gtk_widget_show (label130);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas2_hbox), label130, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label130), GTK_JUSTIFY_CENTER);

  DevDlg_Cas3_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (DevDlg_Cas3_hbox);
  gtk_box_pack_start (GTK_BOX (vbox35), DevDlg_Cas3_hbox, TRUE, TRUE, 0);

  label131 = gtk_label_new (_("Cassette 3:"));
  gtk_widget_show (label131);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas3_hbox), label131, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label131, 140, -1);
  gtk_misc_set_alignment (GTK_MISC (label131), 0.1, 0.5);

  DevDlg_Cas3_spinbutton_adj = gtk_adjustment_new (0, -5, 5, 0.5, 1, 10);
  DevDlg_Cas3_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (DevDlg_Cas3_spinbutton_adj), 1, 1);
  gtk_widget_show (DevDlg_Cas3_spinbutton);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas3_hbox), DevDlg_Cas3_spinbutton, TRUE, TRUE, 0);

  label132 = gtk_label_new (_("  mm (-5.0 to 5.0)  "));
  gtk_widget_show (label132);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas3_hbox), label132, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label132), GTK_JUSTIFY_CENTER);

  DevDlg_Cas4_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (DevDlg_Cas4_hbox);
  gtk_box_pack_start (GTK_BOX (vbox35), DevDlg_Cas4_hbox, TRUE, TRUE, 0);

  label133 = gtk_label_new (_("Cassette 4:"));
  gtk_widget_show (label133);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas4_hbox), label133, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label133, 140, -1);
  gtk_misc_set_alignment (GTK_MISC (label133), 0.1, 0.5);

  DevDlg_Cas4_spinbutton_adj = gtk_adjustment_new (0, -5, 5, 0.5, 1, 10);
  DevDlg_Cas4_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (DevDlg_Cas4_spinbutton_adj), 1, 1);
  gtk_widget_show (DevDlg_Cas4_spinbutton);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas4_hbox), DevDlg_Cas4_spinbutton, TRUE, TRUE, 0);

  label134 = gtk_label_new (_("  mm (-5.0 to 5.0)  "));
  gtk_widget_show (label134);
  gtk_box_pack_start (GTK_BOX (DevDlg_Cas4_hbox), label134, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label134), GTK_JUSTIFY_CENTER);

  DevDlg_Dplx_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (DevDlg_Dplx_hbox);
  gtk_box_pack_start (GTK_BOX (vbox35), DevDlg_Dplx_hbox, TRUE, TRUE, 0);

  label135 = gtk_label_new (_("Duplex Unit:"));
  gtk_widget_show (label135);
  gtk_box_pack_start (GTK_BOX (DevDlg_Dplx_hbox), label135, FALSE, FALSE, 0);
  gtk_widget_set_size_request (label135, 140, -1);
  gtk_misc_set_alignment (GTK_MISC (label135), 0.1, 0.5);

  DevDlg_Dplx_spinbutton_adj = gtk_adjustment_new (0, -5, 5, 0.5, 1, 10);
  DevDlg_Dplx_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (DevDlg_Dplx_spinbutton_adj), 1, 1);
  gtk_widget_show (DevDlg_Dplx_spinbutton);
  gtk_box_pack_start (GTK_BOX (DevDlg_Dplx_hbox), DevDlg_Dplx_spinbutton, TRUE, TRUE, 0);

  label136 = gtk_label_new (_("  mm (-5.0 to 5.0)  "));
  gtk_widget_show (label136);
  gtk_box_pack_start (GTK_BOX (DevDlg_Dplx_hbox), label136, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label136), GTK_JUSTIFY_CENTER);

  dialog_action_area2 = GTK_DIALOG (DevS_dialog)->action_area;
  gtk_widget_show (dialog_action_area2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area2), GTK_BUTTONBOX_END);

  hbuttonbox2 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox2);
  gtk_container_add (GTK_CONTAINER (dialog_action_area2), hbuttonbox2);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox2), GTK_BUTTONBOX_END);

  DevDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (DevDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), DevDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (DevDlg_OK_button, GTK_CAN_DEFAULT);

  DevDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (DevDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), DevDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (DevDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) DevS_dialog, "delete_event",
                    G_CALLBACK (on_DevS_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) DevS_dialog, "destroy",
                    G_CALLBACK (on_DevS_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_2Mode_checkbutton, "toggled",
                    G_CALLBACK (on_DevDlg_2Mode_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_GraMode_checkbutton, "toggled",
                    G_CALLBACK (on_DevDlg_GraMode_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_FlkMode_checkbutton, "toggled",
                    G_CALLBACK (on_DevDlg_FlkMode_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_MltT_spinbutton, "changed",
                    G_CALLBACK (on_DevDlg_MltT_spinbutton_changed),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_Cas1_spinbutton, "changed",
                    G_CALLBACK (on_DevDlg_Cas1_spinbutton_changed),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_Cas2_spinbutton, "changed",
                    G_CALLBACK (on_DevDlg_Cas2_spinbutton_changed),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_Cas3_spinbutton, "changed",
                    G_CALLBACK (on_DevDlg_Cas3_spinbutton_changed),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_Cas4_spinbutton, "changed",
                    G_CALLBACK (on_DevDlg_Cas4_spinbutton_changed),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_Dplx_spinbutton, "changed",
                    G_CALLBACK (on_DevDlg_Dplx_spinbutton_changed),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_OK_button, "clicked",
                    G_CALLBACK (on_DevDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) DevDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_DevDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (DevS_dialog, DevS_dialog, "DevS_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (DevS_dialog, dialog_vbox2, "dialog_vbox2");
  GLADE_HOOKUP_OBJECT (DevS_dialog, vbox32, "vbox32");
  GLADE_HOOKUP_OBJECT (DevS_dialog, frame47, "frame47");
  GLADE_HOOKUP_OBJECT (DevS_dialog, vbox33, "vbox33");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_2Mode_checkbutton, "DevDlg_2Mode_checkbutton");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_GraMode_checkbutton, "DevDlg_GraMode_checkbutton");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_FlkMode_checkbutton, "DevDlg_FlkMode_checkbutton");
  GLADE_HOOKUP_OBJECT (DevS_dialog, hseparator1, "hseparator1");
  GLADE_HOOKUP_OBJECT (DevS_dialog, vbox34, "vbox34");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label124, "label124");
  GLADE_HOOKUP_OBJECT (DevS_dialog, frame48, "frame48");
  GLADE_HOOKUP_OBJECT (DevS_dialog, vbox35, "vbox35");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_MltT_hbox, "DevDlg_MltT_hbox");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label125, "label125");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_MltT_spinbutton, "DevDlg_MltT_spinbutton");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label126, "label126");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Cas1_hbox, "DevDlg_Cas1_hbox");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label127, "label127");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Cas1_spinbutton, "DevDlg_Cas1_spinbutton");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label128, "label128");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Cas2_hbox, "DevDlg_Cas2_hbox");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label129, "label129");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Cas2_spinbutton, "DevDlg_Cas2_spinbutton");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label130, "label130");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Cas3_hbox, "DevDlg_Cas3_hbox");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label131, "label131");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Cas3_spinbutton, "DevDlg_Cas3_spinbutton");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label132, "label132");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Cas4_hbox, "DevDlg_Cas4_hbox");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label133, "label133");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Cas4_spinbutton, "DevDlg_Cas4_spinbutton");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label134, "label134");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Dplx_hbox, "DevDlg_Dplx_hbox");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label135, "label135");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Dplx_spinbutton, "DevDlg_Dplx_spinbutton");
  GLADE_HOOKUP_OBJECT (DevS_dialog, label136, "label136");
  GLADE_HOOKUP_OBJECT_NO_REF (DevS_dialog, dialog_action_area2, "dialog_action_area2");
  GLADE_HOOKUP_OBJECT (DevS_dialog, hbuttonbox2, "hbuttonbox2");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_OK_button, "DevDlg_OK_button");
  GLADE_HOOKUP_OBJECT (DevS_dialog, DevDlg_Cancel_button, "DevDlg_Cancel_button");

  return DevS_dialog;
}

GtkWidget*
create_Msg_dialog (void)
{
  GtkWidget *Msg_dialog;
  GtkWidget *dialog_vbox3;
  GtkWidget *frame49;
  GtkWidget *MsgDlg_label;
  GtkWidget *dialog_action_area3;
  GtkWidget *hbuttonbox3;
  GtkWidget *MsgDlg_OK_button;
  GtkWidget *MsgDlg_Cancel_button;

  Msg_dialog = gtk_dialog_new ();
  gtk_window_set_position (GTK_WINDOW (Msg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (Msg_dialog), TRUE);
  gtk_window_set_default_size (GTK_WINDOW (Msg_dialog), 200, 130);
  gtk_window_set_resizable (GTK_WINDOW (Msg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (Msg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox3 = GTK_DIALOG (Msg_dialog)->vbox;
  gtk_widget_show (dialog_vbox3);

  frame49 = gtk_frame_new (NULL);
  gtk_widget_show (frame49);
  gtk_box_pack_start (GTK_BOX (dialog_vbox3), frame49, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame49), 15);
  gtk_frame_set_shadow_type (GTK_FRAME (frame49), GTK_SHADOW_NONE);

  MsgDlg_label = gtk_label_new ("");
  gtk_widget_show (MsgDlg_label);
  gtk_container_add (GTK_CONTAINER (frame49), MsgDlg_label);
  gtk_misc_set_alignment (GTK_MISC (MsgDlg_label), 0, 0.5);

  dialog_action_area3 = GTK_DIALOG (Msg_dialog)->action_area;
  gtk_widget_show (dialog_action_area3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area3), GTK_BUTTONBOX_END);

  hbuttonbox3 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox3);
  gtk_container_add (GTK_CONTAINER (dialog_action_area3), hbuttonbox3);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox3), GTK_BUTTONBOX_SPREAD);

  MsgDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (MsgDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox3), MsgDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (MsgDlg_OK_button, GTK_CAN_DEFAULT);

  MsgDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (MsgDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox3), MsgDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (MsgDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) Msg_dialog, "destroy",
                    G_CALLBACK (on_Msg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) Msg_dialog, "delete_event",
                    G_CALLBACK (on_Msg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) MsgDlg_OK_button, "clicked",
                    G_CALLBACK (on_MsgDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) MsgDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_MsgDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (Msg_dialog, Msg_dialog, "Msg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (Msg_dialog, dialog_vbox3, "dialog_vbox3");
  GLADE_HOOKUP_OBJECT (Msg_dialog, frame49, "frame49");
  GLADE_HOOKUP_OBJECT (Msg_dialog, MsgDlg_label, "MsgDlg_label");
  GLADE_HOOKUP_OBJECT_NO_REF (Msg_dialog, dialog_action_area3, "dialog_action_area3");
  GLADE_HOOKUP_OBJECT (Msg_dialog, hbuttonbox3, "hbuttonbox3");
  GLADE_HOOKUP_OBJECT (Msg_dialog, MsgDlg_OK_button, "MsgDlg_OK_button");
  GLADE_HOOKUP_OBJECT (Msg_dialog, MsgDlg_Cancel_button, "MsgDlg_Cancel_button");

  return Msg_dialog;
}

GtkWidget*
create_RegiPaper_dialog (void)
{
  GtkWidget *RegiPaper_dialog;
  GtkWidget *dialog_vbox4;
  GtkWidget *frame50;
  GtkWidget *vbox37;
  GtkWidget *RegiPaper_Cas1_hbox;
  GtkWidget *label140;
  GtkWidget *RegiPaper_Cas1_combo;
  GList *RegiPaper_Cas1_combo_items = NULL;
  GtkWidget *RegiPaper_Cas1_combo_entry;
  GtkWidget *RegiPaper_Cas2_hbox;
  GtkWidget *label143;
  GtkWidget *RegiPaper_Cas2_combo;
  GList *RegiPaper_Cas2_combo_items = NULL;
  GtkWidget *RegiPaper_Cas2_combo_entry;
  GtkWidget *RegiPaper_Cas3_hbox;
  GtkWidget *label235;
  GtkWidget *RegiPaper_Cas3_combo;
  GList *RegiPaper_Cas3_combo_items = NULL;
  GtkWidget *RegiPaper_Cas3_combo_entry;
  GtkWidget *RegiPaper_Cas4_hbox;
  GtkWidget *label237;
  GtkWidget *RegiPaper_Cas4_combo;
  GList *RegiPaper_Cas4_combo_items = NULL;
  GtkWidget *RegiPaper_Cas4_combo_entry;
  GtkWidget *label239;
  GtkWidget *dialog_action_area4;
  GtkWidget *hbuttonbox4;
  GtkWidget *RegiPaper_OK;
  GtkWidget *RegiPaper_Cancel;

  RegiPaper_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (RegiPaper_dialog), _("Register Paper Size in Cassettes"));
  gtk_window_set_position (GTK_WINDOW (RegiPaper_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (RegiPaper_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (RegiPaper_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (RegiPaper_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox4 = GTK_DIALOG (RegiPaper_dialog)->vbox;
  gtk_widget_show (dialog_vbox4);

  frame50 = gtk_frame_new (NULL);
  gtk_widget_show (frame50);
  gtk_box_pack_start (GTK_BOX (dialog_vbox4), frame50, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame50), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame50), GTK_SHADOW_NONE);

  vbox37 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox37);
  gtk_container_add (GTK_CONTAINER (frame50), vbox37);

  RegiPaper_Cas1_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (RegiPaper_Cas1_hbox);
  gtk_box_pack_start (GTK_BOX (vbox37), RegiPaper_Cas1_hbox, TRUE, TRUE, 0);

  label140 = gtk_label_new (_("Cassette 1:"));
  gtk_widget_show (label140);
  gtk_box_pack_start (GTK_BOX (RegiPaper_Cas1_hbox), label140, FALSE, FALSE, 20);
  gtk_label_set_justify (GTK_LABEL (label140), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label140), 0, 0.5);

  RegiPaper_Cas1_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (RegiPaper_Cas1_combo)->popwin),
                     "GladeParentKey", RegiPaper_Cas1_combo);
  gtk_widget_show (RegiPaper_Cas1_combo);
  gtk_box_pack_start (GTK_BOX (RegiPaper_Cas1_hbox), RegiPaper_Cas1_combo, TRUE, TRUE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (RegiPaper_Cas1_combo), 5);
  RegiPaper_Cas1_combo_items = g_list_append (RegiPaper_Cas1_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (RegiPaper_Cas1_combo), RegiPaper_Cas1_combo_items);
  g_list_free (RegiPaper_Cas1_combo_items);

  RegiPaper_Cas1_combo_entry = GTK_COMBO (RegiPaper_Cas1_combo)->entry;
  gtk_widget_show (RegiPaper_Cas1_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (RegiPaper_Cas1_combo_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (RegiPaper_Cas1_combo_entry), 8226);

  RegiPaper_Cas2_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (RegiPaper_Cas2_hbox);
  gtk_box_pack_start (GTK_BOX (vbox37), RegiPaper_Cas2_hbox, TRUE, TRUE, 0);

  label143 = gtk_label_new (_("Cassette 2:"));
  gtk_widget_show (label143);
  gtk_box_pack_start (GTK_BOX (RegiPaper_Cas2_hbox), label143, FALSE, FALSE, 20);
  gtk_label_set_justify (GTK_LABEL (label143), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label143), 0, 0.5);

  RegiPaper_Cas2_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (RegiPaper_Cas2_combo)->popwin),
                     "GladeParentKey", RegiPaper_Cas2_combo);
  gtk_widget_show (RegiPaper_Cas2_combo);
  gtk_box_pack_start (GTK_BOX (RegiPaper_Cas2_hbox), RegiPaper_Cas2_combo, TRUE, TRUE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (RegiPaper_Cas2_combo), 5);
  RegiPaper_Cas2_combo_items = g_list_append (RegiPaper_Cas2_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (RegiPaper_Cas2_combo), RegiPaper_Cas2_combo_items);
  g_list_free (RegiPaper_Cas2_combo_items);

  RegiPaper_Cas2_combo_entry = GTK_COMBO (RegiPaper_Cas2_combo)->entry;
  gtk_widget_show (RegiPaper_Cas2_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (RegiPaper_Cas2_combo_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (RegiPaper_Cas2_combo_entry), 8226);

  RegiPaper_Cas3_hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox37), RegiPaper_Cas3_hbox, TRUE, TRUE, 0);

  label235 = gtk_label_new (_("Cassette 3:"));
  gtk_widget_show (label235);
  gtk_box_pack_start (GTK_BOX (RegiPaper_Cas3_hbox), label235, FALSE, FALSE, 20);
  gtk_label_set_justify (GTK_LABEL (label235), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label235), 0, 0.5);

  RegiPaper_Cas3_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (RegiPaper_Cas3_combo)->popwin),
                     "GladeParentKey", RegiPaper_Cas3_combo);
  gtk_widget_show (RegiPaper_Cas3_combo);
  gtk_box_pack_start (GTK_BOX (RegiPaper_Cas3_hbox), RegiPaper_Cas3_combo, TRUE, TRUE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (RegiPaper_Cas3_combo), 5);
  RegiPaper_Cas3_combo_items = g_list_append (RegiPaper_Cas3_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (RegiPaper_Cas3_combo), RegiPaper_Cas3_combo_items);
  g_list_free (RegiPaper_Cas3_combo_items);

  RegiPaper_Cas3_combo_entry = GTK_COMBO (RegiPaper_Cas3_combo)->entry;
  gtk_widget_show (RegiPaper_Cas3_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (RegiPaper_Cas3_combo_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (RegiPaper_Cas3_combo_entry), 8226);

  RegiPaper_Cas4_hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox37), RegiPaper_Cas4_hbox, TRUE, TRUE, 0);

  label237 = gtk_label_new (_("Cassette 4:"));
  gtk_widget_show (label237);
  gtk_box_pack_start (GTK_BOX (RegiPaper_Cas4_hbox), label237, FALSE, FALSE, 20);
  gtk_label_set_justify (GTK_LABEL (label237), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label237), 0, 0.5);

  RegiPaper_Cas4_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (RegiPaper_Cas4_combo)->popwin),
                     "GladeParentKey", RegiPaper_Cas4_combo);
  gtk_widget_show (RegiPaper_Cas4_combo);
  gtk_box_pack_start (GTK_BOX (RegiPaper_Cas4_hbox), RegiPaper_Cas4_combo, TRUE, TRUE, 10);
  gtk_container_set_border_width (GTK_CONTAINER (RegiPaper_Cas4_combo), 5);
  RegiPaper_Cas4_combo_items = g_list_append (RegiPaper_Cas4_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (RegiPaper_Cas4_combo), RegiPaper_Cas4_combo_items);
  g_list_free (RegiPaper_Cas4_combo_items);

  RegiPaper_Cas4_combo_entry = GTK_COMBO (RegiPaper_Cas4_combo)->entry;
  gtk_widget_show (RegiPaper_Cas4_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (RegiPaper_Cas4_combo_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (RegiPaper_Cas4_combo_entry), 8226);

  label239 = gtk_label_new (_("Register Paper Sizes"));
  gtk_widget_show (label239);
  gtk_frame_set_label_widget (GTK_FRAME (frame50), label239);

  dialog_action_area4 = GTK_DIALOG (RegiPaper_dialog)->action_area;
  gtk_widget_show (dialog_action_area4);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area4), GTK_BUTTONBOX_END);

  hbuttonbox4 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox4);
  gtk_container_add (GTK_CONTAINER (dialog_action_area4), hbuttonbox4);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox4), GTK_BUTTONBOX_END);

  RegiPaper_OK = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (RegiPaper_OK);
  gtk_container_add (GTK_CONTAINER (hbuttonbox4), RegiPaper_OK);
  GTK_WIDGET_SET_FLAGS (RegiPaper_OK, GTK_CAN_DEFAULT);

  RegiPaper_Cancel = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (RegiPaper_Cancel);
  gtk_container_add (GTK_CONTAINER (hbuttonbox4), RegiPaper_Cancel);
  GTK_WIDGET_SET_FLAGS (RegiPaper_Cancel, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) RegiPaper_dialog, "destroy",
                    G_CALLBACK (on_RegiPaper_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) RegiPaper_dialog, "delete_event",
                    G_CALLBACK (on_RegiPaper_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) RegiPaper_Cas1_combo_entry, "changed",
                    G_CALLBACK (on_RegiPaper_Cas1_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) RegiPaper_Cas2_combo_entry, "changed",
                    G_CALLBACK (on_RegiPaper_Cas2_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) RegiPaper_Cas3_combo_entry, "changed",
                    G_CALLBACK (on_RegiPaper_Cas3_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) RegiPaper_Cas4_combo_entry, "changed",
                    G_CALLBACK (on_RegiPaper_Cas4_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) RegiPaper_OK, "clicked",
                    G_CALLBACK (on_RegiPaper_OK_clicked),
                    NULL);
  g_signal_connect ((gpointer) RegiPaper_Cancel, "clicked",
                    G_CALLBACK (on_RegiPaper_Cancel_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (RegiPaper_dialog, RegiPaper_dialog, "RegiPaper_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (RegiPaper_dialog, dialog_vbox4, "dialog_vbox4");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, frame50, "frame50");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, vbox37, "vbox37");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas1_hbox, "RegiPaper_Cas1_hbox");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, label140, "label140");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas1_combo, "RegiPaper_Cas1_combo");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas1_combo_entry, "RegiPaper_Cas1_combo_entry");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas2_hbox, "RegiPaper_Cas2_hbox");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, label143, "label143");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas2_combo, "RegiPaper_Cas2_combo");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas2_combo_entry, "RegiPaper_Cas2_combo_entry");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas3_hbox, "RegiPaper_Cas3_hbox");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, label235, "label235");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas3_combo, "RegiPaper_Cas3_combo");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas3_combo_entry, "RegiPaper_Cas3_combo_entry");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas4_hbox, "RegiPaper_Cas4_hbox");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, label237, "label237");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas4_combo, "RegiPaper_Cas4_combo");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cas4_combo_entry, "RegiPaper_Cas4_combo_entry");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, label239, "label239");
  GLADE_HOOKUP_OBJECT_NO_REF (RegiPaper_dialog, dialog_action_area4, "dialog_action_area4");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, hbuttonbox4, "hbuttonbox4");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_OK, "RegiPaper_OK");
  GLADE_HOOKUP_OBJECT (RegiPaper_dialog, RegiPaper_Cancel, "RegiPaper_Cancel");

  return RegiPaper_dialog;
}

GtkWidget*
create_ConsumablesCounters_dialog (void)
{
  GtkWidget *ConsumablesCounters_dialog;
  GtkWidget *dialog_vbox5;
  GtkWidget *vbox38;
  GtkWidget *frame51;
  GtkWidget *table1;
  GtkWidget *label147;
  GtkWidget *label145;
  GtkWidget *label146;
  GtkWidget *label148;
  GtkWidget *CCDlg_Black_label;
  GtkWidget *CCDlg_Yellow_label;
  GtkWidget *CCDlg_Magenta_label;
  GtkWidget *CCDlg_Cyan_label;
  GtkWidget *CCDlg_Yellow_Dummy;
  GtkWidget *CCDlg_Magenta_Dummy;
  GtkWidget *CCDlg_Cyan_Dummy;
  GtkWidget *CCDlg_Black_Dummy;
  GtkWidget *label144;
  GtkWidget *frame58;
  GtkWidget *table4;
  GtkWidget *label176;
  GtkWidget *CCDlg_WasteToner_label;
  GtkWidget *label196;
  GtkWidget *label187;
  GtkWidget *frame65;
  GtkWidget *table8;
  GtkWidget *label293;
  GtkWidget *CCDlg_DrumCartridge_label;
  GtkWidget *label295;
  GtkWidget *label296;
  GtkWidget *frame52;
  GtkWidget *table2;
  GtkWidget *label149;
  GtkWidget *label150;
  GtkWidget *CCDlg_Mono_Cnt_label;
  GtkWidget *CCDlg_Color_Cnt_label;
  GtkWidget *label188;
  GtkWidget *label189;
  GtkWidget *label190;
  GtkWidget *label191;
  GtkWidget *CCDlg_MonoS_Cnt_label;
  GtkWidget *CCDlg_MonoL_Cnt_label;
  GtkWidget *CCDlg_ColorS_Cnt_label;
  GtkWidget *CCDlg_ColorL_Cnt_label;
  GtkWidget *label241;
  GtkWidget *label242;
  GtkWidget *CCDlg_Duplex_Cnt_label;
  GtkWidget *CCDlg_Job_Cnt_label;
  GtkWidget *CCDlg_TotalPrint_Cnt_label;
  GtkWidget *label240;
  GtkWidget *Frame_label149;
  GtkWidget *dialog_action_area5;
  GtkWidget *hbuttonbox5;
  GtkWidget *CCDlg_OK_button;

  ConsumablesCounters_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (ConsumablesCounters_dialog), _("Consumables/Counters"));
  gtk_window_set_position (GTK_WINDOW (ConsumablesCounters_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (ConsumablesCounters_dialog), TRUE);
  gtk_window_set_default_size (GTK_WINDOW (ConsumablesCounters_dialog), 320, -1);
  gtk_window_set_type_hint (GTK_WINDOW (ConsumablesCounters_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox5 = GTK_DIALOG (ConsumablesCounters_dialog)->vbox;
  gtk_widget_show (dialog_vbox5);

  vbox38 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox38);
  gtk_box_pack_start (GTK_BOX (dialog_vbox5), vbox38, TRUE, TRUE, 0);

  frame51 = gtk_frame_new (NULL);
  gtk_widget_show (frame51);
  gtk_box_pack_start (GTK_BOX (vbox38), frame51, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame51), 7);

  table1 = gtk_table_new (4, 3, FALSE);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame51), table1);

  label147 = gtk_label_new (_("Magenta:"));
  gtk_widget_show (label147);
  gtk_table_attach (GTK_TABLE (table1), label147, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label147), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label147), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label147), 30, 3);

  label145 = gtk_label_new (_("Black:"));
  gtk_widget_show (label145);
  gtk_table_attach (GTK_TABLE (table1), label145, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label145), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label145), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label145), 30, 3);

  label146 = gtk_label_new (_("Yellow:"));
  gtk_widget_show (label146);
  gtk_table_attach (GTK_TABLE (table1), label146, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label146), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label146), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label146), 30, 3);

  label148 = gtk_label_new (_("Cyan:"));
  gtk_widget_show (label148);
  gtk_table_attach (GTK_TABLE (table1), label148, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label148), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label148), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label148), 30, 4);

  CCDlg_Black_label = gtk_label_new ("");
  gtk_widget_show (CCDlg_Black_label);
  gtk_table_attach (GTK_TABLE (table1), CCDlg_Black_label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_Black_label), GTK_JUSTIFY_CENTER);

  CCDlg_Yellow_label = gtk_label_new ("");
  gtk_widget_show (CCDlg_Yellow_label);
  gtk_table_attach (GTK_TABLE (table1), CCDlg_Yellow_label, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_Yellow_label), GTK_JUSTIFY_CENTER);

  CCDlg_Magenta_label = gtk_label_new ("");
  gtk_widget_show (CCDlg_Magenta_label);
  gtk_table_attach (GTK_TABLE (table1), CCDlg_Magenta_label, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_Magenta_label), GTK_JUSTIFY_CENTER);

  CCDlg_Cyan_label = gtk_label_new ("");
  gtk_widget_show (CCDlg_Cyan_label);
  gtk_table_attach (GTK_TABLE (table1), CCDlg_Cyan_label, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_Cyan_label), GTK_JUSTIFY_CENTER);

  CCDlg_Yellow_Dummy = gtk_label_new ("");
  gtk_widget_show (CCDlg_Yellow_Dummy);
  gtk_table_attach (GTK_TABLE (table1), CCDlg_Yellow_Dummy, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (CCDlg_Yellow_Dummy, 8, -1);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_Yellow_Dummy), 0, 0.5);

  CCDlg_Magenta_Dummy = gtk_label_new ("");
  gtk_widget_show (CCDlg_Magenta_Dummy);
  gtk_table_attach (GTK_TABLE (table1), CCDlg_Magenta_Dummy, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (CCDlg_Magenta_Dummy, 8, -1);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_Magenta_Dummy), 0, 0.5);

  CCDlg_Cyan_Dummy = gtk_label_new ("");
  gtk_widget_show (CCDlg_Cyan_Dummy);
  gtk_table_attach (GTK_TABLE (table1), CCDlg_Cyan_Dummy, 2, 3, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (CCDlg_Cyan_Dummy, 8, -1);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_Cyan_Dummy), 0, 0.5);

  CCDlg_Black_Dummy = gtk_label_new ("");
  gtk_widget_show (CCDlg_Black_Dummy);
  gtk_table_attach (GTK_TABLE (table1), CCDlg_Black_Dummy, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_Black_Dummy), GTK_JUSTIFY_CENTER);

  label144 = gtk_label_new (_("Toner Cartridge Information"));
  gtk_widget_show (label144);
  gtk_frame_set_label_widget (GTK_FRAME (frame51), label144);

  frame58 = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox38), frame58, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame58), 7);

  table4 = gtk_table_new (1, 3, FALSE);
  gtk_widget_show (table4);
  gtk_container_add (GTK_CONTAINER (frame58), table4);

  label176 = gtk_label_new ("");
  gtk_widget_show (label176);
  gtk_table_attach (GTK_TABLE (table4), label176, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label176), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label176), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label176), 30, 3);

  CCDlg_WasteToner_label = gtk_label_new ("");
  gtk_widget_show (CCDlg_WasteToner_label);
  gtk_table_attach (GTK_TABLE (table4), CCDlg_WasteToner_label, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_WasteToner_label), GTK_JUSTIFY_CENTER);

  label196 = gtk_label_new ("");
  gtk_widget_show (label196);
  gtk_table_attach (GTK_TABLE (table4), label196, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label196), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label196), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label196), 30, 3);

  label187 = gtk_label_new (_("Waste Toner Container Information"));
  gtk_widget_show (label187);
  gtk_frame_set_label_widget (GTK_FRAME (frame58), label187);

  frame65 = gtk_frame_new (NULL);
  gtk_box_pack_start (GTK_BOX (vbox38), frame65, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame65), 7);

  table8 = gtk_table_new (1, 3, FALSE);
  gtk_widget_show (table8);
  gtk_container_add (GTK_CONTAINER (frame65), table8);

  label293 = gtk_label_new ("");
  gtk_widget_show (label293);
  gtk_table_attach (GTK_TABLE (table8), label293, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label293), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label293), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label293), 30, 3);

  CCDlg_DrumCartridge_label = gtk_label_new ("");
  gtk_widget_show (CCDlg_DrumCartridge_label);
  gtk_table_attach (GTK_TABLE (table8), CCDlg_DrumCartridge_label, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_DrumCartridge_label), GTK_JUSTIFY_CENTER);

  label295 = gtk_label_new ("");
  gtk_widget_show (label295);
  gtk_table_attach (GTK_TABLE (table8), label295, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label295), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label295), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label295), 30, 3);

  label296 = gtk_label_new (_("Drum Cartridge Information"));
  gtk_widget_show (label296);
  gtk_frame_set_label_widget (GTK_FRAME (frame65), label296);

  frame52 = gtk_frame_new (NULL);
  gtk_widget_show (frame52);
  gtk_box_pack_start (GTK_BOX (vbox38), frame52, FALSE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame52), 7);

  table2 = gtk_table_new (9, 2, FALSE);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame52), table2);

  label149 = gtk_label_new (_("Black & White:"));
  gtk_widget_show (label149);
  gtk_table_attach (GTK_TABLE (table2), label149, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label149), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label149), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label149), 30, 3);

  label150 = gtk_label_new (_("Color:"));
  gtk_widget_show (label150);
  gtk_table_attach (GTK_TABLE (table2), label150, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label150), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label150), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label150), 30, 3);

  CCDlg_Mono_Cnt_label = gtk_label_new ("");
  gtk_widget_show (CCDlg_Mono_Cnt_label);
  gtk_table_attach (GTK_TABLE (table2), CCDlg_Mono_Cnt_label, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_Mono_Cnt_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_Mono_Cnt_label), 0, 0.5);

  CCDlg_Color_Cnt_label = gtk_label_new ("");
  gtk_widget_show (CCDlg_Color_Cnt_label);
  gtk_table_attach (GTK_TABLE (table2), CCDlg_Color_Cnt_label, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_Color_Cnt_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_Color_Cnt_label), 0, 0.5);

  label188 = gtk_label_new (_("Black & White S:"));
  gtk_table_attach (GTK_TABLE (table2), label188, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label188), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label188), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label188), 30, 3);

  label189 = gtk_label_new (_("Black & White L:"));
  gtk_table_attach (GTK_TABLE (table2), label189, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label189), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label189), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label189), 30, 3);

  label190 = gtk_label_new (_("Color S:"));
  gtk_table_attach (GTK_TABLE (table2), label190, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label190), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label190), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label190), 30, 3);

  label191 = gtk_label_new (_("Color L:"));
  gtk_table_attach (GTK_TABLE (table2), label191, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label191), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label191), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label191), 30, 3);

  CCDlg_MonoS_Cnt_label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table2), CCDlg_MonoS_Cnt_label, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_MonoS_Cnt_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_MonoS_Cnt_label), 0, 0.5);

  CCDlg_MonoL_Cnt_label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table2), CCDlg_MonoL_Cnt_label, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_MonoL_Cnt_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_MonoL_Cnt_label), 0, 0.5);

  CCDlg_ColorS_Cnt_label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table2), CCDlg_ColorS_Cnt_label, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_ColorS_Cnt_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_ColorS_Cnt_label), 0, 0.5);

  CCDlg_ColorL_Cnt_label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table2), CCDlg_ColorL_Cnt_label, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_ColorL_Cnt_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_ColorL_Cnt_label), 0, 0.5);

  label241 = gtk_label_new (_("Number of 2-sided Printing Sheets:"));
  gtk_table_attach (GTK_TABLE (table2), label241, 0, 1, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label241), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label241), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label241), 30, 3);

  label242 = gtk_label_new (_("Number of Jobs:"));
  gtk_table_attach (GTK_TABLE (table2), label242, 0, 1, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label242), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label242), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label242), 30, 3);

  CCDlg_Duplex_Cnt_label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table2), CCDlg_Duplex_Cnt_label, 1, 2, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_Duplex_Cnt_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_Duplex_Cnt_label), 0, 0.5);

  CCDlg_Job_Cnt_label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table2), CCDlg_Job_Cnt_label, 1, 2, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_Job_Cnt_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_Job_Cnt_label), 0, 0.5);

  CCDlg_TotalPrint_Cnt_label = gtk_label_new ("");
  gtk_table_attach (GTK_TABLE (table2), CCDlg_TotalPrint_Cnt_label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (CCDlg_TotalPrint_Cnt_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (CCDlg_TotalPrint_Cnt_label), 0, 0.5);

  label240 = gtk_label_new (_("Total Printed Pages:"));
  gtk_table_attach (GTK_TABLE (table2), label240, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label240), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label240), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (label240), 30, 3);

  Frame_label149 = gtk_label_new (_("Number of Total Printed Pages"));
  gtk_widget_show (Frame_label149);
  gtk_frame_set_label_widget (GTK_FRAME (frame52), Frame_label149);

  dialog_action_area5 = GTK_DIALOG (ConsumablesCounters_dialog)->action_area;
  gtk_widget_show (dialog_action_area5);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area5), GTK_BUTTONBOX_END);

  hbuttonbox5 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox5);
  gtk_container_add (GTK_CONTAINER (dialog_action_area5), hbuttonbox5);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox5), GTK_BUTTONBOX_END);

  CCDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (CCDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox5), CCDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (CCDlg_OK_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) ConsumablesCounters_dialog, "destroy",
                    G_CALLBACK (on_ConsumablesCounters_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) ConsumablesCounters_dialog, "delete_event",
                    G_CALLBACK (on_ConsumablesCounters_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) CCDlg_OK_button, "clicked",
                    G_CALLBACK (on_CCDlg_OK_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (ConsumablesCounters_dialog, ConsumablesCounters_dialog, "ConsumablesCounters_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (ConsumablesCounters_dialog, dialog_vbox5, "dialog_vbox5");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, vbox38, "vbox38");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, frame51, "frame51");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, table1, "table1");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label147, "label147");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label145, "label145");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label146, "label146");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label148, "label148");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Black_label, "CCDlg_Black_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Yellow_label, "CCDlg_Yellow_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Magenta_label, "CCDlg_Magenta_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Cyan_label, "CCDlg_Cyan_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Yellow_Dummy, "CCDlg_Yellow_Dummy");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Magenta_Dummy, "CCDlg_Magenta_Dummy");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Cyan_Dummy, "CCDlg_Cyan_Dummy");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Black_Dummy, "CCDlg_Black_Dummy");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label144, "label144");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, frame58, "frame58");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, table4, "table4");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label176, "label176");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_WasteToner_label, "CCDlg_WasteToner_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label196, "label196");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label187, "label187");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, frame65, "frame65");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, table8, "table8");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label293, "label293");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_DrumCartridge_label, "CCDlg_DrumCartridge_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label295, "label295");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label296, "label296");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, frame52, "frame52");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, table2, "table2");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label149, "label149");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label150, "label150");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Mono_Cnt_label, "CCDlg_Mono_Cnt_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Color_Cnt_label, "CCDlg_Color_Cnt_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label188, "label188");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label189, "label189");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label190, "label190");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label191, "label191");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_MonoS_Cnt_label, "CCDlg_MonoS_Cnt_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_MonoL_Cnt_label, "CCDlg_MonoL_Cnt_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_ColorS_Cnt_label, "CCDlg_ColorS_Cnt_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_ColorL_Cnt_label, "CCDlg_ColorL_Cnt_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label241, "label241");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label242, "label242");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Duplex_Cnt_label, "CCDlg_Duplex_Cnt_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_Job_Cnt_label, "CCDlg_Job_Cnt_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_TotalPrint_Cnt_label, "CCDlg_TotalPrint_Cnt_label");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, label240, "label240");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, Frame_label149, "Frame_label149");
  GLADE_HOOKUP_OBJECT_NO_REF (ConsumablesCounters_dialog, dialog_action_area5, "dialog_action_area5");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, hbuttonbox5, "hbuttonbox5");
  GLADE_HOOKUP_OBJECT (ConsumablesCounters_dialog, CCDlg_OK_button, "CCDlg_OK_button");

  return ConsumablesCounters_dialog;
}

GtkWidget*
create_SleepS_dialog (void)
{
  GtkWidget *SleepS_dialog;
  GtkWidget *dialog_vbox6;
  GtkWidget *frame53;
  GtkWidget *vbox39;
  GtkWidget *SleepSDlg_Use_checkbutton;
  GtkWidget *hbox61;
  GtkWidget *label157;
  GtkWidget *SleepSDlg_Time_combo;
  GList *SleepSDlg_Time_combo_items = NULL;
  GtkWidget *SleepSDlg_Time_combo_entry;
  GtkWidget *label158;
  GtkWidget *dialog_action_area6;
  GtkWidget *hbuttonbox6;
  GtkWidget *SleepSDlg_OK_button;
  GtkWidget *SleepSDlg_Cancel_button;

  SleepS_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (SleepS_dialog), _("Sleep Settings"));
  gtk_window_set_position (GTK_WINDOW (SleepS_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (SleepS_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (SleepS_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (SleepS_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox6 = GTK_DIALOG (SleepS_dialog)->vbox;
  gtk_widget_show (dialog_vbox6);

  frame53 = gtk_frame_new (NULL);
  gtk_widget_show (frame53);
  gtk_box_pack_start (GTK_BOX (dialog_vbox6), frame53, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame53), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame53), GTK_SHADOW_NONE);

  vbox39 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox39);
  gtk_container_add (GTK_CONTAINER (frame53), vbox39);

  SleepSDlg_Use_checkbutton = gtk_check_button_new_with_mnemonic (_("Use Sleep Mode"));
  gtk_widget_show (SleepSDlg_Use_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox39), SleepSDlg_Use_checkbutton, FALSE, FALSE, 0);

  hbox61 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox61);
  gtk_box_pack_start (GTK_BOX (vbox39), hbox61, TRUE, TRUE, 0);

  label157 = gtk_label_new (_("Time to Enter Sleep Mode:   "));
  gtk_widget_show (label157);
  gtk_box_pack_start (GTK_BOX (hbox61), label157, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label157), GTK_JUSTIFY_CENTER);
  gtk_misc_set_padding (GTK_MISC (label157), 3, 0);

  SleepSDlg_Time_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (SleepSDlg_Time_combo)->popwin),
                     "GladeParentKey", SleepSDlg_Time_combo);
  gtk_widget_show (SleepSDlg_Time_combo);
  gtk_box_pack_start (GTK_BOX (hbox61), SleepSDlg_Time_combo, TRUE, TRUE, 0);
  SleepSDlg_Time_combo_items = g_list_append (SleepSDlg_Time_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (SleepSDlg_Time_combo), SleepSDlg_Time_combo_items);
  g_list_free (SleepSDlg_Time_combo_items);

  SleepSDlg_Time_combo_entry = GTK_COMBO (SleepSDlg_Time_combo)->entry;
  gtk_widget_show (SleepSDlg_Time_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (SleepSDlg_Time_combo_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (SleepSDlg_Time_combo_entry), 8226);

  label158 = gtk_label_new (_("minutes"));
  gtk_widget_show (label158);
  gtk_box_pack_start (GTK_BOX (hbox61), label158, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label158), GTK_JUSTIFY_CENTER);
  gtk_misc_set_padding (GTK_MISC (label158), 3, 0);

  dialog_action_area6 = GTK_DIALOG (SleepS_dialog)->action_area;
  gtk_widget_show (dialog_action_area6);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area6), GTK_BUTTONBOX_END);

  hbuttonbox6 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox6);
  gtk_container_add (GTK_CONTAINER (dialog_action_area6), hbuttonbox6);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox6), GTK_BUTTONBOX_END);

  SleepSDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (SleepSDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox6), SleepSDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (SleepSDlg_OK_button, GTK_CAN_DEFAULT);

  SleepSDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (SleepSDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox6), SleepSDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (SleepSDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) SleepS_dialog, "delete_event",
                    G_CALLBACK (on_SleepS_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) SleepS_dialog, "destroy",
                    G_CALLBACK (on_SleepS_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) SleepSDlg_Use_checkbutton, "toggled",
                    G_CALLBACK (on_SleepSDlg_Use_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) SleepSDlg_Time_combo_entry, "changed",
                    G_CALLBACK (on_SleepSDlg_Time_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) SleepSDlg_OK_button, "clicked",
                    G_CALLBACK (on_SleepSDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) SleepSDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_SleepSDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (SleepS_dialog, SleepS_dialog, "SleepS_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (SleepS_dialog, dialog_vbox6, "dialog_vbox6");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, frame53, "frame53");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, vbox39, "vbox39");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, SleepSDlg_Use_checkbutton, "SleepSDlg_Use_checkbutton");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, hbox61, "hbox61");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, label157, "label157");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, SleepSDlg_Time_combo, "SleepSDlg_Time_combo");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, SleepSDlg_Time_combo_entry, "SleepSDlg_Time_combo_entry");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, label158, "label158");
  GLADE_HOOKUP_OBJECT_NO_REF (SleepS_dialog, dialog_action_area6, "dialog_action_area6");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, hbuttonbox6, "hbuttonbox6");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, SleepSDlg_OK_button, "SleepSDlg_OK_button");
  GLADE_HOOKUP_OBJECT (SleepS_dialog, SleepSDlg_Cancel_button, "SleepSDlg_Cancel_button");

  return SleepS_dialog;
}

GtkWidget*
create_CancelJobKeyDlg_dialog (void)
{
  GtkWidget *CancelJobKeyDlg_dialog;
  GtkWidget *dialog_vbox7;
  GtkWidget *frame54;
  GtkWidget *vbox40;
  GtkWidget *CJKDlg_ErrorJob_checkbutton;
  GtkWidget *hbox62;
  GtkWidget *label159;
  GtkWidget *CJKDlg_PrintJob_checkbutton;
  GtkWidget *dialog_action_area7;
  GtkWidget *hbuttonbox7;
  GtkWidget *CJKDlg_OK_button;
  GtkWidget *CJKDlg_Cancel_button;

  CancelJobKeyDlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (CancelJobKeyDlg_dialog), _("Settings of the Cancel Job Key"));
  gtk_window_set_position (GTK_WINDOW (CancelJobKeyDlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (CancelJobKeyDlg_dialog), TRUE);
  gtk_window_set_default_size (GTK_WINDOW (CancelJobKeyDlg_dialog), 400, -1);
  gtk_window_set_type_hint (GTK_WINDOW (CancelJobKeyDlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox7 = GTK_DIALOG (CancelJobKeyDlg_dialog)->vbox;
  gtk_widget_show (dialog_vbox7);

  frame54 = gtk_frame_new (NULL);
  gtk_widget_show (frame54);
  gtk_box_pack_start (GTK_BOX (dialog_vbox7), frame54, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame54), 10);
  gtk_frame_set_shadow_type (GTK_FRAME (frame54), GTK_SHADOW_NONE);

  vbox40 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox40);
  gtk_container_add (GTK_CONTAINER (frame54), vbox40);

  CJKDlg_ErrorJob_checkbutton = gtk_check_button_new_with_mnemonic (_("Enable to Cancel Error Jobs"));
  gtk_widget_show (CJKDlg_ErrorJob_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox40), CJKDlg_ErrorJob_checkbutton, FALSE, FALSE, 0);

  hbox62 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox62);
  gtk_box_pack_start (GTK_BOX (vbox40), hbox62, FALSE, FALSE, 0);

  label159 = gtk_label_new ("");
  gtk_widget_show (label159);
  gtk_box_pack_start (GTK_BOX (hbox62), label159, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label159), GTK_JUSTIFY_CENTER);
  gtk_misc_set_padding (GTK_MISC (label159), 7, 0);

  CJKDlg_PrintJob_checkbutton = gtk_check_button_new_with_mnemonic (_("Enable to Cancel Any Processing Print Job"));
  gtk_widget_show (CJKDlg_PrintJob_checkbutton);
  gtk_box_pack_start (GTK_BOX (hbox62), CJKDlg_PrintJob_checkbutton, FALSE, FALSE, 0);

  dialog_action_area7 = GTK_DIALOG (CancelJobKeyDlg_dialog)->action_area;
  gtk_widget_show (dialog_action_area7);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area7), GTK_BUTTONBOX_END);

  hbuttonbox7 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox7);
  gtk_container_add (GTK_CONTAINER (dialog_action_area7), hbuttonbox7);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox7), GTK_BUTTONBOX_END);

  CJKDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (CJKDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox7), CJKDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (CJKDlg_OK_button, GTK_CAN_DEFAULT);

  CJKDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (CJKDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox7), CJKDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (CJKDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) CancelJobKeyDlg_dialog, "delete_event",
                    G_CALLBACK (on_CancelJobKeyDlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) CancelJobKeyDlg_dialog, "destroy",
                    G_CALLBACK (on_CancelJobKeyDlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) CJKDlg_ErrorJob_checkbutton, "toggled",
                    G_CALLBACK (on_CJKDlg_ErrorJob_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) CJKDlg_PrintJob_checkbutton, "toggled",
                    G_CALLBACK (on_CJKDlg_PrintJob_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) CJKDlg_OK_button, "clicked",
                    G_CALLBACK (on_CJKDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) CJKDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_CJKDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (CancelJobKeyDlg_dialog, CancelJobKeyDlg_dialog, "CancelJobKeyDlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (CancelJobKeyDlg_dialog, dialog_vbox7, "dialog_vbox7");
  GLADE_HOOKUP_OBJECT (CancelJobKeyDlg_dialog, frame54, "frame54");
  GLADE_HOOKUP_OBJECT (CancelJobKeyDlg_dialog, vbox40, "vbox40");
  GLADE_HOOKUP_OBJECT (CancelJobKeyDlg_dialog, CJKDlg_ErrorJob_checkbutton, "CJKDlg_ErrorJob_checkbutton");
  GLADE_HOOKUP_OBJECT (CancelJobKeyDlg_dialog, hbox62, "hbox62");
  GLADE_HOOKUP_OBJECT (CancelJobKeyDlg_dialog, label159, "label159");
  GLADE_HOOKUP_OBJECT (CancelJobKeyDlg_dialog, CJKDlg_PrintJob_checkbutton, "CJKDlg_PrintJob_checkbutton");
  GLADE_HOOKUP_OBJECT_NO_REF (CancelJobKeyDlg_dialog, dialog_action_area7, "dialog_action_area7");
  GLADE_HOOKUP_OBJECT (CancelJobKeyDlg_dialog, hbuttonbox7, "hbuttonbox7");
  GLADE_HOOKUP_OBJECT (CancelJobKeyDlg_dialog, CJKDlg_OK_button, "CJKDlg_OK_button");
  GLADE_HOOKUP_OBJECT (CancelJobKeyDlg_dialog, CJKDlg_Cancel_button, "CJKDlg_Cancel_button");

  return CancelJobKeyDlg_dialog;
}

GtkWidget*
create_NetworkSDlg_dialog (void)
{
  GtkWidget *NetworkSDlg_dialog;
  GtkWidget *dialog_vbox8;
  GtkWidget *frame55;
  GtkWidget *table3;
  GtkWidget *label160;
  GtkWidget *NetworkSDlg_RARP_checkbutton;
  GtkWidget *NetworkSDlg_BOOTP_checkbutton;
  GtkWidget *NetworkSDlg_DHCP_checkbutton;
  GtkWidget *label161;
  GtkWidget *label162;
  GtkWidget *label163;
  GtkWidget *NetworkSDlg_IPSetting_combo;
  GList *NetworkSDlg_IPSetting_combo_items = NULL;
  GtkWidget *NetworkSDlg_IPSetting_combo_entry;
  GtkWidget *NetworkSDlg_IP_hbox;
  GtkWidget *NetworkSDlg_IP1_entry;
  GtkWidget *NetworkSDlg_IP2_entry;
  GtkWidget *NetworkSDlg_IP3_entry;
  GtkWidget *NetworkSDlg_IP4_entry;
  GtkWidget *NetworkSDlg_Sub_hbox;
  GtkWidget *NetworkSDlg_Sub1_entry;
  GtkWidget *NetworkSDlg_Sub2_entry;
  GtkWidget *NetworkSDlg_Sub3_entry;
  GtkWidget *NetworkSDlg_Sub4_entry;
  GtkWidget *NetworkSDlg_Gate_hbox;
  GtkWidget *NetworkSDlg_Gate1_entry;
  GtkWidget *NetworkSDlg_Gate2_entry;
  GtkWidget *NetworkSDlg_Gate3_entry;
  GtkWidget *NetworkSDlg_Gate4_entry;
  GtkWidget *Frame_label160;
  GtkWidget *hbox63;
  GtkWidget *label164;
  GtkWidget *NetworkSDlg_Password_entry;
  GtkWidget *dialog_action_area8;
  GtkWidget *hbuttonbox8;
  GtkWidget *NetWorkSDlg_OK_button;
  GtkWidget *NetworkSDlg_button;

  NetworkSDlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (NetworkSDlg_dialog), _("Network Settings"));
  gtk_window_set_position (GTK_WINDOW (NetworkSDlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (NetworkSDlg_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (NetworkSDlg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (NetworkSDlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox8 = GTK_DIALOG (NetworkSDlg_dialog)->vbox;
  gtk_widget_show (dialog_vbox8);

  frame55 = gtk_frame_new (NULL);
  gtk_widget_show (frame55);
  gtk_box_pack_start (GTK_BOX (dialog_vbox8), frame55, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame55), 5);

  table3 = gtk_table_new (7, 2, TRUE);
  gtk_widget_show (table3);
  gtk_container_add (GTK_CONTAINER (frame55), table3);

  label160 = gtk_label_new (_("IP Address Setting with:"));
  gtk_widget_show (label160);
  gtk_table_attach (GTK_TABLE (table3), label160, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label160), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label160), 0, 0.5);

  NetworkSDlg_RARP_checkbutton = gtk_check_button_new_with_mnemonic (_("RARP"));
  gtk_widget_show (NetworkSDlg_RARP_checkbutton);
  gtk_table_attach (GTK_TABLE (table3), NetworkSDlg_RARP_checkbutton, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  NetworkSDlg_BOOTP_checkbutton = gtk_check_button_new_with_mnemonic (_("BOOTP"));
  gtk_widget_show (NetworkSDlg_BOOTP_checkbutton);
  gtk_table_attach (GTK_TABLE (table3), NetworkSDlg_BOOTP_checkbutton, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  NetworkSDlg_DHCP_checkbutton = gtk_check_button_new_with_mnemonic (_("DHCP"));
  gtk_widget_show (NetworkSDlg_DHCP_checkbutton);
  gtk_table_attach (GTK_TABLE (table3), NetworkSDlg_DHCP_checkbutton, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label161 = gtk_label_new (_("IP Address:"));
  gtk_widget_show (label161);
  gtk_table_attach (GTK_TABLE (table3), label161, 0, 1, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label161), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label161), 0, 0.5);

  label162 = gtk_label_new (_("Subnet Mask:"));
  gtk_widget_show (label162);
  gtk_table_attach (GTK_TABLE (table3), label162, 0, 1, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label162), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label162), 0, 0.5);

  label163 = gtk_label_new (_("Gateway Address:"));
  gtk_widget_show (label163);
  gtk_table_attach (GTK_TABLE (table3), label163, 0, 1, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (label163), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label163), 0, 0.5);

  NetworkSDlg_IPSetting_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (NetworkSDlg_IPSetting_combo)->popwin),
                     "GladeParentKey", NetworkSDlg_IPSetting_combo);
  gtk_widget_show (NetworkSDlg_IPSetting_combo);
  gtk_table_attach (GTK_TABLE (table3), NetworkSDlg_IPSetting_combo, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (NetworkSDlg_IPSetting_combo), 3);
  NetworkSDlg_IPSetting_combo_items = g_list_append (NetworkSDlg_IPSetting_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (NetworkSDlg_IPSetting_combo), NetworkSDlg_IPSetting_combo_items);
  g_list_free (NetworkSDlg_IPSetting_combo_items);

  NetworkSDlg_IPSetting_combo_entry = GTK_COMBO (NetworkSDlg_IPSetting_combo)->entry;
  gtk_widget_show (NetworkSDlg_IPSetting_combo_entry);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_IPSetting_combo_entry), 8226);

  NetworkSDlg_IP_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (NetworkSDlg_IP_hbox);
  gtk_table_attach (GTK_TABLE (table3), NetworkSDlg_IP_hbox, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  NetworkSDlg_IP1_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_IP1_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_IP_hbox), NetworkSDlg_IP1_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_IP1_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_IP1_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_IP1_entry), 3);

  NetworkSDlg_IP2_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_IP2_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_IP_hbox), NetworkSDlg_IP2_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_IP2_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_IP2_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_IP2_entry), 3);

  NetworkSDlg_IP3_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_IP3_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_IP_hbox), NetworkSDlg_IP3_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_IP3_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_IP3_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_IP3_entry), 3);

  NetworkSDlg_IP4_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_IP4_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_IP_hbox), NetworkSDlg_IP4_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_IP4_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_IP4_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_IP4_entry), 3);

  NetworkSDlg_Sub_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (NetworkSDlg_Sub_hbox);
  gtk_table_attach (GTK_TABLE (table3), NetworkSDlg_Sub_hbox, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  NetworkSDlg_Sub1_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_Sub1_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_Sub_hbox), NetworkSDlg_Sub1_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_Sub1_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_Sub1_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_Sub1_entry), 3);

  NetworkSDlg_Sub2_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_Sub2_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_Sub_hbox), NetworkSDlg_Sub2_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_Sub2_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_Sub2_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_Sub2_entry), 3);

  NetworkSDlg_Sub3_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_Sub3_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_Sub_hbox), NetworkSDlg_Sub3_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_Sub3_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_Sub3_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_Sub3_entry), 3);

  NetworkSDlg_Sub4_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_Sub4_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_Sub_hbox), NetworkSDlg_Sub4_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_Sub4_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_Sub4_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_Sub4_entry), 3);

  NetworkSDlg_Gate_hbox = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (NetworkSDlg_Gate_hbox);
  gtk_table_attach (GTK_TABLE (table3), NetworkSDlg_Gate_hbox, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_FILL), 0, 0);

  NetworkSDlg_Gate1_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_Gate1_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_Gate_hbox), NetworkSDlg_Gate1_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_Gate1_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_Gate1_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_Gate1_entry), 3);

  NetworkSDlg_Gate2_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_Gate2_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_Gate_hbox), NetworkSDlg_Gate2_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_Gate2_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_Gate2_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_Gate2_entry), 3);

  NetworkSDlg_Gate3_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_Gate3_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_Gate_hbox), NetworkSDlg_Gate3_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_Gate3_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_Gate3_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_Gate3_entry), 3);

  NetworkSDlg_Gate4_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_Gate4_entry);
  gtk_box_pack_start (GTK_BOX (NetworkSDlg_Gate_hbox), NetworkSDlg_Gate4_entry, FALSE, TRUE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_Gate4_entry), 3);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_Gate4_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_Gate4_entry), 3);

  Frame_label160 = gtk_label_new (_("TCP/IP"));
  gtk_widget_show (Frame_label160);
  gtk_frame_set_label_widget (GTK_FRAME (frame55), Frame_label160);

  hbox63 = gtk_hbox_new (TRUE, 0);
  gtk_widget_show (hbox63);
  gtk_box_pack_start (GTK_BOX (dialog_vbox8), hbox63, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox63), 5);

  label164 = gtk_label_new (_("Password:"));
  gtk_widget_show (label164);
  gtk_box_pack_start (GTK_BOX (hbox63), label164, TRUE, TRUE, 7);
  gtk_label_set_justify (GTK_LABEL (label164), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label164), 0, 0.5);

  NetworkSDlg_Password_entry = gtk_entry_new ();
  gtk_widget_show (NetworkSDlg_Password_entry);
  gtk_box_pack_start (GTK_BOX (hbox63), NetworkSDlg_Password_entry, FALSE, FALSE, 0);
  gtk_entry_set_max_length (GTK_ENTRY (NetworkSDlg_Password_entry), 15);
  gtk_entry_set_visibility (GTK_ENTRY (NetworkSDlg_Password_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (NetworkSDlg_Password_entry), 8226);
  gtk_entry_set_width_chars (GTK_ENTRY (NetworkSDlg_Password_entry), 15);

  dialog_action_area8 = GTK_DIALOG (NetworkSDlg_dialog)->action_area;
  gtk_widget_show (dialog_action_area8);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area8), GTK_BUTTONBOX_END);

  hbuttonbox8 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox8);
  gtk_container_add (GTK_CONTAINER (dialog_action_area8), hbuttonbox8);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox8), GTK_BUTTONBOX_END);

  NetWorkSDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (NetWorkSDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox8), NetWorkSDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (NetWorkSDlg_OK_button, GTK_CAN_DEFAULT);

  NetworkSDlg_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (NetworkSDlg_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox8), NetworkSDlg_button);
  GTK_WIDGET_SET_FLAGS (NetworkSDlg_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) NetworkSDlg_dialog, "delete_event",
                    G_CALLBACK (on_NetworkSDlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_dialog, "destroy",
                    G_CALLBACK (on_NetworkSDlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_RARP_checkbutton, "toggled",
                    G_CALLBACK (on_NetworkSDlg_RARP_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_BOOTP_checkbutton, "toggled",
                    G_CALLBACK (on_NetworkSDlg_BOOTP_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_DHCP_checkbutton, "toggled",
                    G_CALLBACK (on_NetworkSDlg_DHCP_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_IPSetting_combo_entry, "changed",
                    G_CALLBACK (on_NetworkSDlg_IPSetting_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_IP1_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_IP1_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_IP2_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_IP2_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_IP3_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_IP3_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_IP4_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_IP4_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_Sub1_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_Sub1_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_Sub2_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_Sub2_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_Sub3_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_Sub3_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_Sub4_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_Sub4_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_Gate1_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_Gate1_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_Gate2_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_Gate2_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_Gate3_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_Gate3_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_Gate4_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_Gate4_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_Password_entry, "focus_out_event",
                    G_CALLBACK (on_NetworkSDlg_Password_entry_focus_out_event),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_Password_entry, "changed",
                    G_CALLBACK (on_NetworkSDlg_Password_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) NetWorkSDlg_OK_button, "clicked",
                    G_CALLBACK (on_NetWorkSDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) NetworkSDlg_button, "clicked",
                    G_CALLBACK (on_NetworkSDlg_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (NetworkSDlg_dialog, NetworkSDlg_dialog, "NetworkSDlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (NetworkSDlg_dialog, dialog_vbox8, "dialog_vbox8");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, frame55, "frame55");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, table3, "table3");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, label160, "label160");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_RARP_checkbutton, "NetworkSDlg_RARP_checkbutton");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_BOOTP_checkbutton, "NetworkSDlg_BOOTP_checkbutton");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_DHCP_checkbutton, "NetworkSDlg_DHCP_checkbutton");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, label161, "label161");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, label162, "label162");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, label163, "label163");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_IPSetting_combo, "NetworkSDlg_IPSetting_combo");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_IPSetting_combo_entry, "NetworkSDlg_IPSetting_combo_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_IP_hbox, "NetworkSDlg_IP_hbox");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_IP1_entry, "NetworkSDlg_IP1_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_IP2_entry, "NetworkSDlg_IP2_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_IP3_entry, "NetworkSDlg_IP3_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_IP4_entry, "NetworkSDlg_IP4_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Sub_hbox, "NetworkSDlg_Sub_hbox");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Sub1_entry, "NetworkSDlg_Sub1_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Sub2_entry, "NetworkSDlg_Sub2_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Sub3_entry, "NetworkSDlg_Sub3_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Sub4_entry, "NetworkSDlg_Sub4_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Gate_hbox, "NetworkSDlg_Gate_hbox");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Gate1_entry, "NetworkSDlg_Gate1_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Gate2_entry, "NetworkSDlg_Gate2_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Gate3_entry, "NetworkSDlg_Gate3_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Gate4_entry, "NetworkSDlg_Gate4_entry");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, Frame_label160, "Frame_label160");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, hbox63, "hbox63");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, label164, "label164");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_Password_entry, "NetworkSDlg_Password_entry");
  GLADE_HOOKUP_OBJECT_NO_REF (NetworkSDlg_dialog, dialog_action_area8, "dialog_action_area8");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, hbuttonbox8, "hbuttonbox8");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetWorkSDlg_OK_button, "NetWorkSDlg_OK_button");
  GLADE_HOOKUP_OBJECT (NetworkSDlg_dialog, NetworkSDlg_button, "NetworkSDlg_button");

  return NetworkSDlg_dialog;
}

GtkWidget*
create_AsstPrtSDlg_dialog (void)
{
  GtkWidget *AsstPrtSDlg_dialog;
  GtkWidget *dialog_vbox9;
  GtkWidget *frame56;
  GtkWidget *vbox41;
  GtkWidget *AsstPrtSDlg_highspeed_checkbutton;
  GtkWidget *hbox64;
  GtkWidget *AsstPrtSDlg_mode_label;
  GtkWidget *AsstPrtSDlg_mode_combo;
  GList *AsstPrtSDlg_mode_combo_items = NULL;
  GtkWidget *AsstPrtSDlg_mode_combo_entry;
  GtkWidget *label166;
  GtkWidget *AsstPrtSDlg_ReduceStreaks_checkbutton;
  GtkWidget *AsstPrtSDlg_preventpoorquality_checkbutton;
  GtkWidget *AsstPrtSDlg_cleanevery2sheets_checkbutton;
  GtkWidget *AsstPrtSDlg_adjusttemp_checkbutton;
  GtkWidget *AsstPrtSDlg_adjust16k_checkbutton;
  GtkWidget *hbox66;
  GtkWidget *AsstPrtSDlg_quietmode_checkbutton;
  GtkWidget *quietmode_label;
  GtkWidget *hbox83;
  GtkWidget *AsstPrtSDlg_colormisfrequency_label;
  GtkWidget *AsstPrtSDlg_colormisfrequency_combo;
  GList *AsstPrtSDlg_colormisfrequency_combo_items = NULL;
  GtkWidget *AsstPrtSDlg_colormisfrequency_combo_entry;
  GtkWidget *hbox84;
  GtkWidget *AsstPrtSDlg_paperjamreduction_label;
  GtkWidget *AsstPrtSDlg_paperjamreduction_combo;
  GList *AsstPrtSDlg_paperjamreduction_combo_items = NULL;
  GtkWidget *AsstPrtSDlg_paperjamreduction_combo_entry;
  GtkWidget *dialog_action_area9;
  GtkWidget *hbuttonbox9;
  GtkWidget *AsstPrtSDlg_OK_button;
  GtkWidget *AsstPrtSDlg_Cancel_button;

  AsstPrtSDlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (AsstPrtSDlg_dialog), _("Assisting Print Settings"));
  gtk_window_set_position (GTK_WINDOW (AsstPrtSDlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (AsstPrtSDlg_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (AsstPrtSDlg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (AsstPrtSDlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  dialog_vbox9 = GTK_DIALOG (AsstPrtSDlg_dialog)->vbox;
  gtk_widget_show (dialog_vbox9);

  frame56 = gtk_frame_new (NULL);
  gtk_widget_show (frame56);
  gtk_box_pack_start (GTK_BOX (dialog_vbox9), frame56, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame56), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame56), GTK_SHADOW_NONE);

  vbox41 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox41);
  gtk_container_add (GTK_CONTAINER (frame56), vbox41);

  AsstPrtSDlg_highspeed_checkbutton = gtk_check_button_new_with_mnemonic (_("Print Mixed Color/B&W Documents at High Speed   "));
  gtk_widget_show (AsstPrtSDlg_highspeed_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox41), AsstPrtSDlg_highspeed_checkbutton, FALSE, FALSE, 0);

  hbox64 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox64);
  gtk_box_pack_start (GTK_BOX (vbox41), hbox64, TRUE, TRUE, 0);

  AsstPrtSDlg_mode_label = gtk_label_new (_("Print Mode:       "));
  gtk_widget_show (AsstPrtSDlg_mode_label);
  gtk_box_pack_start (GTK_BOX (hbox64), AsstPrtSDlg_mode_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (AsstPrtSDlg_mode_label), GTK_JUSTIFY_CENTER);

  AsstPrtSDlg_mode_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (AsstPrtSDlg_mode_combo)->popwin),
                     "GladeParentKey", AsstPrtSDlg_mode_combo);
  gtk_widget_show (AsstPrtSDlg_mode_combo);
  gtk_box_pack_start (GTK_BOX (hbox64), AsstPrtSDlg_mode_combo, TRUE, TRUE, 0);
  AsstPrtSDlg_mode_combo_items = g_list_append (AsstPrtSDlg_mode_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (AsstPrtSDlg_mode_combo), AsstPrtSDlg_mode_combo_items);
  g_list_free (AsstPrtSDlg_mode_combo_items);

  AsstPrtSDlg_mode_combo_entry = GTK_COMBO (AsstPrtSDlg_mode_combo)->entry;
  gtk_widget_show (AsstPrtSDlg_mode_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (AsstPrtSDlg_mode_combo_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (AsstPrtSDlg_mode_combo_entry), 8226);

  label166 = gtk_label_new (_("          "));
  gtk_widget_show (label166);
  gtk_box_pack_start (GTK_BOX (hbox64), label166, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label166), GTK_JUSTIFY_CENTER);

  AsstPrtSDlg_ReduceStreaks_checkbutton = gtk_check_button_new_with_mnemonic (_("Reduce Vertical Streaks on Outputs"));
  gtk_widget_show (AsstPrtSDlg_ReduceStreaks_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox41), AsstPrtSDlg_ReduceStreaks_checkbutton, FALSE, FALSE, 0);

  AsstPrtSDlg_preventpoorquality_checkbutton = gtk_check_button_new_with_mnemonic (_("Prevent Poor Quality after Long Idle"));
  gtk_widget_show (AsstPrtSDlg_preventpoorquality_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox41), AsstPrtSDlg_preventpoorquality_checkbutton, FALSE, FALSE, 0);

  AsstPrtSDlg_cleanevery2sheets_checkbutton = gtk_check_button_new_with_mnemonic (_("Clean Every 2 Sheets in Continuous Print"));
  gtk_widget_show (AsstPrtSDlg_cleanevery2sheets_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox41), AsstPrtSDlg_cleanevery2sheets_checkbutton, FALSE, FALSE, 0);

  AsstPrtSDlg_adjusttemp_checkbutton = gtk_check_button_new_with_mnemonic (_("Adjust Temperature during Standby"));
  gtk_box_pack_start (GTK_BOX (vbox41), AsstPrtSDlg_adjusttemp_checkbutton, FALSE, FALSE, 0);

  AsstPrtSDlg_adjust16k_checkbutton = gtk_check_button_new_with_mnemonic (_("Adjust Output When Printing Plain 16K"));
  gtk_box_pack_start (GTK_BOX (vbox41), AsstPrtSDlg_adjust16k_checkbutton, FALSE, FALSE, 0);

  hbox66 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox66);
  gtk_box_pack_start (GTK_BOX (vbox41), hbox66, TRUE, TRUE, 0);

  AsstPrtSDlg_quietmode_checkbutton = gtk_check_button_new_with_mnemonic (_("Print Quiet Mode"));
  gtk_box_pack_start (GTK_BOX (hbox66), AsstPrtSDlg_quietmode_checkbutton, FALSE, FALSE, 0);

  quietmode_label = gtk_label_new ("");
  gtk_box_pack_start (GTK_BOX (hbox66), quietmode_label, FALSE, FALSE, 0);
  gtk_misc_set_padding (GTK_MISC (quietmode_label), 100, 0);

  hbox83 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox41), hbox83, TRUE, TRUE, 0);

  AsstPrtSDlg_colormisfrequency_label = gtk_label_new (_("Color Mismatch Correction Frequency:       "));
  gtk_widget_show (AsstPrtSDlg_colormisfrequency_label);
  gtk_box_pack_start (GTK_BOX (hbox83), AsstPrtSDlg_colormisfrequency_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (AsstPrtSDlg_colormisfrequency_label), GTK_JUSTIFY_CENTER);

  AsstPrtSDlg_colormisfrequency_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (AsstPrtSDlg_colormisfrequency_combo)->popwin),
                     "GladeParentKey", AsstPrtSDlg_colormisfrequency_combo);
  gtk_widget_show (AsstPrtSDlg_colormisfrequency_combo);
  gtk_box_pack_start (GTK_BOX (hbox83), AsstPrtSDlg_colormisfrequency_combo, TRUE, TRUE, 0);
  AsstPrtSDlg_colormisfrequency_combo_items = g_list_append (AsstPrtSDlg_colormisfrequency_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (AsstPrtSDlg_colormisfrequency_combo), AsstPrtSDlg_colormisfrequency_combo_items);
  g_list_free (AsstPrtSDlg_colormisfrequency_combo_items);

  AsstPrtSDlg_colormisfrequency_combo_entry = GTK_COMBO (AsstPrtSDlg_colormisfrequency_combo)->entry;
  gtk_widget_show (AsstPrtSDlg_colormisfrequency_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (AsstPrtSDlg_colormisfrequency_combo_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (AsstPrtSDlg_colormisfrequency_combo_entry), 8226);

  hbox84 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox41), hbox84, TRUE, TRUE, 0);

  AsstPrtSDlg_paperjamreduction_label = gtk_label_new (_("Paper Jam Reduction(Plain L, 2-sided):        "));
  gtk_widget_show (AsstPrtSDlg_paperjamreduction_label);
  gtk_box_pack_start (GTK_BOX (hbox84), AsstPrtSDlg_paperjamreduction_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (AsstPrtSDlg_paperjamreduction_label), GTK_JUSTIFY_CENTER);

  AsstPrtSDlg_paperjamreduction_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (AsstPrtSDlg_paperjamreduction_combo)->popwin),
                     "GladeParentKey", AsstPrtSDlg_paperjamreduction_combo);
  gtk_widget_show (AsstPrtSDlg_paperjamreduction_combo);
  gtk_box_pack_start (GTK_BOX (hbox84), AsstPrtSDlg_paperjamreduction_combo, TRUE, TRUE, 0);
  AsstPrtSDlg_paperjamreduction_combo_items = g_list_append (AsstPrtSDlg_paperjamreduction_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (AsstPrtSDlg_paperjamreduction_combo), AsstPrtSDlg_paperjamreduction_combo_items);
  g_list_free (AsstPrtSDlg_paperjamreduction_combo_items);

  AsstPrtSDlg_paperjamreduction_combo_entry = GTK_COMBO (AsstPrtSDlg_paperjamreduction_combo)->entry;
  gtk_widget_show (AsstPrtSDlg_paperjamreduction_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (AsstPrtSDlg_paperjamreduction_combo_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (AsstPrtSDlg_paperjamreduction_combo_entry), 8226);

  dialog_action_area9 = GTK_DIALOG (AsstPrtSDlg_dialog)->action_area;
  gtk_widget_show (dialog_action_area9);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area9), GTK_BUTTONBOX_END);

  hbuttonbox9 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox9);
  gtk_container_add (GTK_CONTAINER (dialog_action_area9), hbuttonbox9);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox9), GTK_BUTTONBOX_END);

  AsstPrtSDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (AsstPrtSDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), AsstPrtSDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (AsstPrtSDlg_OK_button, GTK_CAN_DEFAULT);

  AsstPrtSDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (AsstPrtSDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox9), AsstPrtSDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (AsstPrtSDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) AsstPrtSDlg_dialog, "delete_event",
                    G_CALLBACK (on_AsstPrtSDlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_dialog, "destroy",
                    G_CALLBACK (on_AsstPrtSDlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_highspeed_checkbutton, "toggled",
                    G_CALLBACK (on_AsstPrtSDlg_highspeed_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_mode_combo_entry, "changed",
                    G_CALLBACK (on_AsstPrtSDlg_mode_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_ReduceStreaks_checkbutton, "toggled",
                    G_CALLBACK (on_AsstPrtSDlg_ReduceStreaks_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_preventpoorquality_checkbutton, "toggled",
                    G_CALLBACK (on_AsstPrtSDlg_preventpoorquality_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_cleanevery2sheets_checkbutton, "toggled",
                    G_CALLBACK (on_AsstPrtSDlg_cleanevery2sheets_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_adjusttemp_checkbutton, "toggled",
                    G_CALLBACK (on_AsstPrtSDlg_adjusttemp_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_adjust16k_checkbutton, "toggled",
                    G_CALLBACK (on_AsstPrtSDlg_adjust16k_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_quietmode_checkbutton, "toggled",
                    G_CALLBACK (on_AsstPrtSDlg_adjust16k_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_colormisfrequency_combo_entry, "changed",
                    G_CALLBACK (on_AsstPrtSDlg_colormisfrequency_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_paperjamreduction_combo_entry, "changed",
                    G_CALLBACK (on_AsstPrtSDlg_paperjamreduction_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_OK_button, "clicked",
                    G_CALLBACK (on_AsstPrtSDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) AsstPrtSDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_AsstPrtSDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (AsstPrtSDlg_dialog, AsstPrtSDlg_dialog, "AsstPrtSDlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (AsstPrtSDlg_dialog, dialog_vbox9, "dialog_vbox9");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, frame56, "frame56");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, vbox41, "vbox41");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_highspeed_checkbutton, "AsstPrtSDlg_highspeed_checkbutton");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, hbox64, "hbox64");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_mode_label, "AsstPrtSDlg_mode_label");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_mode_combo, "AsstPrtSDlg_mode_combo");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_mode_combo_entry, "AsstPrtSDlg_mode_combo_entry");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, label166, "label166");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_ReduceStreaks_checkbutton, "AsstPrtSDlg_ReduceStreaks_checkbutton");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_preventpoorquality_checkbutton, "AsstPrtSDlg_preventpoorquality_checkbutton");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_cleanevery2sheets_checkbutton, "AsstPrtSDlg_cleanevery2sheets_checkbutton");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_adjusttemp_checkbutton, "AsstPrtSDlg_adjusttemp_checkbutton");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_adjust16k_checkbutton, "AsstPrtSDlg_adjust16k_checkbutton");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, hbox66, "hbox66");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_quietmode_checkbutton, "AsstPrtSDlg_quietmode_checkbutton");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, quietmode_label, "quietmode_label");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, hbox83, "hbox83");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_colormisfrequency_label, "AsstPrtSDlg_colormisfrequency_label");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_colormisfrequency_combo, "AsstPrtSDlg_colormisfrequency_combo");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_colormisfrequency_combo_entry, "AsstPrtSDlg_colormisfrequency_combo_entry");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, hbox84, "hbox84");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_paperjamreduction_label, "AsstPrtSDlg_paperjamreduction_label");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_paperjamreduction_combo, "AsstPrtSDlg_paperjamreduction_combo");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_paperjamreduction_combo_entry, "AsstPrtSDlg_paperjamreduction_combo_entry");
  GLADE_HOOKUP_OBJECT_NO_REF (AsstPrtSDlg_dialog, dialog_action_area9, "dialog_action_area9");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, hbuttonbox9, "hbuttonbox9");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_OK_button, "AsstPrtSDlg_OK_button");
  GLADE_HOOKUP_OBJECT (AsstPrtSDlg_dialog, AsstPrtSDlg_Cancel_button, "AsstPrtSDlg_Cancel_button");

  return AsstPrtSDlg_dialog;
}

GtkWidget*
create_StartupSettingsDlg_dialog (void)
{
  GtkWidget *StartupSettingsDlg_dialog;
  GtkWidget *vbox42;
  GtkWidget *frame57;
  GtkWidget *vbox43;
  GtkWidget *StartupSettingsDlg_QualityCorr_label;
  GtkWidget *hbox65;
  GtkWidget *StartupSettingsDlg_QualityCorr_combo;
  GList *StartupSettingsDlg_QualityCorr_combo_items = NULL;
  GtkWidget *StartupSettingsDlg_QualityCorr_combo_entry;
  GtkWidget *hbuttonbox10;
  GtkWidget *hbuttonbox11;
  GtkWidget *StartupSettingsDlg_OK_button;
  GtkWidget *StartupSettingsDlg_Cancel_button;

  StartupSettingsDlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (StartupSettingsDlg_dialog), _("Startup Settings"));
  gtk_window_set_position (GTK_WINDOW (StartupSettingsDlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (StartupSettingsDlg_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (StartupSettingsDlg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (StartupSettingsDlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  vbox42 = GTK_DIALOG (StartupSettingsDlg_dialog)->vbox;
  gtk_widget_show (vbox42);

  frame57 = gtk_frame_new (NULL);
  gtk_widget_show (frame57);
  gtk_box_pack_start (GTK_BOX (vbox42), frame57, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame57), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame57), GTK_SHADOW_NONE);

  vbox43 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox43);
  gtk_container_add (GTK_CONTAINER (frame57), vbox43);

  StartupSettingsDlg_QualityCorr_label = gtk_label_new (_("Quality Correction:"));
  gtk_widget_show (StartupSettingsDlg_QualityCorr_label);
  gtk_box_pack_start (GTK_BOX (vbox43), StartupSettingsDlg_QualityCorr_label, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (StartupSettingsDlg_QualityCorr_label), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (StartupSettingsDlg_QualityCorr_label), 0, 0.5);

  hbox65 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox65);
  gtk_box_pack_start (GTK_BOX (vbox43), hbox65, TRUE, TRUE, 0);
  gtk_widget_set_size_request (hbox65, 333, -1);

  StartupSettingsDlg_QualityCorr_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (StartupSettingsDlg_QualityCorr_combo)->popwin),
                     "GladeParentKey", StartupSettingsDlg_QualityCorr_combo);
  gtk_widget_show (StartupSettingsDlg_QualityCorr_combo);
  gtk_box_pack_start (GTK_BOX (hbox65), StartupSettingsDlg_QualityCorr_combo, TRUE, TRUE, 0);
  StartupSettingsDlg_QualityCorr_combo_items = g_list_append (StartupSettingsDlg_QualityCorr_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (StartupSettingsDlg_QualityCorr_combo), StartupSettingsDlg_QualityCorr_combo_items);
  g_list_free (StartupSettingsDlg_QualityCorr_combo_items);

  StartupSettingsDlg_QualityCorr_combo_entry = GTK_COMBO (StartupSettingsDlg_QualityCorr_combo)->entry;
  gtk_widget_show (StartupSettingsDlg_QualityCorr_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (StartupSettingsDlg_QualityCorr_combo_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (StartupSettingsDlg_QualityCorr_combo_entry), 8226);

  hbuttonbox10 = GTK_DIALOG (StartupSettingsDlg_dialog)->action_area;
  gtk_widget_show (hbuttonbox10);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox10), GTK_BUTTONBOX_END);

  hbuttonbox11 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox11);
  gtk_container_add (GTK_CONTAINER (hbuttonbox10), hbuttonbox11);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox11), GTK_BUTTONBOX_END);

  StartupSettingsDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (StartupSettingsDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox11), StartupSettingsDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (StartupSettingsDlg_OK_button, GTK_CAN_DEFAULT);

  StartupSettingsDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (StartupSettingsDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox11), StartupSettingsDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (StartupSettingsDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) StartupSettingsDlg_dialog, "delete_event",
                    G_CALLBACK (on_StartupSettingsDlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) StartupSettingsDlg_dialog, "destroy",
                    G_CALLBACK (on_StartupSettingsDlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) StartupSettingsDlg_QualityCorr_combo_entry, "changed",
                    G_CALLBACK (on_StartupSettingsDlg_QualityCorr_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) StartupSettingsDlg_OK_button, "clicked",
                    G_CALLBACK (on_StartupSettingsDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) StartupSettingsDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_StartupSettingsDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (StartupSettingsDlg_dialog, StartupSettingsDlg_dialog, "StartupSettingsDlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (StartupSettingsDlg_dialog, vbox42, "vbox42");
  GLADE_HOOKUP_OBJECT (StartupSettingsDlg_dialog, frame57, "frame57");
  GLADE_HOOKUP_OBJECT (StartupSettingsDlg_dialog, vbox43, "vbox43");
  GLADE_HOOKUP_OBJECT (StartupSettingsDlg_dialog, StartupSettingsDlg_QualityCorr_label, "StartupSettingsDlg_QualityCorr_label");
  GLADE_HOOKUP_OBJECT (StartupSettingsDlg_dialog, hbox65, "hbox65");
  GLADE_HOOKUP_OBJECT (StartupSettingsDlg_dialog, StartupSettingsDlg_QualityCorr_combo, "StartupSettingsDlg_QualityCorr_combo");
  GLADE_HOOKUP_OBJECT (StartupSettingsDlg_dialog, StartupSettingsDlg_QualityCorr_combo_entry, "StartupSettingsDlg_QualityCorr_combo_entry");
  GLADE_HOOKUP_OBJECT_NO_REF (StartupSettingsDlg_dialog, hbuttonbox10, "hbuttonbox10");
  GLADE_HOOKUP_OBJECT (StartupSettingsDlg_dialog, hbuttonbox11, "hbuttonbox11");
  GLADE_HOOKUP_OBJECT (StartupSettingsDlg_dialog, StartupSettingsDlg_OK_button, "StartupSettingsDlg_OK_button");
  GLADE_HOOKUP_OBJECT (StartupSettingsDlg_dialog, StartupSettingsDlg_Cancel_button, "StartupSettingsDlg_Cancel_button");

  return StartupSettingsDlg_dialog;
}

GtkWidget*
create_CassetteSet2Dlg_dialog (void)
{
  GtkWidget *CassetteSet2Dlg_dialog;
  GtkWidget *vbox45;
  GtkWidget *frame59;
  GtkWidget *table5;
  GtkWidget *label203;
  GtkWidget *label204;
  GtkWidget *CassetteSet2Dlg_Cas1_checkbutton;
  GtkWidget *CassetteSet2Dlg_Cas2_checkbutton;
  GtkWidget *CassetteSet2Dlg_Cas3_checkbutton;
  GtkWidget *CassetteSet2Dlg_Cas4_checkbutton;
  GtkWidget *label202;
  GtkWidget *hbuttonbox14;
  GtkWidget *hbuttonbox15;
  GtkWidget *CassetteSet2Dlg_OK_button;
  GtkWidget *CassetteSet2Dlg_Cancel_button;

  CassetteSet2Dlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (CassetteSet2Dlg_dialog), _("Cassette Settings 2"));
  gtk_window_set_position (GTK_WINDOW (CassetteSet2Dlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (CassetteSet2Dlg_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (CassetteSet2Dlg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (CassetteSet2Dlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  vbox45 = GTK_DIALOG (CassetteSet2Dlg_dialog)->vbox;
  gtk_widget_show (vbox45);

  frame59 = gtk_frame_new (NULL);
  gtk_widget_show (frame59);
  gtk_box_pack_start (GTK_BOX (vbox45), frame59, FALSE, TRUE, 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame59), GTK_SHADOW_NONE);

  table5 = gtk_table_new (4, 3, FALSE);
  gtk_widget_show (table5);
  gtk_container_add (GTK_CONTAINER (frame59), table5);

  label203 = gtk_label_new (_(" "));
  gtk_widget_show (label203);
  gtk_table_attach (GTK_TABLE (table5), label203, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label203), 0, 0.5);

  label204 = gtk_label_new (_(" "));
  gtk_widget_show (label204);
  gtk_table_attach (GTK_TABLE (table5), label204, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label204), 0, 0.5);

  CassetteSet2Dlg_Cas1_checkbutton = gtk_check_button_new_with_mnemonic (_("Use Cassette 1 as Target of Auto Select"));
  gtk_widget_show (CassetteSet2Dlg_Cas1_checkbutton);
  gtk_table_attach (GTK_TABLE (table5), CassetteSet2Dlg_Cas1_checkbutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  CassetteSet2Dlg_Cas2_checkbutton = gtk_check_button_new_with_mnemonic (_("Use Cassette 2 as Target of Auto Select"));
  gtk_widget_show (CassetteSet2Dlg_Cas2_checkbutton);
  gtk_table_attach (GTK_TABLE (table5), CassetteSet2Dlg_Cas2_checkbutton, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  CassetteSet2Dlg_Cas3_checkbutton = gtk_check_button_new_with_mnemonic (_("Use Cassette 3 as Target of Auto Select"));
  gtk_widget_show (CassetteSet2Dlg_Cas3_checkbutton);
  gtk_table_attach (GTK_TABLE (table5), CassetteSet2Dlg_Cas3_checkbutton, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  CassetteSet2Dlg_Cas4_checkbutton = gtk_check_button_new_with_mnemonic (_("Use Cassette 4 as Target of Auto Select"));
  gtk_widget_show (CassetteSet2Dlg_Cas4_checkbutton);
  gtk_table_attach (GTK_TABLE (table5), CassetteSet2Dlg_Cas4_checkbutton, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  label202 = gtk_label_new (_("Auto Select Settings"));
  gtk_widget_show (label202);
  gtk_frame_set_label_widget (GTK_FRAME (frame59), label202);

  hbuttonbox14 = GTK_DIALOG (CassetteSet2Dlg_dialog)->action_area;
  gtk_widget_show (hbuttonbox14);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox14), GTK_BUTTONBOX_END);

  hbuttonbox15 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox15);
  gtk_container_add (GTK_CONTAINER (hbuttonbox14), hbuttonbox15);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox15), GTK_BUTTONBOX_END);

  CassetteSet2Dlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (CassetteSet2Dlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox15), CassetteSet2Dlg_OK_button);
  GTK_WIDGET_SET_FLAGS (CassetteSet2Dlg_OK_button, GTK_CAN_DEFAULT);

  CassetteSet2Dlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (CassetteSet2Dlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox15), CassetteSet2Dlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (CassetteSet2Dlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) CassetteSet2Dlg_dialog, "destroy",
                    G_CALLBACK (on_CassetteSet2Dlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) CassetteSet2Dlg_dialog, "delete_event",
                    G_CALLBACK (on_CassetteSet2Dlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) CassetteSet2Dlg_OK_button, "clicked",
                    G_CALLBACK (on_CassetteSet2Dlg_OK_clicked),
                    NULL);
  g_signal_connect ((gpointer) CassetteSet2Dlg_Cancel_button, "clicked",
                    G_CALLBACK (on_CassetteSet2Dlg_Cancel_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (CassetteSet2Dlg_dialog, CassetteSet2Dlg_dialog, "CassetteSet2Dlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (CassetteSet2Dlg_dialog, vbox45, "vbox45");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, frame59, "frame59");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, table5, "table5");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, label203, "label203");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, label204, "label204");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, CassetteSet2Dlg_Cas1_checkbutton, "CassetteSet2Dlg_Cas1_checkbutton");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, CassetteSet2Dlg_Cas2_checkbutton, "CassetteSet2Dlg_Cas2_checkbutton");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, CassetteSet2Dlg_Cas3_checkbutton, "CassetteSet2Dlg_Cas3_checkbutton");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, CassetteSet2Dlg_Cas4_checkbutton, "CassetteSet2Dlg_Cas4_checkbutton");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, label202, "label202");
  GLADE_HOOKUP_OBJECT_NO_REF (CassetteSet2Dlg_dialog, hbuttonbox14, "hbuttonbox14");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, hbuttonbox15, "hbuttonbox15");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, CassetteSet2Dlg_OK_button, "CassetteSet2Dlg_OK_button");
  GLADE_HOOKUP_OBJECT (CassetteSet2Dlg_dialog, CassetteSet2Dlg_Cancel_button, "CassetteSet2Dlg_Cancel_button");

  return CassetteSet2Dlg_dialog;
}

GtkWidget*
create_ResetUnitDlg_dialog (void)
{
  GtkWidget *ResetUnitDlg_dialog;
  GtkWidget *vbox46;
  GtkWidget *frame60;
  GtkWidget *table6;
  GtkWidget *label205;
  GtkWidget *label206;
  GtkWidget *ResetUnitDlg_FixingUnit_checkbutton;
  GtkWidget *ResetUnitDlg_ITBUnit_checkbutton;
  GtkWidget *ResetUnitDlg_SecondaryTrans_checkbutton;
  GtkWidget *ResetUnitDlg_MultiTray_checkbutton;
  GtkWidget *ResetUnitDlg_Cas1_checkbutton;
  GtkWidget *ResetUnitDlg_Cas2_checkbutton;
  GtkWidget *ResetUnitDlg_Cas3_checkbutton;
  GtkWidget *ResetUnitDlg_Cas4_checkbutton;
  GtkWidget *label207;
  GtkWidget *hbuttonbox16;
  GtkWidget *hbuttonbox17;
  GtkWidget *ResetUnitDlg_OK_button;
  GtkWidget *ResetUnitDlg_Cancel_button;

  ResetUnitDlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (ResetUnitDlg_dialog), _("Reset Part Counters"));
  gtk_window_set_position (GTK_WINDOW (ResetUnitDlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (ResetUnitDlg_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (ResetUnitDlg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (ResetUnitDlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  vbox46 = GTK_DIALOG (ResetUnitDlg_dialog)->vbox;
  gtk_widget_show (vbox46);

  frame60 = gtk_frame_new (NULL);
  gtk_widget_show (frame60);
  gtk_box_pack_start (GTK_BOX (vbox46), frame60, FALSE, TRUE, 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame60), GTK_SHADOW_NONE);

  table6 = gtk_table_new (8, 3, FALSE);
  gtk_widget_show (table6);
  gtk_container_add (GTK_CONTAINER (frame60), table6);

  label205 = gtk_label_new (_(" "));
  gtk_widget_show (label205);
  gtk_table_attach (GTK_TABLE (table6), label205, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label205), 0, 0.5);

  label206 = gtk_label_new (_(" "));
  gtk_widget_show (label206);
  gtk_table_attach (GTK_TABLE (table6), label206, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label206), 0, 0.5);

  ResetUnitDlg_FixingUnit_checkbutton = gtk_check_button_new_with_mnemonic (_("Fixing Unit"));
  gtk_widget_show (ResetUnitDlg_FixingUnit_checkbutton);
  gtk_table_attach (GTK_TABLE (table6), ResetUnitDlg_FixingUnit_checkbutton, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  ResetUnitDlg_ITBUnit_checkbutton = gtk_check_button_new_with_mnemonic (_("ITB Unit"));
  gtk_widget_show (ResetUnitDlg_ITBUnit_checkbutton);
  gtk_table_attach (GTK_TABLE (table6), ResetUnitDlg_ITBUnit_checkbutton, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  ResetUnitDlg_SecondaryTrans_checkbutton = gtk_check_button_new_with_mnemonic (_("Secondary Transfer Roller"));
  gtk_widget_show (ResetUnitDlg_SecondaryTrans_checkbutton);
  gtk_table_attach (GTK_TABLE (table6), ResetUnitDlg_SecondaryTrans_checkbutton, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  ResetUnitDlg_MultiTray_checkbutton = gtk_check_button_new_with_mnemonic (_("Paper Feed Roller (Multi-purpose Tray)"));
  gtk_widget_show (ResetUnitDlg_MultiTray_checkbutton);
  gtk_table_attach (GTK_TABLE (table6), ResetUnitDlg_MultiTray_checkbutton, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  ResetUnitDlg_Cas1_checkbutton = gtk_check_button_new_with_mnemonic (_("Paper Feed Roller (Cassette 1)"));
  gtk_widget_show (ResetUnitDlg_Cas1_checkbutton);
  gtk_table_attach (GTK_TABLE (table6), ResetUnitDlg_Cas1_checkbutton, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  ResetUnitDlg_Cas2_checkbutton = gtk_check_button_new_with_mnemonic (_("Paper Feed Roller (Cassette 2)"));
  gtk_widget_show (ResetUnitDlg_Cas2_checkbutton);
  gtk_table_attach (GTK_TABLE (table6), ResetUnitDlg_Cas2_checkbutton, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  ResetUnitDlg_Cas3_checkbutton = gtk_check_button_new_with_mnemonic (_("Paper Feed Roller (Cassette 3)"));
  gtk_widget_show (ResetUnitDlg_Cas3_checkbutton);
  gtk_table_attach (GTK_TABLE (table6), ResetUnitDlg_Cas3_checkbutton, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  ResetUnitDlg_Cas4_checkbutton = gtk_check_button_new_with_mnemonic (_("Paper Feed Roller (Cassette 4)"));
  gtk_widget_show (ResetUnitDlg_Cas4_checkbutton);
  gtk_table_attach (GTK_TABLE (table6), ResetUnitDlg_Cas4_checkbutton, 1, 2, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 5);

  label207 = gtk_label_new (_("Select parts and click [OK] to reset the counter after replacing parts."));
  gtk_widget_show (label207);
  gtk_frame_set_label_widget (GTK_FRAME (frame60), label207);
  gtk_label_set_line_wrap (GTK_LABEL (label207), TRUE);

  hbuttonbox16 = GTK_DIALOG (ResetUnitDlg_dialog)->action_area;
  gtk_widget_show (hbuttonbox16);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox16), GTK_BUTTONBOX_END);

  hbuttonbox17 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox17);
  gtk_container_add (GTK_CONTAINER (hbuttonbox16), hbuttonbox17);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox17), GTK_BUTTONBOX_END);

  ResetUnitDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (ResetUnitDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox17), ResetUnitDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (ResetUnitDlg_OK_button, GTK_CAN_DEFAULT);

  ResetUnitDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (ResetUnitDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox17), ResetUnitDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (ResetUnitDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) ResetUnitDlg_dialog, "destroy",
                    G_CALLBACK (on_ResetUnitDlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) ResetUnitDlg_dialog, "delete_event",
                    G_CALLBACK (on_ResetUnitDlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) ResetUnitDlg_OK_button, "clicked",
                    G_CALLBACK (on_ResetUnitDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) ResetUnitDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_ResetUnitDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (ResetUnitDlg_dialog, ResetUnitDlg_dialog, "ResetUnitDlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (ResetUnitDlg_dialog, vbox46, "vbox46");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, frame60, "frame60");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, table6, "table6");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, label205, "label205");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, label206, "label206");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, ResetUnitDlg_FixingUnit_checkbutton, "ResetUnitDlg_FixingUnit_checkbutton");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, ResetUnitDlg_ITBUnit_checkbutton, "ResetUnitDlg_ITBUnit_checkbutton");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, ResetUnitDlg_SecondaryTrans_checkbutton, "ResetUnitDlg_SecondaryTrans_checkbutton");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, ResetUnitDlg_MultiTray_checkbutton, "ResetUnitDlg_MultiTray_checkbutton");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, ResetUnitDlg_Cas1_checkbutton, "ResetUnitDlg_Cas1_checkbutton");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, ResetUnitDlg_Cas2_checkbutton, "ResetUnitDlg_Cas2_checkbutton");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, ResetUnitDlg_Cas3_checkbutton, "ResetUnitDlg_Cas3_checkbutton");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, ResetUnitDlg_Cas4_checkbutton, "ResetUnitDlg_Cas4_checkbutton");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, label207, "label207");
  GLADE_HOOKUP_OBJECT_NO_REF (ResetUnitDlg_dialog, hbuttonbox16, "hbuttonbox16");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, hbuttonbox17, "hbuttonbox17");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, ResetUnitDlg_OK_button, "ResetUnitDlg_OK_button");
  GLADE_HOOKUP_OBJECT (ResetUnitDlg_dialog, ResetUnitDlg_Cancel_button, "ResetUnitDlg_Cancel_button");

  return ResetUnitDlg_dialog;
}

GtkWidget*
create_MultiTrayDlg_dialog (void)
{
  GtkWidget *MultiTrayDlg_dialog;
  GtkWidget *vbox47;
  GtkWidget *frame61;
  GtkWidget *vbox48;
  GtkWidget *MultiTrayDlg_Prioritize_checkbutton;
  GtkWidget *hbuttonbox18;
  GtkWidget *hbuttonbox19;
  GtkWidget *MultiTrayDlg_OK_button;
  GtkWidget *MultiTrayDlg_Cancel_button;

  MultiTrayDlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (MultiTrayDlg_dialog), _("Multi-purpose Tray Settings"));
  gtk_window_set_position (GTK_WINDOW (MultiTrayDlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (MultiTrayDlg_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (MultiTrayDlg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (MultiTrayDlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  vbox47 = GTK_DIALOG (MultiTrayDlg_dialog)->vbox;
  gtk_widget_show (vbox47);

  frame61 = gtk_frame_new (NULL);
  gtk_widget_show (frame61);
  gtk_box_pack_start (GTK_BOX (vbox47), frame61, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame61), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame61), GTK_SHADOW_NONE);

  vbox48 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox48);
  gtk_container_add (GTK_CONTAINER (frame61), vbox48);

  MultiTrayDlg_Prioritize_checkbutton = gtk_check_button_new_with_mnemonic (_("Prioritize Using Multi-purpose Tray"));
  gtk_widget_show (MultiTrayDlg_Prioritize_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox48), MultiTrayDlg_Prioritize_checkbutton, FALSE, FALSE, 0);

  hbuttonbox18 = GTK_DIALOG (MultiTrayDlg_dialog)->action_area;
  gtk_widget_show (hbuttonbox18);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox18), GTK_BUTTONBOX_END);

  hbuttonbox19 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox19);
  gtk_container_add (GTK_CONTAINER (hbuttonbox18), hbuttonbox19);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox19), GTK_BUTTONBOX_END);

  MultiTrayDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (MultiTrayDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox19), MultiTrayDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (MultiTrayDlg_OK_button, GTK_CAN_DEFAULT);

  MultiTrayDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (MultiTrayDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox19), MultiTrayDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (MultiTrayDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) MultiTrayDlg_dialog, "delete_event",
                    G_CALLBACK (on_MultiTrayDlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) MultiTrayDlg_dialog, "destroy",
                    G_CALLBACK (on_MultiTrayDlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) MultiTrayDlg_OK_button, "clicked",
                    G_CALLBACK (on_MultiTrayDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) MultiTrayDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_MultiTrayDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (MultiTrayDlg_dialog, MultiTrayDlg_dialog, "MultiTrayDlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (MultiTrayDlg_dialog, vbox47, "vbox47");
  GLADE_HOOKUP_OBJECT (MultiTrayDlg_dialog, frame61, "frame61");
  GLADE_HOOKUP_OBJECT (MultiTrayDlg_dialog, vbox48, "vbox48");
  GLADE_HOOKUP_OBJECT (MultiTrayDlg_dialog, MultiTrayDlg_Prioritize_checkbutton, "MultiTrayDlg_Prioritize_checkbutton");
  GLADE_HOOKUP_OBJECT_NO_REF (MultiTrayDlg_dialog, hbuttonbox18, "hbuttonbox18");
  GLADE_HOOKUP_OBJECT (MultiTrayDlg_dialog, hbuttonbox19, "hbuttonbox19");
  GLADE_HOOKUP_OBJECT (MultiTrayDlg_dialog, MultiTrayDlg_OK_button, "MultiTrayDlg_OK_button");
  GLADE_HOOKUP_OBJECT (MultiTrayDlg_dialog, MultiTrayDlg_Cancel_button, "MultiTrayDlg_Cancel_button");

  return MultiTrayDlg_dialog;
}

GtkWidget*
create_PPAVHDlg_dialog (void)
{
  GtkWidget *PPAVHDlg_dialog;
  GtkWidget *vbox49;
  GtkWidget *table7;
  GtkWidget *label208;
  GtkWidget *PPAVHDlg_Vertical_Multi_label;
  GtkWidget *PPAVHDlg_Vertical_Cas1_label;
  GtkWidget *PPAVHDlg_Vertical_Cas2_label;
  GtkWidget *PPAVHDlg_Vertical_Cas3_label;
  GtkWidget *PPAVHDlg_Vertical_Cas4_label;
  GtkWidget *PPAVHDlg_Vertical_Duplex_label;
  GtkWidget *hseparator2;
  GtkWidget *label216;
  GtkWidget *PPAVHDlg_Horizontal_Multi_label;
  GtkWidget *PPAVHDlg_Horizontal_Cas1_label;
  GtkWidget *PPAVHDlg_Horizontal_Cas2_label;
  GtkWidget *PPAVHDlg_Horizontal_Cas3_label;
  GtkWidget *PPAVHDlg_Horizontal_Cas4_label;
  GtkWidget *PPAVHDlg_Horizontal_Duplex_label;
  GtkWidget *PPAVHDlg_Vertical_Multi_combo;
  GtkWidget *PPAVHDlg_Vertical_Multi_combo_entry;
  GtkWidget *PPAVHDlg_Vertical_Cas1_combo;
  GtkWidget *PPAVHDlg_Vertical_Cas1_combo_entry;
  GtkWidget *PPAVHDlg_Vertical_Cas2_combo;
  GtkWidget *PPAVHDlg_Vertical_Cas2_combo_entry;
  GtkWidget *PPAVHDlg_Vertical_Cas3_combo;
  GtkWidget *PPAVHDlg_Vertical_Cas3_combo_entry;
  GtkWidget *PPAVHDlg_Vertical_Cas4_combo;
  GtkWidget *PPAVHDlg_Vertical_Cas4_combo_entry;
  GtkWidget *PPAVHDlg_Vertical_Duplex_combo;
  GtkWidget *PPAVHDlg_Vertical_Duplex_combo_entry;
  GtkWidget *PPAVHDlg_Horizontal_Multi_combo;
  GtkWidget *PPAVHDlg_Horizontal_Multi_combo_entry;
  GtkWidget *PPAVHDlg_Horizontal_Cas1_combo;
  GtkWidget *PPAVHDlg_Horizontal_Cas1_combo_entry;
  GtkWidget *PPAVHDlg_Horizontal_Cas2_combo;
  GtkWidget *PPAVHDlg_Horizontal_Cas2_combo_entry;
  GtkWidget *PPAVHDlg_Horizontal_Cas3_combo;
  GtkWidget *PPAVHDlg_Horizontal_Cas3_combo_entry;
  GtkWidget *PPAVHDlg_Horizontal_Cas4_combo;
  GtkWidget *PPAVHDlg_Horizontal_Cas4_combo_entry;
  GtkWidget *PPAVHDlg_Horizontal_Duplex_combo;
  GtkWidget *PPAVHDlg_Horizontal_Duplex_combo_entry;
  GtkWidget *label223;
  GtkWidget *label224;
  GtkWidget *label225;
  GtkWidget *label226;
  GtkWidget *label227;
  GtkWidget *label228;
  GtkWidget *label229;
  GtkWidget *label230;
  GtkWidget *label231;
  GtkWidget *label232;
  GtkWidget *label233;
  GtkWidget *label234;
  GtkWidget *hbuttonbox20;
  GtkWidget *hbuttonbox21;
  GtkWidget *PPAVHDlg_OK_button;
  GtkWidget *PPAVHDlg_Cancel_button;

  PPAVHDlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (PPAVHDlg_dialog), _("Printing Position Adjustment"));
  gtk_window_set_position (GTK_WINDOW (PPAVHDlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (PPAVHDlg_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (PPAVHDlg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (PPAVHDlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  vbox49 = GTK_DIALOG (PPAVHDlg_dialog)->vbox;
  gtk_widget_show (vbox49);

  table7 = gtk_table_new (15, 5, FALSE);
  gtk_widget_show (table7);
  gtk_box_pack_start (GTK_BOX (vbox49), table7, FALSE, TRUE, 5);

  label208 = gtk_label_new (_("Vertical Adjustment"));
  gtk_widget_show (label208);
  gtk_table_attach (GTK_TABLE (table7), label208, 0, 5, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label208), 0, 0.5);

  PPAVHDlg_Vertical_Multi_label = gtk_label_new (_("Vertical Adjustment with Multi-purpose Tray:"));
  gtk_widget_show (PPAVHDlg_Vertical_Multi_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Multi_label, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Vertical_Multi_label), 0, 0.5);

  PPAVHDlg_Vertical_Cas1_label = gtk_label_new (_("Vertical Adjustment with Cassette 1:"));
  gtk_widget_show (PPAVHDlg_Vertical_Cas1_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Cas1_label, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Vertical_Cas1_label), 0, 0.5);

  PPAVHDlg_Vertical_Cas2_label = gtk_label_new (_("Vertical Adjustment with Cassette 2:"));
  gtk_widget_show (PPAVHDlg_Vertical_Cas2_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Cas2_label, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Vertical_Cas2_label), 0, 0.5);

  PPAVHDlg_Vertical_Cas3_label = gtk_label_new (_("Vertical Adjustment with Cassette 3:"));
  gtk_widget_show (PPAVHDlg_Vertical_Cas3_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Cas3_label, 1, 2, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Vertical_Cas3_label), 0, 0.5);

  PPAVHDlg_Vertical_Cas4_label = gtk_label_new (_("Vertical Adjustment with Cassette 4:"));
  gtk_widget_show (PPAVHDlg_Vertical_Cas4_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Cas4_label, 1, 2, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Vertical_Cas4_label), 0, 0.5);

  PPAVHDlg_Vertical_Duplex_label = gtk_label_new (_("Vertical Adjustment with Duplex Unit:"));
  gtk_widget_show (PPAVHDlg_Vertical_Duplex_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Duplex_label, 1, 2, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Vertical_Duplex_label), 0, 0.5);

  hseparator2 = gtk_hseparator_new ();
  gtk_widget_show (hseparator2);
  gtk_table_attach (GTK_TABLE (table7), hseparator2, 0, 5, 7, 8,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 5);

  label216 = gtk_label_new (_("Horizontal Adjustment"));
  gtk_widget_show (label216);
  gtk_table_attach (GTK_TABLE (table7), label216, 0, 5, 8, 9,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label216), 0, 0.5);

  PPAVHDlg_Horizontal_Multi_label = gtk_label_new (_("Horizontal Adjustment with Multi-purpose Tray:"));
  gtk_widget_show (PPAVHDlg_Horizontal_Multi_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Multi_label, 1, 2, 9, 10,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Horizontal_Multi_label), 0, 0.5);

  PPAVHDlg_Horizontal_Cas1_label = gtk_label_new (_("Horizontal Adjustment with Cassette 1:"));
  gtk_widget_show (PPAVHDlg_Horizontal_Cas1_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Cas1_label, 1, 2, 10, 11,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Horizontal_Cas1_label), 0, 0.5);

  PPAVHDlg_Horizontal_Cas2_label = gtk_label_new (_("Horizontal Adjustment with Cassette 2:"));
  gtk_widget_show (PPAVHDlg_Horizontal_Cas2_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Cas2_label, 1, 2, 11, 12,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Horizontal_Cas2_label), 0, 0.5);

  PPAVHDlg_Horizontal_Cas3_label = gtk_label_new (_("Horizontal Adjustment with Cassette 3:"));
  gtk_widget_show (PPAVHDlg_Horizontal_Cas3_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Cas3_label, 1, 2, 12, 13,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Horizontal_Cas3_label), 0, 0.5);

  PPAVHDlg_Horizontal_Cas4_label = gtk_label_new (_("Horizontal Adjustment with Cassette 4:"));
  gtk_widget_show (PPAVHDlg_Horizontal_Cas4_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Cas4_label, 1, 2, 13, 14,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Horizontal_Cas4_label), 0, 0.5);

  PPAVHDlg_Horizontal_Duplex_label = gtk_label_new (_("Horizontal Adjustment with Duplex Unit:"));
  gtk_widget_show (PPAVHDlg_Horizontal_Duplex_label);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Duplex_label, 1, 2, 14, 15,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (PPAVHDlg_Horizontal_Duplex_label), 0, 0.5);

  PPAVHDlg_Vertical_Multi_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Vertical_Multi_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Vertical_Multi_combo);
  gtk_widget_show (PPAVHDlg_Vertical_Multi_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Multi_combo, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Vertical_Multi_combo), 5);

  PPAVHDlg_Vertical_Multi_combo_entry = GTK_COMBO (PPAVHDlg_Vertical_Multi_combo)->entry;
  gtk_widget_show (PPAVHDlg_Vertical_Multi_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Vertical_Multi_combo_entry), FALSE);

  PPAVHDlg_Vertical_Cas1_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Vertical_Cas1_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Vertical_Cas1_combo);
  gtk_widget_show (PPAVHDlg_Vertical_Cas1_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Cas1_combo, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Vertical_Cas1_combo), 5);

  PPAVHDlg_Vertical_Cas1_combo_entry = GTK_COMBO (PPAVHDlg_Vertical_Cas1_combo)->entry;
  gtk_widget_show (PPAVHDlg_Vertical_Cas1_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Vertical_Cas1_combo_entry), FALSE);

  PPAVHDlg_Vertical_Cas2_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Vertical_Cas2_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Vertical_Cas2_combo);
  gtk_widget_show (PPAVHDlg_Vertical_Cas2_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Cas2_combo, 2, 3, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Vertical_Cas2_combo), 5);

  PPAVHDlg_Vertical_Cas2_combo_entry = GTK_COMBO (PPAVHDlg_Vertical_Cas2_combo)->entry;
  gtk_widget_show (PPAVHDlg_Vertical_Cas2_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Vertical_Cas2_combo_entry), FALSE);

  PPAVHDlg_Vertical_Cas3_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Vertical_Cas3_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Vertical_Cas3_combo);
  gtk_widget_show (PPAVHDlg_Vertical_Cas3_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Cas3_combo, 2, 3, 4, 5,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Vertical_Cas3_combo), 5);

  PPAVHDlg_Vertical_Cas3_combo_entry = GTK_COMBO (PPAVHDlg_Vertical_Cas3_combo)->entry;
  gtk_widget_show (PPAVHDlg_Vertical_Cas3_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Vertical_Cas3_combo_entry), FALSE);

  PPAVHDlg_Vertical_Cas4_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Vertical_Cas4_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Vertical_Cas4_combo);
  gtk_widget_show (PPAVHDlg_Vertical_Cas4_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Cas4_combo, 2, 3, 5, 6,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Vertical_Cas4_combo), 5);

  PPAVHDlg_Vertical_Cas4_combo_entry = GTK_COMBO (PPAVHDlg_Vertical_Cas4_combo)->entry;
  gtk_widget_show (PPAVHDlg_Vertical_Cas4_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Vertical_Cas4_combo_entry), FALSE);

  PPAVHDlg_Vertical_Duplex_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Vertical_Duplex_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Vertical_Duplex_combo);
  gtk_widget_show (PPAVHDlg_Vertical_Duplex_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Vertical_Duplex_combo, 2, 3, 6, 7,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Vertical_Duplex_combo), 5);

  PPAVHDlg_Vertical_Duplex_combo_entry = GTK_COMBO (PPAVHDlg_Vertical_Duplex_combo)->entry;
  gtk_widget_show (PPAVHDlg_Vertical_Duplex_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Vertical_Duplex_combo_entry), FALSE);

  PPAVHDlg_Horizontal_Multi_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Horizontal_Multi_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Horizontal_Multi_combo);
  gtk_widget_show (PPAVHDlg_Horizontal_Multi_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Multi_combo, 2, 3, 9, 10,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Horizontal_Multi_combo), 5);

  PPAVHDlg_Horizontal_Multi_combo_entry = GTK_COMBO (PPAVHDlg_Horizontal_Multi_combo)->entry;
  gtk_widget_show (PPAVHDlg_Horizontal_Multi_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Horizontal_Multi_combo_entry), FALSE);

  PPAVHDlg_Horizontal_Cas1_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Horizontal_Cas1_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Horizontal_Cas1_combo);
  gtk_widget_show (PPAVHDlg_Horizontal_Cas1_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Cas1_combo, 2, 3, 10, 11,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Horizontal_Cas1_combo), 5);

  PPAVHDlg_Horizontal_Cas1_combo_entry = GTK_COMBO (PPAVHDlg_Horizontal_Cas1_combo)->entry;
  gtk_widget_show (PPAVHDlg_Horizontal_Cas1_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Horizontal_Cas1_combo_entry), FALSE);

  PPAVHDlg_Horizontal_Cas2_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Horizontal_Cas2_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Horizontal_Cas2_combo);
  gtk_widget_show (PPAVHDlg_Horizontal_Cas2_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Cas2_combo, 2, 3, 11, 12,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Horizontal_Cas2_combo), 5);

  PPAVHDlg_Horizontal_Cas2_combo_entry = GTK_COMBO (PPAVHDlg_Horizontal_Cas2_combo)->entry;
  gtk_widget_show (PPAVHDlg_Horizontal_Cas2_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Horizontal_Cas2_combo_entry), FALSE);

  PPAVHDlg_Horizontal_Cas3_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Horizontal_Cas3_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Horizontal_Cas3_combo);
  gtk_widget_show (PPAVHDlg_Horizontal_Cas3_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Cas3_combo, 2, 3, 12, 13,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Horizontal_Cas3_combo), 5);

  PPAVHDlg_Horizontal_Cas3_combo_entry = GTK_COMBO (PPAVHDlg_Horizontal_Cas3_combo)->entry;
  gtk_widget_show (PPAVHDlg_Horizontal_Cas3_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Horizontal_Cas3_combo_entry), FALSE);

  PPAVHDlg_Horizontal_Cas4_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Horizontal_Cas4_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Horizontal_Cas4_combo);
  gtk_widget_show (PPAVHDlg_Horizontal_Cas4_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Cas4_combo, 2, 3, 13, 14,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Horizontal_Cas4_combo), 5);

  PPAVHDlg_Horizontal_Cas4_combo_entry = GTK_COMBO (PPAVHDlg_Horizontal_Cas4_combo)->entry;
  gtk_widget_show (PPAVHDlg_Horizontal_Cas4_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Horizontal_Cas4_combo_entry), FALSE);

  PPAVHDlg_Horizontal_Duplex_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (PPAVHDlg_Horizontal_Duplex_combo)->popwin),
                     "GladeParentKey", PPAVHDlg_Horizontal_Duplex_combo);
  gtk_widget_show (PPAVHDlg_Horizontal_Duplex_combo);
  gtk_table_attach (GTK_TABLE (table7), PPAVHDlg_Horizontal_Duplex_combo, 2, 3, 14, 15,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_container_set_border_width (GTK_CONTAINER (PPAVHDlg_Horizontal_Duplex_combo), 5);

  PPAVHDlg_Horizontal_Duplex_combo_entry = GTK_COMBO (PPAVHDlg_Horizontal_Duplex_combo)->entry;
  gtk_widget_show (PPAVHDlg_Horizontal_Duplex_combo_entry);
  gtk_editable_set_editable (GTK_EDITABLE (PPAVHDlg_Horizontal_Duplex_combo_entry), FALSE);

  label223 = gtk_label_new (_("mm"));
  gtk_widget_show (label223);
  gtk_table_attach (GTK_TABLE (table7), label223, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label223), 0, 0.5);

  label224 = gtk_label_new (_("mm"));
  gtk_widget_show (label224);
  gtk_table_attach (GTK_TABLE (table7), label224, 3, 4, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label224), 0, 0.5);

  label225 = gtk_label_new (_("mm"));
  gtk_widget_show (label225);
  gtk_table_attach (GTK_TABLE (table7), label225, 3, 4, 3, 4,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label225), 0, 0.5);

  label226 = gtk_label_new (_("mm"));
  gtk_widget_show (label226);
  gtk_table_attach (GTK_TABLE (table7), label226, 3, 4, 4, 5,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label226), 0, 0.5);

  label227 = gtk_label_new (_("mm"));
  gtk_widget_show (label227);
  gtk_table_attach (GTK_TABLE (table7), label227, 3, 4, 5, 6,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label227), 0, 0.5);

  label228 = gtk_label_new (_("mm"));
  gtk_widget_show (label228);
  gtk_table_attach (GTK_TABLE (table7), label228, 3, 4, 6, 7,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label228), 0, 0.5);

  label229 = gtk_label_new (_("mm"));
  gtk_widget_show (label229);
  gtk_table_attach (GTK_TABLE (table7), label229, 3, 4, 9, 10,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label229), 0, 0.5);

  label230 = gtk_label_new (_("mm"));
  gtk_widget_show (label230);
  gtk_table_attach (GTK_TABLE (table7), label230, 3, 4, 10, 11,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label230), 0, 0.5);

  label231 = gtk_label_new (_("mm"));
  gtk_widget_show (label231);
  gtk_table_attach (GTK_TABLE (table7), label231, 3, 4, 11, 12,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label231), 0, 0.5);

  label232 = gtk_label_new (_("mm"));
  gtk_widget_show (label232);
  gtk_table_attach (GTK_TABLE (table7), label232, 3, 4, 12, 13,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label232), 0, 0.5);

  label233 = gtk_label_new (_("mm"));
  gtk_widget_show (label233);
  gtk_table_attach (GTK_TABLE (table7), label233, 3, 4, 13, 14,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label233), 0, 0.5);

  label234 = gtk_label_new (_("mm"));
  gtk_widget_show (label234);
  gtk_table_attach (GTK_TABLE (table7), label234, 3, 4, 14, 15,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label234), 0, 0.5);

  hbuttonbox20 = GTK_DIALOG (PPAVHDlg_dialog)->action_area;
  gtk_widget_show (hbuttonbox20);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox20), GTK_BUTTONBOX_END);

  hbuttonbox21 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox21);
  gtk_container_add (GTK_CONTAINER (hbuttonbox20), hbuttonbox21);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox21), GTK_BUTTONBOX_END);

  PPAVHDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (PPAVHDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox21), PPAVHDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (PPAVHDlg_OK_button, GTK_CAN_DEFAULT);

  PPAVHDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (PPAVHDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox21), PPAVHDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (PPAVHDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) PPAVHDlg_dialog, "delete_event",
                    G_CALLBACK (on_PPAVHDlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_dialog, "destroy",
                    G_CALLBACK (on_PPAVHDlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Vertical_Multi_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Vertical_Multi_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Vertical_Cas1_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Vertical_Cas1_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Vertical_Cas2_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Vertical_Cas2_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Vertical_Cas3_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Vertical_Cas3_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Vertical_Cas4_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Vertical_Cas4_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Vertical_Duplex_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Vertical_Duplex_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Horizontal_Multi_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Horizontal_Multi_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Horizontal_Cas1_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Horizontal_Cas1_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Horizontal_Cas2_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Horizontal_Cas2_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Horizontal_Cas3_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Horizontal_Cas3_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Horizontal_Cas4_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Horizontal_Cas4_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Horizontal_Duplex_combo_entry, "changed",
                    G_CALLBACK (on_PPAVHDlg_Horizontal_Duplex_combo_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_OK_button, "clicked",
                    G_CALLBACK (on_PPAVHDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) PPAVHDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_PPAVHDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (PPAVHDlg_dialog, PPAVHDlg_dialog, "PPAVHDlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (PPAVHDlg_dialog, vbox49, "vbox49");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, table7, "table7");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label208, "label208");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Multi_label, "PPAVHDlg_Vertical_Multi_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas1_label, "PPAVHDlg_Vertical_Cas1_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas2_label, "PPAVHDlg_Vertical_Cas2_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas3_label, "PPAVHDlg_Vertical_Cas3_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas4_label, "PPAVHDlg_Vertical_Cas4_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Duplex_label, "PPAVHDlg_Vertical_Duplex_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, hseparator2, "hseparator2");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label216, "label216");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Multi_label, "PPAVHDlg_Horizontal_Multi_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas1_label, "PPAVHDlg_Horizontal_Cas1_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas2_label, "PPAVHDlg_Horizontal_Cas2_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas3_label, "PPAVHDlg_Horizontal_Cas3_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas4_label, "PPAVHDlg_Horizontal_Cas4_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Duplex_label, "PPAVHDlg_Horizontal_Duplex_label");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Multi_combo, "PPAVHDlg_Vertical_Multi_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Multi_combo_entry, "PPAVHDlg_Vertical_Multi_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas1_combo, "PPAVHDlg_Vertical_Cas1_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas1_combo_entry, "PPAVHDlg_Vertical_Cas1_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas2_combo, "PPAVHDlg_Vertical_Cas2_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas2_combo_entry, "PPAVHDlg_Vertical_Cas2_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas3_combo, "PPAVHDlg_Vertical_Cas3_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas3_combo_entry, "PPAVHDlg_Vertical_Cas3_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas4_combo, "PPAVHDlg_Vertical_Cas4_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Cas4_combo_entry, "PPAVHDlg_Vertical_Cas4_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Duplex_combo, "PPAVHDlg_Vertical_Duplex_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Vertical_Duplex_combo_entry, "PPAVHDlg_Vertical_Duplex_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Multi_combo, "PPAVHDlg_Horizontal_Multi_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Multi_combo_entry, "PPAVHDlg_Horizontal_Multi_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas1_combo, "PPAVHDlg_Horizontal_Cas1_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas1_combo_entry, "PPAVHDlg_Horizontal_Cas1_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas2_combo, "PPAVHDlg_Horizontal_Cas2_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas2_combo_entry, "PPAVHDlg_Horizontal_Cas2_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas3_combo, "PPAVHDlg_Horizontal_Cas3_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas3_combo_entry, "PPAVHDlg_Horizontal_Cas3_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas4_combo, "PPAVHDlg_Horizontal_Cas4_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Cas4_combo_entry, "PPAVHDlg_Horizontal_Cas4_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Duplex_combo, "PPAVHDlg_Horizontal_Duplex_combo");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Horizontal_Duplex_combo_entry, "PPAVHDlg_Horizontal_Duplex_combo_entry");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label223, "label223");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label224, "label224");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label225, "label225");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label226, "label226");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label227, "label227");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label228, "label228");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label229, "label229");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label230, "label230");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label231, "label231");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label232, "label232");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label233, "label233");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, label234, "label234");
  GLADE_HOOKUP_OBJECT_NO_REF (PPAVHDlg_dialog, hbuttonbox20, "hbuttonbox20");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, hbuttonbox21, "hbuttonbox21");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_OK_button, "PPAVHDlg_OK_button");
  GLADE_HOOKUP_OBJECT (PPAVHDlg_dialog, PPAVHDlg_Cancel_button, "PPAVHDlg_Cancel_button");

  return PPAVHDlg_dialog;
}

GtkWidget*
create_TonerReplacementDlg_dialog (void)
{
  GtkWidget *TonerReplacementDlg_dialog;
  GtkWidget *vbox50;
  GtkWidget *frame62;
  GtkWidget *vbox53;
  GtkWidget *scrolledwindow2;
  GtkWidget *TonerReplacementDlg_text;
  GtkWidget *label248;
  GtkWidget *TonerReplacementDlg_Replaceable_TonerColor_label;
  GtkWidget *label250;
  GtkWidget *table9;
  GtkWidget *TonerReplacementDlg_Cyan_label;
  GtkWidget *TonerReplacementDlg_Magenta_label;
  GtkWidget *TonerReplacementDlg_Yellow_label;
  GtkWidget *TonerReplacementDlg_Black_label;
  GtkWidget *TonerReplacementDlg_Magenta_button;
  GtkWidget *TonerReplacementDlg_Yellow_button;
  GtkWidget *TonerReplacementDlg_Black_button;
  GtkWidget *TonerReplacementDlg_Cyan_button;
  GtkWidget *hbuttonbox22;
  GtkWidget *hbuttonbox23;
  GtkWidget *TonerReplacementDlg_Finish_button;

  TonerReplacementDlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (TonerReplacementDlg_dialog), _("Toner Cartridge Replacement"));
  gtk_window_set_position (GTK_WINDOW (TonerReplacementDlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (TonerReplacementDlg_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (TonerReplacementDlg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (TonerReplacementDlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  vbox50 = GTK_DIALOG (TonerReplacementDlg_dialog)->vbox;
  gtk_widget_show (vbox50);

  frame62 = gtk_frame_new (NULL);
  gtk_widget_show (frame62);
  gtk_box_pack_start (GTK_BOX (vbox50), frame62, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame62), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame62), GTK_SHADOW_NONE);

  vbox53 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox53);
  gtk_container_add (GTK_CONTAINER (frame62), vbox53);

  scrolledwindow2 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_show (scrolledwindow2);
  gtk_box_pack_start (GTK_BOX (vbox53), scrolledwindow2, TRUE, TRUE, 0);
  gtk_widget_set_size_request (scrolledwindow2, 360, 100);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolledwindow2), GTK_SHADOW_IN);

  TonerReplacementDlg_text = gtk_text_view_new ();
  gtk_widget_show (TonerReplacementDlg_text);
  gtk_container_add (GTK_CONTAINER (scrolledwindow2), TonerReplacementDlg_text);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (TonerReplacementDlg_text), FALSE);
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (TonerReplacementDlg_text), GTK_WRAP_WORD);

  label248 = gtk_label_new (_("Replaceable Toner Cartridge:"));
  gtk_widget_show (label248);
  gtk_box_pack_start (GTK_BOX (vbox53), label248, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label248), 0, 0.5);

  TonerReplacementDlg_Replaceable_TonerColor_label = gtk_label_new ("");
  gtk_widget_show (TonerReplacementDlg_Replaceable_TonerColor_label);
  gtk_box_pack_start (GTK_BOX (vbox53), TonerReplacementDlg_Replaceable_TonerColor_label, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (TonerReplacementDlg_Replaceable_TonerColor_label), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (TonerReplacementDlg_Replaceable_TonerColor_label), 0, 11);

  label250 = gtk_label_new (_("Toner Cartridge:"));
  gtk_widget_show (label250);
  gtk_box_pack_start (GTK_BOX (vbox53), label250, FALSE, FALSE, 0);
  gtk_misc_set_alignment (GTK_MISC (label250), 0, 0.5);

  table9 = gtk_table_new (4, 2, TRUE);
  gtk_widget_show (table9);
  gtk_box_pack_start (GTK_BOX (vbox53), table9, TRUE, TRUE, 0);

  TonerReplacementDlg_Cyan_label = gtk_label_new ("");
  gtk_widget_show (TonerReplacementDlg_Cyan_label);
  gtk_table_attach (GTK_TABLE (table9), TonerReplacementDlg_Cyan_label, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_label_set_justify (GTK_LABEL (TonerReplacementDlg_Cyan_label), GTK_JUSTIFY_CENTER);

  TonerReplacementDlg_Magenta_label = gtk_label_new ("");
  gtk_widget_show (TonerReplacementDlg_Magenta_label);
  gtk_table_attach (GTK_TABLE (table9), TonerReplacementDlg_Magenta_label, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  TonerReplacementDlg_Yellow_label = gtk_label_new ("");
  gtk_widget_show (TonerReplacementDlg_Yellow_label);
  gtk_table_attach (GTK_TABLE (table9), TonerReplacementDlg_Yellow_label, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  TonerReplacementDlg_Black_label = gtk_label_new ("");
  gtk_widget_show (TonerReplacementDlg_Black_label);
  gtk_table_attach (GTK_TABLE (table9), TonerReplacementDlg_Black_label, 1, 2, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  TonerReplacementDlg_Magenta_button = gtk_button_new_with_mnemonic (_("Magenta"));
  gtk_widget_show (TonerReplacementDlg_Magenta_button);
  gtk_table_attach (GTK_TABLE (table9), TonerReplacementDlg_Magenta_button, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (TonerReplacementDlg_Magenta_button, 150, 40);
  gtk_container_set_border_width (GTK_CONTAINER (TonerReplacementDlg_Magenta_button), 5);
  GTK_WIDGET_SET_FLAGS (TonerReplacementDlg_Magenta_button, GTK_CAN_DEFAULT);

  TonerReplacementDlg_Yellow_button = gtk_button_new_with_mnemonic (_("Yellow"));
  gtk_widget_show (TonerReplacementDlg_Yellow_button);
  gtk_table_attach (GTK_TABLE (table9), TonerReplacementDlg_Yellow_button, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (TonerReplacementDlg_Yellow_button, 150, 40);
  gtk_container_set_border_width (GTK_CONTAINER (TonerReplacementDlg_Yellow_button), 5);
  GTK_WIDGET_SET_FLAGS (TonerReplacementDlg_Yellow_button, GTK_CAN_DEFAULT);

  TonerReplacementDlg_Black_button = gtk_button_new_with_mnemonic (_("Black"));
  gtk_widget_show (TonerReplacementDlg_Black_button);
  gtk_table_attach (GTK_TABLE (table9), TonerReplacementDlg_Black_button, 0, 1, 3, 4,
                    (GtkAttachOptions) (GTK_EXPAND),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (TonerReplacementDlg_Black_button, 150, 40);
  gtk_container_set_border_width (GTK_CONTAINER (TonerReplacementDlg_Black_button), 5);
  GTK_WIDGET_SET_FLAGS (TonerReplacementDlg_Black_button, GTK_CAN_DEFAULT);

  TonerReplacementDlg_Cyan_button = gtk_button_new_with_mnemonic (_("Cyan"));
  gtk_widget_show (TonerReplacementDlg_Cyan_button);
  gtk_table_attach (GTK_TABLE (table9), TonerReplacementDlg_Cyan_button, 0, 1, 0, 1,
                    (GtkAttachOptions) (0),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_widget_set_size_request (TonerReplacementDlg_Cyan_button, 150, 40);
  gtk_container_set_border_width (GTK_CONTAINER (TonerReplacementDlg_Cyan_button), 5);
  GTK_WIDGET_SET_FLAGS (TonerReplacementDlg_Cyan_button, GTK_CAN_DEFAULT);

  hbuttonbox22 = GTK_DIALOG (TonerReplacementDlg_dialog)->action_area;
  gtk_widget_show (hbuttonbox22);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox22), GTK_BUTTONBOX_END);

  hbuttonbox23 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox23);
  gtk_container_add (GTK_CONTAINER (hbuttonbox22), hbuttonbox23);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox23), GTK_BUTTONBOX_END);

  TonerReplacementDlg_Finish_button = gtk_button_new_with_mnemonic (_("Finish Replacing"));
  gtk_widget_show (TonerReplacementDlg_Finish_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox23), TonerReplacementDlg_Finish_button);
  GTK_WIDGET_SET_FLAGS (TonerReplacementDlg_Finish_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) TonerReplacementDlg_dialog, "delete_event",
                    G_CALLBACK (on_TonerReplacementDlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) TonerReplacementDlg_dialog, "destroy",
                    G_CALLBACK (on_TonerReplacementDlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) TonerReplacementDlg_Magenta_button, "clicked",
                    G_CALLBACK (on_TonerReplacementDlg_Magenta_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) TonerReplacementDlg_Yellow_button, "clicked",
                    G_CALLBACK (on_TonerReplacementDlg_Yellow_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) TonerReplacementDlg_Black_button, "clicked",
                    G_CALLBACK (on_TonerReplacementDlg_Black_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) TonerReplacementDlg_Cyan_button, "clicked",
                    G_CALLBACK (on_TonerReplacementDlg_Cyan_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) TonerReplacementDlg_Finish_button, "clicked",
                    G_CALLBACK (on_TonerReplacementDlg_Finish_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (TonerReplacementDlg_dialog, TonerReplacementDlg_dialog, "TonerReplacementDlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (TonerReplacementDlg_dialog, vbox50, "vbox50");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, frame62, "frame62");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, vbox53, "vbox53");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, scrolledwindow2, "scrolledwindow2");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_text, "TonerReplacementDlg_text");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, label248, "label248");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_Replaceable_TonerColor_label, "TonerReplacementDlg_Replaceable_TonerColor_label");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, label250, "label250");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, table9, "table9");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_Cyan_label, "TonerReplacementDlg_Cyan_label");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_Magenta_label, "TonerReplacementDlg_Magenta_label");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_Yellow_label, "TonerReplacementDlg_Yellow_label");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_Black_label, "TonerReplacementDlg_Black_label");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_Magenta_button, "TonerReplacementDlg_Magenta_button");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_Yellow_button, "TonerReplacementDlg_Yellow_button");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_Black_button, "TonerReplacementDlg_Black_button");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_Cyan_button, "TonerReplacementDlg_Cyan_button");
  GLADE_HOOKUP_OBJECT_NO_REF (TonerReplacementDlg_dialog, hbuttonbox22, "hbuttonbox22");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, hbuttonbox23, "hbuttonbox23");
  GLADE_HOOKUP_OBJECT (TonerReplacementDlg_dialog, TonerReplacementDlg_Finish_button, "TonerReplacementDlg_Finish_button");

  return TonerReplacementDlg_dialog;
}

GtkWidget*
create_CleaningDlg_dialog (void)
{
  GtkWidget *CleaningDlg_dialog;
  GtkWidget *vbox54;
  GtkWidget *frame63;
  GtkWidget *vbox55;
  GtkWidget *frame64;
  GtkWidget *alignment1;
  GtkWidget *vbox57;
  GtkWidget *CleaningDlg_FixingUnitCleaning1_radiobutton;
  GSList *CleaningDlg_FixingUnitCleaning1_radiobutton_group = NULL;
  GtkWidget *CleaningDlg_FixingUnitCleaning2_radiobutton;
  GtkWidget *CleaningDlg_DrumCleaning1_radiobutton;
  GtkWidget *CleaningDlg_DrumCleaning2_radiobutton;
  GtkWidget *label263;
  GtkWidget *vbox56;
  GtkWidget *label261;
  GtkWidget *label262;
  GtkWidget *hbuttonbox25;
  GtkWidget *hbuttonbox26;
  GtkWidget *CleaningDlg_OK_button;
  GtkWidget *CleaningDlg_Cancel_button;

  CleaningDlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (CleaningDlg_dialog), _("Cleaning"));
  gtk_window_set_position (GTK_WINDOW (CleaningDlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (CleaningDlg_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (CleaningDlg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (CleaningDlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  vbox54 = GTK_DIALOG (CleaningDlg_dialog)->vbox;
  gtk_widget_show (vbox54);

  frame63 = gtk_frame_new (NULL);
  gtk_widget_show (frame63);
  gtk_box_pack_start (GTK_BOX (vbox54), frame63, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame63), 5);
  gtk_frame_set_shadow_type (GTK_FRAME (frame63), GTK_SHADOW_NONE);

  vbox55 = gtk_vbox_new (TRUE, 0);
  gtk_widget_show (vbox55);
  gtk_container_add (GTK_CONTAINER (frame63), vbox55);

  frame64 = gtk_frame_new (NULL);
  gtk_widget_show (frame64);
  gtk_box_pack_start (GTK_BOX (vbox55), frame64, TRUE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame64), GTK_SHADOW_OUT);

  alignment1 = gtk_alignment_new (0.5, 0.5, 1, 1);
  gtk_widget_show (alignment1);
  gtk_container_add (GTK_CONTAINER (frame64), alignment1);
  gtk_alignment_set_padding (GTK_ALIGNMENT (alignment1), 0, 0, 12, 0);

  vbox57 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox57);
  gtk_container_add (GTK_CONTAINER (alignment1), vbox57);

  CleaningDlg_FixingUnitCleaning1_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Fixing Unit Cleaning 1"));
  gtk_widget_show (CleaningDlg_FixingUnitCleaning1_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox57), CleaningDlg_FixingUnitCleaning1_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (CleaningDlg_FixingUnitCleaning1_radiobutton), CleaningDlg_FixingUnitCleaning1_radiobutton_group);
  CleaningDlg_FixingUnitCleaning1_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (CleaningDlg_FixingUnitCleaning1_radiobutton));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (CleaningDlg_FixingUnitCleaning1_radiobutton), TRUE);

  CleaningDlg_FixingUnitCleaning2_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Fixing Unit Cleaning 2"));
  gtk_widget_show (CleaningDlg_FixingUnitCleaning2_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox57), CleaningDlg_FixingUnitCleaning2_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (CleaningDlg_FixingUnitCleaning2_radiobutton), CleaningDlg_FixingUnitCleaning1_radiobutton_group);
  CleaningDlg_FixingUnitCleaning1_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (CleaningDlg_FixingUnitCleaning2_radiobutton));

  CleaningDlg_DrumCleaning1_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Drum Cleaning 1"));
  gtk_widget_show (CleaningDlg_DrumCleaning1_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox57), CleaningDlg_DrumCleaning1_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (CleaningDlg_DrumCleaning1_radiobutton), CleaningDlg_FixingUnitCleaning1_radiobutton_group);
  CleaningDlg_FixingUnitCleaning1_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (CleaningDlg_DrumCleaning1_radiobutton));

  CleaningDlg_DrumCleaning2_radiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Drum Cleaning 2"));
  gtk_widget_show (CleaningDlg_DrumCleaning2_radiobutton);
  gtk_box_pack_start (GTK_BOX (vbox57), CleaningDlg_DrumCleaning2_radiobutton, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (CleaningDlg_DrumCleaning2_radiobutton), CleaningDlg_FixingUnitCleaning1_radiobutton_group);
  CleaningDlg_FixingUnitCleaning1_radiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (CleaningDlg_DrumCleaning2_radiobutton));

  label263 = gtk_label_new (_("Cleaning Type"));
  gtk_widget_show (label263);
  gtk_frame_set_label_widget (GTK_FRAME (frame64), label263);
  gtk_label_set_use_markup (GTK_LABEL (label263), TRUE);

  vbox56 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox56);
  gtk_box_pack_start (GTK_BOX (vbox55), vbox56, FALSE, FALSE, 0);

  label261 = gtk_label_new (_("Performs Cleaning.\nTo perform Fixing Unit Cleaning, check that the correct size paper is loaded in the paper source, and then click [OK]."));
  gtk_widget_show (label261);
  gtk_box_pack_start (GTK_BOX (vbox56), label261, FALSE, FALSE, 0);
  gtk_label_set_line_wrap (GTK_LABEL (label261), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label261), 0, 0);

  label262 = gtk_label_new (_("See the instruction manual for more information about cleaning."));
  gtk_widget_show (label262);
  gtk_box_pack_start (GTK_BOX (vbox56), label262, FALSE, FALSE, 0);
  gtk_label_set_line_wrap (GTK_LABEL (label262), TRUE);
  gtk_misc_set_alignment (GTK_MISC (label262), 0, 0);

  hbuttonbox25 = GTK_DIALOG (CleaningDlg_dialog)->action_area;
  gtk_widget_show (hbuttonbox25);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox25), GTK_BUTTONBOX_END);

  hbuttonbox26 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox26);
  gtk_container_add (GTK_CONTAINER (hbuttonbox25), hbuttonbox26);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox26), GTK_BUTTONBOX_END);

  CleaningDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (CleaningDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox26), CleaningDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (CleaningDlg_OK_button, GTK_CAN_DEFAULT);

  CleaningDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (CleaningDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox26), CleaningDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (CleaningDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) CleaningDlg_dialog, "delete_event",
                    G_CALLBACK (on_CleaningDlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) CleaningDlg_dialog, "destroy",
                    G_CALLBACK (on_CleaningDlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) CleaningDlg_OK_button, "clicked",
                    G_CALLBACK (on_CleaningDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) CleaningDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_CleaningDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (CleaningDlg_dialog, CleaningDlg_dialog, "CleaningDlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (CleaningDlg_dialog, vbox54, "vbox54");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, frame63, "frame63");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, vbox55, "vbox55");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, frame64, "frame64");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, alignment1, "alignment1");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, vbox57, "vbox57");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, CleaningDlg_FixingUnitCleaning1_radiobutton, "CleaningDlg_FixingUnitCleaning1_radiobutton");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, CleaningDlg_FixingUnitCleaning2_radiobutton, "CleaningDlg_FixingUnitCleaning2_radiobutton");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, CleaningDlg_DrumCleaning1_radiobutton, "CleaningDlg_DrumCleaning1_radiobutton");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, CleaningDlg_DrumCleaning2_radiobutton, "CleaningDlg_DrumCleaning2_radiobutton");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, label263, "label263");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, vbox56, "vbox56");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, label261, "label261");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, label262, "label262");
  GLADE_HOOKUP_OBJECT_NO_REF (CleaningDlg_dialog, hbuttonbox25, "hbuttonbox25");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, hbuttonbox26, "hbuttonbox26");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, CleaningDlg_OK_button, "CleaningDlg_OK_button");
  GLADE_HOOKUP_OBJECT (CleaningDlg_dialog, CleaningDlg_Cancel_button, "CleaningDlg_Cancel_button");

  return CleaningDlg_dialog;
}

GtkWidget*
create_CalibrationSettingsDlg_dialog (void)
{
  GtkWidget *CalibrationSettingsDlg_dialog;
  GtkWidget *vbox58;
  GtkWidget *vbox67;
  GtkWidget *CalibrationSettingsDlg_UseCalibTimer_checkbutton;
  GtkWidget *hbox82;
  GtkWidget *label289;
  GtkObject *CalibrationSettingsDlg_Hour_spinbutton_adj;
  GtkWidget *CalibrationSettingsDlg_Hour_spinbutton;
  GtkWidget *label291;
  GtkObject *CalibrationSettingsDlg_Minutes_spinbutton_adj;
  GtkWidget *CalibrationSettingsDlg_Minutes_spinbutton;
  GtkWidget *label290;
  GtkWidget *CalibrationSettingsDlg_Startup_combo;
  GList *CalibrationSettingsDlg_Startup_combo_items = NULL;
  GtkWidget *CalibrationSettingsDlg_Startup_entry;
  GtkWidget *hbuttonbox27;
  GtkWidget *hbuttonbox28;
  GtkWidget *CalibrationSettingsDlg_OK_button;
  GtkWidget *CalibrationSettingsDlg_Cancel_button;

  CalibrationSettingsDlg_dialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (CalibrationSettingsDlg_dialog), _("Calibration Settings"));
  gtk_window_set_position (GTK_WINDOW (CalibrationSettingsDlg_dialog), GTK_WIN_POS_MOUSE);
  gtk_window_set_modal (GTK_WINDOW (CalibrationSettingsDlg_dialog), TRUE);
  gtk_window_set_resizable (GTK_WINDOW (CalibrationSettingsDlg_dialog), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (CalibrationSettingsDlg_dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

  vbox58 = GTK_DIALOG (CalibrationSettingsDlg_dialog)->vbox;
  gtk_widget_show (vbox58);

  vbox67 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox67);
  gtk_box_pack_start (GTK_BOX (vbox58), vbox67, TRUE, TRUE, 0);

  CalibrationSettingsDlg_UseCalibTimer_checkbutton = gtk_check_button_new_with_mnemonic (_("Use Periodical Calibration Timer"));
  gtk_widget_show (CalibrationSettingsDlg_UseCalibTimer_checkbutton);
  gtk_box_pack_start (GTK_BOX (vbox67), CalibrationSettingsDlg_UseCalibTimer_checkbutton, FALSE, FALSE, 5);

  hbox82 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox82);
  gtk_box_pack_start (GTK_BOX (vbox67), hbox82, TRUE, TRUE, 0);

  label289 = gtk_label_new (_("Time:"));
  gtk_widget_show (label289);
  gtk_box_pack_start (GTK_BOX (hbox82), label289, TRUE, FALSE, 5);

  CalibrationSettingsDlg_Hour_spinbutton_adj = gtk_adjustment_new (0, 0, 23, 1, 10, 10);
  CalibrationSettingsDlg_Hour_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (CalibrationSettingsDlg_Hour_spinbutton_adj), 1, 0);
  gtk_widget_show (CalibrationSettingsDlg_Hour_spinbutton);
  gtk_box_pack_start (GTK_BOX (hbox82), CalibrationSettingsDlg_Hour_spinbutton, FALSE, FALSE, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (CalibrationSettingsDlg_Hour_spinbutton), TRUE);

  label291 = gtk_label_new (_(":"));
  gtk_widget_show (label291);
  gtk_box_pack_start (GTK_BOX (hbox82), label291, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label291), GTK_JUSTIFY_CENTER);
  gtk_misc_set_alignment (GTK_MISC (label291), 0, 0.5);

  CalibrationSettingsDlg_Minutes_spinbutton_adj = gtk_adjustment_new (0, 0, 59, 1, 10, 10);
  CalibrationSettingsDlg_Minutes_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (CalibrationSettingsDlg_Minutes_spinbutton_adj), 1, 0);
  gtk_widget_show (CalibrationSettingsDlg_Minutes_spinbutton);
  gtk_box_pack_start (GTK_BOX (hbox82), CalibrationSettingsDlg_Minutes_spinbutton, FALSE, FALSE, 5);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (CalibrationSettingsDlg_Minutes_spinbutton), TRUE);

  label290 = gtk_label_new (_("Startup Calibration:"));
  gtk_widget_show (label290);
  gtk_box_pack_start (GTK_BOX (vbox67), label290, TRUE, TRUE, 0);
  gtk_misc_set_alignment (GTK_MISC (label290), 0, 1);

  CalibrationSettingsDlg_Startup_combo = gtk_combo_new ();
  g_object_set_data (G_OBJECT (GTK_COMBO (CalibrationSettingsDlg_Startup_combo)->popwin),
                     "GladeParentKey", CalibrationSettingsDlg_Startup_combo);
  gtk_widget_show (CalibrationSettingsDlg_Startup_combo);
  gtk_box_pack_start (GTK_BOX (vbox67), CalibrationSettingsDlg_Startup_combo, FALSE, FALSE, 10);
  CalibrationSettingsDlg_Startup_combo_items = g_list_append (CalibrationSettingsDlg_Startup_combo_items, (gpointer) "");
  gtk_combo_set_popdown_strings (GTK_COMBO (CalibrationSettingsDlg_Startup_combo), CalibrationSettingsDlg_Startup_combo_items);
  g_list_free (CalibrationSettingsDlg_Startup_combo_items);

  CalibrationSettingsDlg_Startup_entry = GTK_COMBO (CalibrationSettingsDlg_Startup_combo)->entry;
  gtk_widget_show (CalibrationSettingsDlg_Startup_entry);
  gtk_editable_set_editable (GTK_EDITABLE (CalibrationSettingsDlg_Startup_entry), FALSE);
  gtk_entry_set_invisible_char (GTK_ENTRY (CalibrationSettingsDlg_Startup_entry), 8226);

  hbuttonbox27 = GTK_DIALOG (CalibrationSettingsDlg_dialog)->action_area;
  gtk_widget_show (hbuttonbox27);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox27), GTK_BUTTONBOX_END);

  hbuttonbox28 = gtk_hbutton_box_new ();
  gtk_widget_show (hbuttonbox28);
  gtk_container_add (GTK_CONTAINER (hbuttonbox27), hbuttonbox28);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox28), GTK_BUTTONBOX_END);

  CalibrationSettingsDlg_OK_button = gtk_button_new_with_mnemonic (_("OK"));
  gtk_widget_show (CalibrationSettingsDlg_OK_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox28), CalibrationSettingsDlg_OK_button);
  GTK_WIDGET_SET_FLAGS (CalibrationSettingsDlg_OK_button, GTK_CAN_DEFAULT);

  CalibrationSettingsDlg_Cancel_button = gtk_button_new_with_mnemonic (_("Cancel "));
  gtk_widget_show (CalibrationSettingsDlg_Cancel_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox28), CalibrationSettingsDlg_Cancel_button);
  GTK_WIDGET_SET_FLAGS (CalibrationSettingsDlg_Cancel_button, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) CalibrationSettingsDlg_dialog, "delete_event",
                    G_CALLBACK (on_CalibrationSettingsDlg_dialog_delete_event),
                    NULL);
  g_signal_connect ((gpointer) CalibrationSettingsDlg_dialog, "destroy",
                    G_CALLBACK (on_CalibrationSettingsDlg_dialog_destroy),
                    NULL);
  g_signal_connect ((gpointer) CalibrationSettingsDlg_UseCalibTimer_checkbutton, "toggled",
                    G_CALLBACK (on_CalibrationSettingsDlg_UseCalibTimer_checkbutton_toggled),
                    NULL);
  g_signal_connect ((gpointer) CalibrationSettingsDlg_Startup_entry, "changed",
                    G_CALLBACK (on_CalibrationSettingsDlg_Startup_entry_changed),
                    NULL);
  g_signal_connect ((gpointer) CalibrationSettingsDlg_OK_button, "clicked",
                    G_CALLBACK (on_CalibrationSettingsDlg_OK_button_clicked),
                    NULL);
  g_signal_connect ((gpointer) CalibrationSettingsDlg_Cancel_button, "clicked",
                    G_CALLBACK (on_CalibrationSettingsDlg_Cancel_button_clicked),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (CalibrationSettingsDlg_dialog, CalibrationSettingsDlg_dialog, "CalibrationSettingsDlg_dialog");
  GLADE_HOOKUP_OBJECT_NO_REF (CalibrationSettingsDlg_dialog, vbox58, "vbox58");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, vbox67, "vbox67");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, CalibrationSettingsDlg_UseCalibTimer_checkbutton, "CalibrationSettingsDlg_UseCalibTimer_checkbutton");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, hbox82, "hbox82");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, label289, "label289");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, CalibrationSettingsDlg_Hour_spinbutton, "CalibrationSettingsDlg_Hour_spinbutton");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, label291, "label291");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, CalibrationSettingsDlg_Minutes_spinbutton, "CalibrationSettingsDlg_Minutes_spinbutton");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, label290, "label290");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, CalibrationSettingsDlg_Startup_combo, "CalibrationSettingsDlg_Startup_combo");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, CalibrationSettingsDlg_Startup_entry, "CalibrationSettingsDlg_Startup_entry");
  GLADE_HOOKUP_OBJECT_NO_REF (CalibrationSettingsDlg_dialog, hbuttonbox27, "hbuttonbox27");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, hbuttonbox28, "hbuttonbox28");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, CalibrationSettingsDlg_OK_button, "CalibrationSettingsDlg_OK_button");
  GLADE_HOOKUP_OBJECT (CalibrationSettingsDlg_dialog, CalibrationSettingsDlg_Cancel_button, "CalibrationSettingsDlg_Cancel_button");

  return CalibrationSettingsDlg_dialog;
}

