/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.ArithmeticDecoder;
import org.jpedal.jbig2.decoders.DecodeIntResult;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.decoders.MMRDecoder;
import org.jpedal.jbig2.image.BitmapPointer;
import org.jpedal.jbig2.util.BinaryOperation;

public final class JBIG2Bitmap {
    private int width;
    private int height;
    private int line;
    private int bitmapNumber;
    private byte[] newData;
    private ArithmeticDecoder arithmeticDecoder;
    private HuffmanDecoder huffmanDecoder;
    private MMRDecoder mmrDecoder;

    public JBIG2Bitmap(int n, int n2, ArithmeticDecoder arithmeticDecoder, HuffmanDecoder huffmanDecoder, MMRDecoder mMRDecoder) {
        this.width = n;
        this.height = n2;
        this.arithmeticDecoder = arithmeticDecoder;
        this.huffmanDecoder = huffmanDecoder;
        this.mmrDecoder = mMRDecoder;
        this.line = n + 7 >> 3;
        this.newData = new byte[this.line * n2];
    }

    public void readBitmap(boolean bl, int n, boolean bl2, boolean bl3, JBIG2Bitmap jBIG2Bitmap, short[] sArray, short[] sArray2, int n2) throws IOException, JBIG2Exception {
        block64: {
            block62: {
                block63: {
                    if (!bl) break block62;
                    this.mmrDecoder.reset();
                    int[] nArray = new int[this.width + 2];
                    int[] nArray2 = new int[this.width + 2];
                    nArray2[0] = nArray2[1] = this.width;
                    for (int i = 0; i < this.height; ++i) {
                        int n3;
                        int n4;
                        int n5 = 0;
                        while (nArray2[n5] < this.width) {
                            nArray[n5] = nArray2[n5];
                            ++n5;
                        }
                        int n6 = this.width;
                        nArray[n5 + 1] = n6;
                        nArray[n5] = n6;
                        int n7 = 0;
                        int n8 = 0;
                        int n9 = 0;
                        block25: do {
                            n4 = this.mmrDecoder.get2DCode();
                            switch (n4) {
                                case 0: {
                                    if (nArray[n7] >= this.width) continue block25;
                                    n9 = nArray[n7 + 1];
                                    n7 += 2;
                                    break;
                                }
                                case 1: {
                                    int n10;
                                    if (n8 & true) {
                                        n4 = 0;
                                        do {
                                            n10 = this.mmrDecoder.getBlackCode();
                                            n4 += n10;
                                        } while (n10 >= 64);
                                        n3 = 0;
                                        do {
                                            n10 = this.mmrDecoder.getWhiteCode();
                                            n3 += n10;
                                        } while (n10 >= 64);
                                    } else {
                                        n4 = 0;
                                        do {
                                            n10 = this.mmrDecoder.getWhiteCode();
                                            n4 += n10;
                                        } while (n10 >= 64);
                                        n3 = 0;
                                        do {
                                            n10 = this.mmrDecoder.getBlackCode();
                                            n3 += n10;
                                        } while (n10 >= 64);
                                    }
                                    if (n4 <= 0 && n3 <= 0) continue block25;
                                    int n11 = n8++;
                                    int n12 = n9 + n4;
                                    nArray2[n11] = n12;
                                    n9 = n12;
                                    int n13 = n8++;
                                    int n14 = n9 + n3;
                                    nArray2[n13] = n14;
                                    n9 = n14;
                                    while (nArray[n7] <= n9 && nArray[n7] < this.width) {
                                        n7 += 2;
                                    }
                                    continue block25;
                                }
                                case 2: {
                                    int n15 = n8++;
                                    int n16 = nArray[n7];
                                    nArray2[n15] = n16;
                                    n9 = n16;
                                    if (nArray[n7] >= this.width) continue block25;
                                    ++n7;
                                    break;
                                }
                                case 3: {
                                    int n17 = n8++;
                                    int n18 = nArray[n7] + 1;
                                    nArray2[n17] = n18;
                                    n9 = n18;
                                    if (nArray[n7] >= this.width) continue block25;
                                    ++n7;
                                    while (nArray[n7] <= n9 && nArray[n7] < this.width) {
                                        n7 += 2;
                                    }
                                    continue block25;
                                }
                                case 5: {
                                    int n19 = n8++;
                                    int n20 = nArray[n7] + 2;
                                    nArray2[n19] = n20;
                                    n9 = n20;
                                    if (nArray[n7] >= this.width) continue block25;
                                    ++n7;
                                    while (nArray[n7] <= n9 && nArray[n7] < this.width) {
                                        n7 += 2;
                                    }
                                    continue block25;
                                }
                                case 7: {
                                    int n21 = n8++;
                                    int n22 = nArray[n7] + 3;
                                    nArray2[n21] = n22;
                                    n9 = n22;
                                    if (nArray[n7] >= this.width) continue block25;
                                    ++n7;
                                    while (nArray[n7] <= n9 && nArray[n7] < this.width) {
                                        n7 += 2;
                                    }
                                    continue block25;
                                }
                                case 4: {
                                    int n23 = n8++;
                                    int n24 = nArray[n7] - 1;
                                    nArray2[n23] = n24;
                                    n9 = n24;
                                    n7 = n7 > 0 ? --n7 : ++n7;
                                    while (nArray[n7] <= n9 && nArray[n7] < this.width) {
                                        n7 += 2;
                                    }
                                    continue block25;
                                }
                                case 6: {
                                    int n25 = n8++;
                                    int n26 = nArray[n7] - 2;
                                    nArray2[n25] = n26;
                                    n9 = n26;
                                    n7 = n7 > 0 ? --n7 : ++n7;
                                    while (nArray[n7] <= n9 && nArray[n7] < this.width) {
                                        n7 += 2;
                                    }
                                    continue block25;
                                }
                                case 8: {
                                    int n27 = n8++;
                                    int n28 = nArray[n7] - 3;
                                    nArray2[n27] = n28;
                                    n9 = n28;
                                    n7 = n7 > 0 ? --n7 : ++n7;
                                    while (nArray[n7] <= n9 && nArray[n7] < this.width) {
                                        n7 += 2;
                                    }
                                    continue block25;
                                }
                                default: {
                                    if (!JBIG2StreamDecoder.debug) continue block25;
                                    System.out.println("Illegal code in JBIG2 MMR bitmap data");
                                }
                            }
                        } while (n9 < this.width);
                        nArray2[n8++] = this.width;
                        n4 = 0;
                        while (nArray2[n4] < this.width) {
                            for (n3 = nArray2[n4]; n3 < nArray2[n4 + 1]; ++n3) {
                                this.setPixel(n3, i, 1);
                            }
                            n4 += 2;
                        }
                    }
                    if (n2 < 0) break block63;
                    this.mmrDecoder.skipTo(n2);
                    break block64;
                }
                if (this.mmrDecoder.get24Bits() == 4097L || !JBIG2StreamDecoder.debug) break block64;
                System.out.println("Missing EOFB in JBIG2 MMR bitmap data");
                break block64;
            }
            BitmapPointer bitmapPointer = new BitmapPointer(this);
            BitmapPointer bitmapPointer2 = new BitmapPointer(this);
            BitmapPointer bitmapPointer3 = new BitmapPointer(this);
            BitmapPointer bitmapPointer4 = new BitmapPointer(this);
            BitmapPointer bitmapPointer5 = new BitmapPointer(this);
            BitmapPointer bitmapPointer6 = new BitmapPointer(this);
            long l = 0L;
            if (bl2) {
                switch (n) {
                    case 0: {
                        l = 14675L;
                        break;
                    }
                    case 1: {
                        l = 1946L;
                        break;
                    }
                    case 2: {
                        l = 227L;
                        break;
                    }
                    case 3: {
                        l = 394L;
                    }
                }
            }
            boolean bl4 = false;
            block39: for (int i = 0; i < this.height; ++i) {
                int n29;
                if (bl2) {
                    n29 = this.arithmeticDecoder.decodeBit(l, this.arithmeticDecoder.genericRegionStats);
                    if (n29 != 0) {
                        boolean bl5 = bl4 = !bl4;
                    }
                    if (bl4) {
                        this.duplicateRow(i, i - 1);
                        continue;
                    }
                }
                switch (n) {
                    case 0: {
                        long l2;
                        int n30;
                        bitmapPointer.setPointer(0, i - 2);
                        long l3 = bitmapPointer.nextPixel();
                        l3 = BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer.nextPixel();
                        bitmapPointer2.setPointer(0, i - 1);
                        long l4 = bitmapPointer2.nextPixel();
                        l4 = BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel();
                        l4 = BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel();
                        long l5 = 0L;
                        bitmapPointer3.setPointer(sArray[0], i + sArray2[0]);
                        bitmapPointer4.setPointer(sArray[1], i + sArray2[1]);
                        bitmapPointer5.setPointer(sArray[2], i + sArray2[2]);
                        bitmapPointer6.setPointer(sArray[3], i + sArray2[3]);
                        for (n30 = 0; n30 < this.width; ++n30) {
                            l2 = BinaryOperation.bit32Shift(l3, 13, 0) | BinaryOperation.bit32Shift(l4, 8, 0) | BinaryOperation.bit32Shift(l5, 4, 0) | (long)(bitmapPointer3.nextPixel() << 3) | (long)(bitmapPointer4.nextPixel() << 2) | (long)(bitmapPointer5.nextPixel() << 1) | (long)bitmapPointer6.nextPixel();
                            if (bl3 && jBIG2Bitmap.getPixel(n30, i) != 0) {
                                n29 = 0;
                            } else {
                                n29 = this.arithmeticDecoder.decodeBit(l2, this.arithmeticDecoder.genericRegionStats);
                                if (n29 != 0) {
                                    this.setPixel(n30, i, 1);
                                }
                            }
                            l3 = (BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer.nextPixel()) & 7L;
                            l4 = (BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel()) & 0x1FL;
                            l5 = (BinaryOperation.bit32Shift(l5, 1, 0) | (long)n29) & 0xFL;
                        }
                        continue block39;
                    }
                    case 1: {
                        long l2;
                        int n30;
                        bitmapPointer.setPointer(0, i - 2);
                        long l3 = bitmapPointer.nextPixel();
                        l3 = BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer.nextPixel();
                        l3 = BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer.nextPixel();
                        bitmapPointer2.setPointer(0, i - 1);
                        long l4 = bitmapPointer2.nextPixel();
                        l4 = BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel();
                        l4 = BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel();
                        long l5 = 0L;
                        bitmapPointer3.setPointer(sArray[0], i + sArray2[0]);
                        for (n30 = 0; n30 < this.width; ++n30) {
                            l2 = BinaryOperation.bit32Shift(l3, 9, 0) | BinaryOperation.bit32Shift(l4, 4, 0) | BinaryOperation.bit32Shift(l5, 1, 0) | (long)bitmapPointer3.nextPixel();
                            if (bl3 && jBIG2Bitmap.getPixel(n30, i) != 0) {
                                n29 = 0;
                            } else {
                                n29 = this.arithmeticDecoder.decodeBit(l2, this.arithmeticDecoder.genericRegionStats);
                                if (n29 != 0) {
                                    this.setPixel(n30, i, 1);
                                }
                            }
                            l3 = (BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer.nextPixel()) & 0xFL;
                            l4 = (BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel()) & 0x1FL;
                            l5 = (BinaryOperation.bit32Shift(l5, 1, 0) | (long)n29) & 7L;
                        }
                        continue block39;
                    }
                    case 2: {
                        long l2;
                        int n30;
                        bitmapPointer.setPointer(0, i - 2);
                        long l3 = bitmapPointer.nextPixel();
                        l3 = BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer.nextPixel();
                        bitmapPointer2.setPointer(0, i - 1);
                        long l4 = bitmapPointer2.nextPixel();
                        l4 = BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel();
                        long l5 = 0L;
                        bitmapPointer3.setPointer(sArray[0], i + sArray2[0]);
                        for (n30 = 0; n30 < this.width; ++n30) {
                            l2 = BinaryOperation.bit32Shift(l3, 7, 0) | BinaryOperation.bit32Shift(l4, 3, 0) | BinaryOperation.bit32Shift(l5, 1, 0) | (long)bitmapPointer3.nextPixel();
                            if (bl3 && jBIG2Bitmap.getPixel(n30, i) != 0) {
                                n29 = 0;
                            } else {
                                n29 = this.arithmeticDecoder.decodeBit(l2, this.arithmeticDecoder.genericRegionStats);
                                if (n29 != 0) {
                                    this.setPixel(n30, i, 1);
                                }
                            }
                            l3 = (BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer.nextPixel()) & 7L;
                            l4 = (BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel()) & 0xFL;
                            l5 = (BinaryOperation.bit32Shift(l5, 1, 0) | (long)n29) & 3L;
                        }
                        continue block39;
                    }
                    case 3: {
                        long l2;
                        int n30;
                        bitmapPointer2.setPointer(0, i - 1);
                        long l4 = bitmapPointer2.nextPixel();
                        l4 = BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel();
                        long l5 = 0L;
                        bitmapPointer3.setPointer(sArray[0], i + sArray2[0]);
                        for (n30 = 0; n30 < this.width; ++n30) {
                            l2 = BinaryOperation.bit32Shift(l4, 5, 0) | BinaryOperation.bit32Shift(l5, 1, 0) | (long)bitmapPointer3.nextPixel();
                            if (bl3 && jBIG2Bitmap.getPixel(n30, i) != 0) {
                                n29 = 0;
                            } else {
                                n29 = this.arithmeticDecoder.decodeBit(l2, this.arithmeticDecoder.genericRegionStats);
                                if (n29 != 0) {
                                    this.setPixel(n30, i, 1);
                                }
                            }
                            l4 = (BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel()) & 0x1FL;
                            l5 = (BinaryOperation.bit32Shift(l5, 1, 0) | (long)n29) & 0xFL;
                        }
                        continue block39;
                    }
                }
            }
        }
    }

    public void readGenericRefinementRegion(int n, boolean bl, JBIG2Bitmap jBIG2Bitmap, int n2, int n3, short[] sArray, short[] sArray2) throws IOException, JBIG2Exception {
        BitmapPointer bitmapPointer;
        BitmapPointer bitmapPointer2;
        BitmapPointer bitmapPointer3;
        BitmapPointer bitmapPointer4;
        BitmapPointer bitmapPointer5;
        BitmapPointer bitmapPointer6;
        BitmapPointer bitmapPointer7;
        BitmapPointer bitmapPointer8;
        BitmapPointer bitmapPointer9;
        BitmapPointer bitmapPointer10;
        long l;
        if (n != 0) {
            l = 8L;
            bitmapPointer10 = new BitmapPointer(this);
            bitmapPointer9 = new BitmapPointer(this);
            bitmapPointer8 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer7 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer6 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer5 = new BitmapPointer(this);
            bitmapPointer4 = new BitmapPointer(this);
            bitmapPointer3 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer2 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer = new BitmapPointer(jBIG2Bitmap);
        } else {
            l = 16L;
            bitmapPointer10 = new BitmapPointer(this);
            bitmapPointer9 = new BitmapPointer(this);
            bitmapPointer8 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer7 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer6 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer5 = new BitmapPointer(this);
            bitmapPointer4 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer3 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer2 = new BitmapPointer(jBIG2Bitmap);
            bitmapPointer = new BitmapPointer(jBIG2Bitmap);
        }
        boolean bl2 = false;
        for (int i = 0; i < this.height; ++i) {
            long l2;
            int n4;
            int n5;
            long l3;
            long l4;
            long l5;
            long l6;
            long l7;
            long l8;
            if (n != 0) {
                bitmapPointer10.setPointer(0, i - 1);
                l8 = bitmapPointer10.nextPixel();
                bitmapPointer9.setPointer(-1, i);
                bitmapPointer8.setPointer(-n2, i - 1 - n3);
                bitmapPointer7.setPointer(-1 - n2, i - n3);
                l7 = bitmapPointer7.nextPixel();
                l7 = BinaryOperation.bit32Shift(l7, 1, 0) | (long)bitmapPointer7.nextPixel();
                bitmapPointer6.setPointer(-n2, i + 1 - n3);
                l6 = bitmapPointer6.nextPixel();
                l5 = 0L;
                l4 = 0L;
                l3 = 0L;
                if (bl) {
                    bitmapPointer3.setPointer(-1 - n2, i - 1 - n3);
                    l3 = bitmapPointer3.nextPixel();
                    l3 = BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer3.nextPixel();
                    l3 = BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer3.nextPixel();
                    bitmapPointer2.setPointer(-1 - n2, i - n3);
                    l4 = bitmapPointer2.nextPixel();
                    l4 = BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel();
                    l4 = BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel();
                    bitmapPointer.setPointer(-1 - n2, i + 1 - n3);
                    l5 = bitmapPointer.nextPixel();
                    l5 = BinaryOperation.bit32Shift(l5, 1, 0) | (long)bitmapPointer.nextPixel();
                    l5 = BinaryOperation.bit32Shift(l5, 1, 0) | (long)bitmapPointer.nextPixel();
                }
                for (n5 = 0; n5 < this.width; ++n5) {
                    l8 = (BinaryOperation.bit32Shift(l8, 1, 0) | (long)bitmapPointer10.nextPixel()) & 7L;
                    l7 = (BinaryOperation.bit32Shift(l7, 1, 0) | (long)bitmapPointer7.nextPixel()) & 7L;
                    l6 = (BinaryOperation.bit32Shift(l6, 1, 0) | (long)bitmapPointer6.nextPixel()) & 3L;
                    if (bl) {
                        l3 = (BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer3.nextPixel()) & 7L;
                        l4 = (BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel()) & 7L;
                        l5 = (BinaryOperation.bit32Shift(l5, 1, 0) | (long)bitmapPointer.nextPixel()) & 7L;
                        n4 = this.arithmeticDecoder.decodeBit(l, this.arithmeticDecoder.refinementRegionStats);
                        if (n4 != 0) {
                            boolean bl3 = bl2 = !bl2;
                        }
                        if (l3 == 0L && l4 == 0L && l5 == 0L) {
                            this.setPixel(n5, i, 0);
                            continue;
                        }
                        if (l3 == 7L && l4 == 7L && l5 == 7L) {
                            this.setPixel(n5, i, 1);
                            continue;
                        }
                    }
                    if ((n4 = this.arithmeticDecoder.decodeBit(l2 = BinaryOperation.bit32Shift(l8, 7, 0) | (long)(bitmapPointer9.nextPixel() << 6) | (long)(bitmapPointer8.nextPixel() << 5) | BinaryOperation.bit32Shift(l7, 2, 0) | l6, this.arithmeticDecoder.refinementRegionStats)) != 1) continue;
                    this.setPixel(n5, i, 1);
                }
                continue;
            }
            bitmapPointer10.setPointer(0, i - 1);
            l8 = bitmapPointer10.nextPixel();
            bitmapPointer9.setPointer(-1, i);
            bitmapPointer8.setPointer(-n2, i - 1 - n3);
            long l9 = bitmapPointer8.nextPixel();
            bitmapPointer7.setPointer(-1 - n2, i - n3);
            l7 = bitmapPointer7.nextPixel();
            l7 = BinaryOperation.bit32Shift(l7, 1, 0) | (long)bitmapPointer7.nextPixel();
            bitmapPointer6.setPointer(-1 - n2, i + 1 - n3);
            l6 = bitmapPointer6.nextPixel();
            l6 = BinaryOperation.bit32Shift(l6, 1, 0) | (long)bitmapPointer6.nextPixel();
            bitmapPointer5.setPointer(sArray[0], i + sArray2[0]);
            bitmapPointer4.setPointer(sArray[1] - n2, i + sArray2[1] - n3);
            l5 = 0L;
            l4 = 0L;
            l3 = 0L;
            if (bl) {
                bitmapPointer3.setPointer(-1 - n2, i - 1 - n3);
                l3 = bitmapPointer3.nextPixel();
                l3 = BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer3.nextPixel();
                l3 = BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer3.nextPixel();
                bitmapPointer2.setPointer(-1 - n2, i - n3);
                l4 = bitmapPointer2.nextPixel();
                l4 = BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel();
                l4 = BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel();
                bitmapPointer.setPointer(-1 - n2, i + 1 - n3);
                l5 = bitmapPointer.nextPixel();
                l5 = BinaryOperation.bit32Shift(l5, 1, 0) | (long)bitmapPointer.nextPixel();
                l5 = BinaryOperation.bit32Shift(l5, 1, 0) | (long)bitmapPointer.nextPixel();
            }
            for (n5 = 0; n5 < this.width; ++n5) {
                l8 = (BinaryOperation.bit32Shift(l8, 1, 0) | (long)bitmapPointer10.nextPixel()) & 3L;
                l9 = (BinaryOperation.bit32Shift(l9, 1, 0) | (long)bitmapPointer8.nextPixel()) & 3L;
                l7 = (BinaryOperation.bit32Shift(l7, 1, 0) | (long)bitmapPointer7.nextPixel()) & 7L;
                l6 = (BinaryOperation.bit32Shift(l6, 1, 0) | (long)bitmapPointer6.nextPixel()) & 7L;
                if (bl) {
                    l3 = (BinaryOperation.bit32Shift(l3, 1, 0) | (long)bitmapPointer3.nextPixel()) & 7L;
                    l4 = (BinaryOperation.bit32Shift(l4, 1, 0) | (long)bitmapPointer2.nextPixel()) & 7L;
                    l5 = (BinaryOperation.bit32Shift(l5, 1, 0) | (long)bitmapPointer.nextPixel()) & 7L;
                    n4 = this.arithmeticDecoder.decodeBit(l, this.arithmeticDecoder.refinementRegionStats);
                    if (n4 == 1) {
                        boolean bl4 = bl2 = !bl2;
                    }
                    if (l3 == 0L && l4 == 0L && l5 == 0L) {
                        this.setPixel(n5, i, 0);
                        continue;
                    }
                    if (l3 == 7L && l4 == 7L && l5 == 7L) {
                        this.setPixel(n5, i, 1);
                        continue;
                    }
                }
                if ((n4 = this.arithmeticDecoder.decodeBit(l2 = BinaryOperation.bit32Shift(l8, 11, 0) | (long)(bitmapPointer9.nextPixel() << 10) | BinaryOperation.bit32Shift(l9, 8, 0) | BinaryOperation.bit32Shift(l7, 5, 0) | BinaryOperation.bit32Shift(l6, 2, 0) | (long)(bitmapPointer5.nextPixel() << 1) | (long)bitmapPointer4.nextPixel(), this.arithmeticDecoder.refinementRegionStats)) != 1) continue;
                this.setPixel(n5, i, 1);
            }
        }
    }

    public void readTextRegion(boolean bl, boolean bl2, int n, int n2, int n3, int[][] nArray, int n4, JBIG2Bitmap[] jBIG2BitmapArray, int n5, int n6, boolean bl3, int n7, int n8, int[][] nArray2, int[][] nArray3, int[][] nArray4, int[][] nArray5, int[][] nArray6, int[][] nArray7, int[][] nArray8, int[][] nArray9, int n9, short[] sArray, short[] sArray2, JBIG2StreamDecoder jBIG2StreamDecoder) throws JBIG2Exception, IOException {
        int n10 = 1 << n2;
        this.clear(n5);
        int n11 = bl ? this.huffmanDecoder.decodeInt(nArray4).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadtStats).intResult();
        n11 *= -n10;
        int n12 = 0;
        block12: for (int i = 0; i < n; ++i) {
            int n13 = bl ? this.huffmanDecoder.decodeInt(nArray4).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadtStats).intResult();
            n11 += n13 * n10;
            int n14 = bl ? this.huffmanDecoder.decodeInt(nArray2).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iafsStats).intResult();
            int n15 = n12 += n14;
            while (true) {
                int n16;
                int n17;
                n13 = n10 == 1 ? 0 : (bl ? jBIG2StreamDecoder.readBits(n2) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaitStats).intResult());
                int n18 = n11 + n13;
                long l = bl ? (nArray != null ? (long)this.huffmanDecoder.decodeInt(nArray).intResult() : (long)jBIG2StreamDecoder.readBits(n4)) : this.arithmeticDecoder.decodeIAID(n4, this.arithmeticDecoder.iaidStats);
                if (l >= (long)n3) {
                    if (!JBIG2StreamDecoder.debug) continue block12;
                    System.out.println("Invalid symbol number in JBIG2 text region");
                    continue block12;
                }
                JBIG2Bitmap jBIG2Bitmap = null;
                int n19 = bl2 ? (bl ? jBIG2StreamDecoder.readBit() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iariStats).intResult()) : 0;
                if (n19 != 0) {
                    int n20;
                    int n21;
                    if (bl) {
                        n17 = this.huffmanDecoder.decodeInt(nArray5).intResult();
                        n16 = this.huffmanDecoder.decodeInt(nArray6).intResult();
                        n21 = this.huffmanDecoder.decodeInt(nArray7).intResult();
                        n20 = this.huffmanDecoder.decodeInt(nArray8).intResult();
                        jBIG2StreamDecoder.consumeRemainingBits();
                        this.arithmeticDecoder.start();
                    } else {
                        n17 = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardwStats).intResult();
                        n16 = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardhStats).intResult();
                        n21 = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardxStats).intResult();
                        n20 = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardyStats).intResult();
                    }
                    n21 = (n17 >= 0 ? n17 : n17 - 1) / 2 + n21;
                    n20 = (n16 >= 0 ? n16 : n16 - 1) / 2 + n20;
                    jBIG2Bitmap = new JBIG2Bitmap(n17 + jBIG2BitmapArray[(int)l].width, n16 + jBIG2BitmapArray[(int)l].height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
                    jBIG2Bitmap.readGenericRefinementRegion(n9, false, jBIG2BitmapArray[(int)l], n21, n20, sArray, sArray2);
                } else {
                    jBIG2Bitmap = jBIG2BitmapArray[(int)l];
                }
                n17 = jBIG2Bitmap.width - 1;
                n16 = jBIG2Bitmap.height - 1;
                if (bl3) {
                    switch (n7) {
                        case 0: {
                            this.combine(jBIG2Bitmap, n18, n15, n6);
                            break;
                        }
                        case 1: {
                            this.combine(jBIG2Bitmap, n18, n15, n6);
                            break;
                        }
                        case 2: {
                            this.combine(jBIG2Bitmap, n18 - n17, n15, n6);
                            break;
                        }
                        case 3: {
                            this.combine(jBIG2Bitmap, n18 - n17, n15, n6);
                        }
                    }
                    n15 += n16;
                    continue block12;
                }
                switch (n7) {
                    case 0: {
                        this.combine(jBIG2Bitmap, n15, n18 - n16, n6);
                        break;
                    }
                    case 1: {
                        this.combine(jBIG2Bitmap, n15, n18, n6);
                        break;
                    }
                    case 2: {
                        this.combine(jBIG2Bitmap, n15, n18 - n16, n6);
                        break;
                    }
                    case 3: {
                        this.combine(jBIG2Bitmap, n15, n18, n6);
                    }
                }
                n15 += n17;
                DecodeIntResult decodeIntResult = bl ? this.huffmanDecoder.decodeInt(nArray3) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadsStats);
                if (!decodeIntResult.booleanResult()) continue block12;
                n14 = decodeIntResult.intResult();
                n15 += n8 + n14;
            }
        }
    }

    public void clear(int n) {
        this.newData = new byte[this.newData.length];
        int n2 = n == 0 ? 0 : -128;
        for (int i = 0; i < this.newData.length; ++i) {
            this.newData[i] = n2;
        }
    }

    public void combine(JBIG2Bitmap jBIG2Bitmap, int n, int n2, long l) {
        int n3 = jBIG2Bitmap.width;
        int n4 = jBIG2Bitmap.height;
        int n5 = 0;
        int n6 = 0;
        for (int i = n2; i < n2 + n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                int n7 = jBIG2Bitmap.getPixel(n6, n5);
                switch ((int)l) {
                    case 0: {
                        this.setPixel(j, i, JBIG2Bitmap.getPixel(j, i, this.line, this.newData) | n7);
                        break;
                    }
                    case 1: {
                        this.setPixel(j, i, JBIG2Bitmap.getPixel(j, i, this.line, this.newData) & n7);
                        break;
                    }
                    case 2: {
                        this.setPixel(j, i, JBIG2Bitmap.getPixel(j, i, this.line, this.newData) ^ n7);
                        break;
                    }
                    case 3: {
                        if (JBIG2Bitmap.getPixel(j, i, this.line, this.newData) == 1 && n7 == 1 || JBIG2Bitmap.getPixel(j, i, this.line, this.newData) == 0 && n7 == 0) {
                            this.setPixel(j, i, 1);
                            break;
                        }
                        this.setPixel(j, i, 0);
                        break;
                    }
                    case 4: {
                        this.setPixel(j, i, n7);
                    }
                }
                ++n6;
            }
            n6 = 0;
            ++n5;
        }
    }

    private void duplicateRow(int n, int n2) {
        for (int i = 0; i < this.width; ++i) {
            this.setPixel(i, n, JBIG2Bitmap.getPixel(i, n2, this.line, this.newData));
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getData(boolean bl) {
        byte[] byArray = this.newData;
        if (bl) {
            int n = 0;
            while (n < byArray.length) {
                int n2 = n++;
                byArray[n2] = (byte)(byArray[n2] ^ 0xFF);
            }
        }
        return byArray;
    }

    public JBIG2Bitmap getSlice(int n, int n2, int n3, int n4) {
        JBIG2Bitmap jBIG2Bitmap = new JBIG2Bitmap(n3, n4, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
        int n5 = 0;
        int n6 = 0;
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n + n3; ++j) {
                jBIG2Bitmap.setPixel(n6, n5, JBIG2Bitmap.getPixel(j, i, this.line, this.newData));
                ++n6;
            }
            n6 = 0;
            ++n5;
        }
        return jBIG2Bitmap;
    }

    private void newSetPixel(int n, int n2, byte[] byArray, int n3) {
        int n4 = n2 * this.line + n / 8;
        int n5 = byArray[n4];
        n5 = n3 == 0 ? (n5 &= ~(1 << 7 - n % 8)) : (n5 |= 1 << 7 - n % 8);
        byArray[n4] = (byte)n5;
    }

    public void setPixel(int n, int n2, int n3) {
        this.newSetPixel(n, n2, this.newData, n3);
    }

    private static final int getPixel(int n, int n2, int n3, byte[] byArray) {
        return (byArray[n2 * n3 + n / 8] & 1 << 7 - n % 8) != 0 ? 1 : 0;
    }

    public int getPixel(int n, int n2) {
        return (this.newData[n2 * this.line + n / 8] & 1 << 7 - n % 8) != 0 ? 1 : 0;
    }

    public void expand(int n, int n2) {
        byte[] byArray = new byte[n * this.line];
        System.arraycopy(this.newData, 0, byArray, 0, this.height * this.line);
        this.height = n;
        this.newData = byArray;
    }

    public void setBitmapNumber(int n) {
        this.bitmapNumber = n;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public BufferedImage getBufferedImage() {
        byte[] byArray = this.getData(true);
        if (byArray == null) {
            return null;
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 12);
        DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferByte, this.width, this.height, 1, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    static final class FastBitSet {
        byte[][] bytes;
        int w;
        int h;

        public FastBitSet(int n, int n2) {
            this.bytes = new byte[n2][(n + 7) / 8];
            this.w = n;
            this.h = n2;
        }

        public byte getByte(int n, int n2) {
            int n3 = n2 / 8;
            int n4 = n2 % 8;
            if (n4 == 0) {
                return this.bytes[n][n3];
            }
            byte by = (byte)(255 >> 8 - n4);
            byte by2 = (byte)(255 << n4);
            byte by3 = (byte)((this.bytes[n][n3] & by) << 8 - n4);
            if (n3 + 1 >= this.bytes[n].length) {
                System.out.println("returning");
                return by3;
            }
            byte by4 = (byte)((this.bytes[n][n3 + 1] & by2) >> n4);
            return (byte)(by3 | by4);
        }

        public void setByte(int n, int n2, byte by) {
            int n3 = n2 / 8;
            int n4 = n2 % 8;
            if (n4 == 0) {
                this.bytes[n][n3] = by;
            } else {
                byte by2 = (byte)(by >> n4);
                byte by3 = (byte)(255 << 8 - n4);
                byte[] byArray = this.bytes[n];
                int n5 = n3;
                byArray[n5] = (byte)(byArray[n5] & by3);
                byte[] byArray2 = this.bytes[n];
                int n6 = n3;
                byArray2[n6] = (byte)(byArray2[n6] | by2);
                if (n3 + 1 >= this.bytes[n].length) {
                    return;
                }
                byte by4 = (byte)(by << 8 - n4);
                byte by5 = (byte)(255 >> n4);
                byte[] byArray3 = this.bytes[n];
                int n7 = n3 + 1;
                byArray3[n7] = (byte)(byArray3[n7] & by5);
                byte[] byArray4 = this.bytes[n];
                int n8 = n3 + 1;
                byArray4[n8] = (byte)(byArray4[n8] | by4);
            }
        }

        public void set(int n, int n2) {
            byte by = (byte)(1 << n2 % 8);
            byte[] byArray = this.bytes[n];
            int n3 = n2 / 8;
            byArray[n3] = (byte)(byArray[n3] | by);
        }

        public void clear(int n, int n2) {
            byte by = (byte)(1 << n2 % 8);
            byte[] byArray = this.bytes[n];
            int n3 = n2 / 8;
            byArray[n3] = (byte)(byArray[n3] & ~by);
        }

        public boolean get(int n, int n2) {
            byte by = (byte)(1 << n2 % 8);
            return (this.bytes[n][n2 / 8] & by) != 0;
        }

        public void reset(boolean bl) {
            for (int i = 0; i < this.bytes.length; ++i) {
                Arrays.fill(this.bytes[i], bl ? (byte)-1 : 0);
            }
        }
    }
}

