/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.io.JBIG2;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.filter.ASCII85;
import org.jpedal.io.filter.ASCIIHex;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.CCITT;
import org.jpedal.io.filter.Flate;
import org.jpedal.io.filter.LZW;
import org.jpedal.io.filter.RunLength;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class PdfFilteredReader {
    private static final int A85 = 1116165;
    private static final int AHx = 0x111848;
    private static final int ASCII85Decode = 1582784916;
    private static final int ASCIIHexDecode = 2074112677;
    public static final int CCITTFaxDecode = 2108391315;
    private static final int CCF = 0x131316;
    private static final int Crypt = 1112096855;
    public static final int DCTDecode = 1180911742;
    public static final int Fl = 5692;
    public static final int FlateDecode = 2005566619;
    public static final int JBIG2Decode = 1247500931;
    public static final int JPXDecode = 1399277700;
    private static final int LZW = 1845799;
    private static final int LZWDecode = 1566984326;
    private static final int RL = 8732;
    private static final int RunLengthDecode = -1815163937;
    private final Map cachedObjects = new HashMap();
    private BufferedOutputStream streamCache = null;
    private BufferedInputStream bis = null;
    private boolean hasError = false;

    public byte[] decodeFilters(PdfObject[] pdfObjectArray, byte[] byArray, PdfArrayIterator pdfArrayIterator, int n, int n2, String string) throws Exception {
        PdfObject pdfObject;
        this.streamCache = null;
        this.bis = null;
        int n3 = pdfObjectArray.length;
        PdfObject pdfObject2 = pdfObjectArray[0];
        byte[] byArray2 = null;
        if (pdfObject2 != null && (pdfObject = pdfObject2.getDictionary(1314558361)) != null) {
            byArray2 = pdfObject.getDecodedStream();
        }
        boolean bl = string != null;
        int n4 = pdfArrayIterator.getTokenCount();
        int n5 = 0;
        if (n4 > 0) {
            boolean bl2 = true;
            while (pdfArrayIterator.hasMoreTokens()) {
                block35: {
                    BaseFilter baseFilter;
                    int n6 = pdfArrayIterator.getNextValueAsConstant(true);
                    bl2 = false;
                    if (n3 > 1) {
                        PdfObject pdfObject3;
                        pdfObject2 = pdfObjectArray[n5];
                        byArray2 = null;
                        if (pdfObject2 != null && (pdfObject3 = pdfObject2.getDictionary(1314558361)) != null) {
                            byArray2 = pdfObject3.getDecodedStream();
                        }
                    }
                    if (bl && string != null && (n6 == 1112096855 || n6 == 1180911742 || n6 == 1399277700)) {
                        ++n5;
                        continue;
                    }
                    if (bl && string != null) {
                        this.setupCachedObjectForDecoding(string);
                    }
                    if (n6 == 2005566619 || n6 == 5692) {
                        baseFilter = new Flate(pdfObject2);
                    } else if (n6 == 1582784916 || n6 == 1116165) {
                        baseFilter = new ASCII85(pdfObject2);
                    } else if (n6 == 2108391315 || n6 == 0x131316) {
                        baseFilter = new CCITT(pdfObject2, n, n2);
                    } else if (n6 == 1566984326 || n6 == 1845799) {
                        baseFilter = new LZW(pdfObject2, n, n2);
                        bl2 = true;
                    } else if (n6 == -1815163937 || n6 == 8732) {
                        baseFilter = new RunLength(pdfObject2);
                    } else if (n6 == 1247500931) {
                        if (byArray == null) {
                            byArray = new byte[this.bis.available()];
                            this.bis.read(byArray);
                            int n7 = -1;
                            for (int i = byArray.length - 1; i > 9; --i) {
                                if (byArray[i] != 101 || byArray[i + 1] != 110 || byArray[i + 2] != 100 || byArray[i + 3] != 115 || byArray[i + 4] != 116 || byArray[i + 5] != 114 || byArray[i + 6] != 101 || byArray[i + 7] != 97 || byArray[i + 8] != 109) continue;
                                n7 = i - 1;
                                i = -1;
                            }
                            if (n7 != -1) {
                                if (byArray[n7] == 10 && byArray[n7 - 1] == 13) {
                                    --n7;
                                }
                                byte[] byArray3 = byArray;
                                byArray = new byte[n7];
                                System.arraycopy(byArray3, 0, byArray, 0, n7);
                            }
                            byArray = JBIG2.JBIGDecode(byArray, byArray2);
                            this.streamCache.write(byArray);
                            byArray = null;
                        } else {
                            byArray = JBIG2.JBIGDecode(byArray, byArray2);
                        }
                        baseFilter = null;
                    } else {
                        baseFilter = n6 == 2074112677 || n6 == 0x111848 ? new ASCIIHex(pdfObject2) : (n6 == 1112096855 ? null : null);
                    }
                    if (baseFilter != null) {
                        try {
                            if (byArray != null) {
                                byArray = baseFilter.decode(byArray);
                            } else if (this.bis != null) {
                                baseFilter.decode(this.bis, this.streamCache, string, this.cachedObjects);
                            }
                            if (!this.hasError && baseFilter.hasError()) {
                                this.hasError = true;
                            }
                        }
                        catch (Exception exception) {
                            if (LogWriter.isOutput()) {
                                LogWriter.writeLog("Exception " + exception + " in " + PdfFilteredReader.getFilterName(n6) + " decompression");
                            }
                            if (!bl2) break block35;
                            byArray = null;
                        }
                    }
                }
                if (bl) {
                    if (this.bis != null) {
                        this.bis.close();
                    }
                    if (this.streamCache != null) {
                        this.streamCache.flush();
                        this.streamCache.close();
                    }
                }
                ++n5;
            }
        }
        return byArray;
    }

    private static String getFilterName(int n) {
        switch (n) {
            case 1116165: {
                return "A85";
            }
            case 0x111848: {
                return "AHx";
            }
            case 1582784916: {
                return "ASCII85Decode";
            }
            case 2074112677: {
                return "ASCIIHexDecode";
            }
            case 2108391315: {
                return "CCITTFaxDecode";
            }
            case 0x131316: {
                return "CCF";
            }
            case 1112096855: {
                return "Crypt";
            }
            case 1180911742: {
                return "DCTDecode";
            }
            case 5692: {
                return "Fl";
            }
            case 2005566619: {
                return "FlateDecode";
            }
            case 1247500931: {
                return "JBIG2Decode";
            }
            case 1399277700: {
                return "";
            }
            case 1845799: {
                return "";
            }
            case 1566984326: {
                return "";
            }
            case 8732: {
                return "";
            }
            case -1815163937: {
                return "";
            }
        }
        return "Unknown";
    }

    private void setupCachedObjectForDecoding(String string) throws IOException {
        File file = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
        this.cachedObjects.put(file.getAbsolutePath(), "x");
        ObjectStore.copy(string, file.getAbsolutePath());
        File file2 = new File(string);
        file2.delete();
        this.streamCache = new BufferedOutputStream(new FileOutputStream(string));
        this.bis = new BufferedInputStream(new FileInputStream(file));
    }

    public boolean hasError() {
        return this.hasError;
    }
}

