/*------------------------------------------------------------------------------
 *
 * Copyright (c) 2011-2021, EURid vzw. All rights reserved.
 * The YADIFA TM software product is provided under the BSD 3-clause license:
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *        * Redistributions of source code must retain the above copyright
 *          notice, this list of conditions and the following disclaimer.
 *        * Redistributions in binary form must reproduce the above copyright
 *          notice, this list of conditions and the following disclaimer in the
 *          documentation and/or other materials provided with the distribution.
 *        * Neither the name of EURid nor the names of its contributors may be
 *          used to endorse or promote products derived from this software
 *          without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *------------------------------------------------------------------------------
 *
 */

#define COMMON_C 1

#include "common.h"



/**
 *  @fn const char * file_name_from_path ()
 *  @brief base_of_path
 *
 *  @param const char *
 *
 *  @return char *
 */
const char *
filename_from_path(const char *s)       // base_of_path sounds like beginning of path, or maybe the directory (base) of the file.  This returns the filename_from_path ...
{                                       // it's a nice tool to have, it should be moved into the core (maybe in fdtools, or parsing/parser)
    const char *ptr;

    if(s[0] == '/' && s[1] == 0)        // if the string is "/", return it
    {
        return (s);
    }

    ptr = strrchr (s, '/');             // get the last '/'

    return (ptr ? ++ptr : s);           // if a '/' was found, return the word starting after, else return the original word
}

static  char **module_argv = NULL;
static int module_argc = 0;

void module_arg_set(char **argv, int argc)
{
    module_argv = argv;
    module_argc = argc;
}

int module_arg_count()
{
    return module_argc;
}

const char *module_arg_get(int index)
{
    if((index >= 0) && (index < module_argc))
    {
        return module_argv[index];
    }

    return NULL;
}
