/*
    Copyright (C) 2016  Jeremy White <jwhite@codeweavers.com>
    All rights reserved.

    This file is part of x11spice

    x11spice is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    x11spice is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with x11spice.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef TESTS_H_
#define TESTS_H_

#include <glib.h>
#include <string.h>

#include "xdummy.h"

/*----------------------------------------------------------------------------
**  Structure definitions
**--------------------------------------------------------------------------*/
typedef struct {
    xdummy_t *xserver;
    const gchar *logfile;
    const gchar *name;
    int never_trust_damage;
} test_t;


/*----------------------------------------------------------------------------
**  Prototypes
**--------------------------------------------------------------------------*/
void test_basic(xdummy_t *server, gconstpointer user_data);
void test_resize(xdummy_t *server, gconstpointer user_data);
void test_tallscreen(xdummy_t *server, gconstpointer user_data);
void test_script(xdummy_t *xdummy, gconstpointer user_data);

#endif
