/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class TimeUntilCompleteItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public TimeUntilCompleteItem(String table_id) {
        super("timetocomplete", 2, -1, 65, table_id);
        this.setRefreshInterval(-2);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "content"});
    }

    public void refresh(TableCell cell) {
        long value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        long l = value = peer == null ? Long.MAX_VALUE : peer.getStats().getEstimatedSecondsToCompletion();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        if (value > 604800L) {
            value = Long.MAX_VALUE;
        }
        cell.setText(DisplayFormatters.formatETA(value));
    }
}

