/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytracker;

import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class NameItem
extends CoreTableColumn
implements TableCellRefreshListener,
ObfusticateCellText {
    private static boolean bShowIcon;

    public NameItem() {
        super("name", -2, 250, "MyTracker");
        this.setType(1);
    }

    public void refresh(TableCell cell) {
        String name;
        TRHostTorrent item = (TRHostTorrent)cell.getDataSource();
        String string = name = item == null ? "" : TorrentUtils.getLocalisedName(item.getTorrent());
        if ((cell.setText(name) || !cell.isValid()) && item != null && item.getTorrent() != null && bShowIcon && cell instanceof TableCellSWT) {
            try {
                TOTorrent torrent = item.getTorrent();
                String path = torrent.getFiles()[0].getRelativePath();
                if (path != null) {
                    Image icon = ImageRepository.getPathIcon(path, false, torrent != null && !torrent.isSimpleTorrent());
                    ((TableCellSWT)cell).setIcon(icon);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public String getObfusticatedText(TableCell cell) {
        TRHostTorrent item = (TRHostTorrent)cell.getDataSource();
        String name = null;
        try {
            name = ByteFormatter.nicePrint(item.getTorrent().getHash(), true);
        }
        catch (TOTorrentException e) {
            // empty catch block
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    static {
        COConfigurationManager.addAndFireParameterListener("NameColumn.showProgramIcon", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                bShowIcon = COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon");
            }
        });
    }
}

