/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class SizeItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "size";
    private static boolean DO_MULTILINE = true;

    public SizeItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 70, sTableID);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.setRefreshInterval(-1);
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "content", "bytes"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell) {
        sizeitemsort value;
        Object ds = cell.getDataSource();
        if (ds instanceof DownloadManager) {
            DownloadManager dm = (DownloadManager)ds;
            value = new sizeitemsort(dm.getSize(), dm.getStats().getRemaining());
        } else if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            value = new sizeitemsort(fileInfo2.getLength(), fileInfo2.getLength() - fileInfo2.getDownloaded());
        } else {
            return;
        }
        if (value.compareTo(cell.getSortValue()) == 0 && cell.isValid()) {
            return;
        }
        cell.setSortValue(value);
        String s = DisplayFormatters.formatByteCountToKiBEtc(value.size);
        if (DO_MULTILINE && cell.getMaxLines() > 1 && value.remaining > 0L) {
            s = s + "\n" + DisplayFormatters.formatByteCountToKiBEtc(value.remaining, false, false, 0) + " to go";
        }
        cell.setText(s);
        if (Utils.getUserMode() > 0 && cell instanceof TableCellSWT) {
            if (value.size >= 0x40000000L) {
                ((TableCellSWT)cell).setTextAlpha(456);
            } else if (value.size < 0x100000L) {
                ((TableCellSWT)cell).setTextAlpha(180);
            } else {
                ((TableCellSWT)cell).setTextAlpha(255);
            }
        }
    }

    private class sizeitemsort
    implements Comparable {
        private final long size;
        private final long remaining;

        public sizeitemsort(long size, long remaining) {
            this.size = size;
            this.remaining = remaining;
        }

        public int compareTo(Object arg0) {
            if (!(arg0 instanceof sizeitemsort)) {
                return 1;
            }
            sizeitemsort otherObj = (sizeitemsort)arg0;
            if (this.size == otherObj.size) {
                return this.remaining == otherObj.remaining ? 0 : (this.remaining > otherObj.remaining ? 1 : -1);
            }
            return this.size > otherObj.size ? 1 : -1;
        }
    }
}

