/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;

public class TableTooltips
implements Listener {
    Shell toolTipShell = null;
    Shell mainShell = null;
    Label toolTipLabel = null;
    private final Composite composite;
    private final TableViewSWT tv;

    public TableTooltips(TableViewSWT tv, Composite composite) {
        this.tv = tv;
        this.composite = composite;
        this.mainShell = composite.getShell();
        composite.addListener(12, this);
        composite.addListener(1, this);
        composite.addListener(5, this);
        composite.addListener(32, this);
        this.mainShell.addListener(27, this);
        tv.getComposite().addListener(27, this);
    }

    public void handleEvent(Event event2) {
        switch (event2.type) {
            case 32: {
                Rectangle displayRect;
                TableCellCore cell;
                if (this.toolTipShell != null && !this.toolTipShell.isDisposed()) {
                    this.toolTipShell.dispose();
                }
                if ((cell = this.tv.getTableCell(event2.x, event2.y)) == null) {
                    return;
                }
                cell.invokeToolTipListeners(0);
                Object oToolTip = cell.getToolTip();
                if (oToolTip == null) {
                    oToolTip = cell.getDefaultToolTip();
                }
                if (oToolTip == null) {
                    return;
                }
                Display d = this.composite.getDisplay();
                if (d == null) {
                    return;
                }
                this.toolTipShell = new Shell(this.composite.getShell(), 16384);
                FillLayout f = new FillLayout();
                try {
                    f.marginWidth = 3;
                    f.marginHeight = 1;
                }
                catch (NoSuchFieldError e) {
                    // empty catch block
                }
                this.toolTipShell.setLayout(f);
                this.toolTipShell.setBackground(d.getSystemColor(29));
                Point size = new Point(0, 0);
                if (oToolTip instanceof String) {
                    String sToolTip = (String)oToolTip;
                    this.toolTipLabel = new Label(this.toolTipShell, 64);
                    this.toolTipLabel.setForeground(d.getSystemColor(28));
                    this.toolTipLabel.setBackground(d.getSystemColor(29));
                    this.toolTipShell.setData("TableCellSWT", cell);
                    this.toolTipLabel.setText(sToolTip.replaceAll("&", "&&"));
                    size = this.toolTipLabel.computeSize(-1, -1);
                    if (size.x > 600) {
                        size = this.toolTipLabel.computeSize(600, -1, true);
                    }
                } else if (oToolTip instanceof Image) {
                    Image image = (Image)oToolTip;
                    this.toolTipLabel = new Label(this.toolTipShell, 0x1000000);
                    this.toolTipLabel.setForeground(d.getSystemColor(28));
                    this.toolTipLabel.setBackground(d.getSystemColor(29));
                    this.toolTipShell.setData("TableCellSWT", cell);
                    this.toolTipLabel.setImage(image);
                    size = this.toolTipLabel.computeSize(-1, -1);
                }
                size.x += this.toolTipShell.getBorderWidth() * 2 + 2;
                size.y += this.toolTipShell.getBorderWidth() * 2;
                try {
                    size.x += this.toolTipShell.getBorderWidth() * 2 + f.marginWidth * 2;
                    size.y += this.toolTipShell.getBorderWidth() * 2 + f.marginHeight * 2;
                }
                catch (NoSuchFieldError e) {
                    // empty catch block
                }
                Point pt = this.composite.toDisplay(event2.x, event2.y);
                try {
                    displayRect = this.composite.getMonitor().getClientArea();
                }
                catch (NoSuchMethodError e) {
                    displayRect = this.composite.getDisplay().getClientArea();
                }
                if (pt.x + size.x > displayRect.x + displayRect.width) {
                    pt.x = displayRect.x + displayRect.width - size.x;
                }
                pt.y = pt.y + size.y > displayRect.y + displayRect.height ? (pt.y -= size.y + 2) : (pt.y += 21);
                if (pt.y < displayRect.y) {
                    pt.y = displayRect.y;
                }
                this.toolTipShell.setBounds(pt.x, pt.y, size.x, size.y);
                this.toolTipShell.setVisible(true);
                break;
            }
            case 12: {
                if (this.mainShell != null && !this.mainShell.isDisposed()) {
                    this.mainShell.removeListener(27, this);
                }
                if (this.tv.getComposite() != null && !this.tv.getComposite().isDisposed()) {
                    this.mainShell.removeListener(27, this);
                }
            }
            default: {
                if (this.toolTipShell == null) break;
                this.toolTipShell.dispose();
                this.toolTipShell = null;
                this.toolTipLabel = null;
            }
        }
    }
}

