/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.control.DHTControlActivity;
import com.aelitis.azureus.core.dht.control.DHTControlListener;
import com.aelitis.azureus.core.dht.control.DHTControlStats;
import com.aelitis.azureus.core.dht.db.DHTDBStats;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.router.DHTRouterStats;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class DHTView
extends AbstractIView {
    public static final int DHT_TYPE_MAIN = 0;
    public static final int DHT_TYPE_CVS = 1;
    public static final int DHT_TYPE_MAIN_V6 = 3;
    DHT dht;
    Composite panel;
    String yes_str;
    String no_str;
    Label lblUpTime;
    Label lblNumberOfUsers;
    Label lblNodes;
    Label lblLeaves;
    Label lblContacts;
    Label lblReplacements;
    Label lblLive;
    Label lblUnknown;
    Label lblDying;
    Label lblSkew;
    Label lblRendezvous;
    Label lblReachable;
    Label lblKeys;
    Label lblValues;
    Label lblSize;
    Label lblLocal;
    Label lblDirect;
    Label lblIndirect;
    Label lblDivFreq;
    Label lblDivSize;
    Label lblReceivedPackets;
    Label lblReceivedBytes;
    Label lblSentPackets;
    Label lblSentBytes;
    Label[] lblPings = new Label[4];
    Label[] lblFindNodes = new Label[4];
    Label[] lblFindValues = new Label[4];
    Label[] lblStores = new Label[4];
    Label[] lblData = new Label[4];
    Canvas in;
    Canvas out;
    SpeedGraphic inGraph;
    SpeedGraphic outGraph;
    boolean activityChanged;
    DHTControlListener controlListener;
    Table activityTable;
    DHTControlActivity[] activities;
    private final int dht_type;
    protected AzureusCore core;
    private int refreshIter = 0;

    public DHTView(int dht_type) {
        this.dht_type = dht_type;
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                DHTView.this.core = core;
                DHTView.this.init(core);
            }
        });
    }

    private void init(AzureusCore core) {
        try {
            PluginInterface dht_pi = core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                return;
            }
            DHT[] dhts = ((DHTPlugin)dht_pi.getPlugin()).getDHTs();
            for (int i = 0; i < dhts.length; ++i) {
                if (dhts[i].getTransport().getNetwork() != this.dht_type) continue;
                this.dht = dhts[i];
                break;
            }
            if (this.dht == null) {
                return;
            }
            this.controlListener = new DHTControlListener(){

                public void activityChanged(DHTControlActivity activity, int type) {
                    DHTView.this.activityChanged = true;
                }
            };
            this.dht.getControl().addListener(this.controlListener);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.panel.setLayout(layout);
        this.yes_str = MessageText.getString("Button.yes").replaceAll("&", "");
        this.no_str = MessageText.getString("Button.no").replaceAll("&", "");
        this.initialiseGeneralGroup();
        this.initialiseDBGroup();
        this.initialiseTransportDetailsGroup();
        this.initialiseOperationDetailsGroup();
        this.initialiseActivityGroup();
    }

    private void initialiseGeneralGroup() {
        Group gGeneral = new Group(this.panel, 0);
        Messages.setLanguageText(gGeneral, "DHTView.general.title");
        GridData data = new GridData();
        data.verticalAlignment = 1;
        data.widthHint = 350;
        gGeneral.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        gGeneral.setLayout(layout);
        Label label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.uptime");
        this.lblUpTime = new Label(gGeneral, 0);
        this.lblUpTime.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.users");
        this.lblNumberOfUsers = new Label(gGeneral, 0);
        this.lblNumberOfUsers.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.reachable");
        this.lblReachable = new Label(gGeneral, 0);
        this.lblReachable.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.nodes");
        this.lblNodes = new Label(gGeneral, 0);
        this.lblNodes.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.leaves");
        this.lblLeaves = new Label(gGeneral, 0);
        this.lblLeaves.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.rendezvous");
        this.lblRendezvous = new Label(gGeneral, 0);
        this.lblRendezvous.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.contacts");
        this.lblContacts = new Label(gGeneral, 0);
        this.lblContacts.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.replacements");
        this.lblReplacements = new Label(gGeneral, 0);
        this.lblReplacements.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.live");
        this.lblLive = new Label(gGeneral, 0);
        this.lblLive.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.skew");
        this.lblSkew = new Label(gGeneral, 0);
        this.lblSkew.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.unknown");
        this.lblUnknown = new Label(gGeneral, 0);
        this.lblUnknown.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gGeneral, 0);
        Messages.setLanguageText(label, "DHTView.general.dying");
        this.lblDying = new Label(gGeneral, 0);
        this.lblDying.setLayoutData(new GridData(4, 128, true, false));
    }

    private void initialiseDBGroup() {
        Group gDB = new Group(this.panel, 0);
        Messages.setLanguageText(gDB, "DHTView.db.title");
        GridData data = new GridData(768);
        data.verticalAlignment = 4;
        gDB.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = true;
        gDB.setLayout(layout);
        Label label = new Label(gDB, 0);
        Messages.setLanguageText(label, "DHTView.db.keys");
        this.lblKeys = new Label(gDB, 0);
        this.lblKeys.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gDB, 0);
        Messages.setLanguageText(label, "DHTView.db.values");
        this.lblValues = new Label(gDB, 0);
        this.lblValues.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gDB, 0);
        Messages.setLanguageText(label, "TableColumn.header.size");
        this.lblSize = new Label(gDB, 0);
        this.lblSize.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gDB, 0);
        Messages.setLanguageText(label, "DHTView.db.local");
        this.lblLocal = new Label(gDB, 0);
        this.lblLocal.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gDB, 0);
        Messages.setLanguageText(label, "DHTView.db.direct");
        this.lblDirect = new Label(gDB, 0);
        this.lblDirect.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gDB, 0);
        Messages.setLanguageText(label, "DHTView.db.indirect");
        this.lblIndirect = new Label(gDB, 0);
        this.lblIndirect.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gDB, 0);
        Messages.setLanguageText(label, "DHTView.db.divfreq");
        this.lblDivFreq = new Label(gDB, 0);
        this.lblDivFreq.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gDB, 0);
        Messages.setLanguageText(label, "DHTView.db.divsize");
        this.lblDivSize = new Label(gDB, 0);
        this.lblDivSize.setLayoutData(new GridData(4, 128, true, false));
    }

    private void initialiseTransportDetailsGroup() {
        Group gTransport = new Group(this.panel, 0);
        Messages.setLanguageText(gTransport, "DHTView.transport.title");
        GridData data = new GridData(1040);
        data.widthHint = 350;
        data.verticalSpan = 2;
        gTransport.setLayoutData(data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        gTransport.setLayout(layout);
        Label label = new Label(gTransport, 0);
        label = new Label(gTransport, 0);
        Messages.setLanguageText(label, "DHTView.transport.packets");
        label.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gTransport, 0);
        Messages.setLanguageText(label, "DHTView.transport.bytes");
        label.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gTransport, 0);
        Messages.setLanguageText(label, "DHTView.transport.received");
        this.lblReceivedPackets = new Label(gTransport, 0);
        this.lblReceivedPackets.setLayoutData(new GridData(4, 128, true, false));
        this.lblReceivedBytes = new Label(gTransport, 0);
        this.lblReceivedBytes.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gTransport, 0);
        Messages.setLanguageText(label, "DHTView.transport.sent");
        this.lblSentPackets = new Label(gTransport, 0);
        this.lblSentPackets.setLayoutData(new GridData(4, 128, true, false));
        this.lblSentBytes = new Label(gTransport, 0);
        this.lblSentBytes.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gTransport, 0);
        Messages.setLanguageText(label, "DHTView.transport.in");
        data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData(data);
        this.in = new Canvas(gTransport, 262144);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.in.setLayoutData(data);
        this.inGraph = SpeedGraphic.getInstance();
        this.inGraph.initialize(this.in);
        label = new Label(gTransport, 0);
        Messages.setLanguageText(label, "DHTView.transport.out");
        data = new GridData();
        data.horizontalSpan = 3;
        label.setLayoutData(data);
        this.out = new Canvas(gTransport, 262144);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        this.out.setLayoutData(data);
        this.outGraph = SpeedGraphic.getInstance();
        this.outGraph.initialize(this.out);
    }

    private void initialiseOperationDetailsGroup() {
        int i;
        Group gOperations = new Group(this.panel, 0);
        Messages.setLanguageText(gOperations, "DHTView.operations.title");
        gOperations.setLayoutData(new GridData(4, 1, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        layout.makeColumnsEqualWidth = true;
        gOperations.setLayout(layout);
        Label label = new Label(gOperations, 0);
        label = new Label(gOperations, 0);
        Messages.setLanguageText(label, "DHTView.operations.sent");
        label.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gOperations, 0);
        Messages.setLanguageText(label, "DHTView.operations.ok");
        label.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gOperations, 0);
        Messages.setLanguageText(label, "DHTView.operations.failed");
        label.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gOperations, 0);
        Messages.setLanguageText(label, "DHTView.operations.received");
        label.setLayoutData(new GridData(4, 128, true, false));
        label = new Label(gOperations, 0);
        Messages.setLanguageText(label, "DHTView.operations.ping");
        for (i = 0; i < 4; ++i) {
            this.lblPings[i] = new Label(gOperations, 0);
            this.lblPings[i].setLayoutData(new GridData(4, 128, true, false));
        }
        label = new Label(gOperations, 0);
        Messages.setLanguageText(label, "DHTView.operations.findNode");
        for (i = 0; i < 4; ++i) {
            this.lblFindNodes[i] = new Label(gOperations, 0);
            this.lblFindNodes[i].setLayoutData(new GridData(4, 128, true, false));
        }
        label = new Label(gOperations, 0);
        Messages.setLanguageText(label, "DHTView.operations.findValue");
        for (i = 0; i < 4; ++i) {
            this.lblFindValues[i] = new Label(gOperations, 0);
            this.lblFindValues[i].setLayoutData(new GridData(4, 128, true, false));
        }
        label = new Label(gOperations, 0);
        Messages.setLanguageText(label, "DHTView.operations.store");
        for (i = 0; i < 4; ++i) {
            this.lblStores[i] = new Label(gOperations, 0);
            this.lblStores[i].setLayoutData(new GridData(4, 128, true, false));
        }
        label = new Label(gOperations, 0);
        Messages.setLanguageText(label, "DHTView.operations.data");
        for (i = 0; i < 4; ++i) {
            this.lblData[i] = new Label(gOperations, 0);
            this.lblData[i].setLayoutData(new GridData(4, 128, true, false));
        }
    }

    private void initialiseActivityGroup() {
        Group gActivity = new Group(this.panel, 0);
        Messages.setLanguageText(gActivity, "DHTView.activity.title");
        gActivity.setLayoutData(new GridData(4, 4, true, true));
        gActivity.setLayout(new GridLayout());
        this.activityTable = new Table(gActivity, 268503044);
        this.activityTable.setLayoutData(new GridData(1808));
        final TableColumn colStatus = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText(colStatus, "DHTView.activity.status");
        colStatus.setWidth(80);
        final TableColumn colType = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText(colType, "DHTView.activity.type");
        colType.setWidth(80);
        final TableColumn colName = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText(colName, "DHTView.activity.target");
        colName.setWidth(80);
        final TableColumn colDetails = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText(colDetails, "DHTView.activity.details");
        colDetails.setWidth(300);
        colDetails.setResizable(false);
        this.activityTable.setHeaderVisible(true);
        Listener computeLastRowWidthListener = new Listener(){
            boolean inUse = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event2) {
                if (this.inUse) {
                    return;
                }
                this.inUse = true;
                try {
                    block9: {
                        block8: {
                            if (DHTView.this.activityTable == null) break block8;
                            if (!DHTView.this.activityTable.isDisposed()) break block9;
                        }
                        Object var5_2 = null;
                        this.inUse = false;
                        return;
                    }
                    int totalWidth = DHTView.this.activityTable.getClientArea().width;
                    int remainingWidth = totalWidth - colStatus.getWidth() - colType.getWidth() - colName.getWidth();
                    if (remainingWidth > 0) {
                        colDetails.setWidth(remainingWidth);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.inUse = false;
                    throw throwable;
                }
                Object var5_3 = null;
                this.inUse = false;
            }
        };
        this.activityTable.addListener(11, computeLastRowWidthListener);
        colStatus.addListener(11, computeLastRowWidthListener);
        colType.addListener(11, computeLastRowWidthListener);
        colName.addListener(11, computeLastRowWidthListener);
        this.activityTable.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                TableItem item = (TableItem)event2.item;
                int index = DHTView.this.activityTable.indexOf(item);
                item.setText(0, MessageText.getString("DHTView.activity.status." + DHTView.this.activities[index].isQueued()));
                item.setText(1, MessageText.getString("DHTView.activity.type." + DHTView.this.activities[index].getType()));
                item.setText(2, ByteFormatter.nicePrint(DHTView.this.activities[index].getTarget()));
                item.setText(3, DHTView.this.activities[index].getDescription());
            }
        });
    }

    public void delete() {
        Utils.disposeComposite(this.panel);
        if (this.dht != null) {
            this.dht.getControl().removeListener(this.controlListener);
        }
        this.outGraph.dispose();
        this.inGraph.dispose();
    }

    public String getFullTitle() {
        if (this.dht_type == 0) {
            return "DHTView.title.full";
        }
        if (this.dht_type == 1) {
            return "DHTView.title.fullcvs";
        }
        return "DHTView.title.full_v6";
    }

    public Composite getComposite() {
        return this.panel;
    }

    public void refresh() {
        if (this.dht == null) {
            if (this.core != null) {
                this.init(this.core);
            }
            return;
        }
        this.inGraph.refresh();
        this.outGraph.refresh();
        this.refreshGeneral();
        this.refreshDB();
        this.refreshTransportDetails();
        this.refreshOperationDetails();
        this.refreshActivity();
    }

    private void refreshGeneral() {
        DHTControlStats controlStats = this.dht.getControl().getStats();
        DHTRouterStats routerStats = this.dht.getRouter().getStats();
        DHTTransport transport = this.dht.getTransport();
        DHTTransportStats transportStats = transport.getStats();
        this.lblUpTime.setText(TimeFormatter.format(controlStats.getRouterUptime() / 1000L));
        this.lblNumberOfUsers.setText("" + controlStats.getEstimatedDHTSize());
        int percent = transportStats.getRouteablePercentage();
        this.lblReachable.setText((transport.isReachable() ? this.yes_str : this.no_str) + (percent == -1 ? "" : " " + percent + "%"));
        DHTNATPuncher puncher = this.dht.getNATPuncher();
        String puncher_str = puncher == null ? "" : (puncher.operational() ? this.yes_str : this.no_str);
        this.lblRendezvous.setText(transport.isReachable() ? "" : puncher_str);
        long[] stats2 = routerStats.getStats();
        this.lblNodes.setText("" + stats2[0]);
        this.lblLeaves.setText("" + stats2[1]);
        this.lblContacts.setText("" + stats2[2]);
        this.lblReplacements.setText("" + stats2[3]);
        this.lblLive.setText("" + stats2[4]);
        this.lblUnknown.setText("" + stats2[5]);
        this.lblDying.setText("" + stats2[6]);
        long skew_average = transportStats.getSkewAverage();
        this.lblSkew.setText(skew_average == 0L ? "" : (skew_average < 0L ? "-" : "") + TimeFormatter.format100ths(Math.abs(skew_average)));
    }

    private void refreshDB() {
        if (this.refreshIter == 0) {
            String rem_size;
            String rem_freq;
            DHTDBStats dbStats = this.dht.getDataBase().getStats();
            this.lblKeys.setText("" + dbStats.getKeyCount() + " (" + dbStats.getLocalKeyCount() + ")");
            int[] stats2 = dbStats.getValueDetails();
            this.lblValues.setText("" + stats2[0]);
            this.lblSize.setText(DisplayFormatters.formatByteCountToKiBEtc(dbStats.getSize()));
            this.lblDirect.setText(DisplayFormatters.formatByteCountToKiBEtc(stats2[2]));
            this.lblIndirect.setText(DisplayFormatters.formatByteCountToKiBEtc(stats2[3]));
            this.lblLocal.setText(DisplayFormatters.formatByteCountToKiBEtc(stats2[1]));
            DHTStorageAdapter sa = this.dht.getStorageAdapter();
            if (sa == null) {
                rem_freq = "?";
                rem_size = "?";
            } else {
                rem_freq = "" + sa.getRemoteFreqDivCount();
                rem_size = "" + sa.getRemoteSizeDivCount();
            }
            this.lblDivFreq.setText("" + stats2[4] + " (" + rem_freq + ")");
            this.lblDivSize.setText("" + stats2[5] + " (" + rem_size + ")");
        } else {
            ++this.refreshIter;
            if (this.refreshIter == 100) {
                this.refreshIter = 0;
            }
        }
    }

    private void refreshTransportDetails() {
        DHTTransportStats transportStats = this.dht.getTransport().getStats();
        this.lblReceivedBytes.setText(DisplayFormatters.formatByteCountToKiBEtc(transportStats.getBytesReceived()));
        this.lblSentBytes.setText(DisplayFormatters.formatByteCountToKiBEtc(transportStats.getBytesSent()));
        this.lblReceivedPackets.setText("" + transportStats.getPacketsReceived());
        this.lblSentPackets.setText("" + transportStats.getPacketsSent());
    }

    private void refreshOperationDetails() {
        DHTTransportStats transportStats = this.dht.getTransport().getStats();
        long[] pings = transportStats.getPings();
        for (int i = 0; i < 4; ++i) {
            this.lblPings[i].setText("" + pings[i]);
        }
        long[] findNodes = transportStats.getFindNodes();
        for (int i = 0; i < 4; ++i) {
            this.lblFindNodes[i].setText("" + findNodes[i]);
        }
        long[] findValues = transportStats.getFindValues();
        for (int i = 0; i < 4; ++i) {
            this.lblFindValues[i].setText("" + findValues[i]);
        }
        long[] stores = transportStats.getStores();
        long[] qstores = transportStats.getQueryStores();
        for (int i = 0; i < 4; ++i) {
            this.lblStores[i].setText("" + stores[i] + " (" + qstores[i] + ")");
        }
        long[] data = transportStats.getData();
        for (int i = 0; i < 4; ++i) {
            this.lblData[i].setText("" + data[i]);
        }
    }

    private void refreshActivity() {
        if (this.activityChanged) {
            this.activityChanged = false;
            this.activities = this.dht.getControl().getActivities();
            this.activityTable.setItemCount(this.activities.length);
            this.activityTable.clearAll();
            this.activityTable.redraw();
        }
    }

    public void periodicUpdate() {
        if (this.dht == null) {
            return;
        }
        DHTTransportFullStats fullStats = this.dht.getTransport().getLocalContact().getStats();
        this.inGraph.addIntValue((int)fullStats.getAverageBytesReceived());
        this.outGraph.addIntValue((int)fullStats.getAverageBytesSent());
    }

    public String getData() {
        return this.getFullTitle();
    }
}

