/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class CacheView
extends AbstractIView {
    CacheFileManagerStats stats;
    Composite panel;
    Label lblInUse;
    Label lblSize;
    Label lblPercentUsed;
    ProgressBar pbInUse;
    Label lblReadsFromCache;
    Label lblNumberReadsFromCache;
    Label lblAvgSizeFromCache;
    Label lblReadsFromFile;
    Label lblNumberReadsFromFile;
    Label lblAvgSizeFromFile;
    Label lblPercentReads;
    ProgressBar pbReads;
    Label lblWritesToCache;
    Label lblNumberWritesToCache;
    Label lblAvgSizeToCache;
    Label lblWritesToFile;
    Label lblNumberWritesToFile;
    Label lblAvgSizeToFile;
    Label lblPercentWrites;
    ProgressBar pbWrites;
    Canvas readsFromFile;
    Canvas readsFromCache;
    Canvas writesToCache;
    Canvas writesToFile;
    SpeedGraphic rffGraph;
    SpeedGraphic rfcGraph;
    SpeedGraphic wtcGraph;
    SpeedGraphic wtfGraph;

    public CacheView() {
        try {
            this.stats = CacheFileManagerFactory.getSingleton().getStats();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout(new GridLayout());
        this.generateGeneralGroup();
        this.generateReadsGroup();
        this.generateWritesGroup();
        this.generateSpeedGroup();
    }

    private void generateGeneralGroup() {
        Group gCacheGeneral = new Group(this.panel, 0);
        Messages.setLanguageText(gCacheGeneral, "CacheView.general.title");
        gCacheGeneral.setLayoutData(new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 4;
        gCacheGeneral.setLayout(layoutGeneral);
        Label lbl = new Label(gCacheGeneral, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData(gridData);
        Messages.setLanguageText(lbl, "CacheView.general.inUse");
        this.lblInUse = new Label(gCacheGeneral, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblInUse.setLayoutData(gridData);
        this.pbInUse = new ProgressBar(gCacheGeneral, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        this.pbInUse.setLayoutData(gridData);
        this.pbInUse.setMinimum(0);
        this.pbInUse.setMaximum(1000);
        this.lblPercentUsed = new Label(gCacheGeneral, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 100;
        this.lblPercentUsed.setLayoutData(gridData);
        lbl = new Label(gCacheGeneral, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData(gridData);
        Messages.setLanguageText(lbl, "CacheView.general.size");
        this.lblSize = new Label(gCacheGeneral, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblSize.setLayoutData(gridData);
    }

    private void generateReadsGroup() {
        Group gCacheReads = new Group(this.panel, 0);
        Messages.setLanguageText(gCacheReads, "CacheView.reads.title");
        gCacheReads.setLayoutData(new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 6;
        gCacheReads.setLayout(layoutGeneral);
        Label lbl = new Label(gCacheReads, 0);
        lbl = new Label(gCacheReads, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.#");
        lbl = new Label(gCacheReads, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.amount");
        lbl = new Label(gCacheReads, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.avgsize");
        lbl = new Label(gCacheReads, 0);
        lbl = new Label(gCacheReads, 0);
        lbl = new Label(gCacheReads, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData(gridData);
        Messages.setLanguageText(lbl, "CacheView.reads.fromCache");
        this.lblNumberReadsFromCache = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberReadsFromCache.setLayoutData(gridData);
        this.lblReadsFromCache = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblReadsFromCache.setLayoutData(gridData);
        this.lblAvgSizeFromCache = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeFromCache.setLayoutData(gridData);
        this.pbReads = new ProgressBar(gCacheReads, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        this.pbReads.setLayoutData(gridData);
        this.pbReads.setMinimum(0);
        this.pbReads.setMaximum(1000);
        this.lblPercentReads = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 100;
        this.lblPercentReads.setLayoutData(gridData);
        lbl = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData(gridData);
        Messages.setLanguageText(lbl, "CacheView.reads.fromFile");
        this.lblNumberReadsFromFile = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberReadsFromFile.setLayoutData(gridData);
        this.lblReadsFromFile = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblReadsFromFile.setLayoutData(gridData);
        this.lblAvgSizeFromFile = new Label(gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeFromFile.setLayoutData(gridData);
    }

    private void generateSpeedGroup() {
        Group gCacheSpeeds = new Group(this.panel, 0);
        Messages.setLanguageText(gCacheSpeeds, "CacheView.speeds.title");
        gCacheSpeeds.setLayoutData(new GridData(1808));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 3;
        gCacheSpeeds.setLayout(layoutGeneral);
        Label lbl = new Label(gCacheSpeeds, 0);
        lbl = new Label(gCacheSpeeds, 0);
        GridData gridData = new GridData(64);
        lbl.setLayoutData(gridData);
        Messages.setLanguageText(lbl, "CacheView.speeds.reads");
        lbl = new Label(gCacheSpeeds, 0);
        gridData = new GridData(64);
        lbl.setLayoutData(gridData);
        Messages.setLanguageText(lbl, "CacheView.speeds.writes");
        lbl = new Label(gCacheSpeeds, 0);
        Messages.setLanguageText(lbl, "CacheView.speeds.fromCache");
        this.readsFromCache = new Canvas(gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.readsFromCache.setLayoutData(gridData);
        this.rfcGraph = SpeedGraphic.getInstance();
        this.rfcGraph.initialize(this.readsFromCache);
        this.writesToCache = new Canvas(gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.writesToCache.setLayoutData(gridData);
        this.wtcGraph = SpeedGraphic.getInstance();
        this.wtcGraph.initialize(this.writesToCache);
        lbl = new Label(gCacheSpeeds, 0);
        Messages.setLanguageText(lbl, "CacheView.speeds.fromFile");
        this.readsFromFile = new Canvas(gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.readsFromFile.setLayoutData(gridData);
        this.rffGraph = SpeedGraphic.getInstance();
        this.rffGraph.initialize(this.readsFromFile);
        this.writesToFile = new Canvas(gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.writesToFile.setLayoutData(gridData);
        this.wtfGraph = SpeedGraphic.getInstance();
        this.wtfGraph.initialize(this.writesToFile);
    }

    public void periodicUpdate() {
        this.rfcGraph.addIntValue((int)this.stats.getAverageBytesReadFromCache());
        this.rffGraph.addIntValue((int)this.stats.getAverageBytesReadFromFile());
        this.wtcGraph.addIntValue((int)this.stats.getAverageBytesWrittenToCache());
        this.wtfGraph.addIntValue((int)this.stats.getAverageBytesWrittenToFile());
    }

    private void generateWritesGroup() {
        Group gCacheWrites = new Group(this.panel, 0);
        Messages.setLanguageText(gCacheWrites, "CacheView.writes.title");
        gCacheWrites.setLayoutData(new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 6;
        gCacheWrites.setLayout(layoutGeneral);
        Label lbl = new Label(gCacheWrites, 0);
        lbl = new Label(gCacheWrites, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.#");
        lbl = new Label(gCacheWrites, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.amount");
        lbl = new Label(gCacheWrites, 0);
        Messages.setLanguageText(lbl, "CacheView.reads.avgsize");
        lbl = new Label(gCacheWrites, 0);
        lbl = new Label(gCacheWrites, 0);
        lbl = new Label(gCacheWrites, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData(gridData);
        Messages.setLanguageText(lbl, "CacheView.writes.toCache");
        this.lblNumberWritesToCache = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberWritesToCache.setLayoutData(gridData);
        this.lblWritesToCache = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblWritesToCache.setLayoutData(gridData);
        this.lblAvgSizeToCache = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeToCache.setLayoutData(gridData);
        this.pbWrites = new ProgressBar(gCacheWrites, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        this.pbWrites.setLayoutData(gridData);
        this.pbWrites.setMinimum(0);
        this.pbWrites.setMaximum(1000);
        this.lblPercentWrites = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 100;
        this.lblPercentWrites.setLayoutData(gridData);
        lbl = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData(gridData);
        Messages.setLanguageText(lbl, "CacheView.writes.toFile");
        this.lblNumberWritesToFile = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberWritesToFile.setLayoutData(gridData);
        this.lblWritesToFile = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblWritesToFile.setLayoutData(gridData);
        this.lblAvgSizeToFile = new Label(gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeToFile.setLayoutData(gridData);
    }

    public void delete() {
        Utils.disposeComposite(this.panel);
        this.rfcGraph.dispose();
        this.rffGraph.dispose();
        this.wtcGraph.dispose();
        this.wtfGraph.dispose();
    }

    public String getFullTitle() {
        return MessageText.getString("CacheView.title.full");
    }

    public Composite getComposite() {
        return this.panel;
    }

    public void refresh() {
        this.lblSize.setText(DisplayFormatters.formatByteCountToKiBEtc(this.stats.getSize()));
        this.lblInUse.setText(DisplayFormatters.formatByteCountToKiBEtc(this.stats.getUsedSize()));
        int perThousands = (int)(1000L * this.stats.getUsedSize() / this.stats.getSize());
        this.lblPercentUsed.setText(DisplayFormatters.formatPercentFromThousands(perThousands));
        this.pbInUse.setSelection(perThousands);
        this.refrehReads();
        this.refreshWrites();
        this.rfcGraph.refresh();
        this.rffGraph.refresh();
        this.wtcGraph.refresh();
        this.wtfGraph.refresh();
    }

    private void refrehReads() {
        long readsFromCache = this.stats.getBytesReadFromCache();
        long readsFromFile = this.stats.getBytesReadFromFile();
        long nbReadsFromCache = this.stats.getCacheReadCount();
        long nbReadsFromFile = this.stats.getFileReadCount();
        this.lblNumberReadsFromCache.setText("" + nbReadsFromCache);
        this.lblNumberReadsFromFile.setText("" + nbReadsFromFile);
        if (nbReadsFromCache != 0L) {
            long avgReadFromCache = readsFromCache / nbReadsFromCache;
            this.lblAvgSizeFromCache.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadFromCache));
        } else {
            this.lblAvgSizeFromCache.setText("--");
        }
        if (nbReadsFromFile != 0L) {
            long avgReadFromFile = readsFromFile / nbReadsFromFile;
            this.lblAvgSizeFromFile.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadFromFile));
        } else {
            this.lblAvgSizeFromFile.setText("--");
        }
        this.lblReadsFromCache.setText(DisplayFormatters.formatByteCountToKiBEtc(readsFromCache));
        this.lblReadsFromFile.setText(DisplayFormatters.formatByteCountToKiBEtc(readsFromFile));
        long totalRead = readsFromCache + readsFromFile;
        if (totalRead > 0L) {
            int perThousands = (int)(1000L * this.stats.getBytesReadFromCache() / totalRead);
            this.lblPercentReads.setText(DisplayFormatters.formatPercentFromThousands(perThousands) + " " + MessageText.getString("CacheView.reads.hits"));
            this.pbReads.setSelection(perThousands);
        }
    }

    private void refreshWrites() {
        long writesToCache = this.stats.getBytesWrittenToCache();
        long writesToFile = this.stats.getBytesWrittenToFile();
        long nbWritesToCache = this.stats.getCacheWriteCount();
        long nbWritesToFile = this.stats.getFileWriteCount();
        this.lblNumberWritesToCache.setText("" + nbWritesToCache);
        this.lblNumberWritesToFile.setText("" + nbWritesToFile);
        if (nbWritesToCache != 0L) {
            long avgReadToCache = writesToCache / nbWritesToCache;
            this.lblAvgSizeToCache.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadToCache));
        } else {
            this.lblAvgSizeToCache.setText("--");
        }
        if (nbWritesToFile != 0L) {
            long avgReadToFile = writesToFile / nbWritesToFile;
            this.lblAvgSizeToFile.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadToFile));
        } else {
            this.lblAvgSizeToFile.setText("--");
        }
        this.lblWritesToCache.setText(DisplayFormatters.formatByteCountToKiBEtc(writesToCache));
        this.lblWritesToFile.setText(DisplayFormatters.formatByteCountToKiBEtc(writesToFile));
        long totalNbWrites = nbWritesToCache + nbWritesToFile;
        if (totalNbWrites > 0L) {
            int perThousands = (int)(1000L * nbWritesToCache / totalNbWrites);
            this.lblPercentWrites.setText(DisplayFormatters.formatPercentFromThousands(perThousands) + " " + MessageText.getString("CacheView.writes.hits"));
            this.pbWrites.setSelection(perThousands);
        }
    }

    public String getData() {
        return "CacheView.title.full";
    }
}

