/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.ColorParameter;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterfaceColor
implements UISWTConfigSection {
    private static final String[] sColorsToOverride = new String[]{"progressBar", "error", "warning", "altRow"};
    private Color[] colorsToOverride = new Color[]{Colors.colorProgressBar, Colors.colorError, Colors.colorWarning, Colors.colorAltRow};
    private Button[] btnColorReset = new Button[sColorsToOverride.length];

    public String configSectionGetParentSection() {
        return "style";
    }

    public String configSectionGetName() {
        return "color";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 0;
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        cSection.setLayoutData(new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        cSection.setLayout(layout);
        Composite cArea = new Composite(cSection, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout(layout);
        cArea.setLayoutData(new GridData());
        Label label = new Label(cArea, 0);
        Messages.setLanguageText(label, "ConfigView.section.color");
        ColorParameter colorScheme = new ColorParameter(cArea, "Color Scheme", 0, 128, 255);
        GridData gridData = new GridData();
        gridData.widthHint = 50;
        colorScheme.setLayoutData(gridData);
        Group cColorOverride = new Group(cArea, 0);
        Messages.setLanguageText(cColorOverride, "ConfigView.section.style.colorOverrides");
        layout = new GridLayout();
        layout.numColumns = 3;
        cColorOverride.setLayout(layout);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        cColorOverride.setLayoutData(gridData);
        for (int i = 0; i < sColorsToOverride.length; ++i) {
            if (Utils.TABLE_GRIDLINE_IS_ALTERNATING_COLOR && sColorsToOverride[i].equals("altRow")) continue;
            String sConfigID = "Colors." + sColorsToOverride[i];
            label = new Label(cColorOverride, 0);
            Messages.setLanguageText(label, "ConfigView.section.style.colorOverride." + sColorsToOverride[i]);
            ColorParameter colorParm = new ColorParameter(cColorOverride, sConfigID, this.colorsToOverride[i].getRed(), this.colorsToOverride[i].getGreen(), this.colorsToOverride[i].getBlue()){

                public void newColorChosen() {
                    COConfigurationManager.setParameter(this.sParamName + ".override", true);
                    for (int i = 0; i < sColorsToOverride.length; ++i) {
                        if (!this.sParamName.equals("Colors." + sColorsToOverride[i])) continue;
                        ConfigSectionInterfaceColor.this.btnColorReset[i].setEnabled(true);
                        break;
                    }
                }
            };
            gridData = new GridData();
            gridData.widthHint = 50;
            colorParm.setLayoutData(gridData);
            this.btnColorReset[i] = new Button(cColorOverride, 8);
            Messages.setLanguageText(this.btnColorReset[i], "ConfigView.section.style.colorOverrides.reset");
            this.btnColorReset[i].setEnabled(COConfigurationManager.getBooleanParameter(sConfigID + ".override", false));
            this.btnColorReset[i].setData("ColorName", sConfigID);
            this.btnColorReset[i].addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    Button btn = (Button)event2.widget;
                    String sName = (String)btn.getData("ColorName");
                    if (sName != null) {
                        COConfigurationManager.setParameter(sName + ".override", false);
                        btn.setEnabled(false);
                    }
                }
            });
        }
        return cSection;
    }
}

