/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.columnsetup;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.columnsetup.TableColumnSetupWindow;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.impl.FakeTableCell;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellImpl;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnTC_Sample
extends CoreTableColumn
implements TableCellAddedListener {
    public static final String COLUMN_ID = "TableColumnSample";

    public ColumnTC_Sample(String tableID) {
        super(COLUMN_ID, tableID);
        this.setPosition(-1);
        this.setRefreshInterval(-2);
        this.setWidth(120);
    }

    public void cellAdded(final TableCell cell) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableColumnCore column = (TableColumnCore)cell.getDataSource();
                TableColumnSetupWindow.TableViewColumnSetup tv = (TableColumnSetupWindow.TableViewColumnSetup)((TableCellCore)cell).getTableRowCore().getView();
                TableRowCore sampleRow = (TableRowCore)tv.getSampleRow();
                cell.addListeners(new Cell(cell, column, tv, sampleRow));
            }
        });
    }

    public class Cell
    implements TableCellRefreshListener,
    TableCellSWTPaintListener,
    TableCellVisibilityListener {
        private final TableColumnCore column;
        private FakeTableCell sampleCell;

        public Cell(TableCell parentCell, TableColumnCore column, TableColumnSetupWindow.TableViewColumnSetup tv, TableRowCore sampleRow) {
            this.column = column;
            if (sampleRow == null) {
                return;
            }
            this.sampleCell = new FakeTableCell(column);
            this.sampleCell.setControl(tv.getTableComposite());
            Rectangle bounds = ((TableCellImpl)parentCell).getBounds();
            this.sampleCell.setCellArea(bounds);
            if (sampleRow != null) {
                this.sampleCell.setDataSource(sampleRow.getDataSource(true));
            }
        }

        public void cellPaint(GC gc, TableCellSWT cell) {
            if (this.sampleCell == null) {
                return;
            }
            Rectangle bounds = ((TableCellImpl)cell).getBounds();
            this.sampleCell.setCellArea(bounds);
            try {
                this.sampleCell.doPaint(gc);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        public void cellVisibilityChanged(TableCell cell, int visibility) {
            if (this.sampleCell == null) {
                return;
            }
            try {
                this.column.invokeCellVisibilityListeners(this.sampleCell, visibility);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }

        public void refresh(TableCell cell) {
            if (this.sampleCell == null) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            this.sampleCell.refresh(true, true, true);
            cell.setSortValue(this.sampleCell.getSortValue());
        }
    }
}

