/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.tracker.TrackerPeerSource;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectedRowsListener;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerTPSListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.ScrapeInfoView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.IntervalItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.LeechersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.PeersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.SeedsItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.StatusItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.TypeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.tracker.UpdateInItem;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackerView
extends TableViewTab<TrackerPeerSource>
implements TableLifeCycleListener,
TableDataSourceChangedListener,
DownloadManagerTPSListener,
TableViewSWTMenuFillListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new TypeItem(), new NameItem(), new StatusItem(), new PeersItem(), new SeedsItem(), new LeechersItem(), new UpdateInItem(), new IntervalItem()};
    DownloadManager manager;
    private TableViewSWTImpl<TrackerPeerSource> tv;
    private ScrapeInfoView scrapeInfoView;

    public TrackerView() {
        super("TrackerView");
    }

    @Override
    public TableViewSWT<TrackerPeerSource> initYourTableView() {
        this.tv = new TableViewSWTImpl(TrackerPeerSource.class, "Trackers", this.getPropertiesPrefix(), basicItems, basicItems[0].getName(), 0x10010004);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.setEnableTabViews(true);
        this.scrapeInfoView = new ScrapeInfoView(this.manager);
        this.tv.setCoreTabViews(new IView[]{this.scrapeInfoView});
        return this.tv;
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        final Object[] sources = this.tv.getSelectedDataSources().toArray();
        boolean found_tracker = false;
        boolean update_ok = false;
        for (Object o : sources) {
            int state;
            TrackerPeerSource ps = (TrackerPeerSource)o;
            if (ps.getType() == 1) {
                found_tracker = true;
            }
            if ((state = ps.getStatus()) != 5 && state != 3 && state != 6 || ps.isUpdating() || !ps.canManuallyUpdate()) continue;
            update_ok = true;
            break;
        }
        if (found_tracker) {
            MenuItem update_item = new MenuItem(menu, 8);
            Messages.setLanguageText(update_item, "GeneralView.label.trackerurlupdate");
            update_item.setEnabled(update_ok);
            update_item.addListener(13, new TableSelectedRowsListener(this.tv){

                public void run(TableRowCore row) {
                    for (Object o : sources) {
                        TrackerPeerSource ps = (TrackerPeerSource)o;
                        if (!ps.canManuallyUpdate()) continue;
                        ps.manualUpdate();
                    }
                }
            });
            new MenuItem(menu, 2);
        }
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    @Override
    public void trackerPeerSourcesChanged() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TrackerView.this.manager == null || TrackerView.this.tv.isDisposed()) {
                    return;
                }
                TrackerView.this.tv.removeAllTableRows();
                TrackerView.this.addExistingDatasources();
            }
        });
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        if (this.manager != null) {
            this.manager.removeTPSListener(this);
        }
        this.manager = newDataSource == null ? null : (newDataSource instanceof Object[] ? (DownloadManager)((Object[])newDataSource)[0] : (DownloadManager)newDataSource);
        if (this.manager != null && !this.tv.isDisposed()) {
            this.manager.addTPSListener(this);
            this.addExistingDatasources();
        }
        if (this.scrapeInfoView != null) {
            this.scrapeInfoView.setDownlaodManager(this.manager);
        }
    }

    @Override
    public void tableViewInitialized() {
        if (this.manager != null) {
            this.manager.addTPSListener(this);
            this.addExistingDatasources();
        }
    }

    @Override
    public void tableViewDestroyed() {
        if (this.manager != null) {
            this.manager.removeTPSListener(this);
        }
    }

    private void addExistingDatasources() {
        if (this.manager == null || this.tv.isDisposed()) {
            return;
        }
        List<TrackerPeerSource> tps = this.manager.getTrackerPeerSources();
        this.tv.addDataSources((TrackerPeerSource[])tps.toArray(new TrackerPeerSource[tps.size()]));
        this.tv.processDataSourceQueue();
    }

    @Override
    public boolean toolBarItemActivated(String itemKey) {
        if (super.toolBarItemActivated(itemKey)) {
            return true;
        }
        if (itemKey.equals("run")) {
            ManagerUtils.run(this.manager);
            return true;
        }
        if (itemKey.equals("start")) {
            ManagerUtils.queue(this.manager, this.getComposite().getShell());
            return true;
        }
        if (itemKey.equals("stop")) {
            ManagerUtils.stop(this.manager, this.getComposite().getShell());
            return true;
        }
        if (itemKey.equals("remove")) {
            TorrentUtil.removeDownloads(new DownloadManager[]{this.manager}, null);
            return true;
        }
        return false;
    }

    @Override
    public void refreshToolBar(Map<String, Boolean> list) {
        list.put("run", true);
        list.put("start", ManagerUtils.isStartable(this.manager));
        list.put("stop", ManagerUtils.isStopable(this.manager));
        list.put("remove", true);
        super.refreshToolBar(list);
    }
}

