/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectedRowsListener;
import com.aelitis.azureus.ui.common.table.TableView;
import java.util.Map;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.peer.PeerInfoView;
import org.gudy.azureus2.ui.swt.views.peer.RemotePieceDistributionView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ASItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ChokedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ChokingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ClientIdentificationItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ClientItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ConnectedTimeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DLedFromOthersItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DiscardedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DownItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DownSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.DownSpeedLimitItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.EncryptionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.GainItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.HandshakeReservedBytesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.HostNameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.IncomingRequestCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.InterestedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.InterestingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.IpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.LANItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.MessagingItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.OptimisticUnchokeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.OutgoingRequestCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PeerByteIDItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PeerIDItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PeerSourceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PercentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.PortItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.ProtocolItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.SnubbedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.StatUpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.StateItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TimeToSendPieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TimeUntilCompleteItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TotalDownSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.TypeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UniquePieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpDownRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpRatioItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpSpeedItem;
import org.gudy.azureus2.ui.swt.views.tableitems.peers.UpSpeedLimitItem;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeersView
extends TableViewTab<PEPeer>
implements DownloadManagerPeerListener,
TableDataSourceChangedListener,
TableLifeCycleListener,
TableViewSWTMenuFillListener {
    private static final TableColumnCore[] basicItems = PeersView.getBasicColumnItems("Peers");
    private DownloadManager manager;
    private TableViewSWT tv;
    private Shell shell;

    static TableColumnCore[] getBasicColumnItems(String table_id) {
        return new TableColumnCore[]{new IpItem(table_id), new ClientItem(table_id), new TypeItem(table_id), new MessagingItem(table_id), new EncryptionItem(table_id), new ProtocolItem(table_id), new PiecesItem(table_id), new PercentItem(table_id), new DownSpeedItem(table_id), new UpSpeedItem(table_id), new PeerSourceItem(table_id), new HostNameItem(table_id), new PortItem(table_id), new InterestedItem(table_id), new ChokedItem(table_id), new DownItem(table_id), new InterestingItem(table_id), new ChokingItem(table_id), new OptimisticUnchokeItem(table_id), new UpItem(table_id), new UpDownRatioItem(table_id), new GainItem(table_id), new StatUpItem(table_id), new SnubbedItem(table_id), new TotalDownSpeedItem(table_id), new TimeUntilCompleteItem(table_id), new DiscardedItem(table_id), new UniquePieceItem(table_id), new TimeToSendPieceItem(table_id), new DLedFromOthersItem(table_id), new UpRatioItem(table_id), new StateItem(table_id), new ConnectedTimeItem(table_id), new PieceItem(table_id), new IncomingRequestCountItem(table_id), new OutgoingRequestCountItem(table_id), new UpSpeedLimitItem(table_id), new DownSpeedLimitItem(table_id), new LANItem(table_id), new PeerIDItem(table_id), new PeerByteIDItem(table_id), new HandshakeReservedBytesItem(table_id), new ClientIdentificationItem(table_id), new ASItem(table_id)};
    }

    public PeersView() {
        super("PeersView");
    }

    @Override
    public TableViewSWT initYourTableView() {
        this.tv = new TableViewSWTImpl(Peer.class, "Peers", this.getPropertiesPrefix(), basicItems, "pieces", 0x10010002);
        this.tv.setRowDefaultHeight(16);
        this.tv.setEnableTabViews(true);
        this.tv.setCoreTabViews(new IView[]{new PeerInfoView(), new RemotePieceDistributionView(), new LoggerView(true)});
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        return this.tv;
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
        }
        this.manager = newDataSource == null ? null : (newDataSource instanceof Object[] ? (DownloadManager)((Object[])newDataSource)[0] : (DownloadManager)newDataSource);
        if (this.manager != null && !this.tv.isDisposed()) {
            this.manager.addPeerListener(this, false);
            this.addExistingDatasources();
        }
    }

    @Override
    public void tableViewInitialized() {
        this.shell = this.tv.getComposite().getShell();
        if (this.manager != null) {
            this.manager.removePeerListener(this);
            this.manager.addPeerListener(this, false);
        }
        this.addExistingDatasources();
    }

    @Override
    public void tableViewDestroyed() {
        if (this.manager != null) {
            this.manager.removePeerListener(this);
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        PeersView.fillMenu(menu, this.tv, this.shell, true);
    }

    public static void fillMenu(Menu menu, final TableView tv, Shell shell, boolean download_specific) {
        PEPeer peer;
        Object[] peers = tv.getSelectedDataSources().toArray();
        boolean hasSelection = peers.length > 0;
        boolean downSpeedDisabled = false;
        boolean downSpeedUnlimited = false;
        long totalDownSpeed = 0L;
        long downSpeedSetMax = 0L;
        long maxDown = 0L;
        boolean upSpeedDisabled = false;
        boolean upSpeedUnlimited = false;
        long totalUpSpeed = 0L;
        long upSpeedSetMax = 0L;
        long maxUp = 0L;
        if (hasSelection) {
            for (int i = 0; i < peers.length; ++i) {
                peer = (PEPeer)peers[i];
                try {
                    int maxul = peer.getStats().getUploadRateLimitBytesPerSecond();
                    maxUp += (long)(maxul * 4);
                    if (maxul == 0) {
                        upSpeedUnlimited = true;
                    } else if ((long)maxul > upSpeedSetMax) {
                        upSpeedSetMax = maxul;
                    }
                    if (maxul == -1) {
                        maxul = 0;
                        upSpeedDisabled = true;
                    }
                    totalUpSpeed += (long)maxul;
                    int maxdl = peer.getStats().getDownloadRateLimitBytesPerSecond();
                    maxDown += (long)(maxdl * 4);
                    if (maxdl == 0) {
                        downSpeedUnlimited = true;
                    } else if ((long)maxdl > downSpeedSetMax) {
                        downSpeedSetMax = maxdl;
                    }
                    if (maxdl == -1) {
                        maxdl = 0;
                        downSpeedDisabled = true;
                    }
                    totalDownSpeed += (long)maxdl;
                    continue;
                }
                catch (Exception ex) {
                    Debug.printStackTrace(ex);
                }
            }
        }
        if (download_specific) {
            MenuItem block_item = new MenuItem(menu, 32);
            peer = (PEPeer)tv.getFirstSelectedDataSource();
            if (peer == null || peer.getManager().getDiskManager().getRemainingExcludingDND() > 0L) {
                block_item.setSelection(false);
                block_item.setEnabled(false);
            } else {
                block_item.setEnabled(true);
                block_item.setSelection(peer.isSnubbed());
            }
            final boolean newSnubbedValue = !peer.isSnubbed();
            Messages.setLanguageText(block_item, "PeersView.menu.blockupload");
            block_item.addListener(13, new TableSelectedRowsListener(tv){

                public void run(TableRowCore row) {
                    PEPeer peer = (PEPeer)row.getDataSource(true);
                    peer.setSnubbed(newSnubbedValue);
                }
            });
        }
        MenuItem ban_item = new MenuItem(menu, 8);
        Messages.setLanguageText(ban_item, "PeersView.menu.kickandban");
        ban_item.addListener(13, new TableSelectedRowsListener(tv){

            public void run(TableRowCore row) {
                PEPeer peer = (PEPeer)row.getDataSource(true);
                String msg = MessageText.getString("PeersView.menu.kickandban.reason");
                IpFilterManagerFactory.getSingleton().getIPFilter().ban(peer.getIp(), msg, true);
                peer.getManager().removePeer(peer);
            }
        });
        MenuItem itemAdvanced = new MenuItem(menu, 64);
        Messages.setLanguageText(itemAdvanced, "MyTorrentsView.menu.advancedmenu");
        itemAdvanced.setEnabled(hasSelection);
        Menu menuAdvanced = new Menu(shell, 4);
        itemAdvanced.setMenu(menuAdvanced);
        ViewUtils.addSpeedMenu(shell, menuAdvanced, false, hasSelection, downSpeedDisabled, downSpeedUnlimited, totalDownSpeed, downSpeedSetMax, maxDown, upSpeedDisabled, upSpeedUnlimited, totalUpSpeed, upSpeedSetMax, maxUp, peers.length, new ViewUtils.SpeedAdapter(){

            public void setDownSpeed(int speed) {
                PeersView.setSelectedPeersDownSpeed(speed, tv);
            }

            public void setUpSpeed(int speed) {
                PeersView.setSelectedPeersUpSpeed(speed, tv);
            }
        });
        new MenuItem(menu, 2);
    }

    @Override
    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    private static void setSelectedPeersUpSpeed(int speed, TableView tv) {
        Object[] peers = tv.getSelectedDataSources().toArray();
        if (peers.length > 0) {
            for (int i = 0; i < peers.length; ++i) {
                try {
                    PEPeer peer = (PEPeer)peers[i];
                    peer.getStats().setUploadRateLimitBytesPerSecond(speed);
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    private static void setSelectedPeersDownSpeed(int speed, TableView tv) {
        Object[] peers = tv.getSelectedDataSources().toArray();
        if (peers.length > 0) {
            for (int i = 0; i < peers.length; ++i) {
                try {
                    PEPeer peer = (PEPeer)peers[i];
                    peer.getStats().setDownloadRateLimitBytesPerSecond(speed);
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    @Override
    public void peerAdded(PEPeer created) {
        this.tv.addDataSource(created);
    }

    @Override
    public void peerRemoved(PEPeer removed) {
        this.tv.removeDataSource(removed);
    }

    @Override
    public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
    }

    @Override
    public void peerManagerAdded(PEPeerManager manager) {
    }

    @Override
    public void peerManagerRemoved(PEPeerManager manager) {
        this.tv.removeAllTableRows();
    }

    private void addExistingDatasources() {
        if (this.manager == null || this.tv.isDisposed()) {
            return;
        }
        PEPeer[] dataSources = this.manager.getCurrentPeers();
        if (dataSources == null || dataSources.length == 0) {
            return;
        }
        this.tv.addDataSources(dataSources);
        this.tv.processDataSourceQueue();
    }

    @Override
    public boolean toolBarItemActivated(String itemKey) {
        if (super.toolBarItemActivated(itemKey)) {
            return true;
        }
        if (itemKey.equals("run")) {
            ManagerUtils.run(this.manager);
            return true;
        }
        if (itemKey.equals("start")) {
            ManagerUtils.queue(this.manager, this.getComposite().getShell());
            return true;
        }
        if (itemKey.equals("stop")) {
            ManagerUtils.stop(this.manager, this.getComposite().getShell());
            return true;
        }
        if (itemKey.equals("remove")) {
            TorrentUtil.removeDownloads(new DownloadManager[]{this.manager}, null);
            return true;
        }
        return false;
    }

    @Override
    public void refreshToolBar(Map<String, Boolean> list) {
        list.put("run", true);
        list.put("start", ManagerUtils.isStartable(this.manager));
        list.put("stop", ManagerUtils.isStopable(this.manager));
        list.put("remove", true);
        super.refreshToolBar(list);
    }
}

