/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadManager;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareItem;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceDirContents;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.tracker.Tracker;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.torrent.TorrentManagerImpl;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.CategoryItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.myshares.TypeItem;

public class MySharesView
extends TableViewTab
implements ShareManagerListener,
TableLifeCycleListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
TableSelectionListener {
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new TypeItem(), new CategoryItem()};
    protected static final TorrentAttribute category_attribute = TorrentManagerImpl.getSingleton().getAttribute("Category");
    private Menu menuCategory;
    private TableViewSWTImpl<ShareResource> tv = new TableViewSWTImpl(ShareResource.class, "MyShares", this.getPropertiesPrefix(), basicItems, "name", 268503042);

    public MySharesView() {
        super("MySharesView");
        this.tv.addSelectionListener(new TableSelectionAdapter(){

            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                MySharesView.this.defaultSelected(rows);
            }
        }, false);
        this.tv.addLifeCycleListener(this);
        this.tv.addMenuFillListener(this);
        this.tv.addRefreshListener(this, false);
        this.tv.addSelectionListener(this, false);
    }

    public TableViewSWT initYourTableView() {
        return this.tv;
    }

    private void defaultSelected(TableRowCore[] rows) {
        ShareResource share = (ShareResource)this.tv.getFirstSelectedDataSource();
        if (share == null) {
            return;
        }
        List dms = AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
        for (int i = 0; i < dms.size(); ++i) {
            org.gudy.azureus2.core3.download.DownloadManager dm = (org.gudy.azureus2.core3.download.DownloadManager)dms.get(i);
            try {
                byte[] share_hash = null;
                if (share.getType() == 2) {
                    share_hash = ((ShareResourceDir)share).getItem().getTorrent().getHash();
                } else if (share.getType() == 1) {
                    share_hash = ((ShareResourceFile)share).getItem().getTorrent().getHash();
                }
                if (!Arrays.equals(share_hash, dm.getTorrent().getHash())) continue;
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions == null) break;
                uiFunctions.openView(5, dm);
                break;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void tableViewInitialized() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                MySharesView.this.createRows(core);
            }
        });
    }

    public void tableViewDestroyed() {
        try {
            PluginInitializer.getDefaultInterface().getShareManager().removeListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void createRows(AzureusCore core) {
        try {
            ShareManager sm = core.getPluginManager().getDefaultPluginInterface().getShareManager();
            ShareResource[] shares = sm.getShares();
            for (int i = 0; i < shares.length; ++i) {
                this.resourceAdded(shares[i]);
            }
            sm.addListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
    }

    public void fillMenu(String sColumnName, Menu menu) {
        Shell shell = menu.getShell();
        this.menuCategory = new Menu(shell, 4);
        MenuItem itemCategory = new MenuItem(menu, 64);
        Messages.setLanguageText(itemCategory, "MyTorrentsView.menu.setCategory");
        itemCategory.setMenu(this.menuCategory);
        this.addCategorySubMenu();
        new MenuItem(menu, 2);
        MenuItem itemRemove = new MenuItem(menu, 8);
        Messages.setLanguageText(itemRemove, "MySharesView.menu.remove");
        Utils.setMenuItemImage(itemRemove, "delete");
        Object[] shares = this.tv.getSelectedDataSources().toArray();
        itemRemove.setEnabled(shares.length > 0);
        itemRemove.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                MySharesView.this.removeSelectedShares();
            }
        });
        new MenuItem(menu, 2);
    }

    public void resourceAdded(ShareResource resource) {
        this.tv.addDataSource(resource);
    }

    public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
        this.tv.removeDataSource(old_resource);
        this.tv.addDataSource(new_resource);
    }

    public void resourceDeleted(ShareResource resource) {
        this.tv.removeDataSource(resource);
    }

    public void reportProgress(int percent_complete) {
    }

    public void reportCurrentTask(String task_description) {
    }

    public void tableRefresh() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    private void addCategorySubMenu() {
        int i;
        MenuItem[] items = this.menuCategory.getItems();
        for (i = 0; i < items.length; ++i) {
            items[i].dispose();
        }
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            MenuItem itemCategory;
            Category catUncat = CategoryManager.getCategory(2);
            if (catUncat != null) {
                itemCategory = new MenuItem(this.menuCategory, 8);
                Messages.setLanguageText(itemCategory, catUncat.getName());
                itemCategory.setData("Category", catUncat);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
                new MenuItem(this.menuCategory, 2);
            }
            for (i = 0; i < categories.length; ++i) {
                if (categories[i].getType() != 0) continue;
                itemCategory = new MenuItem(this.menuCategory, 8);
                itemCategory.setText(categories[i].getName());
                itemCategory.setData("Category", categories[i]);
                itemCategory.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        MenuItem item = (MenuItem)event2.widget;
                        MySharesView.this.assignSelectedToCategory((Category)item.getData("Category"));
                    }
                });
            }
            new MenuItem(this.menuCategory, 2);
        }
        MenuItem itemAddCategory = new MenuItem(this.menuCategory, 8);
        Messages.setLanguageText(itemAddCategory, "MyTorrentsView.menu.setCategory.add");
        itemAddCategory.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MySharesView.this.addCategory();
            }
        });
    }

    private void addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(Display.getDefault());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
    }

    private void assignSelectedToCategory(final Category category) {
        this.tv.runForSelectedRows(new TableGroupRowRunner(){

            public void run(TableRowCore row) {
                String value = category == null ? null : (category == CategoryManager.getCategory(2) ? null : category.getName());
                ((ShareResource)row.getDataSource(true)).setAttribute(category_attribute, value);
            }
        });
    }

    public void refreshToolBar(Map list) {
        boolean start = false;
        boolean stop = false;
        boolean remove = false;
        if (!AzureusCoreFactory.isCoreRunning()) {
            return;
        }
        List items = this.getSelectedItems();
        if (items.size() > 0) {
            PluginInterface pi = PluginInitializer.getDefaultInterface();
            DownloadManager dm = pi.getDownloadManager();
            remove = true;
            for (int i = 0; i < items.size(); ++i) {
                ShareItem item = (ShareItem)items.get(i);
                try {
                    int dl_state;
                    Torrent t = item.getTorrent();
                    Download download = dm.getDownload(t);
                    if (download == null || (dl_state = download.getState()) == 8) continue;
                    if (dl_state != 7) {
                        stop = true;
                        continue;
                    }
                    start = true;
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        list.put("start", start);
        list.put("stop", stop);
        list.put("remove", remove);
        super.refreshToolBar(list);
    }

    public boolean toolBarItemActivated(String itemKey) {
        if (itemKey.equals("remove")) {
            this.removeSelectedShares();
            return true;
        }
        if (itemKey.equals("stop")) {
            this.stopSelectedShares();
            return true;
        }
        if (itemKey.equals("start")) {
            this.startSelectedShares();
            return true;
        }
        return super.toolBarItemActivated(itemKey);
    }

    private List getSelectedItems() {
        Object[] shares = this.tv.getSelectedDataSources().toArray();
        ArrayList<ShareItem> items = new ArrayList<ShareItem>();
        if (shares.length > 0) {
            for (int i = 0; i < shares.length; ++i) {
                ShareResource sr;
                ShareResource share = (ShareResource)shares[i];
                int type = share.getType();
                if (type == 2) {
                    sr = (ShareResourceDir)share;
                    items.add(sr.getItem());
                    continue;
                }
                if (type == 1) {
                    sr = (ShareResourceFile)share;
                    items.add(sr.getItem());
                    continue;
                }
                ShareResourceDirContents cont = (ShareResourceDirContents)share;
                ArrayList entries = new ArrayList();
                this.getEntries(entries, cont);
                for (int j = 0; j < entries.size(); ++j) {
                    ShareResource sr2;
                    share = (ShareResource)entries.get(j);
                    type = share.getType();
                    if (type == 2) {
                        sr2 = (ShareResourceDir)share;
                        items.add(sr2.getItem());
                        continue;
                    }
                    if (type != 1) continue;
                    sr2 = (ShareResourceFile)share;
                    items.add(sr2.getItem());
                }
            }
        }
        return items;
    }

    private void getEntries(List entries, ShareResourceDirContents cont) {
        ShareResource[] kids = cont.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            ShareResource share = kids[i];
            int type = share.getType();
            if (type == 3) {
                this.getEntries(entries, (ShareResourceDirContents)share);
                continue;
            }
            entries.add(share);
        }
    }

    private void startStopSelectedShares(boolean do_stop) {
        List items = this.getSelectedItems();
        if (items.size() == 0) {
            return;
        }
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        DownloadManager dm = pi.getDownloadManager();
        Tracker tracker = pi.getTracker();
        for (int i = 0; i < items.size(); ++i) {
            ShareItem item = (ShareItem)items.get(i);
            try {
                int dl_state;
                Torrent t = item.getTorrent();
                TrackerTorrent tracker_torrent = tracker.getTorrent(t);
                Download download = dm.getDownload(t);
                if (tracker_torrent == null || download == null || (dl_state = download.getState()) == 8) continue;
                if (dl_state != 7) {
                    if (!do_stop) continue;
                    try {
                        download.stop();
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    try {
                        tracker_torrent.stop();
                    }
                    catch (Throwable e) {}
                    continue;
                }
                if (do_stop) continue;
                try {
                    download.restart();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    tracker_torrent.start();
                }
                catch (Throwable e) {}
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    private void startSelectedShares() {
        this.startStopSelectedShares(false);
    }

    private void stopSelectedShares() {
        this.startStopSelectedShares(true);
    }

    private void removeSelectedShares() {
        this.stopSelectedShares();
        Object[] shares = this.tv.getSelectedDataSources().toArray();
        for (int i = 0; i < shares.length; ++i) {
            try {
                ((ShareResource)shares[i]).delete();
                continue;
            }
            catch (Throwable e) {
                Logger.log(new LogAlert(shares[i], false, "{globalmanager.download.remove.veto}", e));
            }
        }
    }

    public void addThisColumnSubMenu(String columnName, Menu menuThisColumn) {
    }

    public void defaultSelected(TableRowCore[] rows, int stateMask) {
    }

    public void deselected(TableRowCore[] rows) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    public void focusChanged(TableRowCore focus) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }

    public void mouseEnter(TableRowCore row) {
    }

    public void mouseExit(TableRowCore row) {
    }

    public void selected(TableRowCore[] row) {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.refreshIconBar();
        }
    }
}

