/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionListener;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStateAttributeListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.FilesViewMenuUtil;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.file.FileInfoView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;
import org.gudy.azureus2.ui.swt.views.tableitems.files.DoneItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FileExtensionItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.FirstPieceItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ModeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.NameItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PathItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PercentItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PieceCountItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.PriorityItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.ProgressGraphItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.RemainingPiecesItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.SizeItem;
import org.gudy.azureus2.ui.swt.views.tableitems.files.StorageTypeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesView
extends TableViewTab<DiskManagerFileInfo>
implements TableDataSourceChangedListener,
TableSelectionListener,
TableViewSWTMenuFillListener,
TableRefreshListener,
DownloadManagerStateAttributeListener,
TableLifeCycleListener {
    boolean refreshing = false;
    private DragSource dragSource = null;
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new PathItem(), new SizeItem(), new DoneItem(), new PercentItem(), new FirstPieceItem(), new PieceCountItem(), new RemainingPiecesItem(), new ProgressGraphItem(), new ModeItem(), new PriorityItem(), new StorageTypeItem(), new FileExtensionItem()};
    private DownloadManager manager = null;
    public static boolean show_full_path;
    private MenuItem path_item;
    private TableViewSWT<DiskManagerFileInfo> tv;
    private final boolean allowTabViews;
    private boolean force_refresh = false;

    public FilesView() {
        super("FilesView");
        this.allowTabViews = true;
    }

    public FilesView(boolean allowTabViews) {
        super("FilesView");
        this.allowTabViews = allowTabViews;
    }

    @Override
    public TableViewSWT<DiskManagerFileInfo> initYourTableView() {
        this.tv = new TableViewSWTImpl<DiskManagerFileInfo>(org.gudy.azureus2.plugins.disk.DiskManagerFileInfo.class, "Files", this.getPropertiesPrefix(), basicItems, "firstpiece", 0x10010002);
        this.tv.setRowDefaultIconSize(new Point(16, 16));
        if (this.allowTabViews) {
            this.tv.setEnableTabViews(true);
            this.tv.setCoreTabViews(new IView[]{new FileInfoView()});
        }
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addRefreshListener(this, true);
        this.tv.addSelectionListener(this, false);
        this.tv.addMenuFillListener(this);
        this.tv.addLifeCycleListener(this);
        return this.tv;
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        DownloadManager old_manager = this.manager;
        this.manager = newDataSource == null ? null : (newDataSource instanceof Object[] ? (DownloadManager)((Object[])newDataSource)[0] : (DownloadManager)newDataSource);
        if (old_manager != null) {
            old_manager.getDownloadState().removeListener(this, "filelinks", 1);
        }
        if (this.manager != null) {
            this.manager.getDownloadState().addListener(this, "filelinks", 1);
        }
        this.tv.removeAllTableRows();
    }

    @Override
    public void deselected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    @Override
    public void focusChanged(TableRowCore focus) {
    }

    @Override
    public void selected(TableRowCore[] rows) {
        this.updateSelectedContent();
    }

    public void updateSelectedContent() {
        Object[] dataSources = this.tv.getSelectedDataSources(true);
        ArrayList<SelectedContent> listSelected = new ArrayList<SelectedContent>(dataSources.length);
        for (Object ds : dataSources) {
            if (!(ds instanceof DiskManagerFileInfo)) continue;
            DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)ds;
            listSelected.add(new SelectedContent(fileInfo2.getDownloadManager(), fileInfo2.getIndex()));
        }
        SelectedContentManager.changeCurrentlySelectedContent(this.tv.getTableID(), listSelected.toArray(new SelectedContent[0]), this.tv);
    }

    @Override
    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        DownloadManager dm;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)this.tv.getFirstSelectedDataSource();
        if (fileInfo2 == null) {
            return;
        }
        AZ3Functions.provider az3 = AZ3Functions.getProvider();
        if (az3 != null && (az3.canPlay(dm = fileInfo2.getDownloadManager(), fileInfo2.getIndex()) || (stateMask & 0x40000) > 0)) {
            az3.play(dm, fileInfo2.getIndex());
            return;
        }
        if (fileInfo2.getAccessMode() == 1) {
            Utils.launch(fileInfo2);
        }
    }

    @Override
    public void fillMenu(String sColumnName, Menu menu) {
        Object[] data_sources = this.tv.getSelectedDataSources().toArray();
        FilesViewMenuUtil.fillMenu(this.tv, menu, this.manager, data_sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableRefresh() {
        if (this.refreshing) {
            return;
        }
        try {
            this.refreshing = true;
            if (this.tv.isDisposed()) {
                Object var8_1 = null;
                this.refreshing = false;
                return;
            }
            DiskManagerFileInfo[] files = this.getFileInfo();
            if (files != null && (this.force_refresh || !this.doAllExist(files))) {
                this.force_refresh = false;
                List datasources = this.tv.getDataSources();
                if (datasources.size() == files.length) {
                    ArrayList<DiskManagerFileInfo> toAdd = new ArrayList<DiskManagerFileInfo>(Arrays.asList(files));
                    ArrayList<DiskManagerFileInfo> toRemove = new ArrayList<DiskManagerFileInfo>();
                    for (int i = 0; i < datasources.size(); ++i) {
                        DiskManagerFileInfo info = (DiskManagerFileInfo)datasources.get(i);
                        if (files[info.getIndex()] == info) {
                            toAdd.set(info.getIndex(), null);
                            continue;
                        }
                        toRemove.add(info);
                    }
                    this.tv.removeDataSources((DiskManagerFileInfo[])toRemove.toArray(new DiskManagerFileInfo[toRemove.size()]));
                    this.tv.addDataSources((DiskManagerFileInfo[])toAdd.toArray(new DiskManagerFileInfo[toAdd.size()]));
                    ((TableViewSWTImpl)this.tv).tableInvalidate();
                } else {
                    this.tv.removeAllTableRows();
                    DiskManagerFileInfo[] filesCopy = new DiskManagerFileInfo[files.length];
                    System.arraycopy(files, 0, filesCopy, 0, files.length);
                    this.tv.addDataSources((DiskManagerFileInfo[])filesCopy);
                }
                this.tv.processDataSourceQueue();
            }
        }
        catch (Throwable throwable) {
            Object var8_3 = null;
            this.refreshing = false;
            throw throwable;
        }
        Object var8_2 = null;
        this.refreshing = false;
    }

    private boolean doAllExist(DiskManagerFileInfo[] files) {
        for (int i = 0; i < files.length; ++i) {
            DiskManagerFileInfo fileinfo = files[i];
            TableRowCore row = this.tv.getRow(fileinfo);
            if (row == null) {
                return false;
            }
            if (row.getDataSource(true) == fileinfo) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addThisColumnSubMenu(String sColumnName, Menu menuThisColumn) {
        if (sColumnName.equals("path")) {
            this.path_item = new MenuItem(menuThisColumn, 32);
            this.path_item.setSelection(show_full_path);
            Messages.setLanguageText(this.path_item, "FilesView.fullpath");
            this.path_item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    show_full_path = FilesView.this.path_item.getSelection();
                    FilesView.this.tv.columnInvalidate("path");
                    FilesView.this.tv.refreshTable(false);
                    COConfigurationManager.setParameter("FilesView.show.full.path", show_full_path);
                }
            });
        }
    }

    private DiskManagerFileInfo[] getFileInfo() {
        if (this.manager == null) {
            return null;
        }
        return this.manager.getDiskManagerFileInfo();
    }

    @Override
    public void attributeEventOccurred(DownloadManager dm, String attribute_name, int event_type) {
        Object oIsChangingLinks = dm.getUserData("is_changing_links");
        if (oIsChangingLinks instanceof Boolean && ((Boolean)oIsChangingLinks).booleanValue()) {
            return;
        }
        this.force_refresh = true;
    }

    @Override
    public void tableViewInitialized() {
        this.createDragDrop();
    }

    @Override
    public void tableViewDestroyed() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                try {
                    Utils.disposeSWTObjects(new Object[]{FilesView.this.dragSource});
                    FilesView.this.dragSource = null;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        });
        if (this.manager != null) {
            this.manager.getDownloadState().removeListener(this, "filelinks", 1);
        }
    }

    @Override
    public void mouseEnter(TableRowCore row) {
    }

    @Override
    public void mouseExit(TableRowCore row) {
    }

    private void createDragDrop() {
        try {
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            if (this.dragSource != null && !this.dragSource.isDisposed()) {
                this.dragSource.dispose();
            }
            this.dragSource = this.tv.createDragSource(3);
            if (this.dragSource != null) {
                this.dragSource.setTransfer(types);
                this.dragSource.addDragListener(new DragSourceAdapter(){
                    private String eventData;

                    public void dragStart(DragSourceEvent event2) {
                        TableRowCore[] rows = FilesView.this.tv.getSelectedRows();
                        if (rows.length == 0 || FilesView.this.manager == null || FilesView.this.manager.getTorrent() == null) {
                            event2.doit = false;
                            return;
                        }
                        event2.doit = true;
                        Object[] selectedDownloads = FilesView.this.tv.getSelectedDataSources().toArray();
                        this.eventData = "DiskManagerFileInfo\n";
                        TOTorrent torrent = FilesView.this.manager.getTorrent();
                        for (int i = 0; i < selectedDownloads.length; ++i) {
                            DiskManagerFileInfo fi = (DiskManagerFileInfo)selectedDownloads[i];
                            try {
                                this.eventData = this.eventData + torrent.getHashWrapper().toBase32String() + ";" + fi.getIndex() + "\n";
                                continue;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }

                    public void dragSetData(DragSourceEvent event2) {
                        event2.data = this.eventData;
                    }
                });
            }
        }
        catch (Throwable t) {
            Logger.log(new LogEvent(LogIDs.GUI, "failed to init drag-n-drop", t));
        }
    }

    @Override
    public void refreshToolBar(Map<String, Boolean> list) {
        ISelectedContent[] content = SelectedContentManager.getCurrentlySelectedContent();
        Map<String, Boolean> states = TorrentUtil.calculateToolbarStates(content, this.tv.getTableID());
        list.putAll(states);
        list.put("up", false);
        list.put("down", false);
        super.refreshToolBar(list);
    }

    @Override
    public boolean toolBarItemActivated(String itemKey) {
        Object[] selected = this.tv.getSelectedDataSources().toArray();
        if (selected.length > 0) {
            if (itemKey.equals("run")) {
                TorrentUtil.runDataSources(selected);
                return true;
            }
            if (itemKey.equals("start")) {
                TorrentUtil.queueDataSources(selected, false);
                UIFunctionsManagerSWT.getUIFunctionsSWT().refreshIconBar();
                return true;
            }
            if (itemKey.equals("stop")) {
                TorrentUtil.stopDataSources(selected);
                UIFunctionsManagerSWT.getUIFunctionsSWT().refreshIconBar();
                return true;
            }
            if (itemKey.equals("remove")) {
                TorrentUtil.removeDataSources(selected);
                UIFunctionsManagerSWT.getUIFunctionsSWT().refreshIconBar();
                return true;
            }
        }
        return super.toolBarItemActivated(itemKey);
    }

    static {
        COConfigurationManager.addAndFireParameterListener("FilesView.show.full.path", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                show_full_path = COConfigurationManager.getBooleanParameter("FilesView.show.full.path");
            }
        });
    }
}

