/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.animations.Animator;
import org.gudy.azureus2.ui.swt.animations.shell.AnimableShell;
import org.gudy.azureus2.ui.swt.animations.shell.LinearAnimator;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;

public class MessagePopupShell
implements AnimableShell {
    private Shell shell;
    private Shell detailsShell;
    Image shellImg;
    private Display display;
    public static final String ICON_ERROR = "error";
    public static final String ICON_WARNING = "warning";
    public static final String ICON_INFO = "info";
    private static LinkedList viewStack = new LinkedList();
    private Timer closeTimer = new Timer(true);
    private String icon;
    private Animator currentAnimator;
    private boolean closeAfterAnimation;
    int x0;
    int y0;
    int x1;
    int y1;

    public MessagePopupShell(String icon, String keyPrefix, String details, String[] textParams, Display display) {
        this(display, icon, MessageText.getString(keyPrefix + ".title"), MessageText.getString(keyPrefix + ".text", textParams), details);
    }

    public MessagePopupShell(Display display, String icon, String title, String errorMessage, String details) {
        this.display = display;
        this.icon = icon;
        this.detailsShell = new Shell(display, 18432);
        Utils.setShellIcon(this.detailsShell);
        this.detailsShell.setLayout(new FillLayout());
        StyledText textDetails = new StyledText(this.detailsShell, 2824);
        textDetails.setBackground(display.getSystemColor(1));
        textDetails.setWordWrap(true);
        this.detailsShell.layout();
        this.detailsShell.setSize(550, 300);
        int popupWidth = 280;
        int popupHeight = 170;
        this.shell = new Shell(display, 16384);
        Utils.setShellIcon(this.shell);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        try {
            layout.spacing = 0;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        this.shell.setLayout(layout);
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image popup_image = imageLoader.getImage("popup");
        GC gcImage = null;
        if (ImageLoader.isRealImage(popup_image)) {
            this.shellImg = new Image((Device)display, popup_image, 0);
            popupWidth = popup_image.getBounds().width;
            popupHeight = popup_image.getBounds().height;
        } else {
            this.shellImg = new Image((Device)display, new Rectangle(0, 0, popupWidth, popupHeight));
        }
        imageLoader.releaseImage("popup");
        this.shell.setSize(popupWidth, popupHeight);
        gcImage = new GC(this.shellImg);
        Image imgIcon = imageLoader.getImage(icon);
        int iconWidth = 0;
        int iconHeight = 15;
        if (ImageLoader.isRealImage(imgIcon)) {
            gcImage.drawImage(imgIcon, 5, 5);
            iconWidth = imgIcon.getBounds().width;
            iconHeight = imgIcon.getBounds().height;
        }
        imageLoader.releaseImage(icon);
        Font tempFont = this.shell.getFont();
        FontData[] fontDataMain = tempFont.getFontData();
        for (int i = 0; i < fontDataMain.length; ++i) {
            fontDataMain[i].setStyle(1);
            fontDataMain[i].setHeight((int)((double)fontDataMain[i].getHeight() * 1.2));
        }
        Font fontTitle = new Font((Device)display, fontDataMain);
        gcImage.setFont(fontTitle);
        Rectangle rect = new Rectangle(iconWidth + 10, 5, popupWidth - iconWidth - 15, iconHeight);
        GCStringPrinter.printString(gcImage, title, rect);
        gcImage.setFont(tempFont);
        fontTitle.dispose();
        rect = new Rectangle(5, iconHeight + 5, popupWidth - 10, popupHeight - iconHeight - 60);
        boolean bItFit = GCStringPrinter.printString(gcImage, errorMessage, rect);
        gcImage.dispose();
        if (!bItFit && details == null) {
            details = errorMessage;
        }
        if (details != null) {
            textDetails.setText(details);
        }
        final Button btnDetails = new Button(this.shell, 2);
        Messages.setLanguageText(btnDetails, "popup.error.details");
        btnDetails.setEnabled(details != null);
        final Button btnHide = new Button(this.shell, 8);
        Messages.setLanguageText(btnHide, "popup.error.hide");
        Label lblImage = new Label(this.shell, 0);
        if (this.shellImg != null) {
            lblImage.setImage(this.shellImg);
        }
        FormData formData = new FormData();
        formData.right = new FormAttachment(btnHide, -5);
        formData.bottom = new FormAttachment(100, -5);
        btnDetails.setLayoutData(formData);
        formData = new FormData();
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        btnHide.setLayoutData(formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment(0, 0);
        lblImage.setLayoutData(formData);
        Button btnHideAll = null;
        if (viewStack.size() > 0) {
            btnHideAll = new Button(this.shell, 8);
            btnHideAll.moveAbove(btnDetails);
            Messages.setLanguageText(btnHideAll, "popup.error.hideall");
            formData = new FormData();
            formData.right = new FormAttachment(btnDetails, -5);
            formData.bottom = new FormAttachment(100, -5);
            btnHideAll.setLayoutData(formData);
            btnHideAll.addListener(4, new Listener(){

                public void handleEvent(Event event2) {
                    btnHide.setEnabled(false);
                    btnDetails.setEnabled(false);
                    Iterator iter = viewStack.iterator();
                    while (iter.hasNext()) {
                        WeakReference wr = (WeakReference)iter.next();
                        MessagePopupShell popup = (MessagePopupShell)wr.get();
                        iter.remove();
                        if (popup == null) {
                            return;
                        }
                        popup.shell.dispose();
                        popup.detailsShell.dispose();
                        if (popup.shellImg == null) continue;
                        popup.shellImg.dispose();
                    }
                }
            });
        }
        this.shell.layout();
        this.shell.setTabList(new Control[]{btnDetails, btnHide});
        btnHide.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                btnHide.setEnabled(false);
                btnDetails.setEnabled(false);
                MessagePopupShell.this.hideShell();
            }
        });
        btnDetails.addListener(4, new Listener(){

            public void handleEvent(Event arg0) {
                MessagePopupShell.this.detailsShell.setVisible(btnDetails.getSelection());
            }
        });
        Rectangle bounds = null;
        try {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions != null) {
                Shell mainShell = uiFunctions.getMainShell();
                bounds = mainShell.getMonitor().getClientArea();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bounds == null) {
            bounds = display.getClientArea();
        }
        this.x0 = bounds.x + bounds.width - popupWidth - 5;
        this.x1 = bounds.x + bounds.width;
        this.y0 = bounds.y + bounds.height;
        this.y1 = bounds.y + bounds.height - popupHeight - 5;
        this.shell.setLocation(this.x0, this.y0);
        viewStack.addFirst(new WeakReference<MessagePopupShell>(this));
        this.detailsShell.setLocation(this.x1 - this.detailsShell.getSize().x, this.y1 - this.detailsShell.getSize().y);
        this.currentAnimator = new LinearAnimator(this, new Point(this.x0, this.y0), new Point(this.x0, this.y1), 20, 30);
        this.currentAnimator.start();
        this.shell.open();
    }

    private void hideShell() {
        try {
            if (this.currentAnimator == null) {
                this.closeTimer.cancel();
                this.detailsShell.setVisible(false);
                this.detailsShell.forceActive();
                if (!Constants.isOSX) {
                    this.detailsShell.forceFocus();
                }
                this.currentAnimator = new LinearAnimator(this, new Point(this.x0, this.y1), new Point(this.x1, this.y1), 20, 30);
                this.currentAnimator.start();
                this.closeAfterAnimation = true;
            }
        }
        catch (Exception e) {
            this.closeAfterAnimation = true;
            this.animationEnded(null);
        }
    }

    public void animationEnded(Animator source) {
        if (source == this.currentAnimator) {
            this.currentAnimator = null;
        }
        if (this.closeAfterAnimation) {
            if (this.display == null || this.display.isDisposed()) {
                return;
            }
            this.display.asyncExec(new AERunnable(){

                public void runSupport() {
                    viewStack.removeFirst();
                    MessagePopupShell.this.shell.dispose();
                    MessagePopupShell.this.detailsShell.dispose();
                    if (MessagePopupShell.this.shellImg != null) {
                        MessagePopupShell.this.shellImg.dispose();
                    }
                }
            });
        } else {
            this.scheduleAutocloseTask();
        }
    }

    private void scheduleAutocloseTask() {
        int delay = COConfigurationManager.getIntParameter("Message Popup Autoclose in Seconds") * 1000;
        if (delay < 1000) {
            return;
        }
        this.closeTimer.scheduleAtFixedRate(new TimerTask(){

            public void run() {
                MessagePopupShell.this.display.syncExec(new AERunnable(){

                    public void runSupport() {
                        boolean mouseOver;
                        boolean notInfoType;
                        if (MessagePopupShell.this.shell.isDisposed()) {
                            MessagePopupShell.this.closeTimer.cancel();
                            return;
                        }
                        boolean bl = notInfoType = MessagePopupShell.this.icon != MessagePopupShell.ICON_INFO;
                        if (notInfoType) {
                            MessagePopupShell.this.closeTimer.cancel();
                            return;
                        }
                        boolean notTopWindow = ((WeakReference)viewStack.getFirst()).get() != MessagePopupShell.this;
                        boolean animationInProgress = MessagePopupShell.this.currentAnimator != null;
                        boolean detailsOpen = !MessagePopupShell.this.detailsShell.isDisposed() && MessagePopupShell.this.detailsShell.isVisible();
                        Control cc = MessagePopupShell.this.display.getCursorControl();
                        boolean bl2 = mouseOver = cc == MessagePopupShell.this.shell;
                        if (!mouseOver) {
                            Control[] childControls = MessagePopupShell.this.shell.getChildren();
                            for (int i = 0; i < childControls.length; ++i) {
                                if (childControls[i] != cc) continue;
                                mouseOver = true;
                                break;
                            }
                        }
                        if (notTopWindow || mouseOver || animationInProgress || detailsOpen) {
                            return;
                        }
                        MessagePopupShell.this.hideShell();
                    }
                });
            }
        }, delay, (long)delay);
    }

    public void animationStarted(Animator source) {
    }

    public Shell getShell() {
        return this.shell;
    }

    public void reportPercent(int percent) {
    }
}

