/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.sharing.progress;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareManager;
import org.gudy.azureus2.plugins.sharing.ShareManagerListener;
import org.gudy.azureus2.plugins.sharing.ShareResource;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.animations.Animator;
import org.gudy.azureus2.ui.swt.animations.shell.AnimableShell;
import org.gudy.azureus2.ui.swt.animations.shell.LinearAnimator;
import org.gudy.azureus2.ui.swt.shells.PopupShell;

public class ProgressWindow
implements ShareManagerListener {
    private boolean DO_ANIMATION = false;
    private ShareManager share_manager;
    private progressDialog dialog = null;
    private Display display;
    private StyledText tasks;
    private ProgressBar progress;
    private Button cancel_button;
    private boolean shell_opened;
    private boolean manually_hidden;

    public ProgressWindow(Display _display) {
        try {
            this.share_manager = PluginInitializer.getDefaultInterface().getShareManager();
            this.display = _display;
            this.share_manager.addListener(this);
        }
        catch (ShareException e) {
            Debug.printStackTrace(e);
        }
    }

    public void resourceAdded(ShareResource resource) {
        if (!this.share_manager.isInitialising()) {
            this.reportCurrentTask("Resource added: " + resource.getName());
        }
    }

    public void resourceModified(ShareResource old_resource, ShareResource new_resource) {
        this.reportCurrentTask("Resource modified: " + old_resource.getName());
    }

    public void resourceDeleted(ShareResource resource) {
        this.reportCurrentTask("Resource deleted: " + resource.getName());
    }

    public void reportProgress(final int percent_complete) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (ProgressWindow.this.progress != null && !ProgressWindow.this.progress.isDisposed()) {
                    if (ProgressWindow.this.dialog == null) {
                        ProgressWindow.this.dialog = new progressDialog(ProgressWindow.this.display);
                        if (ProgressWindow.this.dialog == null) {
                            return;
                        }
                    }
                    if (!ProgressWindow.this.dialog.isShown() && !ProgressWindow.this.manually_hidden) {
                        ProgressWindow.this.dialog.showPanel();
                    }
                    ProgressWindow.this.cancel_button.setEnabled(percent_complete < 100);
                    ProgressWindow.this.progress.setSelection(percent_complete);
                }
            }
        });
    }

    public void reportCurrentTask(final String task_description) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (ProgressWindow.this.dialog == null) {
                    ProgressWindow.this.dialog = new progressDialog(ProgressWindow.this.display);
                    if (ProgressWindow.this.dialog == null) {
                        return;
                    }
                }
                if (ProgressWindow.this.tasks != null && !ProgressWindow.this.tasks.isDisposed()) {
                    ProgressWindow.this.dialog.showPanel();
                    ProgressWindow.this.tasks.append(task_description + Text.DELIMITER);
                    int lines = ProgressWindow.this.tasks.getLineCount();
                    ProgressWindow.this.tasks.setTopIndex(lines - 1);
                }
            }
        });
    }

    private class progressDialog
    extends PopupShell
    implements AnimableShell {
        Animator currentAnimator;
        int x0;
        int y0;
        int x1;
        int y1;
        boolean isAnimated;
        boolean hideAfter;

        protected progressDialog(Display dialog_display) {
            super(dialog_display);
            if (dialog_display.isDisposed()) {
                return;
            }
            this.shell.setText(MessageText.getString("sharing.progress.title"));
            ProgressWindow.this.tasks = new StyledText(this.shell, 2824);
            ProgressWindow.this.tasks.setBackground(dialog_display.getSystemColor(1));
            ProgressWindow.this.progress = new ProgressBar(this.shell, 0);
            ProgressWindow.this.progress.setMinimum(0);
            ProgressWindow.this.progress.setMaximum(100);
            Button hide_button = new Button(this.shell, 8);
            hide_button.setText(MessageText.getString("sharing.progress.hide"));
            ProgressWindow.this.cancel_button = new Button(this.shell, 8);
            ProgressWindow.this.cancel_button.setText(MessageText.getString("sharing.progress.cancel"));
            ProgressWindow.this.cancel_button.setEnabled(false);
            FormData formData = new FormData();
            formData.right = new FormAttachment(100, -5);
            formData.bottom = new FormAttachment(100, -10);
            hide_button.setLayoutData(formData);
            formData = new FormData();
            formData.right = new FormAttachment(hide_button, -5);
            formData.bottom = new FormAttachment(100, -10);
            ProgressWindow.this.cancel_button.setLayoutData(formData);
            formData = new FormData();
            formData.right = new FormAttachment(ProgressWindow.this.cancel_button, -5);
            formData.left = new FormAttachment(0, 50);
            formData.bottom = new FormAttachment(100, -10);
            ProgressWindow.this.progress.setLayoutData(formData);
            formData = new FormData();
            formData.right = new FormAttachment(100, -5);
            formData.bottom = new FormAttachment(100, -50);
            formData.top = new FormAttachment(0, 5);
            formData.left = new FormAttachment(0, 5);
            ProgressWindow.this.tasks.setLayoutData(formData);
            this.layout();
            ProgressWindow.this.cancel_button.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ProgressWindow.this.cancel_button.setEnabled(false);
                    ProgressWindow.this.share_manager.cancelOperation();
                }
            });
            hide_button.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    progressDialog.this.hidePanel();
                }
            });
            this.shell.setDefaultButton(hide_button);
            this.shell.addListener(31, new Listener(){

                public void handleEvent(Event e) {
                    if (e.character == '\u001b') {
                        progressDialog.this.hidePanel();
                    }
                }
            });
            Rectangle bounds = this.shell.getMonitor().getClientArea();
            this.x0 = bounds.x + bounds.width - 255;
            this.x1 = bounds.x + bounds.width;
            this.y0 = bounds.y + bounds.height;
            this.y1 = bounds.y + bounds.height - 155;
            if (ProgressWindow.this.DO_ANIMATION) {
                this.shell.setLocation(this.x0, this.y0);
            } else {
                this.shell.setLocation(this.x0, this.y1);
            }
        }

        protected void hidePanel() {
            ProgressWindow.this.manually_hidden = true;
            if (ProgressWindow.this.DO_ANIMATION) {
                this.currentAnimator = new LinearAnimator(this, new Point(this.x0, this.y1), new Point(this.x1, this.y1), 15, 30);
                this.currentAnimator.start();
                this.hideAfter = true;
            } else {
                this.shell.setVisible(false);
            }
        }

        protected void showPanel() {
            ProgressWindow.this.manually_hidden = false;
            boolean animate = false;
            if (!ProgressWindow.this.shell_opened) {
                ProgressWindow.this.shell_opened = true;
                this.shell.open();
                animate = ProgressWindow.this.DO_ANIMATION;
            }
            if (!this.shell.isVisible()) {
                this.shell.setVisible(true);
                animate = ProgressWindow.this.DO_ANIMATION;
            }
            this.shell.moveAbove(null);
            if (animate && this.currentAnimator == null) {
                this.currentAnimator = new LinearAnimator(this, new Point(this.x0, this.y0), new Point(this.x0, this.y1), 15, 30);
                this.currentAnimator.start();
            }
        }

        protected boolean isShown() {
            return this.shell.isVisible();
        }

        public void animationEnded(Animator source) {
            if (source != this.currentAnimator) {
                return;
            }
            this.isAnimated = false;
            this.currentAnimator = null;
            if (this.hideAfter) {
                this.hideAfter = false;
                if (ProgressWindow.this.display == null || ProgressWindow.this.display.isDisposed()) {
                    return;
                }
                ProgressWindow.this.display.asyncExec(new AERunnable(){

                    public void runSupport() {
                        progressDialog.this.shell.setVisible(false);
                    }
                });
            }
        }

        public void animationStarted(Animator source) {
        }

        public Shell getShell() {
            return this.shell;
        }

        public void reportPercent(int percent) {
        }
    }
}

