/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.minibar;

import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.minibar.MiniBar;
import org.gudy.azureus2.ui.swt.minibar.MiniBarManager;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class AllTransfersBar
extends MiniBar {
    private static MiniBarManager manager = new MiniBarManager("AllTransfersBar");
    private GlobalManager g_manager;
    private Label down_speed;
    private Label up_speed;

    public static MiniBarManager getManager() {
        return manager;
    }

    public static AllTransfersBar getBarIfOpen(GlobalManager g_manager) {
        return (AllTransfersBar)manager.getMiniBarForObject(g_manager);
    }

    public static AllTransfersBar open(GlobalManager g_manager, Shell main) {
        AllTransfersBar result = AllTransfersBar.getBarIfOpen(g_manager);
        if (result == null) {
            result = new AllTransfersBar(g_manager, main);
        }
        return result;
    }

    public static void close(GlobalManager g_manager) {
        AllTransfersBar result = AllTransfersBar.getBarIfOpen(g_manager);
        if (result != null) {
            result.close();
        }
    }

    private AllTransfersBar(GlobalManager gmanager, Shell main) {
        super(manager);
        this.g_manager = gmanager;
        this.construct(main);
    }

    public Object getContextObject() {
        return this.g_manager;
    }

    public void beginConstruction() {
        this.createFixedTextLabel("MinimizedWindow.all_transfers", false, true);
        this.createGap(40);
        this.createFixedTextLabel("ConfigView.download.abbreviated", false, false);
        this.down_speed = this.createSpeedLabel();
        this.createFixedTextLabel("ConfigView.upload.abbreviated", false, false);
        this.up_speed = this.createSpeedLabel();
    }

    public void buildMenu(Menu menu, MenuEvent menuEvent) {
        MenuItem start_all = new MenuItem(menu, 8);
        Messages.setLanguageText(start_all, "MainWindow.menu.transfers.startalltransfers");
        Utils.setMenuItemImage(start_all, "start");
        start_all.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ManagerUtils.asyncStartAll();
            }
        });
        start_all.setEnabled(true);
        MenuItem stop_all = new MenuItem(menu, 8);
        Messages.setLanguageText(stop_all, "MainWindow.menu.transfers.stopalltransfers");
        Utils.setMenuItemImage(stop_all, "stop");
        stop_all.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ManagerUtils.asyncStopAll();
            }
        });
        stop_all.setEnabled(true);
        MenuItem pause_all = new MenuItem(menu, 8);
        Messages.setLanguageText(pause_all, "MainWindow.menu.transfers.pausetransfers");
        Utils.setMenuItemImage(pause_all, "pause");
        pause_all.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ManagerUtils.asyncPause();
            }
        });
        pause_all.setEnabled(this.g_manager.canPauseDownloads());
        MenuItem resume_all = new MenuItem(menu, 8);
        Messages.setLanguageText(resume_all, "MainWindow.menu.transfers.resumetransfers");
        Utils.setMenuItemImage(resume_all, "resume");
        resume_all.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ManagerUtils.asyncResume();
            }
        });
        resume_all.setEnabled(this.g_manager.canResumeDownloads());
        new MenuItem(menu, 2);
        super.buildMenu(menu);
    }

    protected void refresh0() {
        GlobalManagerStats stats2 = this.g_manager.getStats();
        this.updateSpeedLabel(this.down_speed, stats2.getDataReceiveRate(), stats2.getProtocolReceiveRate());
        this.updateSpeedLabel(this.up_speed, stats2.getDataSendRate(), stats2.getProtocolSendRate());
    }

    public String getPluginMenuIdentifier(Object context2) {
        return "transfersbar";
    }

    protected void storeLastLocation(Point location) {
        COConfigurationManager.setParameter("transferbar.x", location.x);
        COConfigurationManager.setParameter("transferbar.y", location.y);
    }

    protected Point getInitialLocation() {
        if (!COConfigurationManager.getBooleanParameter("Remember transfer bar location")) {
            return null;
        }
        if (!COConfigurationManager.hasParameter("transferbar.x", false)) {
            return null;
        }
        int x = COConfigurationManager.getIntParameter("transferbar.x");
        int y = COConfigurationManager.getIntParameter("transferbar.y");
        return new Point(x, y);
    }
}

