/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config.generic;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;

public class GenericIntParameter {
    private static boolean DEBUG = false;
    private GenericParameterAdapter adapter;
    private int iMinValue = 0;
    private int iMaxValue = -1;
    private int iDefaultValue;
    private String sParamName;
    private boolean bGenerateIntermediateEvents = false;
    private boolean bTriggerOnFocusOut = Utils.isCarbon;
    private Spinner spinner;
    private TimerEvent timedSaveEvent = null;
    private TimerEventPerformer timerEventSave;
    private final boolean delayIntialSet = Utils.isCarbon && System.getProperty("os.version", "").startsWith("10.6");

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name) {
        this.iDefaultValue = adapter.getIntValue(name);
        this.initialize(adapter, composite, name);
    }

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name, int defaultValue) {
        this.iDefaultValue = defaultValue;
        this.initialize(adapter, composite, name);
    }

    public GenericIntParameter(GenericParameterAdapter adapter, Composite composite, String name, int minValue, int maxValue) {
        this.iDefaultValue = adapter.getIntValue(name);
        this.iMinValue = minValue;
        this.iMaxValue = maxValue;
        this.initialize(adapter, composite, name);
    }

    public void initialize(GenericParameterAdapter _adapter, Composite composite, String name) {
        this.adapter = _adapter;
        this.sParamName = name;
        this.timerEventSave = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (GenericIntParameter.this.spinner.isDisposed()) {
                            return;
                        }
                        if (DEBUG) {
                            GenericIntParameter.this.debug("setIntValue to " + GenericIntParameter.this.spinner.getSelection() + " via timeEventSave");
                        }
                        GenericIntParameter.this.adapter.setIntValue(GenericIntParameter.this.sParamName, GenericIntParameter.this.spinner.getSelection());
                    }
                });
            }
        };
        int value = this.adapter.getIntValue(name, this.iDefaultValue);
        this.spinner = new Spinner(composite, 2048);
        this.setMinimumValue(this.iMinValue);
        this.setMaximumValue(this.iMaxValue);
        this.spinner.setSelection(value);
        if (this.delayIntialSet) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    GenericIntParameter.this.spinner.setSelection(GenericIntParameter.this.adapter.getIntValue(GenericIntParameter.this.sParamName, GenericIntParameter.this.iDefaultValue));
                }
            });
        }
        this.spinner.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                if (GenericIntParameter.this.bGenerateIntermediateEvents || !GenericIntParameter.this.spinner.isFocusControl()) {
                    GenericIntParameter.this.adapter.setIntValue(GenericIntParameter.this.sParamName, GenericIntParameter.this.spinner.getSelection());
                } else {
                    GenericIntParameter.this.bTriggerOnFocusOut = true;
                    GenericIntParameter.this.cancelTimedSaveEvent();
                    if (DEBUG) {
                        GenericIntParameter.this.debug("create timeSaveEvent (" + GenericIntParameter.this.spinner.getSelection() + ") ");
                    }
                    GenericIntParameter.this.timedSaveEvent = SimpleTimer.addEvent("IntParam Saver", SystemTime.getOffsetTime(750L), GenericIntParameter.this.timerEventSave);
                }
            }
        });
        this.spinner.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                if (GenericIntParameter.this.spinner.isFocusControl()) {
                    if (DEBUG) {
                        GenericIntParameter.this.debug("next");
                    }
                    GenericIntParameter.this.spinner.traverse(16);
                }
            }
        });
        this.spinner.addListener(16, new Listener(){

            public void handleEvent(Event event2) {
                if (GenericIntParameter.this.bTriggerOnFocusOut) {
                    if (DEBUG) {
                        GenericIntParameter.this.debug("focus out setIntValue(" + GenericIntParameter.this.spinner.getSelection() + "/trigger");
                    }
                    GenericIntParameter.this.cancelTimedSaveEvent();
                    GenericIntParameter.this.adapter.setIntValue(GenericIntParameter.this.sParamName, GenericIntParameter.this.spinner.getSelection());
                }
            }
        });
    }

    private void cancelTimedSaveEvent() {
        if (!(this.timedSaveEvent == null || this.timedSaveEvent.hasRun() && this.timedSaveEvent.isCancelled())) {
            if (DEBUG) {
                this.debug("cancel timeSaveEvent");
            }
            this.timedSaveEvent.cancel();
        }
    }

    private void debug(String string) {
        System.out.println("[GenericIntParameter:" + this.sParamName + "] " + string);
    }

    public void setMinimumValue(final int value) {
        this.iMinValue = value;
        if (this.iMinValue > 0 && this.getValue() < this.iMinValue) {
            this.setValue(this.iMinValue);
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                GenericIntParameter.this.spinner.setMinimum(value);
            }
        });
    }

    public void setMaximumValue(int value) {
        this.iMaxValue = value;
        if (this.iMaxValue != -1 && this.getValue() > this.iMaxValue) {
            this.setValue(this.iMaxValue);
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                GenericIntParameter.this.spinner.setMaximum(GenericIntParameter.this.iMaxValue == -1 ? Integer.MAX_VALUE : GenericIntParameter.this.iMaxValue);
            }
        });
    }

    public String getName() {
        return this.sParamName;
    }

    public void setValue(int value) {
        int newValue = this.iMaxValue != -1 && value > this.iMaxValue ? this.iMaxValue : (this.iMinValue > 0 && value < this.iMinValue ? this.iMinValue : value);
        final int finalNewValue = newValue;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (!GenericIntParameter.this.spinner.isDisposed()) {
                    if (GenericIntParameter.this.spinner.getSelection() != finalNewValue) {
                        if (DEBUG) {
                            GenericIntParameter.this.debug("spinner.setSelection(" + finalNewValue + ")");
                        }
                        GenericIntParameter.this.spinner.setSelection(finalNewValue);
                    }
                    if (DEBUG) {
                        GenericIntParameter.this.debug("setIntValue to " + GenericIntParameter.this.spinner.getSelection() + " via setValue(int)");
                    }
                }
            }
        });
        if (finalNewValue != this.getValue()) {
            this.adapter.setIntValue(this.sParamName, finalNewValue);
        }
    }

    public void setValue(final int value, boolean force_adapter_set) {
        if (force_adapter_set) {
            this.setValue(value);
        } else {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (GenericIntParameter.this.spinner.getSelection() != value) {
                        GenericIntParameter.this.spinner.setSelection(value);
                    }
                }
            });
        }
    }

    public int getValue() {
        return this.adapter.getIntValue(this.sParamName, this.iDefaultValue);
    }

    public void resetToDefault() {
        if (this.adapter.resetIntDefault(this.sParamName)) {
            this.setValue(this.adapter.getIntValue(this.sParamName));
        } else {
            this.setValue(this.getValue());
        }
    }

    public void setLayoutData(Object layoutData) {
        this.spinner.setLayoutData(layoutData);
    }

    public Control getControl() {
        return this.spinner;
    }

    public boolean isGeneratingIntermediateEvents() {
        return this.bGenerateIntermediateEvents;
    }

    public void setGenerateIntermediateEvents(boolean generateIntermediateEvents) {
        this.bGenerateIntermediateEvents = generateIntermediateEvents;
    }
}

