/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.components.graphics.BackGroundGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.Scale;
import org.gudy.azureus2.ui.swt.components.graphics.ValueFormater;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class ScaledGraphic
extends BackGroundGraphic {
    protected Scale scale;
    protected ValueFormater formater;
    protected Image bufferScale;
    private int lastMax;
    private int update_divider_width = 0;

    public ScaledGraphic(Scale scale, ValueFormater formater) {
        this.scale = scale;
        this.formater = formater;
    }

    public void setUpdateDividerWidth(int width) {
        this.update_divider_width = width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void drawScale(boolean sizeChanged) {
        boolean scaleChanged;
        if (this.drawCanvas == null) return;
        if (this.drawCanvas.isDisposed()) return;
        if (!this.drawCanvas.isVisible()) {
            return;
        }
        this.drawBackGround(sizeChanged);
        if (this.bufferBackground == null) return;
        if (this.bufferBackground.isDisposed()) {
            return;
        }
        boolean bl = scaleChanged = this.lastMax != this.scale.getMax();
        if (!sizeChanged && !scaleChanged) {
            if (this.bufferScale != null) return;
        }
        Rectangle bounds = this.drawCanvas.getClientArea();
        if (bounds.height < 30) return;
        if (bounds.width < 100) {
            return;
        }
        if (this.bufferScale != null && !this.bufferScale.isDisposed()) {
            this.bufferScale.dispose();
        }
        this.bufferScale = new Image((Device)this.drawCanvas.getDisplay(), bounds);
        GC gcBuffer = new GC(this.bufferScale);
        try {
            try {
                int i;
                gcBuffer.drawImage(this.bufferBackground, 0, 0);
                gcBuffer.setForeground(Colors.black);
                this.scale.setNbPixels(bounds.height - 16);
                int[] levels = this.scale.getScaleValues();
                for (i = 0; i < levels.length; ++i) {
                    int height = bounds.height - this.scale.getScaledValue(levels[i]) - 2;
                    gcBuffer.drawLine(1, height, bounds.width - 70, height);
                    gcBuffer.drawText(this.formater.format(levels[i]), bounds.width - 65, height - 12, true);
                }
                if (this.update_divider_width > 0) {
                    for (i = bounds.width - 70; i > 0; i -= this.update_divider_width) {
                        gcBuffer.setForeground(Colors.grey);
                        gcBuffer.drawLine(i, 0, i, bounds.height);
                    }
                }
                Object var9_9 = null;
            }
            catch (Exception e) {
                Debug.out(e);
                Object var9_10 = null;
                gcBuffer.dispose();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            gcBuffer.dispose();
            throw throwable;
        }
        gcBuffer.dispose();
    }

    public void dispose() {
        super.dispose();
        if (this.bufferScale != null && !this.bufferScale.isDisposed()) {
            this.bufferScale.dispose();
        }
    }
}

