/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.animations.shell;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.ui.swt.animations.Animator;
import org.gudy.azureus2.ui.swt.animations.shell.AnimableShell;

public class LinearAnimator
extends Animator {
    private AnimableShell shell;
    private Display display;
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private int nbSteps;
    private int period;
    private boolean interrupted;

    public LinearAnimator(AnimableShell shell, Point start, Point end, int nbSteps, int period) {
        super("Linear Shell Animator");
        if (period < 20) {
            period = 20;
        }
        if (nbSteps <= 0) {
            nbSteps = 1;
        }
        this.shell = shell;
        this.display = shell.getShell().getDisplay();
        this.startX = start.x;
        this.startY = start.y;
        this.endX = end.x;
        this.endY = end.y;
        this.nbSteps = nbSteps;
        this.period = period;
        this.interrupted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSupport() {
        try {
            this.shell.animationStarted(this);
            int step = 0;
            while (step <= this.nbSteps && !this.interrupted) {
                this.setShellAtStep(step);
                this.shell.reportPercent(100 * step / this.nbSteps);
                ++step;
                try {
                    Thread.sleep(this.period);
                }
                catch (Exception e) {
                    step = this.nbSteps;
                }
            }
            Object var4_3 = null;
            this.shell.animationEnded(this);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.shell.animationEnded(this);
            throw throwable;
        }
    }

    public void interrupt() {
        this.interrupted = true;
    }

    private void setShellAtStep(int step) {
        if (this.display == null || this.display.isDisposed()) {
            return;
        }
        final int x = this.startX + (this.endX - this.startX) * step / this.nbSteps;
        final int y = this.startY + (this.endY - this.startY) * step / this.nbSteps;
        this.display.asyncExec(new AERunnable(){

            public void runSupport() {
                if (LinearAnimator.this.shell == null || LinearAnimator.this.shell.getShell() == null || LinearAnimator.this.shell.getShell().isDisposed()) {
                    return;
                }
                LinearAnimator.this.shell.getShell().setLocation(x, y);
            }
        });
    }
}

