/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.util.LaunchManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableBoolean;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.TableItemOrTreeItem;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableOrTreeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String GOOD_STRING = "(/|,jI~`gy";
    public static final boolean isGTK = SWT.getPlatform().equals("gtk");
    public static final boolean isCarbon = SWT.getPlatform().equals("carbon");
    public static final boolean isCocoa = SWT.getPlatform().equals("cocoa");
    public static final boolean LAST_TABLECOLUMN_EXPANDS = isGTK;
    public static final boolean TABLE_GRIDLINE_IS_ALTERNATING_COLOR = isGTK || isCocoa;
    private static final boolean DEBUG_SWTEXEC = System.getProperty("debug.swtexec", "0").equals("1");
    private static ArrayList<Runnable> queue;
    private static AEDiagnosticsLogger diag_logger;
    private static Image[] shellIcons;
    private static Image icon128;
    private static final String[] shellIconNames;
    public static final Rectangle EMPTY_RECT;
    private static int userMode;
    private static boolean isAZ2;
    private static boolean gotBrowserStyle;
    private static int browserStyle;
    public static final long IMMEDIATE_ADDREMOVE_DELAY = 150L;
    private static final long IMMEDIATE_ADDREMOVE_MAXDELAY = 2000L;
    private static Timer timerProcessDataSources;
    private static TimerEvent timerEventProcessDS;
    private static List processDataSourcesOutstanding;
    private static Map truncatedTextCache;
    private static ThreadPool tp;

    public static boolean isAZ2UI() {
        return isAZ2;
    }

    public static void disposeComposite(Composite composite, boolean disposeSelf) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        Control[] controls = composite.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            Control control = controls[i];
            if (control == null || control.isDisposed()) continue;
            if (control instanceof Composite) {
                Utils.disposeComposite((Composite)control, true);
            }
            try {
                control.dispose();
                continue;
            }
            catch (SWTException e) {
                Debug.printStackTrace(e);
            }
        }
        if (!composite.isDisposed() && disposeSelf) {
            try {
                composite.dispose();
            }
            catch (SWTException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void disposeComposite(Composite composite) {
        Utils.disposeComposite(composite, true);
    }

    public static void disposeSWTObjects(List disposeList) {
        Utils.disposeSWTObjects(disposeList.toArray());
        disposeList.clear();
    }

    public static void disposeSWTObjects(Object[] disposeList) {
        if (disposeList == null) {
            return;
        }
        for (int i = 0; i < disposeList.length; ++i) {
            try {
                Object o = disposeList[i];
                if (o instanceof Widget && !((Widget)o).isDisposed()) {
                    ((Widget)o).dispose();
                    continue;
                }
                if (!(o instanceof Resource) || ((Resource)o).isDisposed()) continue;
                ((Resource)o).dispose();
                continue;
            }
            catch (Exception e) {
                Debug.out("Warning: Disposal failed " + Debug.getCompressedStackTrace(e, 0, -1, true));
            }
        }
    }

    public static void setTextLinkFromClipboard(Shell shell, Text url, boolean accept_magnets) {
        String link = Utils.getLinkFromClipboard(shell.getDisplay(), accept_magnets);
        if (link != null) {
            url.setText(link);
        }
    }

    public static String getLinkFromClipboard(Display display, boolean accept_magnets) {
        Clipboard cb = new Clipboard(display);
        TextTransfer transfer = TextTransfer.getInstance();
        String data = (String)cb.getContents(transfer);
        String text = UrlUtils.parseTextForURL(data, accept_magnets);
        if (text == null) {
            return "http://";
        }
        return text;
    }

    public static void centreWindow(Shell shell) {
        Rectangle displayArea;
        if (shell.getParent() != null) {
            displayArea = shell.getParent().getBounds();
        } else {
            try {
                displayArea = shell.getMonitor().getClientArea();
            }
            catch (NoSuchMethodError e) {
                displayArea = shell.getDisplay().getClientArea();
            }
        }
        Rectangle shellRect = shell.getBounds();
        if (shellRect.height > displayArea.height) {
            shellRect.height = displayArea.height;
        }
        if (shellRect.width > displayArea.width - 50) {
            shellRect.width = displayArea.width;
        }
        shellRect.x = displayArea.x + (displayArea.width - shellRect.width) / 2;
        shellRect.y = displayArea.y + (displayArea.height - shellRect.height) / 2;
        shell.setBounds(shellRect);
    }

    public static void centerWindowRelativeTo(Shell window, Control control) {
        Rectangle bounds = control.getBounds();
        Point shellSize = window.getSize();
        window.setLocation(bounds.x + bounds.width / 2 - shellSize.x / 2, bounds.y + bounds.height / 2 - shellSize.y / 2);
    }

    public static void createTorrentDropTarget(Composite composite, boolean bAllowShareAdd) {
        try {
            Utils.createDropTarget(composite, bAllowShareAdd, null);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static void createURLDropTarget(Composite composite, Text url) {
        try {
            Utils.createDropTarget(composite, false, url);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private static void createDropTarget(Composite composite, boolean bAllowShareAdd, Text url, DropTargetListener dropTargetListener) {
        Transfer[] transferList = new Transfer[]{HTMLTransfer.getInstance(), URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget(composite, 31);
        dropTarget.setTransfer(transferList);
        dropTarget.addDropListener(dropTargetListener);
        if (Constants.isWindows) {
            return;
        }
        Control[] children = composite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (control.isDisposed()) continue;
            if (control instanceof Composite) {
                Utils.createDropTarget((Composite)control, bAllowShareAdd, url, dropTargetListener);
                continue;
            }
            DropTarget dropTarget2 = new DropTarget(control, 31);
            dropTarget2.setTransfer(transferList);
            dropTarget2.addDropListener(dropTargetListener);
        }
    }

    private static void createDropTarget(Composite composite, boolean bAllowShareAdd, Text url) {
        URLDropTarget target = new URLDropTarget(url, bAllowShareAdd);
        Utils.createDropTarget(composite, bAllowShareAdd, url, target);
    }

    public static void alternateRowBackground(TableItem item) {
        Utils.alternateRowBackground(TableOrTreeUtils.getEventItem(item));
    }

    public static void alternateRowBackground(TableItemOrTreeItem item) {
        if (TABLE_GRIDLINE_IS_ALTERNATING_COLOR) {
            if (!item.getParent().getLinesVisible()) {
                item.getParent().setLinesVisible(true);
            }
            return;
        }
        if (item == null || item.isDisposed()) {
            return;
        }
        Color[] colors = new Color[]{item.getDisplay().getSystemColor(25), Colors.colorAltRow};
        Color newColor = colors[item.getParent().indexOf(item) % colors.length];
        if (!item.getBackground().equals(newColor)) {
            item.setBackground(newColor);
        }
    }

    public static void alternateTableBackground(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        if (TABLE_GRIDLINE_IS_ALTERNATING_COLOR) {
            if (!table.getLinesVisible()) {
                table.setLinesVisible(true);
            }
            return;
        }
        int iTopIndex = table.getTopIndex();
        if (iTopIndex < 0 || iTopIndex == 0 && table.getItemCount() == 0) {
            return;
        }
        TableOrTreeSWT tt = TableOrTreeUtils.getTableOrTreeSWT(table);
        int iBottomIndex = Utils.getTableBottomIndex(tt, iTopIndex);
        Color[] colors = new Color[]{table.getDisplay().getSystemColor(25), Colors.colorAltRow};
        int iFixedIndex = iTopIndex;
        for (int i = iTopIndex; i <= iBottomIndex; ++i) {
            TableItemOrTreeItem row = tt.getItem(i);
            if (row.isDisposed()) continue;
            Color newColor = colors[iFixedIndex % colors.length];
            ++iFixedIndex;
            if (row.getBackground().equals(newColor)) continue;
            row.setBackground(newColor);
        }
    }

    public static void setMenuItemImage(MenuItem item, final String repoKey) {
        if (Constants.isOSX || repoKey == null) {
            return;
        }
        ImageLoader imageLoader = ImageLoader.getInstance();
        item.setImage(imageLoader.getImage(repoKey));
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ImageLoader imageLoader = ImageLoader.getInstance();
                imageLoader.releaseImage(repoKey);
            }
        });
    }

    public static void setMenuItemImage(MenuItem item, Image image) {
        if (!Constants.isOSX) {
            item.setImage(image);
        }
    }

    public static void setShellIcon(Shell shell) {
        if (Constants.isOSX) {
            return;
        }
        try {
            if (shellIcons == null) {
                ArrayList<Image> listShellIcons = new ArrayList<Image>(shellIconNames.length);
                ImageLoader imageLoader = ImageLoader.getInstance();
                for (int i = 0; i < shellIconNames.length; ++i) {
                    Image image = imageLoader.getImage(shellIconNames[i]);
                    if (!ImageLoader.isRealImage(image)) continue;
                    listShellIcons.add(image);
                }
                shellIcons = listShellIcons.toArray(new Image[listShellIcons.size()]);
            }
            shell.setImages(shellIcons);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static Display getDisplay() {
        Display display;
        SWTThread swt = SWTThread.getInstance();
        if (swt == null) {
            display = Display.getDefault();
            if (display == null) {
                System.err.println("SWT Thread not started yet!");
                return null;
            }
        } else {
            if (swt.isTerminated()) {
                return null;
            }
            display = swt.getDisplay();
        }
        if (display == null || display.isDisposed()) {
            return null;
        }
        return display;
    }

    public static boolean execSWTThread(Runnable code, boolean async) {
        return Utils.execSWTThread(code, async ? -1 : -2);
    }

    public static boolean execSWTThreadLater(int msLater, Runnable code) {
        return Utils.execSWTThread(code, msLater);
    }

    public static boolean isSWTThread() {
        Display display = Utils.getDisplay();
        if (display == null) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    private static boolean execSWTThread(final Runnable code, final int msLater) {
        boolean isSWTThread;
        final Display display = Utils.getDisplay();
        if (display == null || code == null) {
            return false;
        }
        boolean bl = isSWTThread = display.getThread() == Thread.currentThread();
        if (msLater < 0 && isSWTThread) {
            if (queue == null) {
                code.run();
            } else {
                long lStartTimeRun = SystemTime.getCurrentTime();
                code.run();
                long wait = SystemTime.getCurrentTime() - lStartTimeRun;
                if (wait > 700L) {
                    diag_logger.log(SystemTime.getCurrentTime() + "] took " + wait + "ms to run " + Debug.getCompressedStackTrace(-5));
                }
            }
        } else if (msLater >= -1) {
            try {
                if (queue == null) {
                    if (msLater <= 0) {
                        display.asyncExec(code);
                    }
                    if (isSWTThread) {
                        display.timerExec(msLater, code);
                    }
                    SimpleTimer.addEvent("execSWTThreadLater", SystemTime.getOffsetTime(msLater), new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            if (!display.isDisposed()) {
                                display.asyncExec(code);
                            }
                        }
                    });
                }
                queue.add(code);
                diag_logger.log(SystemTime.getCurrentTime() + "] + Q. size= " + queue.size() + "; add " + code + " via " + Debug.getCompressedStackTrace(-5));
                final long lStart = SystemTime.getCurrentTime();
                final Display fDisplay = display;
                final AERunnable runnableWrapper = new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public void runSupport() {
                        long wait = SystemTime.getCurrentTime() - lStart - (long)msLater;
                        if (wait > 700L) {
                            diag_logger.log(SystemTime.getCurrentTime() + "] took " + wait + "ms before SWT ran async code " + code);
                        }
                        long lStartTimeRun = SystemTime.getCurrentTime();
                        try {
                            if (fDisplay.isDisposed()) {
                                Debug.out("Display disposed while trying to execSWTThread " + code);
                                try {
                                    code.run();
                                }
                                catch (SWTException e) {
                                    Debug.out("Error while execSWTThread w/disposed Display", e);
                                }
                            } else {
                                code.run();
                            }
                            Object var7_4 = null;
                        }
                        catch (Throwable throwable) {
                            Object var7_5 = null;
                            long runTIme = SystemTime.getCurrentTime() - lStartTimeRun;
                            if (runTIme > 500L) {
                                diag_logger.log(SystemTime.getCurrentTime() + "] took " + runTIme + "ms to run " + code);
                            }
                            queue.remove(code);
                            if (runTIme > 10L) {
                                diag_logger.log(SystemTime.getCurrentTime() + "] - Q. size=" + queue.size() + ";wait:" + wait + "ms;run:" + runTIme + "ms " + code);
                                throw throwable;
                            } else {
                                diag_logger.log(SystemTime.getCurrentTime() + "] - Q. size=" + queue.size() + ";wait:" + wait + "ms;run:" + runTIme + "ms");
                            }
                            throw throwable;
                        }
                        long runTIme = SystemTime.getCurrentTime() - lStartTimeRun;
                        if (runTIme > 500L) {
                            diag_logger.log(SystemTime.getCurrentTime() + "] took " + runTIme + "ms to run " + code);
                        }
                        queue.remove(code);
                        if (runTIme > 10L) {
                            diag_logger.log(SystemTime.getCurrentTime() + "] - Q. size=" + queue.size() + ";wait:" + wait + "ms;run:" + runTIme + "ms " + code);
                            return;
                        }
                        diag_logger.log(SystemTime.getCurrentTime() + "] - Q. size=" + queue.size() + ";wait:" + wait + "ms;run:" + runTIme + "ms");
                    }
                };
                if (msLater <= 0) {
                    display.asyncExec(runnableWrapper);
                }
                if (isSWTThread) {
                    display.timerExec(msLater, runnableWrapper);
                }
                SimpleTimer.addEvent("execSWTThreadLater", SystemTime.getOffsetTime(msLater), new TimerEventPerformer(){

                    public void perform(TimerEvent event2) {
                        if (!display.isDisposed()) {
                            display.asyncExec(runnableWrapper);
                        }
                    }
                });
            }
            catch (NullPointerException e) {
                return false;
            }
        } else {
            display.syncExec(code);
        }
        return true;
    }

    public static boolean execSWTThread(Runnable code) {
        return Utils.execSWTThread(code, -1);
    }

    public static boolean isThisThreadSWT() {
        Display display;
        SWTThread swt = SWTThread.getInstance();
        if (swt == null) {
            // empty if block
        }
        Display display2 = display = swt == null ? Display.getCurrent() : swt.getDisplay();
        if (display == null) {
            return false;
        }
        try {
            display.getWarnings();
        }
        catch (SWTException e) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    public static int getTableBottomIndex(TableOrTreeSWT table, int iTopIndex) {
        Object lastBottomIndex = table.getData("lastBottomIndex");
        if (lastBottomIndex instanceof Number) {
            return ((Number)lastBottomIndex).intValue();
        }
        int columnCount = table.getColumnCount();
        if (columnCount == 0) {
            return -1;
        }
        int xPos = table.getColumn(0).getWidth() - 1;
        if (columnCount > 1) {
            xPos += table.getColumn(1).getWidth();
        }
        Rectangle clientArea = table.getClientArea();
        TableItemOrTreeItem bottomItem = table.getItem(new Point(xPos, clientArea.y + clientArea.height - 2));
        if (bottomItem != null) {
            while (bottomItem.getParentItem() != null) {
                bottomItem = bottomItem.getParentItem();
            }
            return table.indexOf(bottomItem);
        }
        return table.getItemCount() - 1;
    }

    public static List<TableItemOrTreeItem> getVisibleTableItems(TableOrTreeSWT table) {
        if (table.getColumnCount() < 2) {
            return Collections.emptyList();
        }
        int xPos = table.getColumn(0).getWidth() + table.getColumn(1).getWidth() - 1;
        Rectangle clientArea = table.getClientArea();
        TableItemOrTreeItem bottomItem = table.getItem(new Point(xPos, clientArea.y + clientArea.height - 1));
        if (bottomItem == null && clientArea.height + clientArea.y <= 0) {
            return Collections.emptyList();
        }
        TableItemOrTreeItem curItem = table.getTopItem();
        if (curItem == null) {
            if (table.getItemCount() > 0) {
                curItem = table.getItem(0);
            } else {
                return Collections.emptyList();
            }
        }
        ArrayList<TableItemOrTreeItem> items = new ArrayList<TableItemOrTreeItem>();
        int i = table.indexOf(curItem);
        int count = table.getItemCount();
        while (true) {
            if (curItem == bottomItem) {
                items.add(curItem);
                break;
            }
            if (curItem == null) break;
            items.add(curItem);
            if (curItem.getExpanded() && curItem.getItemCount() > 0 && !Utils.addItemsToList(items, curItem.getItems(), bottomItem) || ++i >= count) break;
            curItem = table.getItem(i);
        }
        return items;
    }

    private static boolean addItemsToList(List<TableItemOrTreeItem> list, TableItemOrTreeItem[] items, TableItemOrTreeItem stopOnItem) {
        for (TableItemOrTreeItem item : items) {
            list.add(item);
            if (item != stopOnItem) continue;
            return false;
        }
        return true;
    }

    public static void launch(final DiskManagerFileInfo fileInfo2) {
        LaunchManager launch_manager = LaunchManager.getManager();
        LaunchManager.LaunchTarget target = launch_manager.createTarget(fileInfo2);
        launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

            public void actionAllowed() {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        Utils.launch(fileInfo2.getFile(true).toString());
                    }
                });
            }

            public void actionDenied(Throwable reason) {
                Debug.out("Launch request denied", reason);
            }
        });
    }

    public static void launch(String sFile) {
        boolean launched;
        PlatformManager mgr;
        if (sFile == null || sFile.trim().length() == 0) {
            return;
        }
        if (!Constants.isWindows && new File(sFile).isDirectory() && (mgr = PlatformManagerFactory.getPlatformManager()).hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            try {
                PlatformManagerFactory.getPlatformManager().showFile(sFile);
                return;
            }
            catch (PlatformManagerException platformManagerException) {
                // empty catch block
            }
        }
        if (!(launched = Program.launch(sFile = sFile.replaceAll("&vzemb=1", ""))) && Constants.isUnix) {
            sFile = sFile.replaceAll(" ", "\\ ");
            if (!Program.launch("xdg-open " + sFile) && !Program.launch("htmlview " + sFile)) {
                Debug.out("Failed to launch '" + sFile + "'");
            }
        }
    }

    public static void setCheckedInSetData(TableItem item, boolean checked) {
        item.setChecked(checked);
        if (Constants.isWindowsXP || isGTK) {
            Rectangle r = item.getBounds(0);
            Table table = item.getParent();
            Rectangle rTable = table.getClientArea();
            table.redraw(0, r.y, rTable.width, r.height, true);
        }
    }

    public static boolean linkShellMetricsToConfig(Shell shell, String sConfigPrefix) {
        boolean isMaximized = COConfigurationManager.getBooleanParameter(sConfigPrefix + ".maximized");
        if (!isMaximized) {
            shell.setMaximized(false);
        }
        String windowRectangle = COConfigurationManager.getStringParameter(sConfigPrefix + ".rectangle", null);
        boolean bDidResize = false;
        if (null != windowRectangle) {
            int i = 0;
            int[] values = new int[4];
            StringTokenizer st = new StringTokenizer(windowRectangle, ",");
            try {
                while (st.hasMoreTokens() && i < 4) {
                    values[i++] = Integer.valueOf(st.nextToken());
                }
                if (i == 4) {
                    Rectangle shellBounds = new Rectangle(values[0], values[1], values[2], values[3]);
                    if (shellBounds.width > 100 && shellBounds.height > 50) {
                        shell.setBounds(shellBounds);
                        Utils.verifyShellRect(shell, true);
                        bDidResize = true;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (isMaximized) {
            shell.setMaximized(isMaximized);
        }
        new ShellMetricsResizeListener(shell, sConfigPrefix);
        return bDidResize;
    }

    public static GridData setGridData(Composite composite, int gridStyle, Control ctrlBestSize, int maxHeight) {
        GridData gridData = new GridData(gridStyle);
        gridData.heightHint = ctrlBestSize.computeSize((int)-1, (int)-1).y;
        if (gridData.heightHint > maxHeight && maxHeight > 0) {
            gridData.heightHint = maxHeight;
        }
        composite.setLayoutData(gridData);
        return gridData;
    }

    public static FormData getFilledFormData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        return formData;
    }

    public static int pixelsToPoint(int pixels, int dpi) {
        int ret = (int)Math.round((double)pixels * 72.0 / (double)dpi);
        return ret;
    }

    private static int pixelsToPoint(double pixels, int dpi) {
        int ret = (int)Math.round(pixels * 72.0 / (double)dpi);
        return ret;
    }

    private static boolean drawImage(GC gc, Image image, Rectangle dstRect, Rectangle clipping, int hOffset, int vOffset, boolean clearArea) {
        return Utils.drawImage(gc, image, new Point(0, 0), dstRect, clipping, hOffset, vOffset, clearArea);
    }

    private static boolean drawImage(GC gc, Image image, Rectangle dstRect, Rectangle clipping, int hOffset, int vOffset) {
        return Utils.drawImage(gc, image, new Point(0, 0), dstRect, clipping, hOffset, vOffset, false);
    }

    public static boolean drawImage(GC gc, Image image, Point srcStart, Rectangle dstRect, Rectangle clipping, int hOffset, int vOffset, boolean clearArea) {
        Rectangle srcRect;
        Point dstAdj;
        if (clipping == null) {
            dstAdj = new Point(0, 0);
            srcRect = new Rectangle(srcStart.x, srcStart.y, dstRect.width, dstRect.height);
        } else {
            if (!dstRect.intersects(clipping)) {
                return false;
            }
            dstAdj = new Point(Math.max(0, clipping.x - dstRect.x), Math.max(0, clipping.y - dstRect.y));
            srcRect = new Rectangle(0, 0, 0, 0);
            srcRect.x = srcStart.x + dstAdj.x;
            srcRect.y = srcStart.y + dstAdj.y;
            srcRect.width = Math.min(dstRect.width - dstAdj.x, clipping.x + clipping.width - dstRect.x);
            srcRect.height = Math.min(dstRect.height - dstAdj.y, clipping.y + clipping.height - dstRect.y);
        }
        if (!srcRect.isEmpty()) {
            try {
                if (clearArea) {
                    gc.fillRectangle(dstRect.x + dstAdj.x + hOffset, dstRect.y + dstAdj.y + vOffset, srcRect.width, srcRect.height);
                }
                gc.drawImage(image, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x + dstAdj.x + hOffset, dstRect.y + dstAdj.y + vOffset, srcRect.width, srcRect.height);
            }
            catch (Exception e) {
                System.out.println("drawImage: " + e.getMessage() + ": " + image + ", " + srcRect + ", " + (dstRect.x + dstAdj.y + hOffset) + "," + (dstRect.y + dstAdj.y + vOffset) + "," + srcRect.width + "," + srcRect.height + "; imageBounds = " + image.getBounds());
            }
        }
        return true;
    }

    public static Control findChild(Composite comp2, int x, int y) {
        Rectangle comp_bounds = comp2.getBounds();
        if (comp2.isVisible() && comp_bounds.contains(x, y)) {
            x -= comp_bounds.x;
            y -= comp_bounds.y;
            Control[] children = comp2.getChildren();
            for (int i = 0; i < children.length; ++i) {
                Control child = children[i];
                if (!child.isVisible()) continue;
                if (child instanceof Composite) {
                    Control res = Utils.findChild((Composite)child, x, y);
                    if (res == null) continue;
                    return res;
                }
                return child;
            }
            return comp2;
        }
        return null;
    }

    public static void addListenerAndChildren(Composite area, int event2, Listener listener) {
        area.addListener(event2, listener);
        Control[] children = area.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (child instanceof Composite) {
                Utils.addListenerAndChildren((Composite)child, event2, listener);
                continue;
            }
            child.addListener(event2, listener);
        }
    }

    public static Shell findAnyShell() {
        Shell shell;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (shell = uiFunctions.getMainShell()) != null && !shell.isDisposed()) {
            return shell;
        }
        Display current = Display.getCurrent();
        if (current == null) {
            return null;
        }
        Shell shell2 = current.getActiveShell();
        if (shell2 != null && !shell2.isDisposed()) {
            return shell2;
        }
        Shell[] shells = current.getShells();
        if (shells.length == 0) {
            return null;
        }
        if (shells[0] != null && !shells[0].isDisposed()) {
            return shells[0];
        }
        return null;
    }

    public static boolean verifyShellRect(Shell shell, boolean bAdjustIfInvalid) {
        boolean bMetricsOk;
        try {
            bMetricsOk = false;
            Point ptTopLeft = shell.getLocation();
            Monitor[] monitors = shell.getDisplay().getMonitors();
            for (int j = 0; j < monitors.length && !bMetricsOk; ++j) {
                Rectangle bounds = monitors[j].getBounds();
                bMetricsOk = bounds.contains(ptTopLeft);
            }
        }
        catch (NoSuchMethodError e) {
            Rectangle bounds = shell.getDisplay().getBounds();
            bMetricsOk = shell.getBounds().intersects(bounds);
        }
        if (!bMetricsOk && bAdjustIfInvalid) {
            Utils.centreWindow(shell);
        }
        return bMetricsOk;
    }

    public static void relayout(Control control) {
        Utils.relayout(control, false);
    }

    public static void relayout(Control control, boolean expandOnly) {
        if (control == null || control.isDisposed() || !control.isVisible()) {
            return;
        }
        Composite parent = control.getParent();
        Point targetSize = control.computeSize(-1, -1, true);
        Point size = control.getSize();
        if (size.y == targetSize.y && size.x == targetSize.x) {
            return;
        }
        int fixedWidth = -1;
        int fixedHeight = -1;
        Object layoutData = control.getLayoutData();
        if (layoutData instanceof FormData) {
            FormData fd = (FormData)layoutData;
            fixedHeight = fd.height;
            fixedWidth = fd.width;
            if (fd.width != -1 && fd.height != -1) {
                parent.layout();
                return;
            }
        }
        if (expandOnly && size.y >= targetSize.y && size.x >= targetSize.x) {
            parent.layout();
            return;
        }
        while (parent != null) {
            parent.layout(true, true);
            parent = parent.getParent();
            Point newSize = control.getSize();
            if (fixedHeight <= -1 && newSize.y < targetSize.y || fixedWidth <= -1 && newSize.x < targetSize.x) continue;
            break;
        }
        if (parent != null) {
            parent.layout();
        }
    }

    public static void beep() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Display display = Display.getDefault();
                if (display != null) {
                    display.beep();
                }
            }
        });
    }

    public static boolean execSWTThreadWithBool(String ID, AERunnableBoolean code) {
        return Utils.execSWTThreadWithBool(ID, code, 0L);
    }

    public static boolean execSWTThreadWithBool(String ID, AERunnableBoolean code, long millis) {
        if (code == null) {
            return false;
        }
        boolean[] returnValueObject = new boolean[]{false};
        Display display = Utils.getDisplay();
        AESemaphore sem = null;
        if (display == null || display.getThread() != Thread.currentThread()) {
            sem = new AESemaphore(ID);
        }
        try {
            code.setupReturn(ID, returnValueObject, sem);
            if (!Utils.execSWTThread(code)) {
                return false;
            }
        }
        catch (Throwable e) {
            if (sem != null) {
                sem.release();
            }
            Debug.out(ID, e);
        }
        if (sem != null) {
            sem.reserve(millis);
        }
        return returnValueObject[0];
    }

    public static Object execSWTThreadWithObject(String ID, AERunnableObject code) {
        return Utils.execSWTThreadWithObject(ID, code, 0L);
    }

    public static Object execSWTThreadWithObject(String ID, AERunnableObject code, long millis) {
        if (code == null) {
            return null;
        }
        Object[] returnValueObject = new Object[]{null};
        Display display = Utils.getDisplay();
        AESemaphore sem = null;
        if (display == null || display.getThread() != Thread.currentThread()) {
            sem = new AESemaphore(ID);
        }
        try {
            code.setupReturn(ID, returnValueObject, sem);
            if (!Utils.execSWTThread(code)) {
                return null;
            }
        }
        catch (Throwable e) {
            if (sem != null) {
                sem.releaseForever();
            }
            Debug.out(ID, e);
        }
        if (sem != null) {
            sem.reserve(millis);
        }
        return returnValueObject[0];
    }

    public static void waitForModals() {
        Display display;
        SWTThread swt = SWTThread.getInstance();
        if (swt == null) {
            display = Display.getDefault();
            if (display == null) {
                System.err.println("SWT Thread not started yet!");
                return;
            }
        } else {
            if (swt.isTerminated()) {
                return;
            }
            display = swt.getDisplay();
        }
        if (display == null || display.isDisposed()) {
            return;
        }
        Shell[] shells = display.getShells();
        Widget modalShell = null;
        for (int i = 0; i < shells.length; ++i) {
            Shell shell = shells[i];
            if ((shell.getStyle() & 0x10000) <= 0) continue;
            modalShell = shell;
            break;
        }
        if (modalShell != null) {
            while (!modalShell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        }
    }

    public static GridData getWrappableLabelGridData(int hspan, int styles) {
        GridData gridData = new GridData(0x100 | styles);
        gridData.horizontalSpan = hspan;
        gridData.widthHint = 0;
        return gridData;
    }

    private static Image createAlphaImage(Device device, int width, int height) {
        return Utils.createAlphaImage(device, width, height, (byte)0);
    }

    public static Image createAlphaImage(Device device, int width, int height, byte defaultAlpha) {
        byte[] alphaData = new byte[width * height];
        Arrays.fill(alphaData, 0, alphaData.length, defaultAlpha);
        ImageData imageData = new ImageData(width, height, 24, new PaletteData(255, 65280, 0xFF0000));
        Arrays.fill(imageData.data, 0, imageData.data.length, (byte)0);
        imageData.alphaData = alphaData;
        if (device == null) {
            device = Display.getDefault();
        }
        Image image = new Image(device, imageData);
        return image;
    }

    public static Image blitImage(Device device, Image srcImage, Rectangle srcArea, Image dstImage, Point dstPos) {
        if (srcArea == null) {
            srcArea = srcImage.getBounds();
        }
        Rectangle dstBounds = dstImage.getBounds();
        if (dstPos == null) {
            dstPos = new Point(dstBounds.x, dstBounds.y);
        } else {
            dstBounds.x = dstPos.x;
            dstBounds.y = dstPos.y;
        }
        ImageData dstImageData = dstImage.getImageData();
        ImageData srcImageData = srcImage.getImageData();
        int yPos = dstPos.y;
        int[] pixels = new int[srcArea.width];
        byte[] alphas = new byte[srcArea.width];
        for (int y = 0; y < srcArea.height; ++y) {
            srcImageData.getPixels(srcArea.x, y + srcArea.y, srcArea.width, pixels, 0);
            dstImageData.setPixels(dstPos.x, yPos, srcArea.width, pixels, 0);
            srcImageData.getAlphas(srcArea.x, y + srcArea.y, srcArea.width, alphas, 0);
            dstImageData.setAlphas(dstPos.x, yPos, srcArea.width, alphas, 0);
            ++yPos;
        }
        return new Image(device, dstImageData);
    }

    public static void drawStriped(GC gcImg, int x, int y, int width, int height, int lineDist, int leftshift, boolean fallingLines) {
        lineDist += 2;
        int xm = x + width;
        int ym = y + height;
        for (int i = x; i < xm; ++i) {
            for (int j = y; j < ym; ++j) {
                if ((i + leftshift + (fallingLines ? -j : j)) % lineDist != 0) continue;
                gcImg.drawPoint(i, j);
            }
        }
    }

    public static Image renderTransparency(Display display, Image background, Image foreground, Point foregroundOffsetOnBg, int modifyForegroundAlpha) {
        if (display == null || display.isDisposed() || background == null || background.isDisposed() || foreground == null || foreground.isDisposed()) {
            return null;
        }
        Rectangle backgroundArea = background.getBounds();
        Rectangle foregroundDrawArea = foreground.getBounds();
        foregroundDrawArea.x += foregroundOffsetOnBg.x;
        foregroundDrawArea.y += foregroundOffsetOnBg.y;
        foregroundDrawArea.intersect(backgroundArea);
        if (foregroundDrawArea.isEmpty()) {
            return null;
        }
        Image image = new Image((Device)display, backgroundArea);
        ImageData backData = background.getImageData();
        ImageData foreData = foreground.getImageData();
        ImageData imgData = image.getImageData();
        PaletteData backPalette = backData.palette;
        ImageData backMask = backData.getTransparencyType() != 1 ? backData.getTransparencyMask() : null;
        PaletteData forePalette = foreData.palette;
        ImageData foreMask = foreData.getTransparencyType() != 1 ? foreData.getTransparencyMask() : null;
        PaletteData imgPalette = imgData.palette;
        image.dispose();
        for (int x = 0; x < backgroundArea.width; ++x) {
            for (int y = 0; y < backgroundArea.height; ++y) {
                RGB cBack = backPalette.getRGB(backData.getPixel(x, y));
                int aBack = backData.getAlpha(x, y);
                if (backMask != null && backMask.getPixel(x, y) == 0) {
                    aBack = 0;
                }
                int aFore = 0;
                if (foregroundDrawArea.contains(x, y)) {
                    int fx = x - foregroundDrawArea.x;
                    int fy = y - foregroundDrawArea.y;
                    RGB cFore = forePalette.getRGB(foreData.getPixel(fx, fy));
                    aFore = foreData.getAlpha(fx, fy);
                    if (foreMask != null && foreMask.getPixel(fx, fy) == 0) {
                        aFore = 0;
                    }
                    aFore = aFore * modifyForegroundAlpha / 255;
                    cBack.red *= aBack * (255 - aFore);
                    cBack.red /= 255;
                    cBack.red += aFore * cFore.red;
                    cBack.red /= 255;
                    cBack.green *= aBack * (255 - aFore);
                    cBack.green /= 255;
                    cBack.green += aFore * cFore.green;
                    cBack.green /= 255;
                    cBack.blue *= aBack * (255 - aFore);
                    cBack.blue /= 255;
                    cBack.blue += aFore * cFore.blue;
                    cBack.blue /= 255;
                }
                imgData.setAlpha(x, y, aFore + aBack * (255 - aFore) / 255);
                imgData.setPixel(x, y, imgPalette.getPixel(cBack));
            }
        }
        return new Image((Device)display, imgData);
    }

    public static Control findBackgroundImageControl(Control control) {
        Composite parent;
        Image image = control.getBackgroundImage();
        if (image == null) {
            return control;
        }
        Composite lastParent = parent = control.getParent();
        while (parent != null) {
            Image parentImage = parent.getBackgroundImage();
            if (!image.equals(parentImage)) {
                return lastParent;
            }
            lastParent = parent;
            parent = parent.getParent();
        }
        return control;
    }

    public static boolean anyShellHaveStyle(int styles) {
        Display display = Display.getCurrent();
        if (display != null) {
            Shell[] shells = display.getShells();
            for (int i = 0; i < shells.length; ++i) {
                Shell shell = shells[i];
                int style = shell.getStyle();
                if ((style & styles) != styles) continue;
                return true;
            }
        }
        return false;
    }

    public static Shell findFirstShellWithStyle(int styles) {
        Display display = Display.getCurrent();
        if (display != null) {
            Shell[] shells = display.getShells();
            for (int i = 0; i < shells.length; ++i) {
                Shell shell = shells[i];
                int style = shell.getStyle();
                if ((style & styles) != styles || shell.isDisposed()) continue;
                return shell;
            }
        }
        return null;
    }

    public static int[] colorToIntArray(Color color) {
        if (color == null || color.isDisposed()) {
            return null;
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public static void centerRelativeTo(Rectangle target, Rectangle reference) {
        target.x = reference.x + reference.width / 2 - target.width / 2;
        target.y = reference.y + reference.height / 2 - target.height / 2;
    }

    public static void makeVisibleOnCursor(Rectangle rect) {
        if (null == rect) {
            return;
        }
        Display display = Display.getCurrent();
        if (null == display) {
            Debug.out("No current display detected.  This method [Utils.makeVisibleOnCursor()] must be called from a display thread.");
            return;
        }
        try {
            Point cursorLocation = display.getCursorLocation();
            Utils.makeVisibleOnMonitor(rect, Utils.getMonitor(cursorLocation));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void makeVisibleOnMonitor(Rectangle rect, Monitor monitor) {
        if (null == rect || null == monitor) {
            return;
        }
        try {
            int rightDiff;
            Rectangle monitorBounds = monitor.getClientArea();
            int bottomDiff = monitorBounds.y + monitorBounds.height - (rect.y + rect.height);
            if (bottomDiff < 0) {
                rect.y += bottomDiff;
            }
            if ((rightDiff = monitorBounds.x + monitorBounds.width - (rect.x + rect.width)) < 0) {
                rect.x += rightDiff;
            }
            if (rect.x < monitorBounds.x) {
                rect.x = monitorBounds.x;
            }
            if (rect.y < monitorBounds.y) {
                rect.y = monitorBounds.y;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Monitor getMonitor(int x, int y) {
        return Utils.getMonitor(new Point(x, y));
    }

    public static Monitor getMonitor(Point location) {
        Display display = Display.getCurrent();
        if (null == display) {
            Debug.out("No current display detected.  This method [Utils.makeVisibleOnCursor()] must be called from a display thread.");
            return null;
        }
        try {
            Monitor[] monitors = display.getMonitors();
            Rectangle monitorBounds = null;
            for (int i = 0; i < monitors.length; ++i) {
                monitorBounds = monitors[i].getClientArea();
                if (!monitorBounds.contains(location)) continue;
                return monitors[i];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static int getInitialBrowserStyle(int style) {
        if (!gotBrowserStyle) {
            browserStyle = COConfigurationManager.getBooleanParameter("swt.forceMozilla") ? 32768 : 0;
            gotBrowserStyle = true;
        }
        return style | browserStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addDataSourceAggregated(addDataSourceCallback callback) {
        if (callback == null) {
            return true;
        }
        boolean processQueueImmediately = false;
        List to_do_now = null;
        Timer timer = timerProcessDataSources;
        synchronized (timer) {
            if (timerEventProcessDS != null && !timerEventProcessDS.hasRun()) {
                long now = SystemTime.getCurrentTime();
                if (now - timerEventProcessDS.getCreatedTime() < 2000L) {
                    long lNextTime = now + 150L;
                    timerProcessDataSources.adjustAllBy(lNextTime - timerEventProcessDS.getWhen());
                    if (!processDataSourcesOutstanding.contains(callback)) {
                        processDataSourcesOutstanding.add(callback);
                    }
                } else {
                    timerEventProcessDS.cancel();
                    timerEventProcessDS = null;
                    processQueueImmediately = true;
                    to_do_now = processDataSourcesOutstanding;
                    processDataSourcesOutstanding = new ArrayList();
                }
            } else {
                if (!processDataSourcesOutstanding.contains(callback)) {
                    processDataSourcesOutstanding.add(callback);
                }
                timerEventProcessDS = timerProcessDataSources.addEvent(SystemTime.getCurrentTime() + 150L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        List to_do;
                        Timer timer = timerProcessDataSources;
                        synchronized (timer) {
                            timerEventProcessDS = null;
                            to_do = processDataSourcesOutstanding;
                            processDataSourcesOutstanding = new ArrayList();
                        }
                        for (int i = 0; i < to_do.size(); ++i) {
                            try {
                                addDataSourceCallback this_callback = (addDataSourceCallback)to_do.get(i);
                                if (TableViewSWT.DEBUGADDREMOVE) {
                                    this_callback.debug("processDataSourceQueue after " + (SystemTime.getCurrentTime() - event2.getCreatedTime()) + "ms");
                                }
                                this_callback.process();
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                });
            }
            if (to_do_now != null) {
                to_do_now.remove(callback);
                for (int i = 0; i < to_do_now.size(); ++i) {
                    try {
                        addDataSourceCallback this_callback = (addDataSourceCallback)to_do_now.get(i);
                        if (TableViewSWT.DEBUGADDREMOVE) {
                            this_callback.debug("Over immediate delay limit, processing queue now");
                        }
                        this_callback.process();
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        return processQueueImmediately;
    }

    public static synchronized String truncateText(GC gc, String text, int maxWidth, boolean cache) {
        TruncatedTextResult result;
        if (cache && (result = (TruncatedTextResult)truncatedTextCache.get(text)) != null && result.maxWidth == maxWidth) {
            return result.text;
        }
        StringBuffer sb = new StringBuffer(text);
        String append = "...";
        int appendWidth = gc.textExtent((String)append).x;
        boolean needsAppend = false;
        while (gc.textExtent((String)sb.toString()).x > maxWidth) {
            sb.deleteCharAt(sb.length() - 1);
            needsAppend = true;
            if (sb.length() != 1) continue;
        }
        if (needsAppend) {
            while (gc.textExtent((String)sb.toString()).x + appendWidth > maxWidth) {
                sb.deleteCharAt(sb.length() - 1);
                needsAppend = true;
                if (sb.length() != 1) continue;
            }
            sb.append(append);
        }
        if (cache) {
            TruncatedTextResult ttR = new TruncatedTextResult();
            ttR.text = sb.toString();
            ttR.maxWidth = maxWidth;
            truncatedTextCache.put(text, ttR);
        }
        return sb.toString();
    }

    public static String toColorHexString(Color bg) {
        StringBuffer sb = new StringBuffer();
        Utils.twoHex(sb, bg.getRed());
        Utils.twoHex(sb, bg.getGreen());
        Utils.twoHex(sb, bg.getBlue());
        return sb.toString();
    }

    private static void twoHex(StringBuffer sb, int h) {
        if (h <= 15) {
            sb.append('0');
        }
        sb.append(Integer.toHexString(h));
    }

    public static String getWidgetBGColorURLParam() {
        Color bg = Utils.findAnyShell().getDisplay().getSystemColor(22);
        byte[] color = new byte[]{(byte)bg.getRed(), (byte)bg.getGreen(), (byte)bg.getBlue()};
        return "bg_color=" + ByteFormatter.nicePrint(color);
    }

    public static void reportError(Throwable e) {
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("ConfigView.section.security.op.error.title"), MessageText.getString("ConfigView.section.security.op.error", new String[]{Debug.getNestedExceptionMessage(e)}), new String[]{MessageText.getString("Button.ok")}, 0);
        mb.open(null);
    }

    public static void getOffOfSWTThread(AERunnable runnable) {
        tp.run(runnable);
    }

    public static Browser createSafeBrowser(Composite parent, int style) {
        try {
            Browser browser = new Browser(parent, Utils.getInitialBrowserStyle(style));
            browser.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ((Browser)e.widget).setUrl("about:blank");
                    ((Browser)e.widget).setVisible(false);
                    while (!e.display.isDisposed() && e.display.readAndDispatch()) {
                    }
                }
            });
            return browser;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static int getUserMode() {
        return userMode;
    }

    public static Point getLocationRelativeToShell(Control table) {
        Point controlLocation = table.toDisplay(table.getLocation());
        Point shellLocation = table.getShell().getLocation();
        return new Point(controlLocation.x - shellLocation.x, controlLocation.y - shellLocation.y);
    }

    static {
        shellIcons = null;
        shellIconNames = new String[]{"azureus", "azureus32", "azureus64", "azureus128"};
        EMPTY_RECT = new Rectangle(0, 0, 0, 0);
        if (DEBUG_SWTEXEC) {
            System.out.println("==== debug.swtexec=1, performance may be affected ====");
            queue = new ArrayList();
            diag_logger = AEDiagnostics.getLogger("swt");
            diag_logger.log("\n\nSWT Logging Starts");
            AEDiagnostics.addEvidenceGenerator(new AEDiagnosticsEvidenceGenerator(){

                public void generate(IndentWriter writer) {
                    writer.println("SWT Queue:");
                    writer.indent();
                    for (Runnable r : queue) {
                        writer.println(r.toString());
                    }
                    writer.exdent();
                }
            });
        } else {
            queue = null;
            diag_logger = null;
        }
        COConfigurationManager.addAndFireParameterListener("User Mode", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                userMode = COConfigurationManager.getIntParameter("User Mode");
            }
        });
        COConfigurationManager.addAndFireParameterListener("ui", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                isAZ2 = "az2".equals(COConfigurationManager.getStringParameter("ui"));
            }
        });
        gotBrowserStyle = false;
        browserStyle = 0;
        timerProcessDataSources = new Timer("Process Data Sources");
        processDataSourcesOutstanding = new ArrayList();
        truncatedTextCache = new HashMap();
        tp = new ThreadPool("GetOffSWT", 3);
    }

    private static class ShellMetricsResizeListener
    implements Listener {
        private int state = -1;
        private String sConfigPrefix;
        private Rectangle bounds = null;

        ShellMetricsResizeListener(Shell shell, String sConfigPrefix) {
            this.sConfigPrefix = sConfigPrefix;
            this.state = this.calcState(shell);
            if (this.state == 0) {
                this.bounds = shell.getBounds();
            }
            shell.addListener(11, this);
            shell.addListener(10, this);
            shell.addListener(12, this);
        }

        private int calcState(Shell shell) {
            return shell.getMinimized() ? 128 : (shell.getMaximized() && !isCarbon ? 1024 : 0);
        }

        private void saveMetrics() {
            COConfigurationManager.setParameter(this.sConfigPrefix + ".maximized", this.state == 1024);
            if (this.bounds == null) {
                return;
            }
            COConfigurationManager.setParameter(this.sConfigPrefix + ".rectangle", this.bounds.x + "," + this.bounds.y + "," + this.bounds.width + "," + this.bounds.height);
            COConfigurationManager.save();
        }

        public void handleEvent(Event event2) {
            Shell shell = (Shell)event2.widget;
            this.state = this.calcState(shell);
            if (event2.type != 12 && this.state == 0) {
                this.bounds = shell.getBounds();
            }
            if (event2.type == 12) {
                this.saveMetrics();
            }
        }
    }

    private static class TruncatedTextResult {
        String text;
        int maxWidth;
    }

    private static class URLDropTarget
    extends DropTargetAdapter {
        private final Text url;
        private final boolean bAllowShareAdd;

        public URLDropTarget(Text url, boolean bAllowShareAdd) {
            this.url = url;
            this.bAllowShareAdd = bAllowShareAdd;
        }

        public void dropAccept(DropTargetEvent event2) {
            event2.currentDataType = URLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
        }

        public void dragOver(DropTargetEvent event2) {
            if (event2.detail != 16 && (event2.operations & event2.detail) > 0) {
                return;
            }
            if ((event2.operations & 4) > 0) {
                event2.detail = 4;
            } else if ((event2.operations & 0x10) > 0) {
                event2.detail = 16;
            } else if ((event2.operations & 1) > 0) {
                event2.detail = 1;
            }
        }

        public void drop(DropTargetEvent event2) {
            String sURL;
            if (this.url == null || this.url.isDisposed()) {
                TorrentOpener.openDroppedTorrents(event2, this.bAllowShareAdd);
            } else if (event2.data instanceof URLTransfer.URLType) {
                if (((URLTransfer.URLType)event2.data).linkURL != null) {
                    this.url.setText(((URLTransfer.URLType)event2.data).linkURL);
                }
            } else if (event2.data instanceof String && (sURL = UrlUtils.parseTextForURL((String)event2.data, true)) != null) {
                this.url.setText(sURL);
            }
        }
    }

    public static interface addDataSourceCallback {
        public void process();

        public void debug(String var1);
    }
}

