/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;

public class URLTransfer
extends ByteArrayTransfer {
    private boolean bCheckingString = false;
    private static boolean DEBUG = false;
    private static URLTransfer _instance = new URLTransfer();
    private static final String[] supportedTypes = new String[]{"CF_UNICODETEXT", "CF_TEXT", "OEM_TEXT"};
    private static final int[] supportedTypeIds = new int[]{13, 1, 17};

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (DEBUG) {
            System.out.println("javaToNative called");
        }
        if (object == null || !(object instanceof URLType[])) {
            return;
        }
        if (this.isSupportedType(transferData)) {
            URLType[] myTypes = (URLType[])object;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                DataOutputStream writeOut = new DataOutputStream(out);
                int length = myTypes.length;
                for (int i = 0; i < length; ++i) {
                    writeOut.writeBytes(myTypes[i].linkURL);
                    writeOut.writeBytes("\n");
                    writeOut.writeBytes(myTypes[i].linkText);
                }
                byte[] buffer = out.toByteArray();
                writeOut.close();
                super.javaToNative(buffer, transferData);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (DEBUG) {
            System.out.println("nativeToJava called");
        }
        try {
            if (this.isSupportedType(transferData)) {
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                return this.bytebufferToJava(buffer);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    public URLType bytebufferToJava(byte[] buffer) {
        if (buffer == null) {
            if (DEBUG) {
                System.out.println("buffer null");
            }
            return null;
        }
        URLType myData = null;
        try {
            String data;
            if (buffer.length > 1) {
                boolean bSecond0;
                if (DEBUG) {
                    for (int i = 0; i < buffer.length; ++i) {
                        if (buffer[i] >= 32) {
                            System.out.print((char)buffer[i]);
                            continue;
                        }
                        System.out.print("#");
                    }
                    System.out.println();
                }
                boolean bFirst0 = buffer[0] == 0;
                boolean bl = bSecond0 = buffer[1] == 0;
                data = bFirst0 && bSecond0 ? new String(buffer) : (bFirst0 ? new String(buffer, "UTF-16BE") : (bSecond0 ? new String(buffer, "UTF-16LE") : (buffer[0] == -17 && buffer[1] == -69 && buffer.length > 3 && buffer[2] == -65 ? new String(buffer, 3, buffer.length - 3, "UTF-8") : (buffer[0] == -1 || buffer[0] == -2 ? new String(buffer, "UTF-16") : new String(buffer)))));
            } else {
                byte[] text = new byte[buffer.length];
                int j = 0;
                for (int i = 0; i < buffer.length; ++i) {
                    if (buffer[i] == 0) continue;
                    text[j++] = buffer[i];
                }
                data = new String(text, 0, j);
            }
            int iPos = data.indexOf("\nURL=");
            if (iPos > 0) {
                int iEndPos = data.indexOf("\r", iPos);
                if (iEndPos < 0) {
                    iEndPos = data.length();
                }
                myData = new URLType();
                myData.linkURL = data.substring(iPos + 5, iEndPos);
                myData.linkText = "";
            } else {
                String[] split = data.split("[\r\n]+", 2);
                myData = new URLType();
                myData.linkURL = split.length > 0 ? split[0] : "";
                myData.linkText = split.length > 1 ? split[1] : "";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return myData;
    }

    protected String[] getTypeNames() {
        return supportedTypes;
    }

    protected int[] getTypeIds() {
        return supportedTypeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportedType(TransferData transferData) {
        if (this.bCheckingString) {
            return true;
        }
        if (transferData == null) {
            return false;
        }
        URLType url = null;
        if (DEBUG) {
            System.out.println("Checking if type #" + transferData.type + " is URL");
        }
        this.bCheckingString = true;
        try {
            try {
                byte[] buffer = (byte[])super.nativeToJava(transferData);
                url = this.bytebufferToJava(buffer);
            }
            catch (Exception e) {
                Debug.out(e);
                Object var5_6 = null;
                this.bCheckingString = false;
            }
            Object var5_5 = null;
            this.bCheckingString = false;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.bCheckingString = false;
            throw throwable;
        }
        if (url == null) {
            if (DEBUG) {
                System.out.println("no, Null URL for type #" + transferData.type);
            }
            return false;
        }
        if (UrlUtils.isURL(url.linkURL, false)) {
            if (DEBUG) {
                System.out.println("Yes, " + url.linkURL + " of type #" + transferData.type);
            }
            return true;
        }
        if (DEBUG) {
            System.out.println("no, " + url.linkURL + " not URL for type #" + transferData.type);
        }
        return false;
    }

    public static TransferData pickBestType(TransferData[] dataTypes, TransferData def) {
        for (int i = 0; i < supportedTypeIds.length; ++i) {
            int supportedTypeID = supportedTypeIds[i];
            for (int j = 0; j < dataTypes.length; ++j) {
                try {
                    TransferData data = dataTypes[j];
                    if (supportedTypeID != data.type) continue;
                    return data;
                }
                catch (Throwable t) {
                    Debug.out("Picking Best Type", t);
                }
            }
        }
        return def;
    }

    public static void main(String[] args) {
        LinkedHashMap<String, byte[]> map = new LinkedHashMap<String, byte[]>();
        map.put("UTF-8", new byte[]{-17, -69, -65, 72, 105});
        map.put("UTF-32 BE BOM", new byte[]{0, 0, -2, -1, 72, 0, 0, 0, 105, 0, 0, 0});
        map.put("UTF-16 LE BOM", new byte[]{-1, -2, 72, 0, 105, 0});
        map.put("UTF-16 BE BOM", new byte[]{-2, -1, 0, 72, 0, 105});
        map.put("UTF-16 LE", new byte[]{72, 0, 105, 0});
        map.put("UTF-16 BE", new byte[]{0, 72, 0, 105});
        for (String element : map.keySet()) {
            System.out.println(element + ":");
            byte[] buffer = (byte[])map.get(element);
            boolean bFirst0 = buffer[0] == 0;
            boolean bSecond0 = buffer[1] == 0;
            String data = "";
            try {
                data = bFirst0 && bSecond0 ? new String(buffer) : (bFirst0 ? new String(buffer, "UTF-16BE") : (bSecond0 ? new String(buffer, "UTF-16LE") : (buffer[0] == -17 && buffer[1] == -69 && buffer.length > 3 && buffer[2] == -65 ? new String(buffer, 3, buffer.length - 3, "UTF-8") : (buffer[0] == -1 || buffer[0] == -2 ? new String(buffer, "UTF-16") : new String(buffer)))));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            System.out.println(data);
        }
    }

    public class URLType {
        public String linkURL;
        public String linkText;

        public String toString() {
            return this.linkURL + "\n" + this.linkText;
        }
    }
}

