/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.StringIterator;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class OpenUrlWindow {
    protected static String CONFIG_REFERRER_DEFAULT = "openUrl.referrer.default";
    protected static String last_referrer = null;

    public OpenUrlWindow(Shell parent, String linkURL, String referrer) {
        this(parent, linkURL, referrer, null);
    }

    public OpenUrlWindow(final Shell parent, String linkURL, String referrer, final TorrentDownloaderCallBackInterface listener) {
        final Shell shell = ShellFactory.createShell(parent, 67696);
        shell.setText(MessageText.getString("openUrl.title"));
        Utils.setShellIcon(shell);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        shell.setLayout(layout);
        Label label = new Label(shell, 0);
        label.setText(MessageText.getString("openUrl.url"));
        GridData gridData = new GridData();
        label.setLayoutData(gridData);
        final Text url = new Text(shell, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 400;
        gridData.horizontalSpan = 2;
        url.setLayoutData(gridData);
        if (linkURL == null) {
            Utils.setTextLinkFromClipboard(shell, url, true);
        } else {
            url.setText(linkURL);
        }
        url.setSelection(url.getText().length());
        Label help_label = new Label(shell, 0);
        help_label.setText(MessageText.getString("openUrl.url.info"));
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        help_label.setLayoutData(gridData);
        Label space = new Label(shell, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        space.setLayoutData(gridData);
        Label referrer_label = new Label(shell, 0);
        referrer_label.setText(MessageText.getString("openUrl.referrer"));
        gridData = new GridData();
        referrer_label.setLayoutData(gridData);
        final Combo referrer_combo = new Combo(shell, 2048);
        gridData = new GridData(768);
        gridData.widthHint = 150;
        gridData.grabExcessHorizontalSpace = true;
        referrer_combo.setLayoutData(gridData);
        final StringList referrers = COConfigurationManager.getStringListParameter("url_open_referrers");
        StringIterator iter = referrers.iterator();
        while (iter.hasNext()) {
            referrer_combo.add(iter.next());
        }
        if (referrer != null && referrer.length() > 0) {
            referrer_combo.setText(referrer);
        } else if (last_referrer != null) {
            referrer_combo.setText(last_referrer);
        }
        Label referrer_info = new Label(shell, 0);
        referrer_info.setText(MessageText.getString("openUrl.referrer.info"));
        Label labelSeparator = new Label(shell, 258);
        gridData = new GridData(776);
        gridData.horizontalSpan = 3;
        labelSeparator.setLayoutData(gridData);
        Composite panel = new Composite(shell, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        panel.setLayout(layout);
        gridData = new GridData(904);
        gridData.horizontalSpan = 3;
        gridData.grabExcessHorizontalSpace = true;
        panel.setLayoutData(gridData);
        new Label(panel, 0);
        Button ok = new Button(panel, 8);
        gridData = new GridData(904);
        gridData.widthHint = 70;
        gridData.grabExcessHorizontalSpace = true;
        ok.setLayoutData(gridData);
        ok.setText(MessageText.getString("Button.ok"));
        ok.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                last_referrer = referrer_combo.getText().trim();
                if (!referrers.contains(last_referrer)) {
                    referrers.add(last_referrer);
                    COConfigurationManager.setParameter("url_open_referrers", referrers);
                    COConfigurationManager.save();
                }
                COConfigurationManager.setParameter(CONFIG_REFERRER_DEFAULT, last_referrer);
                COConfigurationManager.save();
                String url_str = url.getText();
                url_str = UrlUtils.parseTextForURL(url_str, true);
                if (url_str == null) {
                    url_str = UrlUtils.parseTextForMagnets(url.getText());
                }
                if (url_str == null) {
                    url_str = url.getText();
                }
                new FileDownloadWindow(parent, url_str, last_referrer, null, listener);
                shell.dispose();
            }
        });
        shell.setDefaultButton(ok);
        Button cancel = new Button(panel, 8);
        gridData = new GridData(128);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 70;
        cancel.setLayoutData(gridData);
        cancel.setText(MessageText.getString("Button.cancel"));
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                shell.dispose();
            }
        });
        shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    shell.dispose();
                }
            }
        });
        Point p = shell.computeSize(-1, -1);
        if (p.x > 800) {
            p.x = 800;
        }
        shell.setSize(p);
        Utils.createURLDropTarget(shell, url);
        Utils.centreWindow(shell);
        shell.open();
    }

    static {
        last_referrer = COConfigurationManager.getStringParameter(CONFIG_REFERRER_DEFAULT, "");
    }
}

