/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.ipfilter.BadIp;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.BlockedIp;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class BlockedIpsWindow {
    static AzureusCore azureus_core;
    static Shell instance;

    private BlockedIpsWindow() {
    }

    public static void show(AzureusCore _azureus_core, Display display, String ipsBlocked, String ipsBanned) {
        if (instance == null || instance.isDisposed()) {
            instance = BlockedIpsWindow.create(_azureus_core, display, ipsBlocked, ipsBanned);
            instance.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event2) {
                    instance = null;
                }
            });
        } else {
            instance.open();
        }
    }

    private static Shell create(AzureusCore _azureus_core, Display display, String ipsBlocked, String ipsBanned) {
        azureus_core = _azureus_core;
        int styles = Constants.isOSX ? 1264 : 68720;
        final Shell window = ShellFactory.createShell(display, styles);
        Messages.setLanguageText(window, "ConfigView.section.ipfilter.list.title");
        Utils.setShellIcon(window);
        FormLayout layout = new FormLayout();
        try {
            layout.spacing = 5;
        }
        catch (NoSuchFieldError e) {
            // empty catch block
        }
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        window.setLayout(layout);
        final StyledText textBlocked = new StyledText(window, 2816);
        Button btnClear = new Button(window, 8);
        textBlocked.setEditable(false);
        final StyledText textBanned = new StyledText(window, 2816);
        Button btnOk = new Button(window, 8);
        Button btnReset = new Button(window, 8);
        textBanned.setEditable(false);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(40, 0);
        textBlocked.setLayoutData(formData);
        textBlocked.setText(ipsBlocked);
        Label blockedInfo = new Label(window, 0);
        Messages.setLanguageText(blockedInfo, "ConfigView.section.ipfilter.blockedinfo");
        formData = new FormData();
        formData.top = new FormAttachment(textBlocked);
        formData.right = new FormAttachment(btnClear);
        formData.left = new FormAttachment(0, 0);
        blockedInfo.setLayoutData(formData);
        Messages.setLanguageText(btnClear, "Button.clear");
        formData = new FormData();
        formData.top = new FormAttachment(textBlocked);
        formData.right = new FormAttachment(95, 0);
        formData.width = 70;
        btnClear.setLayoutData(formData);
        btnClear.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                azureus_core.getIpFilterManager().getIPFilter().clearBlockedIPs();
                textBlocked.setText("");
            }
        });
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(btnClear);
        formData.bottom = new FormAttachment(btnOk);
        textBanned.setLayoutData(formData);
        textBanned.setText(ipsBanned);
        Label bannedInfo = new Label(window, 0);
        Messages.setLanguageText(bannedInfo, "ConfigView.section.ipfilter.bannedinfo");
        formData = new FormData();
        formData.right = new FormAttachment(btnReset);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        bannedInfo.setLayoutData(formData);
        Messages.setLanguageText(btnReset, "Button.reset");
        formData = new FormData();
        formData.right = new FormAttachment(btnOk);
        formData.bottom = new FormAttachment(100, 0);
        formData.width = 70;
        btnReset.setLayoutData(formData);
        btnReset.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                azureus_core.getIpFilterManager().getIPFilter().clearBannedIps();
                azureus_core.getIpFilterManager().getBadIps().clearBadIps();
                textBanned.setText("");
            }
        });
        Messages.setLanguageText(btnOk, "Button.ok");
        formData = new FormData();
        formData.right = new FormAttachment(95, 0);
        formData.bottom = new FormAttachment(100, 0);
        formData.width = 70;
        btnOk.setLayoutData(formData);
        btnOk.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                window.dispose();
            }
        });
        window.setDefaultButton(btnOk);
        window.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    window.dispose();
                }
            }
        });
        if (!Utils.linkShellMetricsToConfig(window, "BlockedIpsWindow")) {
            window.setSize(620, 450);
            if (!Constants.isOSX) {
                Utils.centreWindow(window);
            }
        }
        window.layout();
        window.open();
        return window;
    }

    public static void showBlockedIps(AzureusCore azureus_core, Shell mainWindow) {
        StringBuffer sbBlocked = new StringBuffer();
        StringBuffer sbBanned = new StringBuffer();
        BlockedIp[] blocked = azureus_core.getIpFilterManager().getIPFilter().getBlockedIps();
        String inRange = MessageText.getString("ConfigView.section.ipfilter.list.inrange");
        String notInRange = MessageText.getString("ConfigView.section.ipfilter.list.notinrange");
        String bannedMessage = MessageText.getString("ConfigView.section.ipfilter.list.banned");
        String badDataMessage = MessageText.getString("ConfigView.section.ipfilter.list.baddata");
        for (int i = 0; i < blocked.length; ++i) {
            BlockedIp bIp = blocked[i];
            if (!bIp.isLoggable()) continue;
            sbBlocked.append(DisplayFormatters.formatTimeStamp(bIp.getBlockedTime()));
            sbBlocked.append("\t[");
            sbBlocked.append(bIp.getTorrentName());
            sbBlocked.append("] \t");
            sbBlocked.append(bIp.getBlockedIp());
            IpRange range = bIp.getBlockingRange();
            if (range == null) {
                sbBlocked.append(' ');
                sbBlocked.append(notInRange);
                sbBlocked.append('\n');
                continue;
            }
            sbBlocked.append(' ');
            sbBlocked.append(inRange);
            sbBlocked.append(range.toString());
            sbBlocked.append('\n');
        }
        BannedIp[] banned_ips = azureus_core.getIpFilterManager().getIPFilter().getBannedIps();
        for (int i = 0; i < banned_ips.length; ++i) {
            BannedIp bIp = banned_ips[i];
            sbBanned.append(DisplayFormatters.formatTimeStamp(bIp.getBanningTime()));
            sbBanned.append("\t[");
            sbBanned.append(bIp.getTorrentName());
            sbBanned.append("] \t");
            sbBanned.append(bIp.getIp());
            sbBanned.append(" ");
            sbBanned.append(bannedMessage);
            sbBanned.append("\n");
        }
        BadIp[] bad_ips = azureus_core.getIpFilterManager().getBadIps().getBadIps();
        for (int i = 0; i < bad_ips.length; ++i) {
            BadIp bIp = bad_ips[i];
            sbBanned.append(DisplayFormatters.formatTimeStamp(bIp.getLastTime()));
            sbBanned.append("\t");
            sbBanned.append(bIp.getIp());
            sbBanned.append(" ");
            sbBanned.append(badDataMessage);
            sbBanned.append(" ");
            sbBanned.append(bIp.getNumberOfWarnings());
            sbBanned.append("\n");
        }
        if (mainWindow == null || mainWindow.isDisposed()) {
            return;
        }
        BlockedIpsWindow.show(azureus_core, mainWindow.getDisplay(), sbBlocked.toString(), sbBanned.toString());
    }
}

