/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.download;

import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;

public class RPDownloadStats
extends RPObject
implements DownloadStats {
    protected transient DownloadStats delegate;
    public long downloaded;
    public long uploaded;
    public int completed;
    public int downloadCompletedLive;
    public int downloadCompletedStored;
    public String status;
    public String status_localised;
    public long upload_average;
    public long download_average;
    public String eta;
    public int share_ratio;
    public float availability;
    public int health;

    public static RPDownloadStats create(DownloadStats _delegate) {
        RPDownloadStats res = (RPDownloadStats)RPDownloadStats._lookupLocal(_delegate);
        if (res == null) {
            res = new RPDownloadStats(_delegate);
        }
        return res;
    }

    protected RPDownloadStats(DownloadStats _delegate) {
        super(_delegate);
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (DownloadStats)_delegate;
        this.downloaded = this.delegate.getDownloaded();
        this.uploaded = this.delegate.getUploaded();
        this.completed = this.delegate.getCompleted();
        this.downloadCompletedLive = this.delegate.getDownloadCompleted(true);
        this.downloadCompletedStored = this.delegate.getDownloadCompleted(false);
        this.status = this.delegate.getStatus();
        this.status_localised = this.delegate.getStatus(true);
        this.upload_average = this.delegate.getUploadAverage();
        this.download_average = this.delegate.getDownloadAverage();
        this.eta = this.delegate.getETA();
        this.share_ratio = this.delegate.getShareRatio();
        this.availability = this.delegate.getAvailability();
        this.health = this.delegate.getHealth();
    }

    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        throw new RPException("Unknown method: " + method);
    }

    public String getStatus() {
        return this.status;
    }

    public String getStatus(boolean localised) {
        return localised ? this.status_localised : this.status;
    }

    public String getDownloadDirectory() {
        this.notSupported();
        return null;
    }

    public String getTargetFileOrDir() {
        this.notSupported();
        return null;
    }

    public String getTrackerStatus() {
        this.notSupported();
        return null;
    }

    public int getCompleted() {
        return this.completed;
    }

    public int getDownloadCompleted(boolean bLive) {
        return bLive ? this.downloadCompletedLive : this.downloadCompletedStored;
    }

    public int getCheckingDoneInThousandNotation() {
        this.notSupported();
        return 0;
    }

    public void resetUploadedDownloaded(long l1, long l2) {
        this.notSupported();
    }

    public long getDownloaded() {
        return this.downloaded;
    }

    public long getUploaded() {
        return this.uploaded;
    }

    public long getRemaining() {
        this.notSupported();
        return 0L;
    }

    public long getDiscarded() {
        this.notSupported();
        return 0L;
    }

    public long getDownloadAverage() {
        return this.download_average;
    }

    public long getUploadAverage() {
        return this.upload_average;
    }

    public long getTotalAverage() {
        this.notSupported();
        return 0L;
    }

    public String getElapsedTime() {
        this.notSupported();
        return null;
    }

    public String getETA() {
        return this.eta;
    }

    public long getETASecs() {
        this.notSupported();
        return 0L;
    }

    public long getHashFails() {
        this.notSupported();
        return 0L;
    }

    public int getShareRatio() {
        return this.share_ratio;
    }

    public long getTimeStarted() {
        this.notSupported();
        return 0L;
    }

    public float getAvailability() {
        return this.availability;
    }

    public long getSecondsDownloading() {
        this.notSupported();
        return 0L;
    }

    public long getSecondsOnlySeeding() {
        this.notSupported();
        return 0L;
    }

    public long getTimeStartedSeeding() {
        this.notSupported();
        return 0L;
    }

    public long getSecondsSinceLastDownload() {
        this.notSupported();
        return 0L;
    }

    public long getSecondsSinceLastUpload() {
        this.notSupported();
        return 0L;
    }

    public int getHealth() {
        return this.health;
    }
}

