/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.xml.rss;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.gudy.azureus2.core3.util.Debug;

public class RSSUtils {
    public static Date parseRSSDate(String date_str) {
        try {
            SimpleDateFormat format = date_str.indexOf(",") == -1 ? new SimpleDateFormat("dd MMM yyyy HH:mm:ss z", Locale.US) : new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            return format.parse(date_str);
        }
        catch (ParseException e) {
            String[] fallbacks = new String[]{"dd MMM yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE MMM dd HH:mm:ss z yyyy", "EEE MMM dd HH:mm z yyyy", "EEE MMM dd HH z yyyy", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd"};
            date_str = date_str.replace(',', ' ');
            date_str = date_str.replaceAll("(\\s)+", " ");
            for (int i = 0; i < fallbacks.length; ++i) {
                try {
                    return new SimpleDateFormat(fallbacks[i], Locale.US).parse(date_str);
                }
                catch (ParseException f) {
                    continue;
                }
            }
            Debug.printStackTrace(e);
            return null;
        }
    }

    public static Date parseAtomDate(String date_str) {
        String[] formats = new String[]{"yyyy-MM-dd'T'kk:mm:ss'Z'", "yyyy-MM-dd'T'kk:mm:ssz", "yyyy-MM-dd'T'kk:mm:ssZ", "yyyy-MM-dd'T'kk:mm:ss"};
        for (int i = 0; i < formats.length; ++i) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(formats[i], Locale.US);
                return format.parse(date_str);
            }
            catch (ParseException parseException) {
                continue;
            }
        }
        return null;
    }
}

