/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Debug;

public class Constants {
    public static final String EMPTY_STRING = "";
    public static final String SF_WEB_SITE = "http://plugins.vuze.com/";
    public static final String AELITIS_TORRENTS = "http://cf1.vuze.com/torrent/torrents/";
    public static final String AELITIS_FILES = "http://cf1.vuze.com/torrent/files/";
    public static final String AZUREUS_WIKI = "http://wiki.vuze.com/w/";
    public static final String VERSION_SERVER_V4 = "version.vuze.com";
    public static final String VERSION_SERVER_V6 = "version6.vuze.com";
    public static final String DHT_SEED_ADDRESS_V4 = "dht.vuze.com";
    public static final String DHT_SEED_ADDRESS_V6 = "dht6.vuze.com";
    public static final String NAT_TEST_SERVER = "nettest.vuze.com";
    public static final String NAT_TEST_SERVER_HTTP = "http://nettest.vuze.com/";
    public static final String SPEED_TEST_SERVER = "speedtest.vuze.com";
    public static final String PAIRING_URL = "http://pair.vuze.com/pairing";
    public static final String[] AZUREUS_DOMAINS = new String[]{"azureusplatform.com", "azureus.com", "aelitis.com", "vuze.com"};
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final String BYTE_ENCODING = "ISO-8859-1";
    public static Charset BYTE_CHARSET;
    public static Charset DEFAULT_CHARSET;
    public static final Locale LOCALE_ENGLISH;
    public static final String INFINITY_STRING = "\u221e";
    public static final int CRAPPY_INFINITY_AS_INT = 31536000;
    public static final long CRAPPY_INFINITE_AS_LONG = 1827387392L;
    public static boolean DOWNLOAD_SOURCES_PRETEND_COMPLETE;
    public static String APP_NAME;
    public static final String AZUREUS_NAME = "Azureus";
    public static final String AZUREUS_VERSION = "4.6.0.4";
    public static final String BUILD_VERSION = "@build.version@";
    public static final String AZUREUS_SUBVER = "";
    public static final byte[] VERSION_ID;
    private static final boolean FORCE_NON_CVS;
    public static final boolean IS_CVS_VERSION;
    public static final String OSName;
    public static final boolean isOSX;
    public static final boolean isLinux;
    public static final boolean isSolaris;
    public static final boolean isFreeBSD;
    public static final boolean isWindowsXP;
    public static final boolean isWindows95;
    public static final boolean isWindows98;
    public static final boolean isWindows2000;
    public static final boolean isWindowsME;
    public static final boolean isWindows9598ME;
    public static boolean isSafeMode;
    public static final boolean isWindows;
    public static final boolean isUnix;
    public static final boolean isWindowsVista;
    public static final boolean isWindowsVistaSP2OrHigher;
    public static final boolean isWindowsVistaOrHigher;
    public static final boolean isWindows7OrHigher;
    public static Pattern PAT_SPLIT_COMMAWORDS;
    public static Pattern PAT_SPLIT_COMMA;
    public static Pattern PAT_SPLIT_DOT;
    public static Pattern PAT_SPLIT_SPACE;
    public static Pattern PAT_SPLIT_SLASH_N;
    public static final boolean isOSX_10_5_OrHigher;
    public static final boolean isOSX_10_6_OrHigher;
    public static final String JAVA_VERSION;
    public static final String FILE_WILDCARD;

    public static String getBaseVersion() {
        return Constants.getBaseVersion(AZUREUS_VERSION);
    }

    public static String getBaseVersion(String version) {
        int p1 = version.indexOf("_");
        if (p1 == -1) {
            return version;
        }
        return version.substring(0, p1);
    }

    public static boolean isCVSVersion() {
        return IS_CVS_VERSION;
    }

    public static boolean isCVSVersion(String version) {
        return version.indexOf("_") != -1;
    }

    public static int getIncrementalBuild() {
        return Constants.getIncrementalBuild(AZUREUS_VERSION);
    }

    public static int getIncrementalBuild(String version) {
        if (!Constants.isCVSVersion(version)) {
            return 0;
        }
        int p1 = version.indexOf("_B");
        if (p1 == -1) {
            return -1;
        }
        try {
            return Integer.parseInt(version.substring(p1 + 2));
        }
        catch (Throwable e) {
            System.out.println("can't parse version");
            return -1;
        }
    }

    public static int compareVersions(String version_1, String version_2) {
        try {
            block7: {
                if (version_1.startsWith(".")) {
                    version_1 = "0" + version_1;
                }
                if (version_2.startsWith(".")) {
                    version_2 = "0" + version_2;
                }
                version_1 = version_1.replaceAll("[^0-9.]", ".");
                version_2 = version_2.replaceAll("[^0-9.]", ".");
                StringTokenizer tok1 = new StringTokenizer(version_1, ".");
                StringTokenizer tok2 = new StringTokenizer(version_2, ".");
                while (true) {
                    int i1;
                    if (tok1.hasMoreTokens() && tok2.hasMoreTokens()) {
                        int i2;
                        i1 = Integer.parseInt(tok1.nextToken());
                        if (i1 == (i2 = Integer.parseInt(tok2.nextToken()))) continue;
                        return i1 - i2;
                    }
                    if (tok1.hasMoreTokens()) {
                        i1 = Integer.parseInt(tok1.nextToken());
                        if (i1 == 0) continue;
                        return 1;
                    }
                    if (!tok2.hasMoreTokens()) break block7;
                    int i2 = Integer.parseInt(tok2.nextToken());
                    if (i2 != 0) break;
                }
                return -1;
            }
            return 0;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return 0;
        }
    }

    public static boolean isValidVersionFormat(String version) {
        if (version == null || version.length() == 0) {
            return false;
        }
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return !version.startsWith(".") && !version.endsWith(".") && version.indexOf("..") == -1;
    }

    public static boolean isAzureusDomain(String host) {
        host = host.toLowerCase();
        for (int i = 0; i < AZUREUS_DOMAINS.length; ++i) {
            String domain = AZUREUS_DOMAINS[i];
            if (domain.equals(host)) {
                return true;
            }
            if (!host.endsWith("." + domain)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.out.println(Constants.compareVersions("3.0.0.1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0"));
        System.out.println(Constants.compareVersions("3.0.0.0", "3.0.0.0_B1"));
        System.out.println(Constants.compareVersions("3.0.0.0_B1", "3.0.0.0_B4"));
        System.out.println(Constants.compareVersions("3.0.0.0..B1", "3.0.0.0_B4"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            Constants.BYTE_CHARSET = Charset.forName("ISO-8859-1");
            Constants.DEFAULT_CHARSET = Charset.forName("UTF8");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Constants.LOCALE_ENGLISH = new Locale("en", "");
        Constants.DOWNLOAD_SOURCES_PRETEND_COMPLETE = false;
        Constants.APP_NAME = "Vuze";
        Constants.VERSION_ID = "-AZ4604-".getBytes();
        Constants.FORCE_NON_CVS = System.getProperty("az.force.noncvs", "0").equals("1");
        Constants.IS_CVS_VERSION = Constants.isCVSVersion("4.6.0.4") != false && Constants.FORCE_NON_CVS == false;
        Constants.OSName = System.getProperty("os.name");
        Constants.isOSX = Constants.OSName.toLowerCase().startsWith("mac os");
        Constants.isLinux = Constants.OSName.equalsIgnoreCase("Linux");
        Constants.isSolaris = Constants.OSName.equalsIgnoreCase("SunOS");
        Constants.isFreeBSD = Constants.OSName.equalsIgnoreCase("FreeBSD");
        Constants.isWindowsXP = Constants.OSName.equalsIgnoreCase("Windows XP");
        Constants.isWindows95 = Constants.OSName.equalsIgnoreCase("Windows 95");
        Constants.isWindows98 = Constants.OSName.equalsIgnoreCase("Windows 98");
        Constants.isWindows2000 = Constants.OSName.equalsIgnoreCase("Windows 2000");
        Constants.isWindowsME = Constants.OSName.equalsIgnoreCase("Windows ME");
        Constants.isWindows9598ME = Constants.isWindows95 != false || Constants.isWindows98 != false || Constants.isWindowsME != false;
        Constants.isSafeMode = false;
        Constants.isWindows = Constants.OSName.toLowerCase().startsWith("windows");
        Constants.isUnix = Constants.isWindows == false && Constants.isOSX == false;
        Constants.PAT_SPLIT_COMMAWORDS = Pattern.compile("\\s*,\\s*");
        Constants.PAT_SPLIT_COMMA = Pattern.compile(",");
        Constants.PAT_SPLIT_DOT = Pattern.compile("\\.");
        Constants.PAT_SPLIT_SPACE = Pattern.compile(" ");
        Constants.PAT_SPLIT_SLASH_N = Pattern.compile("\n");
        if (Constants.isWindows) {
            block24: {
                ver = null;
                try {
                    ver = new Float(System.getProperty("os.version"));
                }
                catch (Throwable e) {
                    // empty catch block
                }
                vista_sp2_or_higher = false;
                if (ver == null) {
                    Constants.isWindowsVista = false;
                    Constants.isWindowsVistaOrHigher = false;
                    Constants.isWindows7OrHigher = false;
                } else {
                    f_ver = ver.floatValue();
                    Constants.isWindowsVista = f_ver == 6.0f;
                    Constants.isWindowsVistaOrHigher = f_ver >= 6.0f;
                    v0 = Constants.isWindows7OrHigher = f_ver >= 6.1f;
                    if (Constants.isWindowsVista) {
                        lnr = null;
                        try {
                            try {
                                p = Runtime.getRuntime().exec(new String[]{"reg", "query", "HKLM\\Software\\Microsoft\\Windows NT\\CurrentVersion", "/v", "CSDVersion"});
                                lnr = new LineNumberReader(new InputStreamReader(p.getInputStream()));
                                while ((line = lnr.readLine()) != null) {
                                    if (!line.matches(".*CSDVersion.*")) continue;
                                    vista_sp2_or_higher = line.matches(".*Service Pack [2-9]");
                                    break;
                                }
                                var7_12 = null;
                                if (lnr == null) break block24;
                            }
                            catch (Throwable e) {
                                var7_13 = null;
                                if (lnr != null) {
                                    try {
                                        lnr.close();
                                    }
                                    catch (Throwable e) {}
                                }
                                break block24;
                            }
                        }
                        catch (Throwable var6_18) {
                            var7_14 = null;
                            if (lnr == null) throw var6_18;
                            ** try [egrp 4[TRYBLOCK] [6 : 560->567)] { 
lbl77:
                            // 1 sources

                            lnr.close();
                            throw var6_18;
lbl79:
                            // 1 sources

                            catch (Throwable e) {
                                // empty catch block
                            }
                            throw var6_18;
                        }
                        try {}
                        catch (Throwable e) {}
                        lnr.close();
                    }
                }
            }
            Constants.isWindowsVistaSP2OrHigher = vista_sp2_or_higher;
        } else {
            Constants.isWindowsVista = false;
            Constants.isWindowsVistaSP2OrHigher = false;
            Constants.isWindowsVistaOrHigher = false;
            Constants.isWindows7OrHigher = false;
        }
        if (Constants.isOSX) {
            first_digit = 0;
            second_digit = 0;
            try {
                os_version = System.getProperty("os.version");
                bits = os_version.split("\\.");
                first_digit = Integer.parseInt(bits[0]);
                if (bits.length > 1) {
                    second_digit = Integer.parseInt(bits[1]);
                }
            }
            catch (Throwable var2_7) {
                // empty catch block
            }
            Constants.isOSX_10_5_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 5;
            Constants.isOSX_10_6_OrHigher = first_digit > 10 || first_digit == 10 && second_digit >= 6;
        } else {
            Constants.isOSX_10_5_OrHigher = false;
            Constants.isOSX_10_6_OrHigher = false;
        }
        Constants.JAVA_VERSION = System.getProperty("java.version");
        Constants.FILE_WILDCARD = Constants.isWindows != false ? "*.*" : "*";
    }
}

