/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPosition;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeerBase;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentPeerListener;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerNATChecker;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerSimplePeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentStatsImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerTorrentImpl
implements TRTrackerServerTorrent {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    public static final int MIN_CACHE_ENTRY_SIZE = 10;
    public static final int MAX_UPLOAD_BYTES_PER_SEC = 0x300000;
    public static final int MAX_DOWNLOAD_BYTES_PER_SEC = 0x300000;
    public static final boolean USE_LIGHTWEIGHT_SEEDS = true;
    public static final int MAX_IP_OVERRIDE_PEERS = 64;
    public static final byte COMPACT_MODE_NONE = 0;
    public static final byte COMPACT_MODE_NORMAL = 1;
    public static final byte COMPACT_MODE_AZ = 2;
    public static final byte COMPACT_MODE_AZ_2 = 3;
    public static final byte COMPACT_MODE_XML = 16;
    private static final int QUEUED_PEERS_MAX_SWARM_SIZE = 32;
    private static final int QUEUED_PEERS_MAX = 32;
    private static final int QUEUED_PEERS_ADD_MAX = 3;
    private TRTrackerServerImpl server;
    private HashWrapper hash;
    private Map<HashWrapper, TRTrackerServerPeerImpl> peer_map = new HashMap<HashWrapper, TRTrackerServerPeerImpl>();
    private Map<String, TRTrackerServerPeerImpl> peer_reuse_map = new HashMap<String, TRTrackerServerPeerImpl>();
    private List<TRTrackerServerPeerImpl> peer_list = new ArrayList<TRTrackerServerPeerImpl>();
    private int peer_list_hole_count;
    private boolean peer_list_compaction_suspended;
    private List biased_peers = null;
    private int min_biased_peers = 0;
    private Map lightweight_seed_map = new HashMap();
    private int seed_count;
    private int removed_count;
    private int ip_override_count;
    private int bad_NAT_count;
    private Random random = new Random(SystemTime.getCurrentTime());
    private long last_scrape_calc_time;
    private Map last_scrape;
    private LinkedHashMap announce_cache = new LinkedHashMap();
    private TRTrackerServerTorrentStatsImpl stats;
    private List listeners = new ArrayList();
    private List peer_listeners;
    private boolean deleted;
    private boolean enabled;
    private boolean map_size_diff_reported;
    private boolean ip_override_limit_exceeded_reported;
    private byte duplicate_peer_checker_index = 0;
    private byte[] duplicate_peer_checker = new byte[0];
    private URL[] redirects;
    private boolean caching_enabled = true;
    private LinkedList queued_peers;
    protected AEMonitor this_mon = new AEMonitor("TRTrackerServerTorrent");
    private List explicit_manual_biased_peers;
    private int explicit_next_peer;

    public TRTrackerServerTorrentImpl(TRTrackerServerImpl _server, HashWrapper _hash, boolean _enabled) {
        this.server = _server;
        this.hash = _hash;
        this.enabled = _enabled;
        this.stats = new TRTrackerServerTorrentStatsImpl(this);
    }

    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setMinBiasedPeers(int num) {
        this.min_biased_peers = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importPeers(List peers) {
        try {
            this.this_mon.enter();
            if (this.peer_map.size() > 0) {
                System.out.println("TRTrackerServerTorrent: ignoring peer import as torrent already active");
                Object var6_2 = null;
                this.this_mon.exit();
                return;
            }
            for (int i = 0; i < peers.size(); ++i) {
                TRTrackerServerPeerImpl peer = TRTrackerServerPeerImpl.importPeer((Map)peers.get(i));
                if (peer == null) continue;
                try {
                    String reuse_key = new String(peer.getIPAsRead(), "ISO-8859-1") + ":" + peer.getTCPPort();
                    this.peer_map.put(peer.getPeerId(), peer);
                    this.peer_list.add(peer);
                    this.peer_reuse_map.put(reuse_key, peer);
                    if (peer.isSeed()) {
                        ++this.seed_count;
                    }
                    if (!peer.isBiased()) continue;
                    if (this.biased_peers == null) {
                        this.biased_peers = new ArrayList();
                    }
                    this.biased_peers.add(peer);
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var6_3 = null;
        this.this_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TRTrackerServerPeerImpl peerContact(String url_parameters, String event2, HashWrapper peer_id, int tcp_port, int udp_port, int http_port, byte crypto_level, byte az_ver, String original_address, String ip_address, boolean ip_override, boolean loopback, String tracker_key, long uploaded, long downloaded, long left, long interval_requested, int up_speed, DHTNetworkPosition network_position) throws TRTrackerServerException {
        TRTrackerServerPeerImpl tRTrackerServerPeerImpl;
        if (!this.enabled) {
            throw new TRTrackerServerException("Torrent temporarily disabled");
        }
        if (!HostNameToIPResolver.isNonDNSName(ip_address)) {
            try {
                ip_address = HostNameToIPResolver.syncResolve(ip_address).getHostAddress();
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
        }
        TRTrackerServerException deferred_failure = null;
        try {
            try {
                long le_diff;
                long dl_diff;
                long ul_diff;
                long last_contact_time;
                boolean already_completed;
                boolean peer_already_removed;
                boolean new_peer;
                TRTrackerServerPeerImpl peer;
                long now;
                int event_type;
                block55: {
                    byte[] ip_address_bytes;
                    int tracker_key_hash_code;
                    block57: {
                        boolean biased;
                        this.this_mon.enter();
                        this.handleRedirects(url_parameters, ip_address, false);
                        event_type = 2;
                        if (event2 != null && event2.length() > 2) {
                            char c = event2.charAt(2);
                            event_type = c == 'm' ? 3 : (c == 'o' ? 4 : 1);
                        }
                        now = SystemTime.getCurrentTime();
                        tracker_key_hash_code = tracker_key == null ? 0 : tracker_key.hashCode();
                        peer = this.peer_map.get(peer_id);
                        new_peer = false;
                        peer_already_removed = false;
                        already_completed = false;
                        last_contact_time = 0L;
                        ul_diff = 0L;
                        dl_diff = 0L;
                        le_diff = 0L;
                        ip_address_bytes = ip_address.getBytes("ISO-8859-1");
                        if (peer != null) break block57;
                        String reuse_key = new String(ip_address_bytes, "ISO-8859-1") + ":" + tcp_port;
                        byte last_NAT_status = loopback ? (byte)3 : 0;
                        new_peer = true;
                        TRTrackerServerPeerImpl old_peer = this.peer_reuse_map.get(reuse_key);
                        if (old_peer != null) {
                            if (ip_override && !old_peer.isIPOverride()) {
                                throw new TRTrackerServerException("IP Override denied (existing '" + reuse_key + "' is not override)");
                            }
                            last_contact_time = old_peer.getLastContactTime();
                            already_completed = old_peer.getDownloadCompleted();
                            this.removePeer(old_peer, 5, null);
                            this.lightweight_seed_map.remove(old_peer.getPeerId());
                        } else {
                            lightweightSeed lws = (lightweightSeed)this.lightweight_seed_map.remove(peer_id);
                            if (lws != null) {
                                last_contact_time = lws.getLastContactTime();
                                ul_diff = uploaded - lws.getUploaded();
                                if (ul_diff < 0L) {
                                    ul_diff = 0L;
                                }
                                last_NAT_status = lws.getNATStatus();
                            } else {
                                last_contact_time = now;
                            }
                        }
                        if (event_type == 4) break block55;
                        Set biased_peer_set = this.server.getBiasedPeers();
                        boolean bl = biased = biased_peer_set != null && biased_peer_set.contains(ip_address);
                        if (ip_override && this.ip_override_count >= 64 && !loopback && !biased) {
                            if (!this.ip_override_limit_exceeded_reported) {
                                this.ip_override_limit_exceeded_reported = true;
                                Debug.out("Too many ip-override peers for " + ByteFormatter.encodeString(this.hash.getBytes()));
                            }
                            TRTrackerServerPeerImpl tRTrackerServerPeerImpl2 = null;
                            Object var56_53 = null;
                            this.this_mon.exit();
                            return tRTrackerServerPeerImpl2;
                        }
                        peer = new TRTrackerServerPeerImpl(peer_id, tracker_key_hash_code, ip_address_bytes, ip_override, tcp_port, udp_port, http_port, crypto_level, az_ver, last_contact_time, already_completed, last_NAT_status, up_speed, network_position);
                        if (ip_override) {
                            if (biased && !biased_peer_set.contains(original_address)) {
                                throw new TRTrackerServerException("IP Override denied (you are " + original_address + ")");
                            }
                            ++this.ip_override_count;
                        }
                        this.peer_map.put(peer_id, peer);
                        this.peer_list.add(peer);
                        this.peer_reuse_map.put(reuse_key, peer);
                        if (biased) {
                            peer.setBiased(true);
                            if (this.biased_peers == null) {
                                this.biased_peers = new ArrayList();
                            }
                            this.biased_peers.add(peer);
                        }
                        if (this.queued_peers == null) break block55;
                        if (this.peer_map.size() > 32) {
                            this.queued_peers = null;
                            break block55;
                        } else {
                            Iterator it = this.queued_peers.iterator();
                            while (it.hasNext()) {
                                QueuedPeer qp = (QueuedPeer)it.next();
                                if (!qp.sameAs(peer)) continue;
                                it.remove();
                                break block55;
                            }
                        }
                        break block55;
                    }
                    int existing_tracker_key_hash_code = peer.getKeyHashCode();
                    if (existing_tracker_key_hash_code != tracker_key_hash_code) {
                        throw new TRTrackerServerException("Unauthorised: key mismatch ");
                    }
                    if (ip_override) {
                        if (peer.isBiased()) {
                            Set biased_peer_set = this.server.getBiasedPeers();
                            if (biased_peer_set == null) throw new TRTrackerServerException("IP Override denied (you are " + original_address + ")");
                            if (!biased_peer_set.contains(original_address)) {
                                throw new TRTrackerServerException("IP Override denied (you are " + original_address + ")");
                            }
                        }
                        if (!peer.isIPOverride()) {
                            throw new TRTrackerServerException("IP Override denied (existing entry not override)");
                        }
                    }
                    already_completed = peer.getDownloadCompleted();
                    last_contact_time = peer.getLastContactTime();
                    if (event_type == 4) {
                        this.removePeer(peer, event_type, url_parameters);
                        peer_already_removed = true;
                    } else {
                        byte[] old_ip = peer.getIPAsRead();
                        int old_port = peer.getTCPPort();
                        if (peer.update(ip_address_bytes, tcp_port, udp_port, http_port, crypto_level, az_ver, up_speed, network_position)) {
                            String old_key = new String(old_ip, "ISO-8859-1") + ":" + old_port;
                            String new_key = new String(ip_address_bytes, "ISO-8859-1") + ":" + tcp_port;
                            TRTrackerServerPeerImpl old_peer = this.peer_reuse_map.get(new_key);
                            if (old_peer != null) {
                                this.removePeer(old_peer, 5, null);
                            }
                            if (this.peer_reuse_map.remove(old_key) == null) {
                                Debug.out("TRTrackerServerTorrent: IP address change: '" + old_key + "' -> '" + new_key + "': old key not found");
                            }
                            this.peer_reuse_map.put(new_key, peer);
                        }
                    }
                }
                long new_timeout = now + interval_requested * 1000L * 3L;
                if (peer != null) {
                    long elapsed_time;
                    peer.setTimeout(now, new_timeout);
                    if (!new_peer) {
                        ul_diff = uploaded - peer.getUploaded();
                        dl_diff = downloaded - peer.getDownloaded();
                    }
                    if ((elapsed_time = now - last_contact_time) == 0L) {
                        elapsed_time = 25L;
                    }
                    long ul_rate = ul_diff * 1000L / elapsed_time;
                    long dl_rate = dl_diff * 1000L / elapsed_time;
                    if (ul_rate > 0x300000L) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "TRTrackerPeer: peer " + peer.getIPRaw() + "/" + new String(peer.getPeerId().getHash()) + " reported an upload rate of " + ul_rate / 1024L + " KiB/s per second"));
                        }
                        ul_diff = 0L;
                    }
                    if (dl_rate > 0x300000L) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "TRTrackerPeer: peer " + peer.getIPRaw() + "/" + new String(peer.getPeerId().getHash()) + " reported a download rate of " + dl_rate / 1024L + " KiB/s per second"));
                        }
                        dl_diff = 0L;
                    }
                    le_diff = event_type == 4 ? 0L : left - peer.getAmountLeft();
                    boolean was_seed = new_peer ? false : peer.isSeed();
                    peer.setStats(uploaded, downloaded, left);
                    boolean is_seed = peer.isSeed();
                    if (event_type != 4 && !was_seed && is_seed) {
                        ++this.seed_count;
                    }
                    if (!peer_already_removed) {
                        try {
                            this.peerEvent(peer, event_type, url_parameters);
                        }
                        catch (TRTrackerServerException e) {
                            deferred_failure = e;
                        }
                    }
                }
                this.stats.addAnnounce(ul_diff, dl_diff, le_diff, peer != null && peer.isBiased());
                if (event_type == 3 && !already_completed) {
                    peer.setDownloadCompleted();
                    this.stats.addCompleted();
                }
                if (peer != null && peer.isSeed()) {
                    int seed_limit = TRTrackerServerImpl.getSeedLimit();
                    if (seed_limit != 0 && this.seed_count > seed_limit && !loopback) {
                        if (peer_already_removed) throw new TRTrackerServerException("too many seeds");
                        this.removePeer(peer, 6, null);
                        throw new TRTrackerServerException("too many seeds");
                    }
                    int seed_retention = TRTrackerServerImpl.getMaxSeedRetention();
                    if (seed_retention != 0 && this.seed_count > seed_retention) {
                        int to_remove = seed_retention / 20 + 1;
                        try {
                            int bad_nat_loop;
                            this.peer_list_compaction_suspended = true;
                            int n = bad_nat_loop = TRTrackerServerNATChecker.getSingleton().isEnabled() ? 0 : 1;
                            while (bad_nat_loop < 2) {
                                for (int i = 0; i < this.peer_list.size(); ++i) {
                                    TRTrackerServerPeerImpl this_peer = this.peer_list.get(i);
                                    if (this_peer == null || !this_peer.isSeed() || this_peer.isBiased()) continue;
                                    boolean bad_nat = this_peer.isNATStatusBad();
                                    if ((bad_nat_loop != 0 || !bad_nat) && bad_nat_loop != 1) continue;
                                    this.lightweight_seed_map.put(this_peer.getPeerId(), new lightweightSeed(now, new_timeout, this_peer.getUploaded(), this_peer.getNATStatus()));
                                    this.removePeer(this_peer, i, 6, null);
                                    if (--to_remove == 0) break;
                                }
                                if (to_remove == 0) break;
                                ++bad_nat_loop;
                            }
                            Object var54_63 = null;
                            this.peer_list_compaction_suspended = false;
                        }
                        catch (Throwable throwable) {
                            Object var54_64 = null;
                            this.peer_list_compaction_suspended = false;
                            throw throwable;
                        }
                        this.checkForPeerListCompaction(false);
                    }
                }
                if (deferred_failure != null) {
                    if (peer == null) throw deferred_failure;
                    if (peer_already_removed) throw deferred_failure;
                    this.removePeer(peer, 7, url_parameters);
                    throw deferred_failure;
                }
                tRTrackerServerPeerImpl = peer;
            }
            catch (UnsupportedEncodingException e) {
                throw new TRTrackerServerException("Encoding fails", e);
            }
        }
        catch (Throwable throwable) {
            Object var56_55 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var56_54 = null;
        this.this_mon.exit();
        return tRTrackerServerPeerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void peerQueued(String ip, int tcp_port, int udp_port, int http_port, byte crypto_level, byte az_ver, long timeout_secs, boolean seed) {
        block13: {
            block11: {
                if (this.peer_map.size() >= 32) return;
                if (tcp_port == 0) {
                    return;
                }
                try {
                    boolean add;
                    QueuedPeer new_qp;
                    block12: {
                        block14: {
                            this.this_mon.enter();
                            Set biased_peer_set = this.server.getBiasedPeers();
                            boolean biased = biased_peer_set != null && biased_peer_set.contains(ip);
                            new_qp = new QueuedPeer(ip, tcp_port, udp_port, http_port, crypto_level, az_ver, (int)timeout_secs, seed, biased);
                            String reuse_key = new_qp.getIP() + ":" + tcp_port;
                            if (this.peer_reuse_map.containsKey(reuse_key)) {
                                Object var19_13 = null;
                                this.this_mon.exit();
                                return;
                            }
                            add = true;
                            if (this.queued_peers == null) break block14;
                            Iterator it = this.queued_peers.iterator();
                            while (it.hasNext()) {
                                QueuedPeer qp = (QueuedPeer)it.next();
                                if (!qp.sameAs(new_qp)) continue;
                                it.remove();
                                this.queued_peers.add(new_qp);
                                break block11;
                            }
                            if (this.queued_peers.size() >= 32) {
                                QueuedPeer oldest = null;
                                for (QueuedPeer qp : this.queued_peers) {
                                    if (qp.isBiased()) continue;
                                    if (oldest == null) {
                                        oldest = qp;
                                        continue;
                                    }
                                    if (qp.getCreateTime() >= oldest.getCreateTime()) continue;
                                    oldest = qp;
                                }
                                if (oldest == null) {
                                    add = false;
                                    break block12;
                                } else {
                                    this.queued_peers.remove(oldest);
                                }
                            }
                            break block12;
                        }
                        this.queued_peers = new LinkedList();
                    }
                    if (add) {
                        this.queued_peers.addFirst(new_qp);
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var19_16 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            Object var19_14 = null;
            this.this_mon.exit();
            return;
        }
        Object var19_15 = null;
        this.this_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TRTrackerServerPeerBase peer) {
        try {
            this.this_mon.enter();
            if (peer instanceof TRTrackerServerPeerImpl) {
                int index;
                TRTrackerServerPeerImpl pi = (TRTrackerServerPeerImpl)peer;
                if (this.peer_map.containsKey(pi.getPeerId()) && (index = this.peer_list.indexOf(pi)) != -1) {
                    this.removePeer(pi, index, 7, null);
                }
            } else if (this.queued_peers != null) {
                this.queued_peers.remove(peer);
                if (this.queued_peers.size() == 0) {
                    this.queued_peers = null;
                }
            }
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void removePeer(TRTrackerServerPeerImpl peer, int reason, String url_parameters) {
        this.removePeer(peer, -1, reason, url_parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removePeer(TRTrackerServerPeerImpl peer, int peer_list_index, int reason, String url_parameters) {
        try {
            TRTrackerServerPeerImpl o;
            this.this_mon.enter();
            if (peer.isIPOverride()) {
                --this.ip_override_count;
            }
            this.stats.removeLeft(peer.getAmountLeft());
            if (this.peer_map.size() != this.peer_reuse_map.size() && !this.map_size_diff_reported) {
                this.map_size_diff_reported = true;
                Debug.out("TRTrackerServerTorrent::removePeer: maps size different ( " + this.peer_map.size() + "/" + this.peer_reuse_map.size() + ")");
            }
            if ((o = this.peer_map.remove(peer.getPeerId())) == null) {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_map doesn't contain peer");
            } else {
                try {
                    this.peerEvent(peer, reason, url_parameters);
                }
                catch (TRTrackerServerException e) {
                    // empty catch block
                }
            }
            if (peer_list_index == -1) {
                int peer_index = this.peer_list.indexOf(peer);
                if (peer_index == -1) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer");
                } else {
                    this.peer_list.set(peer_index, null);
                }
            } else if (this.peer_list.get(peer_list_index) == peer) {
                this.peer_list.set(peer_list_index, null);
            } else {
                Debug.out(" TRTrackerServerTorrent::removePeer: peer_list doesn't contain peer at index");
            }
            ++this.peer_list_hole_count;
            this.checkForPeerListCompaction(false);
            try {
                o = this.peer_reuse_map.remove(new String(peer.getIPAsRead(), "ISO-8859-1") + ":" + peer.getTCPPort());
                if (o == null) {
                    Debug.out(" TRTrackerServerTorrent::removePeer: peer_reuse_map doesn't contain peer");
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            if (this.biased_peers != null) {
                this.biased_peers.remove(peer);
            }
            if (peer.isSeed()) {
                --this.seed_count;
            }
            ++this.removed_count;
            Object var8_10 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateBiasedPeers(Set biased_peers_set) {
        try {
            this.this_mon.enter();
            Iterator<TRTrackerServerPeerImpl> it = this.peer_list.iterator();
            if (it.hasNext() && this.biased_peers == null) {
                this.biased_peers = new ArrayList();
            }
            while (it.hasNext()) {
                TRTrackerServerPeerImpl this_peer = it.next();
                if (this_peer == null) continue;
                boolean biased = biased_peers_set.contains(this_peer.getIPRaw());
                this_peer.setBiased(biased);
                if (biased) {
                    if (this.biased_peers.contains(this_peer)) continue;
                    this.biased_peers.add(this_peer);
                    continue;
                }
                this.biased_peers.remove(this_peer);
            }
            if (this.queued_peers != null) {
                for (QueuedPeer peer : this.queued_peers) {
                    peer.setBiased(biased_peers_set.contains(peer.getIP()));
                }
            }
            Object var6_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public TRTrackerServerTorrent addLink(String link) {
        return this.server.addLink(link, this);
    }

    public void removeLink(String link) {
        this.server.removeLink(link, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map exportAnnounceToMap(String ip_address, HashMap preprocess_map, TRTrackerServerPeerImpl requesting_peer, boolean include_seeds, int num_want, long interval, long min_interval, boolean no_peer_id, byte compact_mode, byte crypto_level, DHTNetworkPosition network_position) {
        block122: {
            block125: {
                block124: {
                    block120: {
                        block118: {
                            block123: {
                                block121: {
                                    block119: {
                                        block117: {
                                            block111: {
                                                block112: {
                                                    block108: {
                                                        block106: {
                                                            block107: {
                                                                try {
                                                                    this.this_mon.enter();
                                                                    now = SystemTime.getCurrentTime();
                                                                    nat_warning = requesting_peer != null && requesting_peer.getNATStatus() == 4;
                                                                    total_peers = this.peer_map.size();
                                                                    cache_millis = TRTrackerServerImpl.getAnnounceCachePeriod();
                                                                    send_peer_ids = TRTrackerServerImpl.getSendPeerIds();
                                                                    if (no_peer_id || compact_mode != 0) {
                                                                        send_peer_ids = false;
                                                                    }
                                                                    add_to_cache = false;
                                                                    max_peers = TRTrackerServerImpl.getMaxPeersToSend();
                                                                    if (num_want < 0) {
                                                                        num_want = total_peers;
                                                                    }
                                                                    if (max_peers > 0 && num_want > max_peers) {
                                                                        num_want = max_peers;
                                                                    }
                                                                    explicit_limited_peers = null;
                                                                    explicit_biased_peers = null;
                                                                    remove_ips = null;
                                                                    if (requesting_peer != null && this.peer_listeners != null) {
                                                                        for (i = 0; i < this.peer_listeners.size(); ++i) {
                                                                            try {
                                                                                reply = ((TRTrackerServerTorrentPeerListener)this.peer_listeners.get(i)).eventOccurred(this, requesting_peer, 8, null);
                                                                                if (reply == null) continue;
                                                                                limited_peers = (List)reply.get("limited_peers");
                                                                                if (limited_peers != null) {
                                                                                    if (explicit_limited_peers == null) {
                                                                                        explicit_limited_peers = new ArrayList<TRTrackerServerPeerImpl>();
                                                                                    }
                                                                                    for (j = 0; j < limited_peers.size(); ++j) {
                                                                                        peer_map = (Map)limited_peers.get(j);
                                                                                        ip = (String)peer_map.get("ip");
                                                                                        port = ((Long)peer_map.get("port")).intValue();
                                                                                        reuse_key = ip + ":" + port;
                                                                                        peer = this.peer_reuse_map.get(reuse_key);
                                                                                        if (peer == null || explicit_limited_peers.contains(peer)) continue;
                                                                                        explicit_limited_peers.add(peer);
                                                                                    }
                                                                                }
                                                                                if ((biased_peers = (List)reply.get("biased_peers")) != null) {
                                                                                    if (explicit_biased_peers == null) {
                                                                                        explicit_biased_peers = new ArrayList<TRTrackerServerSimplePeer>();
                                                                                    }
                                                                                    for (j = 0; j < biased_peers.size(); ++j) {
                                                                                        peer_map = (Map)biased_peers.get(j);
                                                                                        ip = (String)peer_map.get("ip");
                                                                                        port = ((Long)peer_map.get("port")).intValue();
                                                                                        reuse_key = ip + ":" + port;
                                                                                        peer = this.peer_reuse_map.get(reuse_key);
                                                                                        if (peer == null) {
                                                                                            peer = new temporaryBiasedSeed(ip, port);
                                                                                        }
                                                                                        if (explicit_biased_peers.contains(peer)) continue;
                                                                                        explicit_biased_peers.add(peer);
                                                                                    }
                                                                                }
                                                                                remove_ips = (Set)reply.get("remove_ips");
                                                                                continue;
                                                                            }
                                                                            catch (Throwable e) {
                                                                                Debug.printStackTrace(e);
                                                                            }
                                                                        }
                                                                    }
                                                                    requester_is_biased = requesting_peer == null ? ((bp = this.server.getBiasedPeers()) == null ? false : bp.contains(ip_address)) : requesting_peer.isBiased();
                                                                    if (this.caching_enabled && explicit_limited_peers == null && explicit_biased_peers == null && !requester_is_biased && remove_ips == null && !nat_warning && preprocess_map.size() == 0 && cache_millis > 0 && num_want >= 10 && total_peers >= TRTrackerServerImpl.getAnnounceCachePeerThreshold() && crypto_level != 2) {
                                                                        network_position = null;
                                                                        it = this.announce_cache.keySet().iterator();
                                                                        while (it.hasNext()) {
                                                                            key = (Integer)it.next();
                                                                            entry = (announceCacheEntry)this.announce_cache.get(key);
                                                                            if (now - entry.getTime() <= (long)cache_millis) continue;
                                                                            it.remove();
                                                                        }
                                                                        for (i = num_want / 10; i > num_want / 20; --i) {
                                                                            entry = (announceCacheEntry)this.announce_cache.get(new Integer(i));
                                                                            if (entry == null) continue;
                                                                            if (now - entry.getTime() > (long)cache_millis) {
                                                                                this.announce_cache.remove(new Integer(i));
                                                                                continue;
                                                                            }
                                                                            if (entry.getSendPeerIds() != send_peer_ids || entry.getCompactMode() != compact_mode) continue;
                                                                            j = entry.getData();
                                                                            var44_91 = null;
                                                                            this.this_mon.exit();
                                                                            return j;
                                                                        }
                                                                        add_to_cache = true;
                                                                    }
                                                                    rep_peers = new LinkedList<HashMap<K, V>>();
                                                                    if (num_want <= 0 || explicit_limited_peers != null) break block106;
                                                                    if (num_want >= total_peers) {
                                                                        break block107;
                                                                    }
                                                                    peer_list_size = this.peer_list.size();
                                                                    if (this.duplicate_peer_checker.length < peer_list_size) {
                                                                        this.duplicate_peer_checker = new byte[peer_list_size * 2];
                                                                        this.duplicate_peer_checker_index = 1;
                                                                    } else if (this.duplicate_peer_checker.length > peer_list_size * 2) {
                                                                        this.duplicate_peer_checker = new byte[3 * peer_list_size / 2];
                                                                        this.duplicate_peer_checker_index = 1;
                                                                    } else {
                                                                        this.duplicate_peer_checker_index = (byte)(this.duplicate_peer_checker_index + 1);
                                                                        if (this.duplicate_peer_checker_index == 0) {
                                                                            Arrays.fill(this.duplicate_peer_checker, (byte)0);
                                                                            this.duplicate_peer_checker_index = 1;
                                                                        }
                                                                    }
                                                                    peer_removed = false;
                                                                    try {
                                                                        this.peer_list_compaction_suspended = true;
                                                                        added = 0;
                                                                        v0 = bad_nat_loop = TRTrackerServerNATChecker.getSingleton().isEnabled() != false ? 0 : 1;
lbl104:
                                                                        // 2 sources

                                                                        while (true) {
                                                                            if (bad_nat_loop < 2) {
                                                                                limit = num_want * 2;
                                                                                if (num_want * 3 > total_peers) {
                                                                                    ++limit;
                                                                                }
                                                                                biased_peers_count = 0;
                                                                                if (this.biased_peers != null) {
                                                                                    if (this.biased_peers.size() > 1) {
                                                                                        x = this.biased_peers.remove(0);
                                                                                        this.biased_peers.add(this.random.nextInt(this.biased_peers.size() + 1), x);
                                                                                    }
                                                                                    biased_peers_count = Math.min(this.min_biased_peers, this.biased_peers.size());
                                                                                }
                                                                                break block108;
                                                                            }
                                                                            var41_116 = null;
                                                                            this.peer_list_compaction_suspended = false;
                                                                            if (!peer_removed) break block106;
                                                                            this.checkForPeerListCompaction(false);
                                                                            break block106;
                                                                            break;
                                                                        }
                                                                    }
                                                                    catch (Throwable var40_119) {
                                                                        var41_117 = null;
                                                                        this.peer_list_compaction_suspended = false;
                                                                        if (peer_removed == false) throw var40_119;
                                                                        this.checkForPeerListCompaction(false);
                                                                        throw var40_119;
                                                                    }
                                                                }
                                                                catch (Throwable var43_124) {
                                                                    var44_93 = null;
                                                                    this.this_mon.exit();
                                                                    throw var43_124;
                                                                }
                                                            }
                                                            for (i = 0; i < this.peer_list.size(); ++i) {
                                                                block110: {
                                                                    block109: {
                                                                        peer = this.peer_list.get(i);
                                                                        if (peer == null || peer == requesting_peer) continue;
                                                                        if (now > peer.getTimeout()) {
                                                                            this.removePeer(peer, i, 5, null);
                                                                            continue;
                                                                        }
                                                                        if (peer.getTCPPort() == 0 || crypto_level == 0 && peer.getCryptoLevel() == 2 || remove_ips != null && remove_ips.contains(new String(peer.getIP())) || !include_seeds && peer.isSeed()) continue;
                                                                        rep_peer = new HashMap<String, Object>(3);
                                                                        if (send_peer_ids) {
                                                                            rep_peer.put("peer id", peer.getPeerId().getHash());
                                                                        }
                                                                        if (compact_mode == 0) break block109;
                                                                        peer_bytes = peer.getIPAddressBytes();
                                                                        if (peer_bytes == null) continue;
                                                                        rep_peer.put("ip", peer_bytes);
                                                                        if (compact_mode >= 2) {
                                                                            rep_peer.put("azver", new Long(peer.getAZVer()));
                                                                            rep_peer.put("azudp", new Long(peer.getUDPPort()));
                                                                            if (peer.isSeed()) {
                                                                                rep_peer.put("azhttp", new Long(peer.getHTTPPort()));
                                                                            }
                                                                            if (compact_mode >= 16) {
                                                                                rep_peer.put("ip", peer.getIPAsRead());
                                                                                break block110;
                                                                            } else {
                                                                                rep_peer.put("azup", new Long(peer.getUpSpeed()));
                                                                                if (peer.isBiased()) {
                                                                                    rep_peer.put("azbiased", "");
                                                                                }
                                                                                if (network_position != null && (peer_pos = peer.getNetworkPosition()) != null && network_position.getPositionType() == peer_pos.getPositionType()) {
                                                                                    rep_peer.put("azrtt", new Long((long)peer_pos.estimateRTT(network_position)));
                                                                                }
                                                                            }
                                                                        }
                                                                        break block110;
                                                                    }
                                                                    rep_peer.put("ip", peer.getIPAsRead());
                                                                }
                                                                rep_peer.put("port", new Long(peer.getTCPPort()));
                                                                if (crypto_level != 0) {
                                                                    rep_peer.put("crypto_flag", new Long(peer.getCryptoLevel() == 2 ? 1L : 0L));
                                                                }
                                                                if (peer.isBiased()) {
                                                                    rep_peers.addFirst(rep_peer);
                                                                    continue;
                                                                }
                                                                rep_peers.addLast(rep_peer);
                                                            }
                                                        }
                                                        if (!include_seeds || explicit_limited_peers != null || send_peer_ids || this.seed_count >= 3 || this.queued_peers == null) break block111;
                                                        it = this.queued_peers.iterator();
                                                        added = new ArrayList<QueuedPeer>(3);
                                                        break block112;
                                                    }
                                                    for (i = 0; i < limit && added < num_want; ++i) {
                                                        block114: {
                                                            block113: {
                                                                if (bad_nat_loop == 1 && i < biased_peers_count) {
                                                                    peer = (TRTrackerServerPeerImpl)this.biased_peers.get(i);
                                                                    peer_index = -1;
                                                                } else {
                                                                    peer_index = this.random.nextInt(peer_list_size);
                                                                    peer = this.peer_list.get(peer_index);
                                                                    if (peer == null || peer.isBiased()) continue;
                                                                }
                                                                if (now > peer.getTimeout()) {
                                                                    this.removePeer(peer, 5, null);
                                                                    peer_removed = true;
                                                                    continue;
                                                                }
                                                                if (requesting_peer == peer || peer.getTCPPort() == 0 || crypto_level == 0 && peer.getCryptoLevel() == 2 || remove_ips != null && remove_ips.contains(new String(peer.getIP())) || !include_seeds && peer.isSeed()) continue;
                                                                bad_nat = peer.isNATStatusBad();
                                                                if ((bad_nat_loop != 0 || bad_nat) && bad_nat_loop != 1 || peer_index != -1 && this.duplicate_peer_checker[peer_index] == this.duplicate_peer_checker_index) continue;
                                                                if (peer_index != -1) {
                                                                    this.duplicate_peer_checker[peer_index] = this.duplicate_peer_checker_index;
                                                                }
                                                                ++added;
                                                                rep_peer = new HashMap<String, Object>(3);
                                                                if (send_peer_ids) {
                                                                    rep_peer.put("peer id", peer.getPeerId().getHash());
                                                                }
                                                                if (compact_mode == 0) break block113;
                                                                peer_bytes = peer.getIPAddressBytes();
                                                                if (peer_bytes == null) continue;
                                                                rep_peer.put("ip", peer_bytes);
                                                                if (compact_mode >= 2) {
                                                                    rep_peer.put("azver", new Long(peer.getAZVer()));
                                                                    rep_peer.put("azudp", new Long(peer.getUDPPort()));
                                                                    if (peer.isSeed()) {
                                                                        rep_peer.put("azhttp", new Long(peer.getHTTPPort()));
                                                                    }
                                                                    if (compact_mode >= 16) {
                                                                        rep_peer.put("ip", peer.getIPAsRead());
                                                                        break block114;
                                                                    } else {
                                                                        rep_peer.put("azup", new Long(peer.getUpSpeed()));
                                                                        if (peer.isBiased()) {
                                                                            rep_peer.put("azbiased", "");
                                                                        }
                                                                        if (network_position != null && (peer_pos = peer.getNetworkPosition()) != null && network_position.getPositionType() == peer_pos.getPositionType()) {
                                                                            rep_peer.put("azrtt", new Long((long)peer_pos.estimateRTT(network_position)));
                                                                        }
                                                                    }
                                                                }
                                                                break block114;
                                                            }
                                                            rep_peer.put("ip", peer.getIPAsRead());
                                                        }
                                                        rep_peer.put("port", new Long(peer.getTCPPort()));
                                                        if (crypto_level != 0) {
                                                            rep_peer.put("crypto_flag", new Long(peer.getCryptoLevel() == 2 ? 1L : 0L));
                                                        }
                                                        if (peer.isBiased()) {
                                                            rep_peers.addFirst(rep_peer);
                                                            continue;
                                                        }
                                                        rep_peers.addLast(rep_peer);
                                                    }
                                                    ++bad_nat_loop;
                                                    ** while (true)
                                                }
                                                while (it.hasNext() && num_want > rep_peers.size() && added.size() < 3) {
                                                    block116: {
                                                        block115: {
                                                            peer = (QueuedPeer)it.next();
                                                            if (peer.isTimedOut(now)) {
                                                                it.remove();
                                                                continue;
                                                            }
                                                            if (crypto_level == 0 && peer.getCryptoLevel() == 2 || remove_ips != null && remove_ips.contains(peer.getIP())) continue;
                                                            rep_peer = new HashMap<String, Object>(3);
                                                            if (compact_mode == 0) break block115;
                                                            peer_bytes = peer.getIPAddressBytes();
                                                            if (peer_bytes == null) continue;
                                                            rep_peer.put("ip", peer_bytes);
                                                            if (compact_mode >= 2) {
                                                                rep_peer.put("azver", new Long(peer.getAZVer()));
                                                                rep_peer.put("azudp", new Long(peer.getUDPPort()));
                                                                if (peer.isSeed()) {
                                                                    rep_peer.put("azhttp", new Long(peer.getHTTPPort()));
                                                                }
                                                                if (compact_mode >= 16) {
                                                                    rep_peer.put("ip", peer.getIPAsRead());
                                                                }
                                                            }
                                                            break block116;
                                                        }
                                                        rep_peer.put("ip", peer.getIPAsRead());
                                                    }
                                                    rep_peer.put("port", new Long(peer.getTCPPort()));
                                                    if (crypto_level != 0) {
                                                        rep_peer.put("crypto_flag", new Long(peer.getCryptoLevel() == 2 ? 1L : 0L));
                                                    }
                                                    rep_peers.addLast(rep_peer);
                                                    added.add(peer);
                                                    it.remove();
                                                }
                                                for (i = 0; i < added.size(); ++i) {
                                                    this.queued_peers.add(added.get(i));
                                                }
                                            }
                                            root = new TreeMap<String, Object>();
                                            if (preprocess_map.size() > 0) {
                                                root.putAll(preprocess_map);
                                            }
                                            if (explicit_limited_peers != null) {
                                                for (i = 0; i < explicit_limited_peers.size(); --num_want, ++i) {
                                                    peer = (TRTrackerServerSimplePeer)explicit_limited_peers.get(i);
                                                    this.exportPeer(rep_peers, peer, send_peer_ids, compact_mode, crypto_level, network_position);
                                                }
                                            }
                                            if (explicit_biased_peers != null) {
                                                for (i = 0; i < explicit_biased_peers.size(); --num_want, ++i) {
                                                    peer = (TRTrackerServerSimplePeer)explicit_biased_peers.get(i);
                                                    this.exportPeer(rep_peers, peer, send_peer_ids, compact_mode, crypto_level, network_position);
                                                }
                                            }
                                            if (this.explicit_manual_biased_peers != null && requesting_peer != null && !requesting_peer.isSeed()) {
                                                explicit_peer = (Object[])this.explicit_manual_biased_peers.get(this.explicit_next_peer++);
                                                if (this.explicit_next_peer == this.explicit_manual_biased_peers.size()) {
                                                    this.explicit_next_peer = 0;
                                                }
                                                rep_peer = new HashMap<String, Object>(3);
                                                if (send_peer_ids) {
                                                    peer_id = new byte[20];
                                                    this.random.nextBytes(peer_id);
                                                    rep_peer.put("peer id", peer_id);
                                                }
                                                if (compact_mode != 0) {
                                                    peer_bytes = (byte[])explicit_peer[1];
                                                    rep_peer.put("ip", peer_bytes);
                                                    if (compact_mode >= 2) {
                                                        rep_peer.put("azver", new Long(0L));
                                                        rep_peer.put("azudp", new Long(0L));
                                                        rep_peer.put("azup", new Long(0L));
                                                        rep_peer.put("azbiased", "");
                                                    }
                                                } else {
                                                    rep_peer.put("ip", ((String)explicit_peer[0]).getBytes());
                                                }
                                                rep_peer.put("port", new Long(((Integer)explicit_peer[2]).intValue()));
                                                if (crypto_level != 0) {
                                                    rep_peer.put("crypto_flag", new Long(0L));
                                                }
                                                rep_peers.addFirst(rep_peer);
                                            }
                                            num_peers_returned = rep_peers.size();
                                            it = rep_peers.iterator();
                                            if (compact_mode != 2) break block117;
                                            compact_peers = new byte[num_peers_returned * 9];
                                            index = 0;
                                            break block118;
                                        }
                                        if (compact_mode != 3) break block119;
                                        compact_peers = new ArrayList<E>(num_peers_returned);
                                        break block120;
                                    }
                                    if (compact_mode != 16) break block121;
                                    xml_peers = new ArrayList<HashMap<K, V>>(num_peers_returned);
                                    while (it.hasNext()) {
                                        rep_peer = (Map)it.next();
                                        peer = new HashMap<String, V>();
                                        xml_peers.add(peer);
                                        peer.put("ip", rep_peer.get("ip"));
                                        peer.put("tcp", rep_peer.get("port"));
                                        udp_port = ((Long)rep_peer.get("azudp")).intValue();
                                        if (udp_port != 0) {
                                            peer.put("udp", new Long(udp_port));
                                        }
                                        if ((http_port_l = (Long)rep_peer.get("azhttp")) == null || (http_port = http_port_l.intValue()) == 0) continue;
                                        peer.put("http", new Long(http_port));
                                    }
                                    root.put("peers", xml_peers);
                                    break block122;
                                }
                                crypto_flags = null;
                                if (crypto_level != 0) {
                                    crypto_flags = new byte[num_peers_returned];
                                }
                                if (compact_mode != 1) break block123;
                                compact_peers = new byte[num_peers_returned * 6];
                                index = 0;
                                num_ipv4 = 0;
                                num_ipv6 = 0;
                                break block124;
                            }
                            index = 0;
                            while (it.hasNext()) {
                                rep_peer = (Map)it.next();
                                if (crypto_flags != null) {
                                    crypto_flag = (Long)rep_peer.remove("crypto_flag");
                                    crypto_flags[index] = crypto_flag.byteValue();
                                }
                                ++index;
                            }
                            root.put("peers", rep_peers);
                            break block125;
                        }
                        while (it.hasNext()) {
                            rep_peer = (Map)it.next();
                            ip = (byte[])rep_peer.get("ip");
                            tcp_port = ((Long)rep_peer.get("port")).intValue();
                            udp_port = ((Long)rep_peer.get("azudp")).intValue();
                            crypto_flag_l = (Long)rep_peer.get("crypto_flag");
                            crypto_flag = crypto_flag_l == null ? 0 : crypto_flag_l.byteValue();
                            pos = index * 9;
                            System.arraycopy(ip, 0, compact_peers, pos, 4);
                            pos += 4;
                            compact_peers[pos++] = (byte)(tcp_port >> 8);
                            compact_peers[pos++] = (byte)(tcp_port & 255);
                            compact_peers[pos++] = (byte)(udp_port >> 8);
                            compact_peers[pos++] = (byte)(udp_port & 255);
                            compact_peers[pos++] = crypto_flag;
                            ++index;
                        }
                        root.put("peers", compact_peers);
                        root.put("azcompact", new Long(1L));
                        break block122;
                    }
                    while (it.hasNext()) {
                        rep_peer = (Map)it.next();
                        peer = new HashMap<String, Object>();
                        compact_peers.add(peer);
                        ip = (byte[])rep_peer.get("ip");
                        peer.put("i", ip);
                        tcp_port = ((Long)rep_peer.get("port")).intValue();
                        peer.put("t", new byte[]{(byte)(tcp_port >> 8), (byte)(tcp_port & 255)});
                        udp_port = ((Long)rep_peer.get("azudp")).intValue();
                        if (udp_port != 0) {
                            if (udp_port == tcp_port) {
                                peer.put("u", new byte[0]);
                            } else {
                                peer.put("u", new byte[]{(byte)(udp_port >> 8), (byte)(udp_port & 255)});
                            }
                        }
                        if ((http_port_l = (Long)rep_peer.get("azhttp")) != null && (http_port = http_port_l.intValue()) != 0) {
                            peer.put("h", new byte[]{(byte)(http_port >> 8), (byte)(http_port & 255)});
                        }
                        v1 = crypto_flag = (crypto_flag_l = (Long)rep_peer.get("crypto_flag")) == null ? 0 : crypto_flag_l.byteValue();
                        if (crypto_flag != 0) {
                            peer.put("c", new byte[]{crypto_flag});
                        }
                        v2 = az_ver = (az_ver_l = (Long)rep_peer.get("azver")) == null ? 0 : az_ver_l.byteValue();
                        if (az_ver != 0) {
                            peer.put("v", new Long(az_ver));
                        }
                        if ((up_speed = (Long)rep_peer.get("azup")) != null && up_speed != 0L) {
                            peer.put("s", up_speed);
                        }
                        if ((rtt = (Long)rep_peer.get("azrtt")) != null) {
                            peer.put("r", rtt);
                        }
                        if (!rep_peer.containsKey("azbiased")) continue;
                        peer.put("b", new Long(1L));
                    }
                    root.put("peers", compact_peers);
                    root.put("azcompact", new Long(2L));
                    break block122;
                }
                while (it.hasNext()) {
                    rep_peer = (Map)it.next();
                    ip = (byte[])rep_peer.get("ip");
                    if (ip.length > 4) {
                        ++num_ipv6;
                    } else {
                        ++num_ipv4;
                        if (num_ipv6 == 0) {
                            port = ((Long)rep_peer.get("port")).intValue();
                            pos = index * 6;
                            System.arraycopy(ip, 0, compact_peers, pos, 4);
                            pos += 4;
                            compact_peers[pos++] = (byte)(port >> 8);
                            compact_peers[pos++] = (byte)(port & 255);
                        }
                    }
                    if (crypto_flags != null) {
                        crypto_flag = (Long)rep_peer.remove("crypto_flag");
                        crypto_flags[index] = crypto_flag.byteValue();
                    }
                    ++index;
                }
                if (num_ipv6 <= 0) {
                    root.put("peers", compact_peers);
                } else {
                    compact_peers_v4 = new byte[num_ipv4 * 6];
                    compact_peers_v6 = new byte[num_ipv6 * 18];
                    it = rep_peers.iterator();
                    v4_index = 0;
                    v6_index = 0;
                    while (it.hasNext()) {
                        rep_peer = (Map)it.next();
                        ip = (byte[])rep_peer.get("ip");
                        port = ((Long)rep_peer.get("port")).intValue();
                        if (ip.length > 4) {
                            pos = v6_index * 18;
                            System.arraycopy(ip, 0, compact_peers_v6, pos, 16);
                            pos += 16;
                            compact_peers_v6[pos++] = (byte)(port >> 8);
                            compact_peers_v6[pos++] = (byte)(port & 255);
                            ++v6_index;
                            continue;
                        }
                        pos = v4_index * 6;
                        System.arraycopy(ip, 0, compact_peers_v4, pos, 4);
                        pos += 4;
                        compact_peers_v4[pos++] = (byte)(port >> 8);
                        compact_peers_v4[pos++] = (byte)(port & 255);
                        ++v4_index;
                    }
                    if (compact_peers_v4.length > 0) {
                        root.put("peers", compact_peers_v4);
                    }
                    if (compact_peers_v6.length > 0) {
                        root.put("peers6", compact_peers_v6);
                    }
                }
            }
            if (crypto_flags != null) {
                root.put("crypto_flags", crypto_flags);
            }
        }
        root.put("interval", new Long(interval));
        root.put("min interval", new Long(min_interval));
        if (nat_warning) {
            requesting_peer.setNATStatus((byte)5);
            root.put("warning message", ("Unable to connect to your incoming data port (" + requesting_peer.getIP() + ":" + requesting_peer.getTCPPort() + "). " + "This will result in slow downloads. Please check your firewall/router settings").getBytes());
        }
        root.put("complete", new Long(this.getSeedCountForScrape(requester_is_biased)));
        root.put("incomplete", new Long(this.getLeecherCount()));
        root.put("downloaded", new Long(this.stats.getCompletedCount()));
        if (add_to_cache) {
            this.announce_cache.put(new Integer((num_peers_returned + 9) / 10), new announceCacheEntry(root, send_peer_ids, compact_mode));
        }
        var30_56 = root;
        var44_92 = null;
        this.this_mon.exit();
        return var30_56;
    }

    private void exportPeer(LinkedList rep_peers, TRTrackerServerSimplePeer peer, boolean send_peer_ids, byte compact_mode, byte crypto_level, DHTNetworkPosition network_position) {
        HashMap<String, Object> rep_peer = new HashMap<String, Object>(3);
        if (send_peer_ids) {
            rep_peer.put("peer id", peer.getPeerId().getHash());
        }
        if (compact_mode != 0) {
            byte[] peer_bytes = peer.getIPAddressBytes();
            if (peer_bytes == null) {
                return;
            }
            rep_peer.put("ip", peer_bytes);
            if (compact_mode >= 2) {
                rep_peer.put("azver", new Long(peer.getAZVer()));
                rep_peer.put("azudp", new Long(peer.getUDPPort()));
                if (peer.isSeed()) {
                    rep_peer.put("azhttp", new Long(peer.getHTTPPort()));
                }
                if (compact_mode >= 16) {
                    rep_peer.put("ip", peer.getIPAsRead());
                } else {
                    DHTNetworkPosition peer_pos;
                    rep_peer.put("azup", new Long(peer.getUpSpeed()));
                    if (peer.isBiased()) {
                        rep_peer.put("azbiased", "");
                    }
                    if (network_position != null && (peer_pos = peer.getNetworkPosition()) != null && network_position.getPositionType() == peer_pos.getPositionType()) {
                        rep_peer.put("azrtt", new Long((long)peer_pos.estimateRTT(network_position)));
                    }
                }
            }
        } else {
            rep_peer.put("ip", peer.getIPAsRead());
        }
        rep_peer.put("port", new Long(peer.getTCPPort()));
        if (crypto_level != 0) {
            rep_peer.put("crypto_flag", new Long(peer.getCryptoLevel() == 2 ? 1L : 0L));
        }
        if (peer.isBiased()) {
            rep_peers.addFirst(rep_peer);
        } else {
            rep_peers.addLast(rep_peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map exportScrapeToMap(String url_parameters, String ip_address, boolean allow_cache) throws TRTrackerServerException {
        long now;
        block3: {
            try {
                this.this_mon.enter();
                this.handleRedirects(url_parameters, ip_address, true);
                this.stats.addScrape();
                now = SystemTime.getCurrentTime();
                long diff = now - this.last_scrape_calc_time;
                if (!allow_cache || this.last_scrape == null || diff >= (long)TRTrackerServerImpl.getScrapeCachePeriod() || diff < 0L) break block3;
                Map map = this.last_scrape;
                Object var12_8 = null;
                this.this_mon.exit();
                return map;
            }
            catch (Throwable throwable) {
                Object var12_10 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        this.last_scrape = new TreeMap();
        this.last_scrape_calc_time = now;
        Set bp = this.server.getBiasedPeers();
        boolean requester_is_biased = bp == null ? false : bp.contains(ip_address);
        this.last_scrape.put("complete", new Long(this.getSeedCountForScrape(requester_is_biased)));
        this.last_scrape.put("incomplete", new Long(this.getLeecherCount()));
        this.last_scrape.put("downloaded", new Long(this.stats.getCompletedCount()));
        Map map = this.last_scrape;
        Object var12_9 = null;
        this.this_mon.exit();
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkTimeouts() {
        try {
            this.this_mon.enter();
            long now = SystemTime.getCurrentTime();
            int new_bad_NAT_count = 0;
            int new_seed_count = 0;
            try {
                this.peer_list_compaction_suspended = true;
                for (int i = 0; i < this.peer_list.size(); ++i) {
                    TRTrackerServerPeerImpl peer = this.peer_list.get(i);
                    if (peer == null) continue;
                    if (now > peer.getTimeout()) {
                        this.removePeer(peer, i, 5, null);
                        continue;
                    }
                    if (peer.isSeed()) {
                        ++new_seed_count;
                    }
                    if (!peer.isNATStatusBad()) continue;
                    ++new_bad_NAT_count;
                }
                Object var8_8 = null;
                this.peer_list_compaction_suspended = false;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.peer_list_compaction_suspended = false;
                throw throwable;
            }
            this.bad_NAT_count = new_bad_NAT_count;
            this.seed_count = new_seed_count;
            if (this.removed_count > 1000) {
                this.removed_count = 0;
                this.checkForPeerListCompaction(true);
                HashMap<HashWrapper, TRTrackerServerPeerImpl> new_peer_map = new HashMap<HashWrapper, TRTrackerServerPeerImpl>(this.peer_map);
                HashMap<String, TRTrackerServerPeerImpl> new_peer_reuse_map = new HashMap<String, TRTrackerServerPeerImpl>(this.peer_reuse_map);
                this.peer_map = new_peer_map;
                this.peer_reuse_map = new_peer_reuse_map;
            } else {
                this.checkForPeerListCompaction(false);
            }
            Iterator it = this.lightweight_seed_map.values().iterator();
            while (it.hasNext()) {
                lightweightSeed lws = (lightweightSeed)it.next();
                if (now <= lws.getTimeout()) continue;
                it.remove();
            }
            Object var10_11 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void checkForPeerListCompaction(boolean force) {
        if (this.peer_list_hole_count > 0 && !this.peer_list_compaction_suspended && (force || this.peer_list_hole_count > this.peer_map.size() / 10)) {
            ArrayList<TRTrackerServerPeerImpl> new_peer_list = new ArrayList<TRTrackerServerPeerImpl>(this.peer_list.size() - this.peer_list_hole_count / 2);
            int holes_found = 0;
            for (int i = 0; i < this.peer_list.size(); ++i) {
                TRTrackerServerPeerImpl obj = this.peer_list.get(i);
                if (obj == null) {
                    ++holes_found;
                    continue;
                }
                new_peer_list.add(obj);
            }
            if (holes_found != this.peer_list_hole_count) {
                Debug.out("TRTrackerTorrent:compactHoles: count mismatch");
            }
            this.peer_list = new_peer_list;
            this.peer_list_hole_count = 0;
        }
    }

    protected void updateXferStats(int bytes_in, int bytes_out) {
        this.stats.addXferStats(bytes_in, bytes_out);
    }

    public TRTrackerServerTorrentStats getStats() {
        return this.stats;
    }

    protected int getPeerCount() {
        return this.peer_map.size() + this.lightweight_seed_map.size();
    }

    protected int getSeedCount() {
        if (this.seed_count < 0) {
            Debug.out("seed count negative");
        }
        return this.seed_count + this.lightweight_seed_map.size();
    }

    protected int getSeedCountForScrape(boolean requester_is_biased) {
        int queued;
        int seeds = this.getSeedCount();
        if (this.biased_peers != null && !requester_is_biased) {
            int bpc = 0;
            for (TRTrackerServerPeerImpl bp : this.biased_peers) {
                if (!bp.isSeed()) continue;
                --seeds;
                ++bpc;
            }
            if (seeds < 0) {
                seeds = 0;
            }
            if (bpc > 0) {
                ++seeds;
            }
        }
        if ((queued = this.getQueuedCount()) > 0) {
            ++seeds;
        }
        return seeds;
    }

    protected int getLeecherCount() {
        int res = this.peer_map.size() - this.seed_count;
        return res < 0 ? 0 : res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerPeer[] getPeers() {
        try {
            this.this_mon.enter();
            TRTrackerServerPeer[] res = new TRTrackerServerPeer[this.peer_map.size()];
            this.peer_map.values().toArray(res);
            TRTrackerServerPeer[] tRTrackerServerPeerArray = res;
            Object var4_3 = null;
            this.this_mon.exit();
            return tRTrackerServerPeerArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected int getQueuedCount() {
        LinkedList l = this.queued_peers;
        if (l == null) {
            return 0;
        }
        return l.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRTrackerServerPeerBase[] getQueuedPeers() {
        block3: {
            try {
                this.this_mon.enter();
                if (this.queued_peers != null) break block3;
                TRTrackerServerPeerBase[] tRTrackerServerPeerBaseArray = new TRTrackerServerPeerBase[]{};
                Object var4_3 = null;
                this.this_mon.exit();
                return tRTrackerServerPeerBaseArray;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        TRTrackerServerPeerBase[] res = new TRTrackerServerPeerBase[this.queued_peers.size()];
        this.queued_peers.toArray(res);
        TRTrackerServerPeerBase[] tRTrackerServerPeerBaseArray = res;
        Object var4_4 = null;
        this.this_mon.exit();
        return tRTrackerServerPeerBaseArray;
    }

    public HashWrapper getHash() {
        return this.hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitBiasedPeer(String ip, int port) {
        byte[] bytes = HostNameToIPResolver.hostAddressToBytes(ip);
        if (bytes != null) {
            try {
                this.this_mon.enter();
                if (this.explicit_manual_biased_peers == null) {
                    this.explicit_manual_biased_peers = new ArrayList();
                }
                this.explicit_manual_biased_peers.add(new Object[]{ip, bytes, new Integer(port)});
                Object var5_4 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRedirects(URL[] urls) {
        try {
            this.this_mon.enter();
            this.redirects = urls;
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public URL[] getRedirects() {
        return this.redirects;
    }

    protected void handleRedirects(String url_parameters, String real_ip_address, boolean scrape) throws TRTrackerServerException {
        if (this.redirects != null) {
            if (url_parameters.indexOf("permredirect") != -1) {
                Debug.out("redirect recursion");
                throw new TRTrackerServerException("redirection recursion not supported");
            }
            URL redirect = this.redirects[real_ip_address.hashCode() % this.redirects.length];
            HashMap<String, String> headers = new HashMap<String, String>();
            String redirect_str = redirect.toString();
            if (scrape) {
                int pos = redirect_str.indexOf("/announce");
                if (pos == -1) {
                    return;
                }
                redirect_str = redirect_str.substring(0, pos) + "/scrape" + redirect_str.substring(pos + 9);
            }
            redirect_str = redirect_str.indexOf(63) == -1 ? redirect_str + "?" : redirect_str + "&";
            redirect_str = redirect_str + "permredirect=1";
            if (url_parameters.length() > 0) {
                redirect_str = redirect_str + "&" + url_parameters;
            }
            System.out.println("redirect -> " + redirect_str);
            headers.put("Location", redirect_str);
            throw new TRTrackerServerException(301, "Moved Permanently", headers);
        }
    }

    public void addListener(TRTrackerServerTorrentListener l) {
        this.listeners.add(l);
        if (this.deleted) {
            l.deleted(this);
        }
    }

    public void removeListener(TRTrackerServerTorrentListener l) {
        this.listeners.remove(l);
    }

    protected void peerEvent(TRTrackerServerPeer peer, int event2, String url_parameters) throws TRTrackerServerException {
        if (this.peer_listeners != null) {
            for (int i = 0; i < this.peer_listeners.size(); ++i) {
                try {
                    ((TRTrackerServerTorrentPeerListener)this.peer_listeners.get(i)).eventOccurred(this, peer, event2, url_parameters);
                    continue;
                }
                catch (TRTrackerServerException e) {
                    throw e;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void addPeerListener(TRTrackerServerTorrentPeerListener l) {
        if (this.peer_listeners == null) {
            this.peer_listeners = new ArrayList();
        }
        this.peer_listeners.add(l);
    }

    public void removePeerListener(TRTrackerServerTorrentPeerListener l) {
        if (this.peer_listeners != null) {
            this.peer_listeners.remove(l);
        }
    }

    public void disableCaching() {
        this.caching_enabled = false;
    }

    public boolean isCachingEnabled() {
        return this.caching_enabled;
    }

    public int getBadNATPeerCount() {
        return this.bad_NAT_count;
    }

    protected void delete() {
        this.deleted = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TRTrackerServerTorrentListener)this.listeners.get(i)).deleted(this);
        }
    }

    public String getString() {
        String redirect;
        if (this.redirects == null) {
            redirect = "none";
        } else {
            redirect = "";
            for (int i = 0; i < this.redirects.length; ++i) {
                redirect = redirect + (i == 0 ? "" : ",") + this.redirects[i];
            }
        }
        return "seeds=" + this.getSeedCount() + ",leechers=" + this.getLeecherCount() + ", redirect=" + redirect;
    }

    protected static class QueuedPeer
    implements TRTrackerServerPeerBase {
        private static final byte FLAG_SEED = 1;
        private static final byte FLAG_BIASED = 2;
        private short tcp_port;
        private short udp_port;
        private short http_port;
        private byte[] ip;
        private byte crypto_level;
        private byte az_ver;
        private int create_time_secs;
        private int timeout_secs;
        private byte flags;

        protected QueuedPeer(String _ip_str, int _tcp_port, int _udp_port, int _http_port, byte _crypto_level, byte _az_ver, int _timeout_secs, boolean _seed, boolean _biased) {
            try {
                this.ip = _ip_str.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                Debug.printStackTrace(e);
            }
            this.tcp_port = (short)_tcp_port;
            this.udp_port = (short)_udp_port;
            this.http_port = (short)_http_port;
            this.crypto_level = _crypto_level;
            this.az_ver = _az_ver;
            this.setFlag((byte)1, _seed);
            this.setFlag((byte)2, _biased);
            this.create_time_secs = (int)(SystemTime.getCurrentTime() / 1000L);
            this.timeout_secs = _timeout_secs * 3;
        }

        protected boolean sameAs(TRTrackerServerPeerImpl peer) {
            return this.tcp_port == peer.getTCPPort() && Arrays.equals(this.ip, peer.getIPAsRead()) && this.isIPOverride() == peer.isIPOverride();
        }

        protected boolean sameAs(QueuedPeer other) {
            return this.tcp_port == other.tcp_port && Arrays.equals(this.ip, other.ip);
        }

        protected byte[] getIPAsRead() {
            return this.ip;
        }

        public String getIP() {
            try {
                return new String(this.ip, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException e) {
                return new String(this.ip);
            }
        }

        protected boolean isSeed() {
            return this.getFlag((byte)1);
        }

        protected void setBiased(boolean _biased) {
            this.setFlag((byte)2, _biased);
        }

        protected boolean isBiased() {
            return this.getFlag((byte)2);
        }

        protected boolean isIPOverride() {
            return false;
        }

        protected void setFlag(byte flag, boolean value) {
            this.flags = value ? (byte)(this.flags | flag) : (byte)(this.flags & ~flag);
        }

        protected boolean getFlag(byte flag) {
            return (this.flags & flag) != 0;
        }

        protected byte[] getIPAddressBytes() {
            try {
                return HostNameToIPResolver.hostAddressToBytes(new String(this.ip, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                Debug.printStackTrace(e);
                return null;
            }
        }

        public int getTCPPort() {
            return this.tcp_port & 0xFFFF;
        }

        public int getUDPPort() {
            return this.udp_port & 0xFFFF;
        }

        public int getHTTPPort() {
            return this.http_port & 0xFFFF;
        }

        protected byte getCryptoLevel() {
            return this.crypto_level;
        }

        protected byte getAZVer() {
            return this.az_ver;
        }

        protected int getCreateTime() {
            return this.create_time_secs;
        }

        protected boolean isTimedOut(long now_millis) {
            int now_secs = (int)(now_millis / 1000L);
            if (now_secs < this.create_time_secs) {
                this.create_time_secs = now_secs;
            }
            return this.create_time_secs + this.timeout_secs < now_secs;
        }

        public int getSecsToLive() {
            int now_secs = (int)(SystemTime.getCurrentTime() / 1000L);
            if (now_secs < this.create_time_secs) {
                this.create_time_secs = now_secs;
            }
            return this.create_time_secs + this.timeout_secs - now_secs;
        }

        protected String getString() {
            return new String(this.ip) + ":" + this.getTCPPort() + "/" + this.getUDPPort() + "/" + this.getCryptoLevel();
        }
    }

    static class announceCacheEntry {
        protected Map data;
        protected boolean send_peer_ids;
        protected byte compact_mode;
        protected long time;

        protected announceCacheEntry(Map _data, boolean _send_peer_ids, byte _compact_mode) {
            this.data = _data;
            this.send_peer_ids = _send_peer_ids;
            this.compact_mode = _compact_mode;
            this.time = SystemTime.getCurrentTime();
        }

        protected boolean getSendPeerIds() {
            return this.send_peer_ids;
        }

        protected byte getCompactMode() {
            return this.compact_mode;
        }

        protected long getTime() {
            return this.time;
        }

        protected Map getData() {
            return this.data;
        }
    }

    protected static class lightweightSeed {
        long timeout;
        long last_contact_time;
        long uploaded;
        byte nat_status;

        protected lightweightSeed(long _now, long _timeout, long _uploaded, byte _nat_status) {
            this.last_contact_time = _now;
            this.timeout = _timeout;
            this.uploaded = _uploaded;
            this.nat_status = _nat_status;
        }

        protected long getTimeout() {
            return this.timeout;
        }

        protected long getLastContactTime() {
            return this.last_contact_time;
        }

        protected long getUploaded() {
            return this.uploaded;
        }

        protected byte getNATStatus() {
            return this.nat_status;
        }
    }

    protected class temporaryBiasedSeed
    implements TRTrackerServerSimplePeer {
        private String ip;
        private int tcp_port;
        private HashWrapper peer_id;

        protected temporaryBiasedSeed(String _ip, int _tcp_port) {
            this.ip = _ip;
            this.tcp_port = _tcp_port;
            this.peer_id = new HashWrapper(RandomUtils.nextHash());
        }

        public byte[] getIPAsRead() {
            try {
                return this.ip.getBytes("ISO-8859-1");
            }
            catch (Throwable e) {
                return this.ip.getBytes();
            }
        }

        public byte[] getIPAddressBytes() {
            try {
                return InetAddress.getByName(this.ip).getAddress();
            }
            catch (Throwable e) {
                return null;
            }
        }

        public HashWrapper getPeerId() {
            return this.peer_id;
        }

        public int getTCPPort() {
            return this.tcp_port;
        }

        public int getUDPPort() {
            return 0;
        }

        public int getHTTPPort() {
            return 0;
        }

        public boolean isSeed() {
            return true;
        }

        public boolean isBiased() {
            return true;
        }

        public byte getCryptoLevel() {
            return 0;
        }

        public byte getAZVer() {
            return 0;
        }

        public int getUpSpeed() {
            return 0;
        }

        public DHTNetworkPosition getNetworkPosition() {
            return null;
        }
    }
}

