/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderCandidate;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoderFallback;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.internat.LocaleUtilListener;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class LocaleTorrentUtil {
    private static List listeners = new ArrayList();

    public static LocaleUtilDecoder getTorrentEncodingIfAvailable(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException {
        String canonical_name;
        String encoding = torrent.getAdditionalStringProperty("encoding");
        if (encoding == null) {
            return null;
        }
        if ("utf8 keys".equals(encoding)) {
            encoding = "utf8";
        }
        try {
            canonical_name = Charset.forName(encoding).name();
        }
        catch (Throwable e) {
            canonical_name = encoding;
        }
        LocaleUtilDecoder chosenDecoder = null;
        LocaleUtilDecoder[] all_decoders = LocaleUtil.getSingleton().getDecoders();
        for (int i = 0; i < all_decoders.length; ++i) {
            if (!all_decoders[i].getName().equals(canonical_name)) continue;
            chosenDecoder = all_decoders[i];
            break;
        }
        return chosenDecoder;
    }

    public static LocaleUtilDecoder getTorrentEncoding(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException {
        return LocaleTorrentUtil.getTorrentEncoding(torrent, true);
    }

    public static LocaleUtilDecoder getTorrentEncoding(TOTorrent torrent, boolean saveToFileAllowed) throws TOTorrentException, UnsupportedEncodingException {
        boolean bSaveToFile;
        String encoding = torrent.getAdditionalStringProperty("encoding");
        if ("utf8 keys".equals(encoding)) {
            encoding = "utf8";
        }
        try {
            TorrentUtils.getTorrentFileName(torrent);
            bSaveToFile = true;
        }
        catch (Throwable e) {
            bSaveToFile = false;
        }
        if (encoding != null) {
            try {
                LocaleUtilDecoder[] all_decoders = LocaleUtil.getSingleton().getDecoders();
                LocaleUtilDecoder fallback_decoder = LocaleUtil.getSingleton().getFallBackDecoder();
                String canonical_name = encoding.equals(fallback_decoder.getName()) ? encoding : Charset.forName(encoding).name();
                for (int i = 0; i < all_decoders.length; ++i) {
                    if (!all_decoders[i].getName().equals(canonical_name)) continue;
                    return all_decoders[i];
                }
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        LocaleUtilDecoderCandidate[] candidates = LocaleTorrentUtil.getTorrentCandidates(torrent);
        boolean system_decoder_is_valid = false;
        LocaleUtil localeUtil = LocaleUtil.getSingleton();
        LocaleUtilDecoder system_decoder = localeUtil.getSystemDecoder();
        for (int i = 0; i < candidates.length; ++i) {
            if (candidates[i].getDecoder() != system_decoder) continue;
            system_decoder_is_valid = true;
            break;
        }
        LocaleUtilDecoder selected_decoder = null;
        for (int i = 0; i < listeners.size(); ++i) {
            LocaleUtilDecoderCandidate candidate = null;
            try {
                candidate = ((LocaleUtilListener)listeners.get(i)).selectDecoder(localeUtil, torrent, candidates);
            }
            catch (LocaleUtilEncodingException e) {
                // empty catch block
            }
            if (candidate != null) {
                selected_decoder = candidate.getDecoder();
                break;
            }
            bSaveToFile = false;
        }
        if (selected_decoder == null) {
            selected_decoder = system_decoder_is_valid ? localeUtil.getSystemDecoder() : localeUtil.getFallBackDecoder();
        }
        torrent.setAdditionalStringProperty("encoding", selected_decoder.getName());
        if (bSaveToFile && saveToFileAllowed) {
            TorrentUtils.writeToFile(torrent);
        }
        return selected_decoder;
    }

    protected static LocaleUtilDecoderCandidate[] getTorrentCandidates(TOTorrent torrent) throws TOTorrentException, UnsupportedEncodingException {
        byte[] created;
        HashSet cand_set = new HashSet();
        LocaleUtil localeUtil = LocaleUtil.getSingleton();
        List candidateDecoders = localeUtil.getCandidateDecoders(torrent.getName());
        long lMinCandidates = candidateDecoders.size();
        byte[] minCandidatesArray = torrent.getName();
        cand_set.addAll(candidateDecoders);
        TOTorrentFile[] files = torrent.getFiles();
        for (int i = 0; i < files.length; ++i) {
            TOTorrentFile file = files[i];
            byte[][] comps = file.getPathComponents();
            for (int j = 0; j < comps.length; ++j) {
                candidateDecoders = localeUtil.getCandidateDecoders(comps[j]);
                if ((long)candidateDecoders.size() < lMinCandidates) {
                    lMinCandidates = candidateDecoders.size();
                    minCandidatesArray = comps[j];
                }
                cand_set.retainAll(candidateDecoders);
            }
        }
        byte[] comment = torrent.getComment();
        if (comment != null) {
            candidateDecoders = localeUtil.getCandidateDecoders(comment);
            if ((long)candidateDecoders.size() < lMinCandidates) {
                lMinCandidates = candidateDecoders.size();
                minCandidatesArray = comment;
            }
            cand_set.retainAll(candidateDecoders);
        }
        if ((created = torrent.getCreatedBy()) != null) {
            candidateDecoders = localeUtil.getCandidateDecoders(created);
            if ((long)candidateDecoders.size() < lMinCandidates) {
                lMinCandidates = candidateDecoders.size();
                minCandidatesArray = created;
            }
            cand_set.retainAll(candidateDecoders);
        }
        List candidatesList = localeUtil.getCandidatesAsList(minCandidatesArray);
        LocaleUtilDecoderCandidate[] candidates = new LocaleUtilDecoderCandidate[candidatesList.size()];
        candidatesList.toArray(candidates);
        Arrays.sort(candidates, new Comparator(){

            public int compare(Object o1, Object o2) {
                LocaleUtilDecoderCandidate luc1 = (LocaleUtilDecoderCandidate)o1;
                LocaleUtilDecoderCandidate luc2 = (LocaleUtilDecoderCandidate)o2;
                return luc1.getDecoder().getIndex() - luc2.getDecoder().getIndex();
            }
        });
        return candidates;
    }

    public static void setTorrentEncoding(TOTorrent torrent, String encoding) throws LocaleUtilEncodingException {
        try {
            String canonical_requested_name;
            LocaleUtil localeUtil = LocaleUtil.getSingleton();
            LocaleUtilDecoderCandidate[] candidates = LocaleTorrentUtil.getTorrentCandidates(torrent);
            if (encoding.equalsIgnoreCase("system")) {
                canonical_requested_name = localeUtil.getSystemEncoding();
            } else if (encoding.equalsIgnoreCase(LocaleUtilDecoderFallback.NAME)) {
                canonical_requested_name = LocaleUtilDecoderFallback.NAME;
            } else {
                CharsetDecoder requested_decoder = Charset.forName(encoding).newDecoder();
                canonical_requested_name = requested_decoder.charset().name();
            }
            boolean ok = false;
            for (int i = 0; i < candidates.length; ++i) {
                if (!candidates[i].getDecoder().getName().equals(canonical_requested_name)) continue;
                ok = true;
                break;
            }
            if (!ok) {
                String[] charsets = new String[candidates.length];
                String[] names = new String[candidates.length];
                for (int i = 0; i < candidates.length; ++i) {
                    LocaleUtilDecoder decoder = candidates[i].getDecoder();
                    charsets[i] = decoder.getName();
                    names[i] = decoder.decodeString(torrent.getName());
                }
                throw new LocaleUtilEncodingException(charsets, names);
            }
            torrent.setAdditionalStringProperty("encoding", canonical_requested_name);
        }
        catch (Throwable e) {
            if (e instanceof LocaleUtilEncodingException) {
                throw (LocaleUtilEncodingException)e;
            }
            throw new LocaleUtilEncodingException(e);
        }
    }

    public static void setDefaultTorrentEncoding(TOTorrent torrent) throws LocaleUtilEncodingException {
        LocaleTorrentUtil.setTorrentEncoding(torrent, "UTF8");
    }

    public static String getCurrentTorrentEncoding(TOTorrent torrent) {
        return torrent.getAdditionalStringProperty("encoding");
    }

    public static void addListener(LocaleUtilListener l) {
        listeners.add(l);
    }

    public static void removeListener(LocaleUtilListener l) {
        listeners.remove(l);
    }
}

