/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.category.impl;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.impl.CategoryManagerImpl;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryImpl
implements Category,
Comparable {
    private String sName;
    private int type;
    private List managers = new ArrayList();
    private int upload_speed;
    private int download_speed;
    private final Map<String, String> attributes;
    private LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        public String getName() {
            return "cat_up: " + CategoryImpl.this.sName;
        }

        public int getRateLimitBytesPerSecond() {
            return CategoryImpl.this.upload_speed;
        }
    };
    private LimitedRateGroup download_limiter = new LimitedRateGroup(){

        public String getName() {
            return "cat_down: " + CategoryImpl.this.sName;
        }

        public int getRateLimitBytesPerSecond() {
            return CategoryImpl.this.download_speed;
        }
    };
    private static final int LDT_CATEGORY_DMADDED = 1;
    private static final int LDT_CATEGORY_DMREMOVED = 2;
    private ListenerManager category_listeners = ListenerManager.createManager("CatListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object _listener, int type, Object value) {
            CategoryListener target = (CategoryListener)_listener;
            if (type == 1) {
                target.downloadManagerAdded(CategoryImpl.this, (DownloadManager)value);
            } else if (type == 2) {
                target.downloadManagerRemoved(CategoryImpl.this, (DownloadManager)value);
            }
        }
    });

    public CategoryImpl(String sName, int maxup, int maxdown, Map<String, String> _attributes) {
        this.sName = sName;
        this.type = 0;
        this.upload_speed = maxup;
        this.download_speed = maxdown;
        this.attributes = _attributes;
    }

    public CategoryImpl(String sName, int type, Map<String, String> _attributes) {
        this.sName = sName;
        this.type = type;
        this.attributes = _attributes;
    }

    @Override
    public void addCategoryListener(CategoryListener l) {
        this.category_listeners.addListener(l);
    }

    @Override
    public void removeCategoryListener(CategoryListener l) {
        this.category_listeners.removeListener(l);
    }

    @Override
    public String getName() {
        return this.sName;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public List getDownloadManagers(List all_dms) {
        if (this.type == 0) {
            return this.managers;
        }
        if (this.type == 1) {
            return all_dms;
        }
        ArrayList<DownloadManager> result = new ArrayList<DownloadManager>();
        for (int i = 0; i < all_dms.size(); ++i) {
            DownloadManager dm = (DownloadManager)all_dms.get(i);
            Category cat = dm.getDownloadState().getCategory();
            if (cat != null && cat.getType() != 2) continue;
            result.add(dm);
        }
        return result;
    }

    @Override
    public void addManager(DownloadManagerState manager_state) {
        if (manager_state.getCategory() != this) {
            manager_state.setCategory(this);
            return;
        }
        DownloadManager manager = manager_state.getDownloadManager();
        if (manager == null) {
            return;
        }
        if (!this.managers.contains(manager)) {
            this.managers.add(manager);
            manager.addRateLimiter(this.upload_limiter, true);
            manager.addRateLimiter(this.download_limiter, false);
            this.category_listeners.dispatch(1, manager);
        }
    }

    @Override
    public void removeManager(DownloadManagerState manager_state) {
        if (manager_state.getCategory() == this) {
            manager_state.setCategory(null);
            return;
        }
        DownloadManager manager = manager_state.getDownloadManager();
        if (manager == null) {
            return;
        }
        if (this.managers.contains(manager) || this.type != 0) {
            this.managers.remove(manager);
            manager.removeRateLimiter(this.upload_limiter, true);
            manager.removeRateLimiter(this.download_limiter, false);
            this.category_listeners.dispatch(2, manager);
        }
    }

    @Override
    public void setDownloadSpeed(int speed) {
        if (this.download_speed != speed) {
            this.download_speed = speed;
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public int getDownloadSpeed() {
        return this.download_speed;
    }

    @Override
    public void setUploadSpeed(int speed) {
        if (this.upload_speed != speed) {
            this.upload_speed = speed;
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public int getUploadSpeed() {
        return this.upload_speed;
    }

    protected void setAttributes(Map<String, String> a) {
        this.attributes.clear();
        this.attributes.putAll(a);
    }

    protected Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getStringAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public void setStringAttribute(String name, String value) {
        String old = this.attributes.put(name, value);
        if (old == null || !old.equals(value)) {
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    @Override
    public boolean getBooleanAttribute(String name) {
        String str = this.getStringAttribute(name);
        return str != null && str.equals("true");
    }

    @Override
    public void setBooleanAttribute(String name, boolean value) {
        String old = this.attributes.put(name, value ? "true" : "false");
        if (old == null || !old.equals(value)) {
            CategoryManagerImpl.getInstance().saveCategories(this);
        }
    }

    public int compareTo(Object b) {
        boolean bTypeIsUser;
        boolean aTypeIsUser = this.type == 0;
        boolean bl = bTypeIsUser = ((Category)b).getType() == 0;
        if (aTypeIsUser == bTypeIsUser) {
            return this.sName.compareToIgnoreCase(((Category)b).getName());
        }
        if (aTypeIsUser) {
            return 1;
        }
        return -1;
    }
}

