/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.util;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.content.RelatedContent;
import com.aelitis.azureus.core.devices.DeviceOfflineDownload;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.util.ConstantsVuze;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class DataSourceUtils {
    public static org.gudy.azureus2.core3.disk.DiskManagerFileInfo getFileInfo(Object ds) {
        try {
            if (ds instanceof DiskManagerFileInfo) {
                return PluginCoreUtils.unwrap((DiskManagerFileInfo)ds);
            }
            if (ds instanceof org.gudy.azureus2.core3.disk.DiskManagerFileInfo) {
                return (org.gudy.azureus2.core3.disk.DiskManagerFileInfo)ds;
            }
            if (ds instanceof ISelectedContent && ((ISelectedContent)ds).getFileIndex() >= 0) {
                ISelectedContent sc = (ISelectedContent)ds;
                int idx = sc.getFileIndex();
                DownloadManager dm = sc.getDownloadManager();
                return dm.getDiskManagerFileInfoSet().getFiles()[idx];
            }
            if (ds instanceof TranscodeJob) {
                TranscodeJob tj = (TranscodeJob)ds;
                try {
                    return PluginCoreUtils.unwrap(tj.getFile());
                }
                catch (DownloadException e) {
                }
            } else if (ds instanceof TranscodeFile) {
                TranscodeFile tf = (TranscodeFile)ds;
                try {
                    DiskManagerFileInfo file = tf.getSourceFile();
                    return PluginCoreUtils.unwrap(file);
                }
                catch (DownloadException downloadException) {}
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static DownloadManager getDM(Object ds) {
        block16: {
            try {
                if (ds instanceof DownloadManager) {
                    return (DownloadManager)ds;
                }
                if (ds instanceof VuzeActivitiesEntry) {
                    String assetHash;
                    VuzeActivitiesEntry entry = (VuzeActivitiesEntry)ds;
                    DownloadManager dm = entry.getDownloadManger();
                    if (dm == null && (assetHash = entry.getAssetHash()) != null && AzureusCoreFactory.isCoreRunning()) {
                        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                        dm = gm.getDownloadManager(new HashWrapper(Base32.decode(assetHash)));
                        entry.setDownloadManager(dm);
                    }
                    return dm;
                }
                if (ds instanceof TOTorrent && AzureusCoreFactory.isCoreRunning()) {
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    return gm.getDownloadManager((TOTorrent)ds);
                }
                if (ds instanceof ISelectedContent) {
                    return DataSourceUtils.getDM(((ISelectedContent)ds).getDownloadManager());
                }
                if (ds instanceof TranscodeJob) {
                    TranscodeJob tj = (TranscodeJob)ds;
                    try {
                        Download download;
                        DiskManagerFileInfo file = tj.getFile();
                        if (file != null && (download = tj.getFile().getDownload()) != null) {
                            return PluginCoreUtils.unwrap(download);
                        }
                        break block16;
                    }
                    catch (DownloadException e) {}
                    break block16;
                }
                if (ds instanceof TranscodeFile) {
                    TranscodeFile tf = (TranscodeFile)ds;
                    try {
                        Download download;
                        DiskManagerFileInfo file = tf.getSourceFile();
                        if (file != null && (download = file.getDownload()) != null) {
                            return PluginCoreUtils.unwrap(download);
                        }
                        break block16;
                    }
                    catch (DownloadException downloadException) {}
                    break block16;
                }
                if (ds instanceof DeviceOfflineDownload) {
                    return PluginCoreUtils.unwrap(((DeviceOfflineDownload)ds).getDownload());
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    public static TOTorrent getTorrent(Object ds) {
        Torrent torrent;
        Download download;
        DiskManagerFileInfo file;
        Object torrent2;
        if (ds instanceof TOTorrent) {
            return (TOTorrent)ds;
        }
        if (ds instanceof DownloadManager && (torrent2 = ((DownloadManager)ds).getTorrent()) != null) {
            return torrent2;
        }
        if (ds instanceof VuzeActivitiesEntry) {
            DownloadManager dm;
            torrent2 = ((VuzeActivitiesEntry)ds).getTorrent();
            if (torrent2 == null && (dm = DataSourceUtils.getDM(ds)) != null) {
                torrent2 = dm.getTorrent();
            }
            return torrent2;
        }
        if (ds instanceof TranscodeFile) {
            TranscodeFile tf = (TranscodeFile)ds;
            try {
                file = tf.getSourceFile();
                if (file != null && (download = file.getDownload()) != null && (torrent = download.getTorrent()) != null) {
                    return PluginCoreUtils.unwrap(torrent);
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (ds instanceof TranscodeJob) {
            TranscodeJob tj = (TranscodeJob)ds;
            try {
                file = tj.getFile();
                if (file != null && (download = tj.getFile().getDownload()) != null && (torrent = download.getTorrent()) != null) {
                    return PluginCoreUtils.unwrap(torrent);
                }
            }
            catch (DownloadException e) {
                // empty catch block
            }
        }
        if (ds instanceof DeviceOfflineDownload && (torrent2 = ((DeviceOfflineDownload)ds).getDownload().getTorrent()) != null) {
            return PluginCoreUtils.unwrap((Torrent)torrent2);
        }
        if (ds instanceof ISelectedContent) {
            return ((ISelectedContent)ds).getTorrent();
        }
        if (ds instanceof String) {
            String hash = (String)ds;
            try {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                if (dm != null) {
                    return dm.getTorrent();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isPlatformContent(Object ds) {
        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
        if (torrent != null) {
            return PlatformTorrentUtils.isContent(torrent, true);
        }
        return ds instanceof VuzeActivitiesEntry && ((VuzeActivitiesEntry)ds).isPlatformContent();
    }

    public static String getHash(Object ds) {
        try {
            if (ds instanceof DownloadManager) {
                return ((DownloadManager)ds).getTorrent().getHashWrapper().toBase32String();
            }
            if (ds instanceof TOTorrent) {
                return ((TOTorrent)ds).getHashWrapper().toBase32String();
            }
            if (ds instanceof DeviceOfflineDownload) {
                return DataSourceUtils.getHash(PluginCoreUtils.unwrap(((DeviceOfflineDownload)ds).getDownload()));
            }
            if (ds instanceof VuzeActivitiesEntry) {
                VuzeActivitiesEntry entry = (VuzeActivitiesEntry)ds;
                return entry.getAssetHash();
            }
            if (ds instanceof ISelectedContent) {
                return ((ISelectedContent)ds).getHash();
            }
            if (ds instanceof String) {
                return (String)ds;
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return null;
    }

    public static ContentNetwork getContentNetwork(Object ds) {
        long id;
        block18: {
            id = -1L;
            try {
                if (ds instanceof DownloadManager) {
                    id = PlatformTorrentUtils.getContentNetworkID(((DownloadManager)ds).getTorrent());
                    break block18;
                }
                if (ds instanceof TOTorrent) {
                    id = PlatformTorrentUtils.getContentNetworkID((TOTorrent)ds);
                    break block18;
                }
                if (ds instanceof DeviceOfflineDownload) {
                    return DataSourceUtils.getContentNetwork(PluginCoreUtils.unwrap(((DeviceOfflineDownload)ds).getDownload()));
                }
                if (ds instanceof VuzeActivitiesEntry) {
                    VuzeActivitiesEntry entry = (VuzeActivitiesEntry)ds;
                    return entry.getContentNetwork();
                }
                if (ds instanceof ISelectedContent) {
                    return DataSourceUtils.getContentNetwork(((ISelectedContent)ds).getDownloadManager());
                }
                if (ds instanceof String && ((String)ds).length() == 32) {
                    id = ConstantsVuze.getDefaultContentNetwork().getID();
                    break block18;
                }
                if (ds instanceof TranscodeJob) {
                    TranscodeJob tj = (TranscodeJob)ds;
                    try {
                        Download download;
                        DiskManagerFileInfo file = tj.getFile();
                        if (file != null && (download = tj.getFile().getDownload()) != null) {
                            DownloadManager dm = PluginCoreUtils.unwrap(download);
                            return DataSourceUtils.getContentNetwork(dm);
                        }
                        break block18;
                    }
                    catch (DownloadException e) {}
                    break block18;
                }
                if (ds instanceof TranscodeFile) {
                    TranscodeFile tf = (TranscodeFile)ds;
                    try {
                        Download download;
                        DiskManagerFileInfo file = tf.getSourceFile();
                        if (file != null && (download = file.getDownload()) != null) {
                            DownloadManager dm = PluginCoreUtils.unwrap(download);
                            return DataSourceUtils.getContentNetwork(dm);
                        }
                        break block18;
                    }
                    catch (Throwable e) {}
                    break block18;
                }
                if (ds instanceof RelatedContent) {
                    id = ((RelatedContent)ds).getContentNetwork();
                } else {
                    Debug.out("Tux: UH OH NO CN for " + ds + "\n" + Debug.getCompressedStackTrace());
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        ContentNetwork cn = ContentNetworkManagerFactory.getSingleton().getContentNetwork(id);
        return cn;
    }

    public static DownloadUrlInfo getDownloadInfo(Object ds) {
        if (ds instanceof ISelectedContent) {
            return ((ISelectedContent)ds).getDownloadInfo();
        }
        return null;
    }
}

