/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.download.DownloadManagerEnhancer;
import com.aelitis.azureus.core.download.EnhancedDownloadManager;
import com.aelitis.azureus.core.download.StreamManager;
import com.aelitis.azureus.core.download.StreamManagerDownload;
import com.aelitis.azureus.core.download.StreamManagerDownloadListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.LaunchManager;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfoContentNetwork;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUI;
import com.aelitis.azureus.ui.swt.player.PlayerInstallWindow;
import com.aelitis.azureus.ui.swt.player.PlayerInstaller;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarItem;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.PlayUtils;
import com.aelitis.azureus.util.win32.Win32Utils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import org.eclipse.swt.program.Program;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.ForceRecheckListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class TorrentListViewsUtils {
    private static StreamManagerDownload current_stream;
    private static TextViewerWindow stream_viewer;
    private static boolean emp_installing;

    public static void playOrStreamDataSource(Object ds, boolean launch_already_checked) {
        String referal = "unknown";
        if (ds instanceof VuzeActivitiesEntry) {
            referal = "playdashboardactivity";
        } else if (ds instanceof DownloadManager) {
            referal = "playdownloadmanager";
        } else if (ds instanceof ISelectedContent) {
            referal = "selectedcontent";
        }
        TorrentListViewsUtils.playOrStreamDataSource(ds, referal, launch_already_checked, true);
    }

    public static void playOrStreamDataSource(Object ds, String referal, boolean launch_already_checked, boolean complete_only) {
        DiskManagerFileInfo fileInfo2 = DataSourceUtils.getFileInfo(ds);
        if (fileInfo2 != null) {
            TorrentListViewsUtils.playOrStream(fileInfo2.getDownloadManager(), fileInfo2.getIndex(), complete_only, launch_already_checked, referal);
        } else {
            DownloadManager dm = DataSourceUtils.getDM(ds);
            if (dm == null) {
                TorrentListViewsUtils.downloadDataSource(ds, true, referal);
            } else {
                TorrentListViewsUtils.playOrStream(dm, -1, complete_only, launch_already_checked, referal);
            }
        }
    }

    public static void downloadDataSource(Object ds, boolean playNow, String referal) {
        TOTorrent torrent = DataSourceUtils.getTorrent(ds);
        try {
            Map torrent_map = torrent.serialiseToMap();
            torrent_map.remove("info");
            VuzeFile vf = VuzeFileHandler.getSingleton().loadVuzeFile(torrent_map);
            if (vf != null) {
                VuzeFileHandler.getSingleton().handleFiles(new VuzeFile[]{vf}, 0);
                return;
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (torrent != null && !DataSourceUtils.isPlatformContent(ds)) {
            TorrentUIUtilsV3.addTorrentToGM(torrent);
        } else {
            DownloadUrlInfo dlInfo = DataSourceUtils.getDownloadInfo(ds);
            if (dlInfo != null) {
                TorrentUIUtilsV3.loadTorrent(dlInfo, playNow, false, true);
                return;
            }
            String hash = DataSourceUtils.getHash(ds);
            if (hash != null) {
                ContentNetwork cn = DataSourceUtils.getContentNetwork(ds);
                if (cn == null) {
                    dlInfo = new DownloadUrlInfo(UrlUtils.parseTextForMagnets(hash));
                    dlInfo.setReferer(referal);
                    TorrentUIUtilsV3.loadTorrent(dlInfo, playNow, false, true);
                    return;
                }
                String url = cn.getTorrentDownloadService(hash, referal);
                dlInfo = new DownloadUrlInfoContentNetwork(url, cn);
                TorrentUIUtilsV3.loadTorrent(dlInfo, playNow, false, true);
            }
        }
    }

    public static void playOrStream(DownloadManager dm, int file_index, boolean complete_only, boolean launch_already_checked) {
        TorrentListViewsUtils.playOrStream(dm, file_index, complete_only, launch_already_checked, null);
    }

    private static void playOrStream(final DownloadManager dm, final int file_index, final boolean complete_only, boolean launch_already_checked, final String referal) {
        if (dm == null) {
            return;
        }
        if (launch_already_checked) {
            TorrentListViewsUtils._playOrStream(dm, file_index, complete_only, referal);
        } else {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            TorrentListViewsUtils._playOrStream(dm, file_index, complete_only, referal);
                        }
                    });
                }

                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void _playOrStream(final DownloadManager dm, final int file_index, boolean complete_only, String referal) {
        boolean reenableButton;
        ToolBarItem btn;
        block28: {
            block27: {
                block26: {
                    block24: {
                        block23: {
                            if (dm == null) {
                                return;
                            }
                            TOTorrent torrent = dm.getTorrent();
                            if (torrent == null) {
                                return;
                            }
                            if (PlayUtils.canUseEMP(torrent, file_index, complete_only)) {
                                TorrentListViewsUtils.debug("Can use EMP");
                                int open_result = TorrentListViewsUtils.openInEMP(dm, file_index, complete_only, referal);
                                if (open_result == 0) {
                                    PlatformTorrentUtils.setHasBeenOpened(dm, true);
                                    return;
                                }
                                if (open_result == 2) {
                                    TorrentListViewsUtils.debug("Open in EMP abandoned");
                                    return;
                                }
                                TorrentListViewsUtils.debug("Open EMP Failed");
                            } else {
                                TorrentListViewsUtils.debug("Can't use EMP. torrent says " + PlatformTorrentUtils.useEMP(torrent));
                            }
                            ToolBarItem btnPlay = null;
                            ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
                            if (tb != null) {
                                btnPlay = tb.getToolBarItem("play");
                            }
                            if ((btn = btnPlay) != null) {
                                btn.setEnabled(false);
                            }
                            reenableButton = false;
                            try {
                                String sFileType;
                                String sTextID;
                                String ext;
                                String sfFile;
                                block25: {
                                    if (!PlayUtils.canProgressiveOrIsComplete(torrent)) {
                                        Object var22_10 = null;
                                        if (btn == null) return;
                                        if (!reenableButton) return;
                                        btn.setEnabled(true);
                                        return;
                                    }
                                    String sFile = null;
                                    EnhancedDownloadManager edm = DownloadManagerEnhancer.getSingleton().getEnhancedDownload(dm);
                                    if (edm != null) {
                                        boolean doProgressive = edm.getProgressiveMode();
                                        if (doProgressive && edm.getProgressivePlayETA() > 0L) {
                                            break block23;
                                        }
                                        if (!doProgressive && dm.getNumFileInfos() > 1 && PlatformTorrentUtils.getContentPrimaryFileIndex(torrent) == -1) {
                                            Utils.launch(dm.getSaveLocation().getAbsolutePath());
                                            reenableButton = true;
                                            PlatformTorrentUtils.setHasBeenOpened(dm, true);
                                            break block24;
                                        }
                                        File file = edm.getPrimaryFile().getFile(true);
                                        sFile = file.getAbsolutePath();
                                    } else {
                                        sFile = dm.getDownloadState().getPrimaryFile();
                                        File file = new File(sFile);
                                    }
                                    sfFile = sFile;
                                    ext = FileUtil.getExtension(sFile);
                                    try {
                                        if (!ext.equalsIgnoreCase(".exe") || !DataSourceUtils.isPlatformContent(dm) || !"Game".equalsIgnoreCase(PlatformTorrentUtils.getContentType(dm.getTorrent()))) break block25;
                                        reenableButton = true;
                                        Utils.launch(sFile);
                                        PlatformTorrentUtils.setHasBeenOpened(dm, true);
                                        break block26;
                                    }
                                    catch (Exception e) {
                                        Debug.out(e);
                                    }
                                }
                                String sPrefix = "v3.mb.openFile.";
                                UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
                                if (functionsSWT == null) {
                                    break block27;
                                }
                                final Program program = Program.findProgram(ext);
                                if (program == null) {
                                    sTextID = "v3.mb.openFile.text.unknown";
                                    sFileType = ext;
                                } else {
                                    sTextID = "v3.mb.openFile.text.known";
                                    sFileType = program.getName();
                                }
                                String[] buttons = new String[program == null ? 2 : 3];
                                buttons[0] = MessageText.getString("v3.mb.openFile.button.guide");
                                buttons[buttons.length - 1] = MessageText.getString("v3.mb.openFile.button.cancel");
                                MessageBoxShell mb = null;
                                if (program != null) {
                                    buttons[1] = MessageText.getString("v3.mb.openFile.button.play");
                                    mb = new MessageBoxShell(MessageText.getString("v3.mb.openFile.title"), MessageText.getString(sTextID, new String[]{dm.getDisplayName(), sFileType, ext}), buttons, 0);
                                    mb.setRemember("v3.mb.openFile..remember_id", false, MessageText.getString("v3.mb.openFile.remember"));
                                    mb.setRememberOnlyIfButton(1);
                                    mb.setRelatedObject(dm);
                                } else {
                                    mb = new MessageBoxShell(MessageText.getString("v3.mb.openFile.title"), MessageText.getString(sTextID, new String[]{dm.getDisplayName(), sFileType, ext}), buttons, 0);
                                    mb.setRelatedObject(dm);
                                }
                                reenableButton = false;
                                mb.open(new UserPrompterResultListener(){

                                    public void prompterClosed(int i) {
                                        String url;
                                        if (i == 0 && UrlUtils.isURL(url = MessageText.getString("v3.mb.openFile.guideurl"))) {
                                            Utils.launch(url);
                                            return;
                                        }
                                        if (i != 1 || program == null) {
                                            return;
                                        }
                                        boolean bComplete = dm.isDownloadComplete(false);
                                        if (bComplete) {
                                            if (btn != null) {
                                                btn.setEnabled(true);
                                            }
                                            TorrentListViewsUtils.runFile(dm.getTorrent(), file_index, sfFile);
                                        } else {
                                            if (btn != null) {
                                                btn.setEnabled(true);
                                            }
                                            try {
                                                TorrentListViewsUtils.playViaMediaServer(DownloadManagerImpl.getDownloadStatic(dm), file_index);
                                            }
                                            catch (DownloadException e) {
                                                Debug.out(e);
                                            }
                                        }
                                    }
                                });
                                break block28;
                            }
                            catch (Throwable throwable) {
                                Object var22_16 = null;
                                if (btn == null) throw throwable;
                                if (!reenableButton) throw throwable;
                                btn.setEnabled(true);
                                throw throwable;
                            }
                        }
                        Object var22_11 = null;
                        if (btn == null) return;
                        if (!reenableButton) return;
                        btn.setEnabled(true);
                        return;
                    }
                    Object var22_12 = null;
                    if (btn == null) return;
                    if (!reenableButton) return;
                    btn.setEnabled(true);
                    return;
                }
                Object var22_13 = null;
                if (btn == null) return;
                if (!reenableButton) return;
                btn.setEnabled(true);
                return;
            }
            Object var22_14 = null;
            if (btn == null) return;
            if (!reenableButton) return;
            btn.setEnabled(true);
            return;
        }
        Object var22_15 = null;
        if (btn == null) return;
        if (!reenableButton) return;
        btn.setEnabled(true);
    }

    private static void debug(String string) {
        if (Constants.isCVSVersion()) {
            System.out.println(string);
        }
    }

    private static void runFile(TOTorrent torrent, int file_index, String runFile) {
        TorrentListViewsUtils.runFile(torrent, file_index, runFile, false);
    }

    private static void runFile(final TOTorrent torrent, final int file_index, final String runFile, final boolean forceWMP) {
        AEThread2 thread = new AEThread2("runFile", true){

            public void run() {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (PlayUtils.canUseEMP(torrent, file_index)) {
                            Debug.out("Shouldn't call runFile with EMP torrent.");
                        }
                        if (PlatformTorrentUtils.isContentDRM(torrent) || forceWMP) {
                            if (!TorrentListViewsUtils.runInMediaPlayer(runFile)) {
                                Utils.launch(runFile);
                            }
                        } else {
                            Utils.launch(runFile);
                        }
                    }
                });
            }
        };
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int installEMP(String name, final Runnable target) {
        Class<TorrentListViewsUtils> clazz = TorrentListViewsUtils.class;
        synchronized (TorrentListViewsUtils.class) {
            int n;
            if (emp_installing) {
                Debug.out("EMP is already being installed, secondary launch for " + name + " ignored");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return 2;
            }
            emp_installing = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            boolean running = false;
            try {
                final PlayerInstaller installer = new PlayerInstaller();
                PlayerInstallWindow window = new PlayerInstallWindow(installer);
                window.open();
                AEThread2 installerThread = new AEThread2("player installer", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            if (installer.install()) {
                                Utils.execSWTThread(new AERunnable(){

                                    public void runSupport() {
                                        target.run();
                                    }
                                });
                            }
                            Object var2_1 = null;
                            Class<TorrentListViewsUtils> clazz = TorrentListViewsUtils.class;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            Class<TorrentListViewsUtils> clazz = TorrentListViewsUtils.class;
                            synchronized (TorrentListViewsUtils.class) {
                                emp_installing = false;
                                // ** MonitorExit[var3_4] (shouldn't be in output)
                                throw throwable;
                            }
                        }
                        synchronized (TorrentListViewsUtils.class) {
                            emp_installing = false;
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            return;
                        }
                    }
                };
                installerThread.start();
                running = true;
                n = 0;
                Object var8_11 = null;
                if (running) return n;
                Class<TorrentListViewsUtils> clazz2 = TorrentListViewsUtils.class;
            }
            catch (Throwable e) {
                int n2;
                try {
                    Debug.out(e);
                    n2 = 1;
                    Object var8_12 = null;
                    if (running) return n2;
                    Class<TorrentListViewsUtils> clazz3 = TorrentListViewsUtils.class;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    if (running) throw throwable;
                    Class<TorrentListViewsUtils> clazz4 = TorrentListViewsUtils.class;
                    synchronized (TorrentListViewsUtils.class) {
                        emp_installing = false;
                        // ** MonitorExit[var9_16] (shouldn't be in output)
                        throw throwable;
                    }
                }
                synchronized (TorrentListViewsUtils.class) {
                    emp_installing = false;
                    // ** MonitorExit[var9_15] (shouldn't be in output)
                    return n2;
                }
            }
            synchronized (TorrentListViewsUtils.class) {
                emp_installing = false;
                // ** MonitorExit[var9_14] (shouldn't be in output)
                return n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static int openInEMP(final DownloadManager dm, int _file_index, final boolean complete_only, final String referal) {
        final int file_index = _file_index == -1 ? PlayUtils.getPrimaryFileIndex(dm) : _file_index;
        if (file_index == -1) {
            return 1;
        }
        org.gudy.azureus2.plugins.disk.DiskManagerFileInfo file = PluginCoreUtils.wrap(dm).getDiskManagerFileInfo()[file_index];
        final URL url = !complete_only && file.getDownloaded() != file.getLength() ? PlayUtils.getMediaServerContentURL(file) : null;
        if (url != null) {
            if (PlayUtils.isStreamPermitted()) {
                boolean show_debug_window = false;
                new AEThread2("stream:async"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        StreamManager sm = StreamManager.getSingleton();
                        Class<TorrentListViewsUtils> clazz = TorrentListViewsUtils.class;
                        synchronized (TorrentListViewsUtils.class) {
                            if (current_stream != null && !current_stream.isCancelled()) {
                                if (current_stream.getURL().equals(url)) {
                                    current_stream.setPreviewMode(!current_stream.getPreviewMode());
                                    // ** MonitorExit[var2_2] (shouldn't be in output)
                                    return;
                                }
                                current_stream.cancel();
                                current_stream = null;
                            }
                            current_stream = sm.stream(dm, file_index, url, false, new StreamManagerDownloadListener(){
                                private long last_log = 0L;

                                public void updateActivity(String str) {
                                    this.append("Activity: " + str);
                                }

                                public void updateStats(int secs_until_playable, int buffer_secs, long buffer_bytes, int target_secs) {
                                    long now = SystemTime.getMonotonousTime();
                                    if (now - this.last_log >= 1000L) {
                                        this.last_log = now;
                                        this.append("stats: play in " + secs_until_playable + " sec, buffer=" + DisplayFormatters.formatByteCountToKiBEtc(buffer_bytes) + "/" + buffer_secs + " sec - target=" + target_secs + " sec");
                                    }
                                }

                                public void ready() {
                                    this.append("ready");
                                }

                                public void failed(Throwable error) {
                                    this.append("failed: " + Debug.getNestedExceptionMessage(error));
                                    Debug.out(error);
                                }

                                private void append(final String str) {
                                    if (stream_viewer != null) {
                                        Utils.execSWTThread(new Runnable(){

                                            public void run() {
                                                if (stream_viewer != null && !stream_viewer.isDisposed()) {
                                                    stream_viewer.append(str + "\r\n");
                                                }
                                            }
                                        });
                                    }
                                }
                            });
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                }.start();
                return 0;
            }
            FeatureManagerUI.openStreamPlusWindow(referal);
            return 0;
        }
        Class<TorrentListViewsUtils> show_debug_window = TorrentListViewsUtils.class;
        // MONITORENTER : com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils.class
        if (current_stream != null && !current_stream.isCancelled()) {
            current_stream.cancel();
            current_stream = null;
        }
        // MONITOREXIT : show_debug_window
        Class<?> epwClass = null;
        try {
            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp", false);
            if (pi == null) {
                return TorrentListViewsUtils.installEMP(dm.getDisplayName(), new Runnable(){

                    public void run() {
                        TorrentListViewsUtils.openInEMP(dm, file_index, complete_only, referal);
                    }
                });
            }
            if (!pi.getPluginState().isOperational()) {
                return 1;
            }
            epwClass = pi.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
        }
        catch (ClassNotFoundException e1) {
            return 1;
        }
        {
            catch (Throwable e) {
                e.printStackTrace();
                if (e.getMessage() != null) {
                    if (e.getMessage().toLowerCase().endsWith("only")) return 1;
                }
                Debug.out(e);
                return 1;
            }
        }
        try {
            Method method = epwClass.getMethod("openWindow", File.class, String.class);
            File f = file.getFile(true);
            method.invoke(null, f, f.getName());
            return 0;
        }
        catch (Throwable e) {
            TorrentListViewsUtils.debug("file/name open method missing");
            Method method = epwClass.getMethod("openWindow", DownloadManager.class);
            method.invoke(null, dm);
            return 0;
        }
    }

    public static int openInEMP(final String name, final URL url) {
        Class<?> epwClass = null;
        try {
            PluginInterface pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azemp", false);
            if (pi == null) {
                return TorrentListViewsUtils.installEMP(name, new Runnable(){

                    public void run() {
                        TorrentListViewsUtils.openInEMP(name, url);
                    }
                });
            }
            if (!pi.getPluginState().isOperational()) {
                return 1;
            }
            epwClass = pi.getPlugin().getClass().getClassLoader().loadClass("com.azureus.plugins.azemp.ui.swt.emp.EmbeddedPlayerWindowSWT");
        }
        catch (ClassNotFoundException e1) {
            return 1;
        }
        try {
            Method method = epwClass.getMethod("openWindow", URL.class, String.class);
            method.invoke(null, url, name);
            return 0;
        }
        catch (Throwable e) {
            TorrentListViewsUtils.debug("URL/name open method missing");
            return 1;
        }
    }

    private static void handleNoFileExists(final DownloadManager dm) {
        UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (functionsSWT == null) {
            return;
        }
        ManagerUtils.start(dm);
        String sPrefix = "v3.mb.PlayFileNotFound.";
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString(sPrefix + "title"), MessageText.getString(sPrefix + "text", new String[]{dm.getDisplayName()}), new String[]{MessageText.getString(sPrefix + "button.remove"), MessageText.getString(sPrefix + "button.redownload"), MessageText.getString("Button.cancel")}, 2);
        mb.setRelatedObject(dm);
        mb.open(new UserPrompterResultListener(){

            public void prompterClosed(int i) {
                if (i == 0) {
                    ManagerUtils.asyncStopDelete(dm, 70, true, false, null);
                } else if (i == 1) {
                    dm.forceRecheck(new ForceRecheckListener(){

                        public void forceRecheckComplete(DownloadManager dm) {
                            ManagerUtils.start(dm);
                        }
                    });
                }
            }
        });
    }

    private static boolean runInMediaPlayer(String mediaFile) {
        String wmpEXE;
        if (Constants.isWindows && new File(wmpEXE = Win32Utils.getWMP()).exists()) {
            try {
                Runtime.getRuntime().exec(wmpEXE + " \"" + mediaFile + "\"");
                return true;
            }
            catch (IOException e) {
                Debug.out("error playing " + mediaFile + " via WMP " + mediaFile, e);
            }
        }
        return false;
    }

    public static String getMediaServerContentURL(DownloadManager dm) {
        try {
            return PlayUtils.getMediaServerContentURL(DownloadManagerImpl.getDownloadStatic(dm));
        }
        catch (DownloadException downloadException) {
            return null;
        }
    }

    public static void playViaMediaServer(Download download, int file_index) {
        try {
            DownloadManager dm = ((DownloadImpl)download).getDownload();
            TOTorrent torrent = dm.getTorrent();
            TorrentListViewsUtils.runFile(torrent, file_index, PlayUtils.getContentUrl(dm), true);
        }
        catch (Throwable e) {
            Logger.log(new LogEvent(LogIDs.UI3, "IPC to media server plugin failed", e));
        }
    }

    public static void playOrStream(DownloadManager dm, int file_index) {
        TorrentListViewsUtils.playOrStream(dm, file_index, true, false, null);
    }
}

