/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.torrent.HasBeenOpenedListener;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MdiEntryLoadedListener;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.mdi.MdiSWTMenuHackListener;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBarEntrySWT;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerAdapter;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FrequencyLimitedDispatcher;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.views.utils.CategoryUIUtils;

public class SB_Transfers {
    private static final String ID_VITALITY_ACTIVE = "image.sidebar.vitality.dl";
    private static final String ID_VITALITY_ALERT = "image.sidebar.vitality.alert";
    private static stats statsWithLowNoise = new stats();
    private static stats statsNoLowNoise = new stats();
    private static List<countRefreshListener> listeners = new ArrayList<countRefreshListener>();
    private static boolean first = true;
    private static FrequencyLimitedDispatcher refresh_limiter;

    public static void setup(final MultipleDocumentInterface mdi) {
        mdi.registerEntry("Library", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "Library", "library", "{sidebar.Library}", null, null, false, 0);
                entry.setImageLeftID("image.sidebar.library");
                return entry;
            }
        });
        mdi.registerEntry("LibraryDL", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                return SB_Transfers.createDownloadingEntry(mdi);
            }
        });
        mdi.registerEntry("LibraryCD", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                return SB_Transfers.createSeedingEntry(mdi);
            }
        });
        mdi.registerEntry("LibraryUnopened", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                return SB_Transfers.createUnopenedEntry(mdi);
            }
        });
        if (first) {
            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                public void azureusCoreRunning(AzureusCore core) {
                    SB_Transfers.setupViewTitleWithCore(core);
                }
            });
        }
        PlatformTorrentUtils.addHasBeenOpenedListener(new HasBeenOpenedListener(){

            public void hasBeenOpenedChanged(DownloadManager dm, boolean opened) {
                SB_Transfers.recountUnopened();
                SB_Transfers.refreshAllLibraries();
            }
        });
        SB_Transfers.addMenuUnwatched("Library");
        mdi.addListener(new MdiEntryLoadedListener(){

            public void mdiEntryLoaded(MdiEntry entry) {
                if ("header.transfers".equals(entry.getId())) {
                    SB_Transfers.addHeaderMenu();
                }
            }
        });
    }

    protected static void addHeaderMenu() {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        MenuItem menuItem = menuManager.addMenuItem("sidebar.header.transfers", "MyTorrentsView.menu.setCategory.add");
        menuItem.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                new CategoryAdderWindow(null);
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setVisible(COConfigurationManager.getBooleanParameter("Library.CatInSideBar"));
            }
        });
        menuItem = menuManager.addMenuItem("sidebar.header.transfers", "ConfigView.section.style.CatInSidebar");
        menuItem.setStyle(2);
        menuItem.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                boolean b = COConfigurationManager.getBooleanParameter("Library.CatInSideBar");
                COConfigurationManager.setParameter("Library.CatInSideBar", !b);
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setVisible(CategoryManager.getCategories().length > 0);
                menu.setData(COConfigurationManager.getBooleanParameter("Library.CatInSideBar"));
            }
        });
    }

    protected static MdiEntry createUnopenedEntry(MultipleDocumentInterface mdi) {
        MdiEntry infoLibraryUn = mdi.createEntryFromSkinRef("header.transfers", "LibraryUnopened", "library", "{sidebar.LibraryUnopened}", null, null, false, "Library");
        infoLibraryUn.setImageLeftID("image.sidebar.unopened");
        SB_Transfers.addMenuUnwatched("LibraryUnopened");
        infoLibraryUn.setViewTitleInfo(new ViewTitleInfo(){

            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0 && statsNoLowNoise.numUnOpened > 0) {
                    return "" + statsNoLowNoise.numUnOpened;
                }
                return null;
            }
        });
        return infoLibraryUn;
    }

    private static void addMenuUnwatched(String id) {
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        MenuItem menuItem = menuManager.addMenuItem("sidebar." + id, "v3.activity.button.watchall");
        menuItem.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.ANY_THREAD, new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        GlobalManager gm = core.getGlobalManager();
                        List downloadManagers = gm.getDownloadManagers();
                        for (DownloadManager dm : downloadManagers) {
                            if (PlatformTorrentUtils.getHasBeenOpened(dm) || !dm.getAssumedComplete()) continue;
                            PlatformTorrentUtils.setHasBeenOpened(dm, true);
                        }
                    }
                });
            }
        });
    }

    protected static MdiEntry createSeedingEntry(MultipleDocumentInterface mdi) {
        ViewTitleInfo titleInfoSeeding = new ViewTitleInfo(){

            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    return null;
                }
                if (propertyID == 1) {
                    return "There are " + statsNoLowNoise.numComplete + " complete torrents, " + statsNoLowNoise.numSeeding + " of which are currently seeding";
                }
                return null;
            }
        };
        MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "LibraryDL", "library", "{sidebar.LibraryDL}", titleInfoSeeding, null, false, null);
        entry.setImageLeftID("image.sidebar.downloading");
        MdiEntryVitalityImage vitalityImage = entry.addVitalityImage(ID_VITALITY_ALERT);
        vitalityImage.setVisible(false);
        entry.setViewTitleInfo(titleInfoSeeding);
        return entry;
    }

    protected static MdiEntry createDownloadingEntry(MultipleDocumentInterface mdi) {
        ViewTitleInfo titleInfoDownloading = new ViewTitleInfo(){

            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0 && statsNoLowNoise.numIncomplete > 0) {
                    return statsNoLowNoise.numIncomplete + "";
                }
                if (propertyID == 1) {
                    return "There are " + statsNoLowNoise.numIncomplete + " incomplete torrents, " + statsNoLowNoise.numDownloading + " of which are currently downloading";
                }
                return null;
            }
        };
        MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "LibraryDL", "library", "{sidebar.LibraryDL}", titleInfoDownloading, null, false, null);
        entry.setImageLeftID("image.sidebar.downloading");
        MdiEntryVitalityImage vitalityImage = entry.addVitalityImage(ID_VITALITY_ACTIVE);
        vitalityImage.setVisible(false);
        vitalityImage = entry.addVitalityImage(ID_VITALITY_ALERT);
        vitalityImage.setVisible(false);
        return entry;
    }

    protected static void setupViewTitleWithCore(AzureusCore core) {
        if (!first) {
            return;
        }
        first = false;
        COConfigurationManager.addAndFireParameterListener("Library.CatInSideBar", new ParameterListener(){
            private CategoryManagerListener categoryManagerListener;

            public void parameterChanged(String parameterName) {
                if (Utils.isAZ2UI()) {
                    return;
                }
                Category[] categories = CategoryManager.getCategories();
                if (categories.length == 0) {
                    return;
                }
                boolean catInSidebar = COConfigurationManager.getBooleanParameter("Library.CatInSideBar");
                if (catInSidebar) {
                    if (this.categoryManagerListener != null) {
                        return;
                    }
                    this.categoryManagerListener = new CategoryManagerListener(){

                        public void categoryRemoved(Category category) {
                            SB_Transfers.removeCategory(category);
                        }

                        public void categoryChanged(Category category) {
                            if (category.getType() != 0) {
                                return;
                            }
                            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                            if (mdi == null) {
                                return;
                            }
                            MdiEntry entry = mdi.getEntry("Cat." + Base32.encode(category.getName().getBytes()));
                            if (entry == null) {
                                return;
                            }
                            ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
                        }

                        public void categoryAdded(Category category) {
                            SB_Transfers.setupCategory(category);
                        }
                    };
                    CategoryManager.addCategoryManagerListener(this.categoryManagerListener);
                    for (Category category : categories) {
                        SB_Transfers.setupCategory(category);
                    }
                } else {
                    if (this.categoryManagerListener != null) {
                        CategoryManager.removeCategoryManagerListener(this.categoryManagerListener);
                        this.categoryManagerListener = null;
                    }
                    for (Category category : categories) {
                        SB_Transfers.removeCategory(category);
                    }
                }
            }
        });
        final GlobalManager gm = core.getGlobalManager();
        final DownloadManagerAdapter dmListener = new DownloadManagerAdapter(){

            public void stateChanged(DownloadManager dm, int state) {
                this.stateChanged(dm, state, statsNoLowNoise);
                this.stateChanged(dm, state, statsWithLowNoise);
            }

            public void stateChanged(DownloadManager dm, int state, stats stats2) {
                boolean isErrorState;
                if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                    return;
                }
                SB_Transfers.updateDMCounts(dm);
                boolean complete = dm.getAssumedComplete();
                Boolean wasErrorStateB = (Boolean)dm.getUserData("wasErrorState");
                boolean wasErrorState = wasErrorStateB == null ? false : wasErrorStateB;
                boolean bl = isErrorState = state == 100;
                if (isErrorState != wasErrorState) {
                    int rel;
                    int n = rel = isErrorState ? 1 : -1;
                    if (complete) {
                        stats2.numErrorComplete += rel;
                    } else {
                        stats2.numErrorInComplete += rel;
                    }
                    this.updateErrorTooltip(stats2);
                    dm.setUserData("wasErrorState", new Boolean(isErrorState));
                }
                SB_Transfers.refreshAllLibraries();
            }

            public void completionChanged(DownloadManager dm, boolean completed) {
                this.completionChanged(dm, completed, statsNoLowNoise);
                this.completionChanged(dm, completed, statsWithLowNoise);
            }

            public void completionChanged(DownloadManager dm, boolean completed, stats stats2) {
                if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                    return;
                }
                SB_Transfers.updateDMCounts(dm);
                if (completed) {
                    ++stats2.numComplete;
                    --stats2.numIncomplete;
                    if (dm.getState() == 100) {
                        ++stats2.numErrorComplete;
                        --stats2.numErrorInComplete;
                    }
                    if (dm.getState() == 70) {
                        --statsNoLowNoise.numStoppedIncomplete;
                    }
                } else {
                    --stats2.numComplete;
                    ++stats2.numIncomplete;
                    if (dm.getState() == 100) {
                        --stats2.numErrorComplete;
                        ++stats2.numErrorInComplete;
                    }
                    if (dm.getState() == 70) {
                        ++statsNoLowNoise.numStoppedIncomplete;
                    }
                }
                SB_Transfers.recountUnopened();
                this.updateErrorTooltip(stats2);
                SB_Transfers.refreshAllLibraries();
            }

            protected void updateErrorTooltip(stats stats2) {
                if (stats2.numErrorComplete < 0) {
                    stats2.numErrorComplete = 0;
                }
                if (stats2.numErrorInComplete < 0) {
                    stats2.numErrorInComplete = 0;
                }
                if (stats2.numErrorComplete > 0 || stats2.numErrorInComplete > 0) {
                    String comp_error = null;
                    String incomp_error = null;
                    List downloads = gm.getDownloadManagers();
                    for (int i = 0; i < downloads.size(); ++i) {
                        DownloadManager download = (DownloadManager)downloads.get(i);
                        if (download.getState() != 100) continue;
                        if (download.getAssumedComplete()) {
                            if (comp_error == null) {
                                comp_error = download.getDisplayName() + ": " + download.getErrorDetails();
                                continue;
                            }
                            comp_error = comp_error + "...";
                            continue;
                        }
                        incomp_error = incomp_error == null ? download.getDisplayName() + ": " + download.getErrorDetails() : incomp_error + "...";
                    }
                    stats2.errorCompleteTooltip = comp_error;
                    stats2.errorInCompleteTooltip = incomp_error;
                }
            }
        };
        gm.addListener(new GlobalManagerAdapter(){

            public void downloadManagerRemoved(DownloadManager dm) {
                this.downloadManagerRemoved(dm, statsNoLowNoise);
                this.downloadManagerRemoved(dm, statsWithLowNoise);
            }

            public void downloadManagerRemoved(DownloadManager dm, stats stats2) {
                boolean wasStopped;
                if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                    return;
                }
                SB_Transfers.recountUnopened();
                if (dm.getAssumedComplete()) {
                    --stats2.numComplete;
                    Boolean wasDownloadingB = (Boolean)dm.getUserData("wasDownloading");
                    if (wasDownloadingB != null && wasDownloadingB.booleanValue()) {
                        --stats2.numDownloading;
                    }
                } else {
                    --stats2.numIncomplete;
                    Boolean wasSeedingB = (Boolean)dm.getUserData("wasSeeding");
                    if (wasSeedingB != null && wasSeedingB.booleanValue()) {
                        --stats2.numSeeding;
                    }
                }
                Boolean wasStoppedB = (Boolean)dm.getUserData("wasStopped");
                boolean bl = wasStopped = wasStoppedB == null ? false : wasStoppedB;
                if (wasStopped) {
                    --stats2.numStoppedAll;
                    if (!dm.getAssumedComplete()) {
                        --stats2.numStoppedIncomplete;
                    }
                }
                SB_Transfers.refreshAllLibraries();
                dm.removeListener(dmListener);
            }

            public void downloadManagerAdded(DownloadManager dm) {
                dm.addListener(dmListener, false);
                SB_Transfers.recountUnopened();
                this.downloadManagerAdded(dm, statsNoLowNoise);
                this.downloadManagerAdded(dm, statsWithLowNoise);
                SB_Transfers.refreshAllLibraries();
            }

            public void downloadManagerAdded(DownloadManager dm, stats stats2) {
                if (!stats2.includeLowNoise && PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
                    return;
                }
                if (dm.getAssumedComplete()) {
                    ++stats2.numComplete;
                    if (dm.getState() == 60) {
                        ++stats2.numSeeding;
                    }
                } else {
                    ++stats2.numIncomplete;
                    if (dm.getState() == 50) {
                        dm.setUserData("wasDownloading", Boolean.TRUE);
                        ++stats2.numDownloading;
                    } else {
                        dm.setUserData("wasDownloading", Boolean.FALSE);
                    }
                }
            }
        }, false);
        List downloadManagers = gm.getDownloadManagers();
        for (DownloadManager dm : downloadManagers) {
            boolean lowNoise = PlatformTorrentUtils.isAdvancedViewOnly(dm);
            dm.addListener(dmListener, false);
            int state = dm.getState();
            if (state == 70) {
                dm.setUserData("wasStopped", Boolean.TRUE);
                ++SB_Transfers.statsWithLowNoise.numStoppedAll;
                if (!dm.getAssumedComplete()) {
                    ++SB_Transfers.statsWithLowNoise.numStoppedIncomplete;
                }
                if (!lowNoise) {
                    ++SB_Transfers.statsNoLowNoise.numStoppedAll;
                    if (!dm.getAssumedComplete()) {
                        ++SB_Transfers.statsNoLowNoise.numStoppedIncomplete;
                    }
                }
            } else {
                dm.setUserData("wasStopped", Boolean.FALSE);
            }
            if (dm.getAssumedComplete()) {
                ++SB_Transfers.statsWithLowNoise.numComplete;
                if (!lowNoise) {
                    ++SB_Transfers.statsNoLowNoise.numComplete;
                }
                if (state == 60) {
                    dm.setUserData("wasSeeding", Boolean.TRUE);
                    ++SB_Transfers.statsWithLowNoise.numSeeding;
                    if (lowNoise) continue;
                    ++SB_Transfers.statsNoLowNoise.numSeeding;
                    continue;
                }
                dm.setUserData("wasSeeding", Boolean.FALSE);
                continue;
            }
            ++SB_Transfers.statsWithLowNoise.numIncomplete;
            if (!lowNoise) {
                ++SB_Transfers.statsNoLowNoise.numIncomplete;
            }
            if (state != 50) continue;
            ++SB_Transfers.statsWithLowNoise.numDownloading;
            if (lowNoise) continue;
            ++SB_Transfers.statsNoLowNoise.numDownloading;
        }
        SB_Transfers.recountUnopened();
        SB_Transfers.refreshAllLibraries();
    }

    private static void setupCategory(final Category category) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        String name = category.getName();
        if (category.getType() != 0) {
            return;
        }
        ViewTitleInfo viewTitleInfo = new ViewTitleInfo(){

            public Object getTitleInfoProperty(int propertyID) {
                List dms;
                if (propertyID == 0 && statsNoLowNoise.numIncomplete > 0 && (dms = category.getDownloadManagers(null)) != null) {
                    return "" + dms.size();
                }
                return null;
            }
        };
        MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "Cat." + Base32.encode(name.getBytes()), "library", name, viewTitleInfo, (Object)category, false, null);
        if (entry != null) {
            entry.setImageLeftID("image.sidebar.library");
        }
        if (entry instanceof SideBarEntrySWT) {
            SideBarEntrySWT entrySWT = (SideBarEntrySWT)entry;
            entrySWT.addListener(new MdiSWTMenuHackListener(){

                public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
                    CategoryUIUtils.createMenuItems(menuTree, category);
                }
            });
        }
        entry.addListener(new MdiEntryDropListener(){

            public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                String type;
                if (!(payload instanceof String)) {
                    return false;
                }
                String dropped = (String)payload;
                String[] split = Constants.PAT_SPLIT_SLASH_N.split(dropped);
                if (split.length > 1 && (type = split[0]).startsWith("DownloadManager")) {
                    GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                    for (int i = 1; i < split.length; ++i) {
                        String hash = split[i];
                        try {
                            DownloadManager dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash)));
                            if (dm == null) continue;
                            TorrentUtil.assignToCategory(new Object[]{dm}, category);
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
                return true;
            }
        });
    }

    private static void removeCategory(Category category) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        MdiEntry entry = mdi.getEntry("Cat." + Base32.encode(category.getName().getBytes()));
        if (entry != null) {
            entry.close(true);
        }
    }

    protected static void updateDMCounts(DownloadManager dm) {
        boolean isDownloading;
        boolean isSeeding;
        boolean wasStopped;
        Boolean wasSeedingB = (Boolean)dm.getUserData("wasSeeding");
        boolean wasSeeding = wasSeedingB == null ? false : wasSeedingB;
        Boolean wasDownloadingB = (Boolean)dm.getUserData("wasDownloading");
        boolean wasDownloading = wasDownloadingB == null ? false : wasDownloadingB;
        Boolean wasStoppedB = (Boolean)dm.getUserData("wasStopped");
        boolean bl = wasStopped = wasStoppedB == null ? false : wasStoppedB;
        if (dm.getAssumedComplete()) {
            isSeeding = dm.getState() == 60;
            isDownloading = false;
        } else {
            isDownloading = dm.getState() == 50;
            isSeeding = false;
        }
        boolean isStopped = dm.getState() == 70;
        boolean lowNoise = PlatformTorrentUtils.isAdvancedViewOnly(dm);
        if (isDownloading != wasDownloading) {
            if (isDownloading) {
                ++SB_Transfers.statsWithLowNoise.numDownloading;
                if (!lowNoise) {
                    ++SB_Transfers.statsNoLowNoise.numDownloading;
                }
            } else {
                --SB_Transfers.statsWithLowNoise.numDownloading;
                if (!lowNoise) {
                    --SB_Transfers.statsNoLowNoise.numDownloading;
                }
            }
            dm.setUserData("wasDownloading", new Boolean(isDownloading));
        }
        if (isSeeding != wasSeeding) {
            if (isSeeding) {
                ++SB_Transfers.statsWithLowNoise.numSeeding;
                if (!lowNoise) {
                    ++SB_Transfers.statsNoLowNoise.numSeeding;
                }
            } else {
                --SB_Transfers.statsWithLowNoise.numSeeding;
                if (!lowNoise) {
                    --SB_Transfers.statsNoLowNoise.numSeeding;
                }
            }
            dm.setUserData("wasSeeding", new Boolean(isSeeding));
        }
        if (isStopped != wasStopped) {
            if (isStopped) {
                ++SB_Transfers.statsWithLowNoise.numStoppedAll;
                if (!dm.getAssumedComplete()) {
                    ++SB_Transfers.statsWithLowNoise.numStoppedIncomplete;
                }
                if (!lowNoise) {
                    ++SB_Transfers.statsNoLowNoise.numStoppedAll;
                    if (!dm.getAssumedComplete()) {
                        ++SB_Transfers.statsNoLowNoise.numStoppedIncomplete;
                    }
                }
            } else {
                --SB_Transfers.statsWithLowNoise.numStoppedAll;
                if (!dm.getAssumedComplete()) {
                    --SB_Transfers.statsWithLowNoise.numStoppedIncomplete;
                }
                if (!lowNoise) {
                    --SB_Transfers.statsNoLowNoise.numStoppedAll;
                    if (!dm.getAssumedComplete()) {
                        --SB_Transfers.statsNoLowNoise.numStoppedIncomplete;
                    }
                }
            }
            dm.setUserData("wasStopped", new Boolean(isStopped));
        }
    }

    private static void recountUnopened() {
        if (!AzureusCoreFactory.isCoreRunning()) {
            return;
        }
        GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
        List dms = gm.getDownloadManagers();
        SB_Transfers.statsNoLowNoise.numUnOpened = 0;
        for (DownloadManager dm : dms) {
            if (PlatformTorrentUtils.getHasBeenOpened(dm) || !dm.getAssumedComplete()) continue;
            ++SB_Transfers.statsNoLowNoise.numUnOpened;
        }
        SB_Transfers.statsWithLowNoise.numUnOpened = SB_Transfers.statsNoLowNoise.numUnOpened;
    }

    protected static void addCountRefreshListener(countRefreshListener l) {
        l.countRefreshed(statsWithLowNoise, statsNoLowNoise);
        listeners.add(l);
    }

    public static void triggerCountRefreshListeners() {
        for (countRefreshListener l : listeners) {
            l.countRefreshed(statsWithLowNoise, statsNoLowNoise);
        }
    }

    private static void refreshAllLibraries() {
        refresh_limiter.dispatch();
    }

    private static void refreshAllLibrariesSupport() {
        String imageID;
        MdiEntryVitalityImage vitalityImage;
        int i;
        MdiEntryVitalityImage[] vitalityImages;
        MdiEntry entry;
        for (countRefreshListener l : listeners) {
            l.countRefreshed(statsWithLowNoise, statsNoLowNoise);
        }
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return;
        }
        if (SB_Transfers.statsNoLowNoise.numIncomplete > 0) {
            entry = mdi.getEntry("LibraryDL");
            if (entry == null) {
                mdi.loadEntryByID("LibraryDL", false);
            }
        } else {
            entry = mdi.getEntry("LibraryDL");
            if (entry != null) {
                entry.close(true);
            }
        }
        entry = mdi.getEntry("LibraryDL");
        if (entry != null) {
            vitalityImages = entry.getVitalityImages();
            for (i = 0; i < vitalityImages.length; ++i) {
                vitalityImage = vitalityImages[i];
                imageID = vitalityImage.getImageID();
                if (imageID == null) continue;
                if (imageID.equals(ID_VITALITY_ACTIVE)) {
                    vitalityImage.setVisible(SB_Transfers.statsNoLowNoise.numDownloading > 0);
                    continue;
                }
                if (!imageID.equals(ID_VITALITY_ALERT)) continue;
                vitalityImage.setVisible(SB_Transfers.statsNoLowNoise.numErrorInComplete > 0);
                if (SB_Transfers.statsNoLowNoise.numErrorInComplete <= 0) continue;
                vitalityImage.setToolTip(SB_Transfers.statsNoLowNoise.errorInCompleteTooltip);
            }
            ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
        }
        if ((entry = mdi.getEntry("LibraryCD")) != null) {
            vitalityImages = entry.getVitalityImages();
            for (i = 0; i < vitalityImages.length; ++i) {
                vitalityImage = vitalityImages[i];
                imageID = vitalityImage.getImageID();
                if (imageID == null || !imageID.equals(ID_VITALITY_ALERT)) continue;
                vitalityImage.setVisible(SB_Transfers.statsNoLowNoise.numErrorComplete > 0);
                if (SB_Transfers.statsNoLowNoise.numErrorComplete <= 0) continue;
                vitalityImage.setToolTip(SB_Transfers.statsNoLowNoise.errorCompleteTooltip);
            }
        }
        if ((entry = mdi.getEntry("LibraryUnopened")) != null) {
            ViewTitleInfoManager.refreshTitleInfo(entry.getViewTitleInfo());
        }
    }

    public static String getTableIdFromFilterMode(int torrentFilterMode, boolean big) {
        if (torrentFilterMode == 1) {
            return big ? "MySeeders.big" : "MySeeders";
        }
        if (torrentFilterMode == 2) {
            return big ? "MyTorrents.big" : "MyTorrents";
        }
        if (torrentFilterMode == 0) {
            return "MyLibrary.big";
        }
        if (torrentFilterMode == 3) {
            return big ? "Unopened.big" : "Unopened";
        }
        return null;
    }

    static {
        SB_Transfers.statsNoLowNoise.includeLowNoise = false;
        SB_Transfers.statsWithLowNoise.includeLowNoise = true;
        refresh_limiter = new FrequencyLimitedDispatcher(new AERunnable(){

            public void runSupport() {
                SB_Transfers.refreshAllLibrariesSupport();
            }
        }, 250);
        refresh_limiter.setSingleThreaded();
    }

    protected static interface countRefreshListener {
        public void countRefreshed(stats var1, stats var2);
    }

    public static class stats {
        int numSeeding = 0;
        int numDownloading = 0;
        int numComplete = 0;
        int numIncomplete = 0;
        int numErrorComplete = 0;
        String errorInCompleteTooltip;
        int numErrorInComplete = 0;
        String errorCompleteTooltip;
        int numUnOpened = 0;
        int numStoppedAll = 0;
        int numStoppedIncomplete = 0;
        boolean includeLowNoise;
    }
}

