/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.views.skin.SBC_LibraryTableView;
import com.aelitis.azureus.ui.swt.views.skin.SB_Transfers;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadTypeComplete;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;

public class MyTorrentsView_Big
extends MyTorrentsView {
    private final int torrentFilterMode;

    public MyTorrentsView_Big(AzureusCore _azureus_core, int torrentFilterMode, TableColumnCore[] basicItems, Text txtFilter, Composite cCats) {
        Class forDataSourceType;
        this.torrentFilterMode = torrentFilterMode;
        this.txtFilter = txtFilter;
        this.cCategories = cCats;
        switch (torrentFilterMode) {
            case 1: {
                forDataSourceType = DownloadTypeComplete.class;
                break;
            }
            case 2: {
                forDataSourceType = DownloadTypeIncomplete.class;
                break;
            }
            case 3: {
                forDataSourceType = Download.class;
                break;
            }
            case 0: {
                forDataSourceType = Download.class;
                break;
            }
            default: {
                forDataSourceType = null;
            }
        }
        this.init(_azureus_core, SB_Transfers.getTableIdFromFilterMode(torrentFilterMode, true), torrentFilterMode != 2, forDataSourceType, basicItems);
    }

    public boolean isOurDownloadManager(DownloadManager dm) {
        if (PlatformTorrentUtils.isAdvancedViewOnly(dm)) {
            return false;
        }
        if (this.torrentFilterMode == 3) {
            if (PlatformTorrentUtils.getHasBeenOpened(dm)) {
                return false;
            }
        } else if (this.torrentFilterMode == 0) {
            return this.isInCurrentCategory(dm);
        }
        return super.isOurDownloadManager(dm);
    }

    protected TableViewSWT createTableView(TableColumnCore[] basicItems) {
        Class forDataSourceType;
        String tableID;
        switch (this.torrentFilterMode) {
            case 1: {
                tableID = "MySeeders.big";
                forDataSourceType = DownloadTypeComplete.class;
                break;
            }
            case 2: {
                tableID = "MyTorrents.big";
                forDataSourceType = DownloadTypeIncomplete.class;
                break;
            }
            case 3: {
                tableID = "Unopened.big";
                forDataSourceType = Download.class;
                break;
            }
            case 0: {
                tableID = "MyLibrary.big";
                forDataSourceType = Download.class;
                break;
            }
            default: {
                tableID = "bad";
                forDataSourceType = null;
            }
        }
        TableViewSWTImpl tv = new TableViewSWTImpl(forDataSourceType, tableID, "MyTorrentsView_Big", basicItems, "#", 268503042);
        return tv;
    }

    public void defaultSelected(TableRowCore[] rows, int stateMask) {
        SBC_LibraryTableView.doDefaultClick(rows, stateMask, !this.isSeedingView);
    }

    protected int getRowDefaultHeight() {
        return 30;
    }
}

