/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.uiupdater;

import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.updater.UIUpdatableAlways;
import com.aelitis.azureus.ui.common.updater.UIUpdater;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;

public class UIUpdaterSWT
extends AEThread2
implements ParameterListener,
UIUpdater {
    private static final LogIDs LOGID = LogIDs.UI3;
    private static final String CFG_REFRESH_INTERVAL = "GUI Refresh";
    private static final String CFG_REFRESH_INACTIVE_FACTOR = "Refresh When Inactive";
    private static final boolean DEBUG_TIMER = Constants.isCVSVersion();
    private static UIUpdater updater = null;
    private int waitTimeMS;
    private boolean finished = false;
    private boolean refreshed = true;
    private ArrayList updateables = new ArrayList();
    private ArrayList alwaysUpdateables = new ArrayList();
    private AEMonitor updateables_mon = new AEMonitor("updateables");
    private int inactiveFactor;
    private int inactiveTicks;
    Map averageTimes = DEBUG_TIMER ? new HashMap() : null;

    public static UIUpdater getInstance() {
        if (updater == null) {
            updater = new UIUpdaterSWT();
            updater.start();
        }
        return updater;
    }

    public UIUpdaterSWT() {
        super("UI Updater", true);
        COConfigurationManager.addAndFireParameterListeners(new String[]{CFG_REFRESH_INTERVAL, CFG_REFRESH_INACTIVE_FACTOR}, this);
    }

    public void run() {
        while (!this.finished) {
            if (this.refreshed) {
                this.refreshed = false;
                if (!Utils.execSWTThread(new AERunnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void runSupport() {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        try {
                                            try {
                                                Display display = Utils.getDisplay();
                                                if (display == null) {
                                                    Object var6_3 = null;
                                                    break block11;
                                                }
                                                if (display.getActiveShell() == null) {
                                                    Shell[] shells = display.getShells();
                                                    boolean noneVisible = true;
                                                    for (int i = 0; i < shells.length; ++i) {
                                                        if (!shells[i].isVisible() || shells[i].getMinimized()) continue;
                                                        noneVisible = false;
                                                        break;
                                                    }
                                                    if (noneVisible) {
                                                        if (UIUpdaterSWT.this.alwaysUpdateables.size() > 0) {
                                                            UIUpdaterSWT.this.update(UIUpdaterSWT.this.alwaysUpdateables);
                                                        }
                                                        break block12;
                                                    }
                                                    if (UIUpdaterSWT.this.inactiveTicks++ % UIUpdaterSWT.this.inactiveFactor != 0) {
                                                        break block13;
                                                    }
                                                }
                                                UIUpdaterSWT.this.update(UIUpdaterSWT.this.updateables);
                                                break block14;
                                            }
                                            catch (Exception e) {
                                                Logger.log(new LogEvent(LOGID, "Error while trying to update GUI", e));
                                                Object var6_7 = null;
                                                UIUpdaterSWT.this.refreshed = true;
                                                return;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var6_8 = null;
                                            UIUpdaterSWT.this.refreshed = true;
                                            throw throwable;
                                        }
                                    }
                                    UIUpdaterSWT.this.refreshed = true;
                                    return;
                                }
                                Object var6_4 = null;
                                UIUpdaterSWT.this.refreshed = true;
                                return;
                            }
                            Object var6_5 = null;
                            UIUpdaterSWT.this.refreshed = true;
                            return;
                        }
                        Object var6_6 = null;
                        UIUpdaterSWT.this.refreshed = true;
                    }
                })) {
                    this.refreshed = true;
                }
            }
            try {
                Thread.sleep(this.waitTimeMS);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void parameterChanged(String parameterName) {
        this.waitTimeMS = COConfigurationManager.getIntParameter(CFG_REFRESH_INTERVAL);
        this.inactiveFactor = COConfigurationManager.getIntParameter(CFG_REFRESH_INACTIVE_FACTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdater(UIUpdatable updateable) {
        this.updateables_mon.enter();
        try {
            if (updateable instanceof UIUpdatableAlways && !this.alwaysUpdateables.contains(updateable)) {
                this.alwaysUpdateables.add(updateable);
            }
            if (!this.updateables.contains(updateable)) {
                this.updateables.add(updateable);
            } else {
                System.out.println("WARNING: already added UIUpdatable " + updateable);
            }
            Object var3_2 = null;
            this.updateables_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.updateables_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdater(UIUpdatable updateable) {
        this.updateables_mon.enter();
        try {
            this.updateables.remove(updateable);
            if (updateable instanceof UIUpdatableAlways) {
                this.alwaysUpdateables.remove(updateable);
            }
            Object var3_2 = null;
            this.updateables_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.updateables_mon.exit();
            throw throwable;
        }
    }

    public void stopIt() {
        this.finished = true;
        COConfigurationManager.removeParameterListener(CFG_REFRESH_INTERVAL, this);
    }

    private void update(List updateables) {
        long start = 0L;
        HashMap<UIUpdatable, Long> mapTimeMap = DEBUG_TIMER ? new HashMap<UIUpdatable, Long>() : null;
        Display display = Utils.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        Object[] updateablesArray = updateables.toArray();
        for (int i = 0; i < updateablesArray.length; ++i) {
            UIUpdatable updateable = (UIUpdatable)updateablesArray[i];
            if (updateable == null) {
                this.removeUpdater(updateable);
            }
            try {
                long diff;
                if (DEBUG_TIMER) {
                    start = SystemTime.getCurrentTime();
                }
                updateable.updateUI();
                if (!DEBUG_TIMER || (diff = SystemTime.getCurrentTime() - start) <= 0L) continue;
                mapTimeMap.put(updateable, new Long(diff));
                continue;
            }
            catch (Throwable t) {
                Logger.log(new LogEvent(LOGID, "Error while trying to update UI Element " + updateable.getUpdateUIName(), t));
            }
        }
        if (DEBUG_TIMER) {
            this.makeDebugToolTip(mapTimeMap);
        }
    }

    private void makeDebugToolTip(Map timeMap) {
        MainStatusBar mainStatusBar;
        boolean IDX_AVG = false;
        boolean IDX_SIZE = true;
        int IDX_MAX = 2;
        int IDX_LAST = 3;
        int IDX_TIME = 4;
        long ttl = 0L;
        for (Object key : timeMap.keySet()) {
            if (!this.averageTimes.containsKey(key)) {
                this.averageTimes.put(key, new Object[]{new Long(0L), new Long(0L), new Long(0L), new Long(0L), new Long(System.currentTimeMillis())});
            }
            Object[] average = (Object[])this.averageTimes.get(key);
            long diff = (Long)timeMap.get(key);
            if (diff > 0L) {
                long count = (Long)average[1];
                if (count >= 20L) {
                    count = 19L;
                }
                long lNewAverage = ((Long)average[0] * count + diff) / (count + 1L);
                average[0] = new Long(lNewAverage);
                average[1] = new Long(count + 1L);
                if (diff > (Long)average[2]) {
                    average[2] = new Long(diff);
                }
                average[3] = new Long(diff);
                average[4] = new Long(System.currentTimeMillis());
            } else {
                average[3] = new Long(diff);
            }
            ttl += diff;
            this.averageTimes.put(key, average);
        }
        UIFunctionsSWT uiFunctionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        MainStatusBar mainStatusBar2 = mainStatusBar = uiFunctionsSWT == null ? null : uiFunctionsSWT.getMainStatusBar();
        if (mainStatusBar != null && mainStatusBar.isMouseOver()) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = this.averageTimes.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                Object[] average = (Object[])this.averageTimes.get(key);
                long lLastUpdated = (Long)average[4];
                if (System.currentTimeMillis() - lLastUpdated > 10000L) {
                    iter.remove();
                    continue;
                }
                long lTime = (Long)average[0];
                if (lTime <= 0L) continue;
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(lTime * 100L / (long)this.waitTimeMS);
                sb.append("% ");
                sb.append(lTime + "ms avg: ");
                sb.append("[" + ((UIUpdatable)key).getUpdateUIName() + "]");
                sb.append(average[1] + " samples");
                sb.append("; max:" + average[2]);
                sb.append("; last:" + average[3]);
            }
            mainStatusBar.setDebugInfo(sb.toString());
        }
    }
}

