/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBox;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBoxListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.ui.swt.donations.DonationWindow;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class DebugMenuHelper {
    public static MenuItem createDebugMenuItem(Menu menuDebug) {
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (null == uiFunctions) {
            throw new IllegalStateException("UIFunctionsManagerSWT.getUIFunctionsSWT() is returning null");
        }
        MenuItem item = new MenuItem(menuDebug, 64);
        item.setText("Run GC");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                System.gc();
            }
        });
        item = new MenuItem(menuDebug, 8);
        item.setText("&CoreReq");
        item.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        new MessageBoxShell(0, "Done", "Core Now Avail").open(null);
                    }
                });
            }
        });
        item = new MenuItem(menuDebug, 64);
        item.setText("DW");
        Menu menuBrowserTB = new Menu(menuDebug.getParent(), 4);
        item.setMenu(menuBrowserTB);
        item = new MenuItem(menuBrowserTB, 0);
        item.setText("popup check");
        item.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean oldDebug = DonationWindow.DEBUG;
                DonationWindow.DEBUG = true;
                DonationWindow.checkForDonationPopup();
                DonationWindow.DEBUG = oldDebug;
            }
        });
        item = new MenuItem(menuBrowserTB, 0);
        item.setText("show");
        item.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean oldDebug = DonationWindow.DEBUG;
                DonationWindow.DEBUG = true;
                DonationWindow.open(true, "debug");
                DonationWindow.DEBUG = oldDebug;
            }
        });
        item = new MenuItem(menuDebug, 0);
        item.setText("Alerts");
        item.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = "This is a  long message with lots of information and stuff you really should read.  Are you still reading? Good, because reading <a href=\"http://moo.com\">stimulates</a> the mind.\n\nYeah Baby.";
                LogAlert logAlert = new LogAlert(true, 0, "Simple");
                Logger.log(logAlert);
                logAlert = new LogAlert(true, 1, text);
                logAlert.details = "Details: \n\n" + text;
                Logger.log(logAlert);
                logAlert = new LogAlert(true, 3, "ShortText");
                logAlert.details = "Details";
                Logger.log(logAlert);
            }
        });
        item = new MenuItem(menuDebug, 0);
        item.setText("MsgBox");
        item.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VuzeMessageBox box = new VuzeMessageBox("Title", "Text", new String[]{"Ok", "Cancel"}, 0);
                box.setListener(new VuzeMessageBoxListener(){

                    public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                        SWTSkin skin = soExtra.getSkin();
                        skin.createSkinObject("dlg.generic.test", "dlg.generic.test", soExtra);
                        skin.layout(soExtra);
                        shell.layout(true, true);
                    }
                });
                box.open(null);
            }
        });
        item = new MenuItem(menuDebug, 64);
        item.setText("Size");
        Menu menuSize = new Menu(menuDebug.getParent(), 4);
        item.setMenu(menuSize);
        int[] sizes = new int[]{640, 430, 800, 550, 1024, 718, 1280, 700};
        for (int i = 0; i < sizes.length; i += 2) {
            final int x = sizes[i];
            final int y = sizes[i + 1];
            item = new MenuItem(menuSize, 0);
            item.setText("" + x + "," + y);
            item.addSelectionListener(new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIFunctionsManagerSWT.getUIFunctionsSWT().getMainShell().setSize(x, y);
                }
            });
        }
        return item;
    }
}

