/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.swt.mdi.BaseMDI;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.TabbedEntry;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTabFolder;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.PluginUISWTSkinObject;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.IViewAlwaysInitialize;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabbedMDI
extends BaseMDI
implements AEDiagnosticsEvidenceGenerator {
    private CTabFolder tabFolder;

    public TabbedMDI() {
        AEDiagnostics.addEvidenceGenerator(this);
    }

    @Override
    public Object skinObjectCreated(SWTSkinObject skinObject, Object params) {
        super.skinObjectCreated(skinObject, params);
        this.creatMDI();
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        TabbedMDI.this.setupPluginViews();
                    }
                });
            }
        });
        try {
            this.loadCloseables();
        }
        catch (Throwable t) {
            Debug.out(t);
        }
        try {
            UIFunctionsManager.getUIFunctions().getUIUpdater().addUpdater(this);
        }
        catch (Exception e) {
            Debug.out(e);
        }
        return null;
    }

    private void creatMDI() {
        this.tabFolder = this.soMain instanceof SWTSkinObjectTabFolder ? ((SWTSkinObjectTabFolder)this.soMain).getTabFolder() : new CTabFolder((Composite)this.soMain.getControl(), 2240);
        COConfigurationManager.addAndFireParameterListener("GUI_SWT_bFancyTab", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        boolean simple = !COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab");
                        TabbedMDI.this.tabFolder.setSimple(simple);
                    }
                });
            }
        });
        Display display = this.tabFolder.getDisplay();
        float[] hsb = this.tabFolder.getBackground().getRGB().getHSB();
        hsb[2] = (float)((double)hsb[2] * (Constants.isOSX ? 0.9 : 0.97));
        this.tabFolder.setBackground(ColorCache.getColor((Device)display, hsb));
        hsb = this.tabFolder.getForeground().getRGB().getHSB();
        hsb[2] = (float)((double)hsb[2] * (Constants.isOSX ? 1.1 : 0.03));
        this.tabFolder.setForeground(ColorCache.getColor((Device)display, hsb));
        this.tabFolder.setSelectionBackground(new Color[]{display.getSystemColor(25), display.getSystemColor(25), display.getSystemColor(22)}, new int[]{10, 90}, true);
        this.tabFolder.setSelectionForeground(display.getSystemColor(24));
        this.tabFolder.setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
        this.tabFolder.setMinimumCharacters(25);
        this.tabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TabbedEntry entry = (TabbedEntry)event2.item.getData("TabbedEntry");
                TabbedMDI.this.showEntry(entry);
            }
        });
        this.tabFolder.getDisplay().addFilter(1, new Listener(){

            public void handleEvent(Event event2) {
                if (TabbedMDI.this.tabFolder.isDisposed()) {
                    return;
                }
                Control focus_control = TabbedMDI.this.tabFolder.getDisplay().getFocusControl();
                if (focus_control != null && focus_control.getShell() != TabbedMDI.this.tabFolder.getShell()) {
                    return;
                }
                int key = event2.character;
                if ((event2.stateMask & SWT.MOD1) != 0 && event2.character <= '\u001a' && event2.character > '\u0000') {
                    key += 96;
                }
                if (key == 27 || event2.keyCode == 0x100000D && event2.stateMask == 262144) {
                    MdiEntry entry = TabbedMDI.this.getCurrentEntry();
                    if (entry != null) {
                        entry.close(false);
                    }
                    event2.doit = false;
                } else if (event2.keyCode == 0x100000F || event2.character == '\t' && (event2.stateMask & 0x40000) != 0) {
                    if ((event2.stateMask & 0x20000) == 0) {
                        event2.doit = false;
                        TabbedMDI.this.selectNextTab(true);
                    } else if (event2.stateMask == 131072) {
                        TabbedMDI.this.selectNextTab(false);
                        event2.doit = false;
                    }
                }
            }
        });
        this.tabFolder.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TabbedMDI.this.saveCloseables();
            }
        });
    }

    private void selectNextTab(boolean selectNext) {
        if (this.tabFolder == null || this.tabFolder.isDisposed()) {
            return;
        }
        int nextOrPrevious = selectNext ? 1 : -1;
        int index = this.tabFolder.getSelectionIndex() + nextOrPrevious;
        if (index == 0 && selectNext || index == -2 || this.tabFolder.getItemCount() < 2) {
            return;
        }
        if (index == this.tabFolder.getItemCount()) {
            index = 0;
        } else if (index < 0) {
            index = this.tabFolder.getItemCount() - 1;
        }
        CTabItem item = this.tabFolder.getItem(index);
        MdiEntry entry = (MdiEntry)item.getData("TabbedEntry");
        if (entry != null) {
            this.showEntry(entry);
        }
    }

    @Override
    public boolean showEntryByID(String id) {
        return this.loadEntryByID(id, true);
    }

    @Override
    public boolean loadEntryByID(String id, boolean activate) {
        return this.loadEntryByID(id, activate, false);
    }

    @Override
    public boolean loadEntryByID(String id, boolean activate, boolean onlyLoadOnce) {
        MdiEntry entry = (MdiEntry)this.mapIdToEntry.get(id);
        if (entry != null) {
            if (activate) {
                this.showEntry(entry);
            }
            return true;
        }
        boolean loadedOnce = COConfigurationManager.getBooleanParameter("tab.once." + id, false);
        if (loadedOnce && onlyLoadOnce) {
            return false;
        }
        MdiEntryCreationListener mdiEntryCreationListener = (MdiEntryCreationListener)this.mapIdToCreationListener.get(id);
        if (mdiEntryCreationListener != null && (entry = mdiEntryCreationListener.createMDiEntry(id)) != null) {
            if (onlyLoadOnce) {
                COConfigurationManager.setParameter("tab.once." + id, true);
            }
            if (activate) {
                this.showEntry(entry);
            }
            return true;
        }
        return false;
    }

    @Override
    public void showEntry(MdiEntry newEntry) {
        if (newEntry == null) {
            return;
        }
        MdiEntrySWT oldEntry = this.currentEntry;
        if (newEntry == oldEntry) {
            this.triggerSelectionListener(newEntry, newEntry);
            return;
        }
        if (oldEntry != null) {
            oldEntry.hide();
        }
        this.currentEntry = (MdiEntrySWT)newEntry;
        if (newEntry != null) {
            ((BaseMdiEntry)newEntry).show();
        }
        this.triggerSelectionListener(newEntry, oldEntry);
    }

    @Override
    public void updateUI() {
        MdiEntry currentEntry = this.getCurrentEntry();
        if (currentEntry != null) {
            currentEntry.updateUI();
        }
    }

    @Override
    public MdiEntry createEntryFromSkinRef(String parentID, String id, String configID, String title, ViewTitleInfo titleInfo, Object params, boolean closeable, int index) {
        MdiEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id);
        entry.setTitle(title);
        entry.setSkinRef(configID, params);
        this.setupNewEntry(entry, id, index);
        return entry;
    }

    @Override
    public MdiEntry createEntryFromSkinRef(String parentID, String id, String configID, String title, ViewTitleInfo titleInfo, Object params, boolean closeable, String preferedAfterID) {
        return this.createEntryFromSkinRef(parentID, id, configID, title, titleInfo, params, closeable, "".equals(preferedAfterID) ? 0 : -1);
    }

    @Override
    public MdiEntry createEntryFromEventListener(String parentID, UISWTViewEventListener l, String id, boolean closeable, Object datasource) {
        MdiEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id);
        entry.setDatasource(datasource);
        entry.setEventListener(l);
        this.setupNewEntry(entry, id, -1);
        return entry;
    }

    @Override
    public MdiEntry createEntryFromIViewClass(String parent, String id, String title, Class<?> iviewClass, Class<?>[] iviewClassArgs, Object[] iviewClassVals, Object datasource, ViewTitleInfo titleInfo, boolean closeable) {
        MdiEntry oldEntry = this.getEntry(id);
        if (oldEntry != null) {
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id);
        entry.setTitle(title);
        entry.setIViewClass(iviewClass, iviewClassArgs, iviewClassVals);
        entry.setDatasource(datasource);
        entry.setViewTitleInfo(titleInfo);
        entry.setCloseable(closeable);
        this.setupNewEntry(entry, id, -1);
        if (IViewAlwaysInitialize.class.isAssignableFrom(iviewClass)) {
            entry.build();
        }
        return entry;
    }

    @Override
    public MdiEntry createEntryFromIView(String parentID, IView iview, String id, Object datasource, boolean closeable, boolean show, boolean expand) {
        MdiEntry oldEntry;
        int i;
        if (id == null && (i = (id = iview.getClass().getName()).lastIndexOf(46)) > 0) {
            id = id.substring(i + 1);
        }
        if ((oldEntry = this.getEntry(id)) != null) {
            if (show) {
                this.showEntry(oldEntry);
            }
            return oldEntry;
        }
        TabbedEntry entry = new TabbedEntry(this, this.skin, id);
        entry.setIView(iview);
        entry.setDatasource(datasource);
        this.setupNewEntry(entry, id, -1);
        if (iview instanceof IViewAlwaysInitialize) {
            entry.build();
        }
        if (show) {
            this.showEntry(entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupNewEntry(final TabbedEntry entry, final String id, final int index) {
        Map map = this.mapIdToEntry;
        synchronized (map) {
            this.mapIdToEntry.put(id, entry);
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                TabbedMDI.this.swt_setupNewEntry(entry, id, index);
            }
        });
    }

    private void swt_setupNewEntry(TabbedEntry entry, String id, int index) {
        if (index < 0 || index >= this.tabFolder.getItemCount()) {
            index = this.tabFolder.getItemCount();
        }
        CTabItem cTabItem = new CTabItem(this.tabFolder, 64, index);
        cTabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TabbedMDI.this.tabFolder.getItemCount() == 0) {
                    TabbedMDI.this.currentEntry = null;
                }
            }
        });
        cTabItem.setData("TabbedEntry", entry);
        entry.setSwtItem(cTabItem);
    }

    @Override
    public String getUpdateUIName() {
        String name = "MDI";
        MdiEntry entry = this.getCurrentEntry();
        if (entry != null) {
            name = name + "-" + entry.getId();
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        MdiEntrySWT[] entries;
        for (MdiEntrySWT entry : entries = this.getEntriesSWT()) {
            Object var10_9;
            IView view;
            if (entry == null || (view = entry.getIView()) == null) continue;
            writer.println(view.getFullTitle());
            try {
                try {
                    writer.indent();
                    view.generateDiagnostics(writer);
                }
                catch (Exception e) {
                    var10_9 = null;
                    writer.exdent();
                    continue;
                }
                var10_9 = null;
                writer.exdent();
            }
            catch (Throwable throwable) {
                var10_9 = null;
                writer.exdent();
                throw throwable;
            }
        }
    }

    @Override
    public MdiEntrySWT getEntryFromSkinObject(PluginUISWTSkinObject pluginSkinObject) {
        if (pluginSkinObject instanceof SWTSkinObject) {
            for (Control control = ((SWTSkinObject)pluginSkinObject).getControl(); control != null && !control.isDisposed(); control = control.getParent()) {
                Object entry = control.getData("BaseMDIEntry");
                if (!(entry instanceof BaseMdiEntry)) continue;
                BaseMdiEntry mdiEntry = (BaseMdiEntry)entry;
                return mdiEntry;
            }
        }
        return null;
    }

    @Override
    public MdiEntry createHeader(String id, String title, String preferredAfterID) {
        return null;
    }
}

