/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.mdi;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MdiEntryLoadedListener;
import com.aelitis.azureus.ui.mdi.MdiListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.MapUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.plugins.ui.UIPluginView;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.IView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseMDI
extends SkinView
implements MultipleDocumentInterfaceSWT,
UIUpdatable {
    protected MdiEntrySWT currentEntry;
    protected Map<String, MdiEntryCreationListener> mapIdToCreationListener = new LightHashMap<String, MdiEntryCreationListener>();
    protected Map<String, MdiEntrySWT> mapIdToEntry = new LightHashMap<String, MdiEntrySWT>();
    private List<MdiListener> listeners = new ArrayList<MdiListener>();
    private List<MdiEntryLoadedListener> listLoadListeners = new ArrayList<MdiEntryLoadedListener>();
    private static Map<String, Object> mapAutoOpen = new LightHashMap<String, Object>();
    private String[] preferredOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiListener l) {
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            if (this.listeners.contains(l)) {
                return;
            }
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiListener l) {
        List<MdiListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(MdiEntryLoadedListener l) {
        MdiEntry[] entries;
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            if (this.listLoadListeners.contains(l)) {
                return;
            }
            this.listLoadListeners.add(l);
        }
        for (MdiEntry entry : entries = this.getEntries()) {
            if (!entry.isAdded()) continue;
            l.mdiEntryLoaded(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(MdiEntryLoadedListener l) {
        List<MdiEntryLoadedListener> list = this.listLoadListeners;
        synchronized (list) {
            this.listLoadListeners.remove(l);
        }
    }

    protected void triggerSelectionListener(MdiEntry newEntry, MdiEntry oldEntry) {
        MdiListener[] array;
        for (MdiListener l : array = this.listeners.toArray(new MdiListener[0])) {
            try {
                l.mdiEntrySelected(newEntry, oldEntry);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    public void triggerEntryLoadedListeners(MdiEntry entry) {
        MdiEntryLoadedListener[] array;
        for (MdiEntryLoadedListener l : array = this.listLoadListeners.toArray(new MdiEntryLoadedListener[0])) {
            try {
                l.mdiEntryLoaded(entry);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void closeEntry(String id) {
        MdiEntry entry = this.getEntry(id);
        if (entry != null) {
            entry.close(false);
        }
    }

    @Override
    public abstract MdiEntry createEntryFromEventListener(String var1, UISWTViewEventListener var2, String var3, boolean var4, Object var5);

    @Override
    public abstract MdiEntry createEntryFromIView(String var1, IView var2, String var3, Object var4, boolean var5, boolean var6, boolean var7);

    @Override
    public abstract MdiEntry createEntryFromIViewClass(String var1, String var2, String var3, Class<?> var4, Class<?>[] var5, Object[] var6, Object var7, ViewTitleInfo var8, boolean var9);

    @Override
    public abstract MdiEntry createEntryFromSkinRef(String var1, String var2, String var3, String var4, ViewTitleInfo var5, Object var6, boolean var7, int var8);

    @Override
    public abstract MdiEntry createEntryFromSkinRef(String var1, String var2, String var3, String var4, ViewTitleInfo var5, Object var6, boolean var7, String var8);

    @Override
    public MdiEntry getCurrentEntry() {
        return this.currentEntry;
    }

    @Override
    public MdiEntrySWT getCurrentEntrySWT() {
        return this.currentEntry;
    }

    @Override
    public MdiEntry[] getEntries() {
        return this.mapIdToEntry.values().toArray(new MdiEntry[0]);
    }

    public MdiEntrySWT[] getEntriesSWT() {
        return this.mapIdToEntry.values().toArray(new MdiEntrySWT[0]);
    }

    @Override
    public MdiEntry getEntry(String id) {
        if ("Browse".equalsIgnoreCase(id)) {
            id = ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork());
        }
        MdiEntry entry = this.mapIdToEntry.get(id);
        return entry;
    }

    @Override
    public MdiEntrySWT getEntrySWT(String id) {
        if ("Browse".equalsIgnoreCase(id)) {
            id = ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork());
        }
        MdiEntrySWT entry = this.mapIdToEntry.get(id);
        return entry;
    }

    @Override
    public MdiEntry getEntryBySkinView(Object skinView) {
        SWTSkinObject so = ((SkinView)skinView).getMainSkinObject();
        Object[] sideBarEntries = this.mapIdToEntry.values().toArray();
        for (int i = 0; i < sideBarEntries.length; ++i) {
            SWTSkinObject entrySOParent;
            BaseMdiEntry entry = (BaseMdiEntry)sideBarEntries[i];
            SWTSkinObject entrySO = entry.getSkinObject();
            SWTSkinObject sWTSkinObject = entrySOParent = entrySO == null ? entrySO : entrySO.getParent();
            if (entrySO != so && entrySO != so.getParent() && entrySOParent != so) continue;
            return entry;
        }
        return null;
    }

    @Override
    public IView getIViewFromID(String id) {
        if (id == null) {
            return null;
        }
        MdiEntrySWT entry = this.getEntrySWT(id);
        if (entry == null) {
            return null;
        }
        return entry.getIView();
    }

    @Override
    public String getUpdateUIName() {
        if (this.currentEntry == null || this.currentEntry.getIView() == null) {
            return "MDI";
        }
        if (this.currentEntry.getIView() instanceof UIPluginView) {
            UIPluginView uiPluginView = (UIPluginView)((Object)this.currentEntry.getIView());
            return uiPluginView.getViewID();
        }
        return this.currentEntry.getIView().getFullTitle();
    }

    @Override
    public void registerEntry(String id, MdiEntryCreationListener l) {
        MdiEntryCreationListener mdiEntryCreationListener;
        this.mapIdToCreationListener.put(id, l);
        Object o = mapAutoOpen.get(id);
        if (o instanceof Map && (mdiEntryCreationListener = this.mapIdToCreationListener.get(id)) != null) {
            try {
                mdiEntryCreationListener.createMDiEntry(id);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public abstract boolean showEntryByID(String var1);

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        return null;
    }

    @Override
    public void updateUI() {
        MdiEntry currentEntry = this.getCurrentEntry();
        if (currentEntry != null) {
            currentEntry.updateUI();
        }
    }

    @Override
    public boolean entryExists(String id) {
        MdiEntry entry;
        if ("Browse".equalsIgnoreCase(id)) {
            id = ContentNetworkUtils.getTarget(ConstantsVuze.getDefaultContentNetwork());
        }
        if ((entry = (MdiEntry)this.mapIdToEntry.get(id)) == null) {
            return false;
        }
        return entry.isAdded();
    }

    protected MdiEntry createWelcomeSection() {
        MdiEntry entry = this.createEntryFromSkinRef("header.vuze", "Welcome", "main.area.welcome", MessageText.getString("v3.MainWindow.menu.getting_started").replaceAll("&", ""), null, null, true, 0);
        entry.setImageLeftID("image.sidebar.welcome");
        this.addDropTest(entry);
        return entry;
    }

    protected void addDropTest(MdiEntry entry) {
        if (!Constants.isCVSVersion()) {
            return;
        }
        entry.addListener(new MdiEntryDropListener(){

            public boolean mdiEntryDrop(MdiEntry entry, Object droppedObject) {
                String s = "You just dropped " + droppedObject.getClass() + "\n" + droppedObject + "\n\n";
                if (droppedObject.getClass().isArray()) {
                    Object[] o = (Object[])droppedObject;
                    for (int i = 0; i < o.length; ++i) {
                        s = s + "" + i + ":  ";
                        Object object = o[i];
                        s = object == null ? s + "null" : s + object.getClass() + ";" + object;
                        s = s + "\n";
                    }
                }
                new MessageBoxShell(32, "test", s).open(null);
                return true;
            }
        });
    }

    @Override
    public void setEntryAutoOpen(String id, boolean autoOpen) {
        if (!autoOpen) {
            mapAutoOpen.remove(id);
        } else {
            mapAutoOpen.put(id, new LightHashMap(0));
        }
    }

    protected void setupPluginViews() {
        UISWTInstanceImpl uiSWTInstance = (UISWTInstanceImpl)UIFunctionsManagerSWT.getUIFunctionsSWT().getUISWTInstance();
        if (uiSWTInstance != null) {
            Map<String, Map<String, UISWTViewEventListenerHolder>> allViews = uiSWTInstance.getAllViews();
            Object[] parentIDs = allViews.keySet().toArray();
            for (int i = 0; i < parentIDs.length; ++i) {
                String parentID = (String)parentIDs[i];
                String sidebarParentID = null;
                if ("MyTorrents".equals(parentID)) {
                    sidebarParentID = "header.transfers";
                } else if ("Main".equals(parentID)) {
                    sidebarParentID = "header.plugins";
                }
                Map<String, UISWTViewEventListenerHolder> mapSubViews = allViews.get(parentID);
                if (mapSubViews == null) continue;
                Object[] viewIDs = mapSubViews.keySet().toArray();
                for (int j = 0; j < viewIDs.length; ++j) {
                    boolean open;
                    String viewID = (String)viewIDs[j];
                    UISWTViewEventListener l = mapSubViews.get(viewID);
                    if (l == null || !(open = COConfigurationManager.getBooleanParameter("SideBar.AutoOpen." + viewID, false))) continue;
                    this.createEntryFromEventListener(sidebarParentID, l, viewID, true, null);
                }
            }
        }
        PluginsMenuHelper.getInstance().addPluginAddedViewListener(new PluginsMenuHelper.PluginAddedViewListener(){

            public void pluginViewAdded(PluginsMenuHelper.IViewInfo viewInfo) {
                Object o = mapAutoOpen.get(viewInfo.viewID);
                if (o instanceof Map) {
                    BaseMDI.this.processAutoOpenMap(viewInfo.viewID, (Map)o, viewInfo);
                }
            }
        });
    }

    @Override
    public void informAutoOpenSet(MdiEntry entry, Map<String, Object> autoOpenInfo) {
        mapAutoOpen.put(entry.getId(), autoOpenInfo);
    }

    public void loadCloseables() {
        Map loadedMap = FileUtil.readResilientConfigFile("sidebarauto.config", true);
        if (loadedMap.isEmpty()) {
            return;
        }
        BDecoder.decodeStrings(loadedMap);
        for (String id : loadedMap.keySet()) {
            Object o = loadedMap.get(id);
            if (!(o instanceof Map) || this.processAutoOpenMap(id, (Map)o, null)) continue;
            mapAutoOpen.put(id, o);
        }
    }

    public void saveCloseables() {
        for (String id : mapAutoOpen.keySet()) {
            Object o = mapAutoOpen.get(id);
            MdiEntry entry = this.getEntry(id);
            if (entry == null || !entry.isAdded() || !(o instanceof Map)) continue;
            Map autoOpenInfo = (Map)o;
            String s = entry.getTitle();
            if (s == null) continue;
            autoOpenInfo.put("title", s);
        }
        FileUtil.writeResilientConfigFile("sidebarauto.config", mapAutoOpen);
    }

    private boolean processAutoOpenMap(String id, Map<?, ?> autoOpenInfo, PluginsMenuHelper.IViewInfo viewInfo) {
        try {
            Class<?> cla;
            MdiEntryCreationListener mdiEntryCreationListener;
            MdiEntry entry = this.getEntry(id);
            if (entry != null) {
                return true;
            }
            if (id.equals("Welcome")) {
                this.createWelcomeSection();
            }
            if ((mdiEntryCreationListener = this.mapIdToCreationListener.get(id)) != null) {
                try {
                    mdiEntryCreationListener.createMDiEntry(id);
                    return true;
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
            String title = MapUtils.getMapString(autoOpenInfo, "title", id);
            String parentID = MapUtils.getMapString(autoOpenInfo, "parentID", "header.plugins");
            Object datasource = autoOpenInfo.get("datasource");
            if (viewInfo != null) {
                if (viewInfo.view != null) {
                    entry = this.createEntryFromIView(parentID, viewInfo.view, id, datasource, true, false, true);
                    return true;
                }
                if (viewInfo.event_listener != null) {
                    entry = this.createEntryFromEventListener(parentID, viewInfo.event_listener, id, true, datasource);
                    return true;
                }
            }
            if ((cla = Class.forName(MapUtils.getMapString(autoOpenInfo, "iviewClass", ""))) != null) {
                entry = this.createEntryFromIViewClass(parentID, id, title, cla, null, null, datasource, null, true);
                if (datasource == null) {
                    final MdiEntry fEntry = entry;
                    final String dmHash = MapUtils.getMapString(autoOpenInfo, "dm", null);
                    if (dmHash != null) {
                        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                            public void azureusCoreRunning(AzureusCore core) {
                                HashWrapper hw;
                                GlobalManager gm = core.getGlobalManager();
                                DownloadManager dm = gm.getDownloadManager(hw = new HashWrapper(Base32.decode(dmHash)));
                                if (dm != null) {
                                    fEntry.setDatasource(dm);
                                }
                            }
                        });
                    } else {
                        final List listHashes = MapUtils.getMapList(autoOpenInfo, "dms", null);
                        if (listHashes != null) {
                            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                                public void azureusCoreRunning(AzureusCore core) {
                                    ArrayList<DownloadManager> listDMS = new ArrayList<DownloadManager>(1);
                                    GlobalManager gm = core.getGlobalManager();
                                    for (Object oDM : listHashes) {
                                        String hash;
                                        DownloadManager dm;
                                        if (oDM instanceof String && (dm = gm.getDownloadManager(new HashWrapper(Base32.decode(hash = (String)oDM)))) != null) {
                                            listDMS.add(dm);
                                        }
                                        fEntry.setDatasource(listDMS.toArray(new DownloadManager[0]));
                                    }
                                }
                            });
                        }
                    }
                }
                return true;
            }
        }
        catch (ClassNotFoundException ce) {
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItem(MdiEntry entry) {
        String id = entry.getId();
        Map<String, MdiEntrySWT> map = this.mapIdToEntry;
        synchronized (map) {
            this.mapIdToEntry.remove(id);
            this.removeChildrenOf(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChildrenOf(String id) {
        if (id == null) {
            return;
        }
        Map<String, MdiEntrySWT> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntrySWT[] entriesSWT;
            for (MdiEntrySWT entry : entriesSWT = this.getEntriesSWT()) {
                if (!id.equals(entry.getParentID())) continue;
                this.mapIdToEntry.remove(entry);
                this.removeChildrenOf(entry.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MdiEntry> getChildrenOf(String id) {
        if (id == null) {
            return Collections.emptyList();
        }
        ArrayList<MdiEntry> list = new ArrayList<MdiEntry>(1);
        Map<String, MdiEntrySWT> map = this.mapIdToEntry;
        synchronized (map) {
            MdiEntrySWT[] entriesSWT;
            for (MdiEntrySWT entry : entriesSWT = this.getEntriesSWT()) {
                if (!id.equals(entry.getParentID())) continue;
                list.add(entry);
            }
        }
        return list;
    }

    @Override
    public Object updateLanguage(SWTSkinObject skinObject, Object params) {
        MdiEntrySWT[] entries;
        for (MdiEntrySWT entry : entries = this.getEntriesSWT()) {
            IView view;
            if (entry == null || (view = entry.getIView()) == null) continue;
            try {
                view.updateLanguage();
                view.refresh();
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        return null;
    }

    @Override
    public void setPreferredOrder(String[] preferredOrder) {
        this.preferredOrder = preferredOrder;
    }

    @Override
    public String[] getPreferredOrder() {
        return this.preferredOrder == null ? new String[]{} : this.preferredOrder;
    }
}

