/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices.add;

import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.ui.swt.Utils;

public class ManufacturerChooser {
    private SkinnedDialog skinnedDialog;
    private ClosedListener listener;
    protected DeviceManager.DeviceManufacturer chosenMF;

    public void open(ClosedListener l) {
        this.listener = l;
        this.skinnedDialog = new SkinnedDialog("skin3_dlg_deviceadd_mfchooser", "shell", 2080);
        this.skinnedDialog.addCloseListener(new SkinnedDialog.SkinnedDialogClosedListener(){

            public void skinDialogClosed(SkinnedDialog dialog) {
                if (ManufacturerChooser.this.listener != null) {
                    ManufacturerChooser.this.listener.MfChooserClosed(ManufacturerChooser.this.chosenMF);
                }
            }
        });
        SWTSkin skin = this.skinnedDialog.getSkin();
        SWTSkinObject so = skin.getSkinObject("list");
        if (so instanceof SWTSkinObjectContainer) {
            DeviceManager.DeviceManufacturer[] mfs;
            SWTSkinObjectContainer soList = (SWTSkinObjectContainer)so;
            Composite parent = soList.getComposite();
            Canvas centerCanvas = new Canvas(parent, 0);
            FormData fd = Utils.getFilledFormData();
            fd.bottom = null;
            fd.height = 0;
            centerCanvas.setLayoutData(fd);
            Composite area = new Composite(parent, 0);
            RowLayout rowLayout = new RowLayout(512);
            rowLayout.fill = true;
            area.setLayout(rowLayout);
            fd = Utils.getFilledFormData();
            fd.left = new FormAttachment(centerCanvas, 50, 0x1000000);
            fd.right = null;
            area.setLayoutData(fd);
            Listener btnListener = new Listener(){

                public void handleEvent(Event event2) {
                    ManufacturerChooser.this.chosenMF = (DeviceManager.DeviceManufacturer)event2.widget.getData("mf");
                    ManufacturerChooser.this.skinnedDialog.close();
                }
            };
            DeviceManager deviceManager = DeviceManagerFactory.getSingleton();
            for (DeviceManager.DeviceManufacturer mf : mfs = deviceManager.getDeviceManufacturers(3)) {
                DeviceTemplate[] deviceTemplates = mf.getDeviceTemplates();
                boolean hasNonAuto = false;
                for (DeviceTemplate deviceTemplate : deviceTemplates) {
                    if (deviceTemplate.isAuto()) continue;
                    hasNonAuto = true;
                    break;
                }
                if (!hasNonAuto) continue;
                Button button = new Button(area, 8);
                button.setText(mf.getName());
                button.setData("mf", mf);
                button.addListener(4, btnListener);
            }
        }
        this.skinnedDialog.getShell().pack();
        this.skinnedDialog.open();
    }

    public static interface ClosedListener {
        public void MfChooserClosed(DeviceManager.DeviceManufacturer var1);
    }
}

