/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.devices.Device;
import com.aelitis.azureus.core.devices.DeviceManager;
import com.aelitis.azureus.core.devices.DeviceManagerException;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceManagerListener;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloader;
import com.aelitis.azureus.core.devices.DeviceOfflineDownloaderManager;
import com.aelitis.azureus.core.devices.DeviceSearchListener;
import com.aelitis.azureus.core.devices.DeviceTemplate;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeFile;
import com.aelitis.azureus.core.devices.TranscodeJob;
import com.aelitis.azureus.core.devices.TranscodeManager;
import com.aelitis.azureus.core.devices.TranscodeManagerListener;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.core.devices.TranscodeQueue;
import com.aelitis.azureus.core.devices.TranscodeQueueListener;
import com.aelitis.azureus.core.devices.TranscodeTarget;
import com.aelitis.azureus.core.devices.TranscodeTargetListener;
import com.aelitis.azureus.core.download.DiskManagerFileInfoFile;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImageListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.devices.DeviceInternetView;
import com.aelitis.azureus.ui.swt.devices.DevicesFTUX;
import com.aelitis.azureus.ui.swt.devices.DevicesODFTUX;
import com.aelitis.azureus.ui.swt.devices.TranscodeChooser;
import com.aelitis.azureus.ui.swt.devices.add.DeviceTemplateChooser;
import com.aelitis.azureus.ui.swt.devices.add.ManufacturerChooser;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.sidebar.SideBar;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.DirectoryParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.PropertiesWindow;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.plugins.UISWTInputReceiver;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class DeviceManagerUI {
    public static boolean DISABLED;
    private static final int MIN_FILE_SIZE_FOR_XCODE = 131072;
    private static final int MAX_FILES_FOR_MULTI_XCODE = 64;
    private static final Object DEVICE_IVIEW_KEY;
    private static final String CONFIG_VIEW_TYPE = "device.sidebar.ui.viewtype";
    public static final String CONFIG_VIEW_HIDE_REND_GENERIC = "device.sidebar.ui.rend.hidegeneric";
    private static final String SPINNER_IMAGE_ID = "image.sidebar.vitality.dl";
    private static final String INFO_IMAGE_ID = "image.sidebar.vitality.info";
    private static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
    private static final boolean SHOW_RENDERER_VITALITY = false;
    private static final boolean SHOW_OD_VITALITY = true;
    private DeviceManager device_manager;
    private DeviceManagerListener device_manager_listener;
    private boolean device_manager_listener_added;
    private final PluginInterface plugin_interface;
    private final UIManager ui_manager;
    private UISWTInstance swt_ui;
    private boolean ui_setup;
    private MultipleDocumentInterfaceSWT mdi;
    private boolean sidebar_built;
    private static final int SBV_SIMPLE = 0;
    private static final int SBV_FULL = Integer.MAX_VALUE;
    private int side_bar_view_type = COConfigurationManager.getIntParameter("device.sidebar.ui.viewtype", 0);
    private boolean side_bar_hide_rend_gen = COConfigurationManager.getBooleanParameter("device.sidebar.ui.rend.hidegeneric", true);
    private int next_sidebar_id;
    private List<categoryView> categories = new ArrayList<categoryView>();
    private MenuItemListener properties_listener;
    private MenuItemListener hide_listener;
    private MenuItemListener rename_listener;
    private MenuItemListener export_listener;
    private MenuItemFillListener will_remove_listener;
    private MenuItemListener remove_listener;
    private MenuItemFillListener show_fill_listener;
    private MenuItemListener show_listener;
    private MenuItemFillListener will_browse_listener;
    private boolean offline_menus_setup;
    private MdiEntry mdiEntryOverview;
    private boolean needsAddAllDevices;
    private MdiEntry entryHeader;

    public DeviceManagerUI(AzureusCore core) {
        this.plugin_interface = PluginInitializer.getDefaultInterface();
        this.ui_manager = this.plugin_interface.getUIManager();
        if (DISABLED) {
            return;
        }
        this.ui_manager.addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    DeviceManagerUI.this.swt_ui = (UISWTInstance)instance;
                    AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                        public void azureusCoreRunning(AzureusCore core) {
                            DeviceManagerUI.this.uiAttachedAndCoreRunning(core);
                        }
                    });
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    private void uiAttachedAndCoreRunning(AzureusCore core) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
                if (mdi != null) {
                    DeviceManagerUI.this.setupUI(mdi);
                } else {
                    SkinViewManager.addListener(new SkinViewManager.SkinViewManagerListener(){

                        public void skinViewAdded(SkinView skinview) {
                            if (skinview instanceof SideBar) {
                                DeviceManagerUI.this.setupUI((SideBar)skinview);
                                SkinViewManager.RemoveListener(this);
                            }
                        }
                    });
                }
            }
        });
        UIExitUtilsSWT.addListener(new UIExitUtilsSWT.canCloseListener(){

            public boolean canClose() {
                try {
                    if (DeviceManagerUI.this.device_manager == null) {
                        return true;
                    }
                    TranscodeJob job = DeviceManagerUI.this.device_manager.getTranscodeManager().getQueue().getCurrentJob();
                    if (job == null || job.getState() != 1) {
                        return true;
                    }
                    if (job.getTranscodeFile().getDevice().isHidden()) {
                        return true;
                    }
                    String title = MessageText.getString("device.quit.transcoding.title");
                    String text = MessageText.getString("device.quit.transcoding.text", new String[]{job.getName(), job.getTarget().getDevice().getName(), String.valueOf(job.getPercentComplete())});
                    MessageBoxShell mb = new MessageBoxShell(title, text, new String[]{MessageText.getString("UpdateWindow.quit"), MessageText.getString("Content.alert.notuploaded.button.abort")}, 1);
                    mb.open(null);
                    mb.waitUntilClosed();
                    return mb.getResult() == 0;
                }
                catch (Throwable e) {
                    Debug.out(e);
                    return true;
                }
            }
        });
    }

    protected DeviceManager getDeviceManager() {
        return this.device_manager;
    }

    protected PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupUI(MultipleDocumentInterfaceSWT mdi) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            if (this.ui_setup) {
                return;
            }
            this.ui_setup = true;
        }
        this.mdi = mdi;
        this.device_manager = DeviceManagerFactory.getSingleton();
        this.setupMenuListeners();
        mdi.registerEntry("Devices", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                if (DeviceManagerUI.this.sidebar_built) {
                    DeviceManagerUI.this.removeAllDevices();
                    DeviceManagerUI.this.buildSideBar(true);
                } else {
                    DeviceManagerUI.this.buildSideBar(false);
                }
                DeviceManagerUI.this.addAllDevices();
                return DeviceManagerUI.this.mdiEntryOverview;
            }
        });
        this.device_manager.addListener(new DeviceManagerListener(){

            public void deviceRemoved(Device device) {
            }

            public void deviceManagerLoaded() {
                DeviceManagerUI.this.device_manager.removeListener(this);
                DeviceManagerUI.this.setupUIwithDeviceManager();
            }

            public void deviceChanged(Device device) {
            }

            public void deviceAttentionRequest(Device device) {
            }

            public void deviceAdded(Device device) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupUIwithDeviceManager() {
        boolean add_all = false;
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            this.device_manager_listener = new DeviceManagerListener(){

                public void deviceAdded(Device device) {
                    DeviceManagerUI.this.addOrChangeDevice(device);
                }

                public void deviceChanged(Device device) {
                    DeviceManagerUI.this.addOrChangeDevice(device);
                }

                public void deviceAttentionRequest(Device device) {
                    DeviceManagerUI.this.showDevice(device);
                }

                public void deviceRemoved(Device device) {
                    DeviceManagerUI.this.removeDevice(device);
                }

                public void deviceManagerLoaded() {
                }
            };
            if (this.needsAddAllDevices) {
                add_all = true;
                this.needsAddAllDevices = false;
            }
        }
        TranscodeManager transMan = this.device_manager.getTranscodeManager();
        TranscodeQueue transQ = transMan.getQueue();
        transQ.addListener(new TranscodeQueueListener(){
            int last_job_count = 0;

            public void jobAdded(TranscodeJob job) {
                this.check();
            }

            public void jobChanged(TranscodeJob job) {
                this.check();
            }

            public void jobRemoved(TranscodeJob job) {
                this.check();
            }

            protected void check() {
                int job_count = DeviceManagerUI.this.device_manager.getTranscodeManager().getQueue().getJobCount();
                if (job_count != this.last_job_count) {
                    MdiEntry main_entry;
                    MultipleDocumentInterface mdi;
                    if ((job_count == 0 || this.last_job_count == 0) && (mdi = UIFunctionsManager.getUIFunctions().getMDI()) != null && (main_entry = mdi.getEntry("Devices")) != null) {
                        ViewTitleInfoManager.refreshTitleInfo(main_entry.getViewTitleInfo());
                    }
                    this.last_job_count = job_count;
                }
            }
        });
        this.setupListeners();
        this.setupConfigUI();
        if (add_all) {
            this.addAllDevices();
        }
        this.setupTranscodeMenus();
    }

    public void setupConfigUI() {
        BasicPluginConfigModel configModel = this.ui_manager.createBasicPluginConfigModel("root", "Devices");
        final BooleanParameter as = configModel.addBooleanParameter2("device.search.auto", "device.search.auto", this.device_manager.getAutoSearch());
        as.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setAutoSearch(as.getValue());
                if (DeviceManagerUI.this.device_manager.getAutoSearch()) {
                    DeviceManagerUI.this.search();
                }
            }
        });
        final BooleanParameter qosParam = configModel.addBooleanParameter2("devices.sendQOS", "devices.turnon.qos", false);
        qosParam.setValue(COConfigurationManager.getBooleanParameter("devices.sendQOS", false));
        qosParam.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                COConfigurationManager.setParameter("devices.sendQOS", qosParam.getValue());
            }
        });
        final BooleanParameter config_simple_view = configModel.addBooleanParameter2(CONFIG_VIEW_TYPE, "devices.sidebar.simple", this.side_bar_view_type == 0);
        config_simple_view.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                COConfigurationManager.setParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, config_simple_view.getValue() ? 0 : Integer.MAX_VALUE);
            }
        });
        COConfigurationManager.addParameterListener(CONFIG_VIEW_TYPE, new org.gudy.azureus2.core3.config.ParameterListener(){

            public void parameterChanged(String parameterName) {
                config_simple_view.setValue(COConfigurationManager.getIntParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, 0) == 0);
            }
        });
        configModel.addBooleanParameter2("!device.sidebar.ui.rend.hidegeneric!", "devices.sidebar.hide.rend.generic", this.side_bar_hide_rend_gen);
        String def = this.device_manager.getDefaultWorkingDirectory().getAbsolutePath();
        final DirectoryParameter def_work_dir = configModel.addDirectoryParameter2("device.config.xcode.workdir", "device.config.xcode.workdir", def);
        def_work_dir.setValue(def);
        def_work_dir.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setDefaultWorkingDirectory(new File(def_work_dir.getValue()));
            }
        });
        final IntParameter max_xcode = configModel.addIntParameter2("device.config.xcode.maxbps", "device.config.xcode.maxbps", (int)(this.device_manager.getTranscodeManager().getQueue().getMaxBytesPerSecond() / 1024L), 0, Integer.MAX_VALUE);
        max_xcode.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.getTranscodeManager().getQueue().setMaxBytesPerSecond(max_xcode.getValue() * 1024);
            }
        });
        final ActionParameter btnITunes = configModel.addActionParameter2("devices.button.installitunes", "UpdateWindow.columns.install");
        btnITunes.setEnabled(false);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                boolean hasItunes = core.getPluginManager().getPluginInterfaceByID("azitunes") != null;
                btnITunes.setEnabled(!hasItunes);
            }
        });
        btnITunes.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                CoreWaiterSWT.waitForCoreRunning(new AzureusCoreRunningListener(){

                    public void azureusCoreRunning(AzureusCore core) {
                        try {
                            PluginInstaller installer = core.getPluginManager().getPluginInstaller();
                            StandardPlugin itunes_plugin = installer.getStandardPlugin("azitunes");
                            itunes_plugin.install(false);
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                });
            }
        });
        configModel.createGroup("device.xcode.group", new Parameter[]{def_work_dir, max_xcode, btnITunes});
        final BooleanParameter rss_enable = configModel.addBooleanParameter2("device.rss.enable", "device.rss.enable", this.device_manager.isRSSPublishEnabled());
        rss_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setRSSPublishEnabled(rss_enable.getValue());
            }
        });
        HyperlinkParameter rss_view = configModel.addHyperlinkParameter2("device.rss.view", this.device_manager.getRSSLink());
        rss_enable.addEnabledOnSelection(rss_view);
        configModel.createGroup("device.rss.group", new Parameter[]{rss_enable, rss_view});
        final DeviceOfflineDownloaderManager dodm = this.device_manager.getOfflineDownlaoderManager();
        final BooleanParameter od_enable = configModel.addBooleanParameter2("device.od.enable", "device.od.enable", dodm.isOfflineDownloadingEnabled());
        od_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                dodm.setOfflineDownloadingEnabled(od_enable.getValue());
                DeviceManagerUI.this.rebuildSideBarIfExists();
            }
        });
        final BooleanParameter od_auto_enable = configModel.addBooleanParameter2("device.odauto.enable", "device.odauto.enable", dodm.getOfflineDownloadingIsAuto());
        od_auto_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                dodm.setOfflineDownloadingIsAuto(od_auto_enable.getValue());
            }
        });
        final BooleanParameter od_pt_enable = configModel.addBooleanParameter2("device.odpt.enable", "device.odpt.enable", dodm.getOfflineDownloadingIncludePrivate());
        od_pt_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                dodm.setOfflineDownloadingIncludePrivate(od_pt_enable.getValue());
            }
        });
        od_auto_enable.addEnabledOnSelection(od_pt_enable);
        configModel.createGroup("device.od.group", new Parameter[]{od_enable, od_auto_enable, od_pt_enable});
        final BooleanParameter tivo_enable = configModel.addBooleanParameter2("device.tivo.enable", "device.tivo.enable", false);
        tivo_enable.setValue(this.device_manager.isTiVoEnabled());
        tivo_enable.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setTiVoEnabled(tivo_enable.getValue());
                DeviceManagerUI.this.rebuildSideBarIfExists();
            }
        });
    }

    protected void setupMenuListeners() {
        this.properties_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    Device device = (Device)info.getDatasource();
                    DeviceManagerUI.this.showProperties(device);
                }
            }
        };
        this.hide_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    Device device = (Device)info.getDatasource();
                    device.setHidden(true);
                }
            }
        };
        this.rename_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    final Device device = (Device)info.getDatasource();
                    UISWTInputReceiver entry = (UISWTInputReceiver)DeviceManagerUI.this.swt_ui.getInputReceiver();
                    entry.setPreenteredText(device.getName(), false);
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    entry.setLocalisedTitle(MessageText.getString("label.rename", new String[]{device.getName()}));
                    entry.prompt(new UIInputReceiverListener(){

                        public void UIInputReceiverClosed(UIInputReceiver entry) {
                            if (!entry.hasSubmittedInput()) {
                                return;
                            }
                            String input = entry.getSubmittedInput().trim();
                            if (input.length() > 0) {
                                device.setName(input, false);
                            }
                        }
                    });
                }
            }
        };
        this.export_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    Device device = (Device)info.getDatasource();
                    DeviceManagerUI.this.export(device);
                }
            }
        };
        this.will_remove_listener = new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object targets) {
                Object[] rows = targets instanceof Object[] ? (Object[])targets : new Object[]{targets};
                if (rows.length > 0 && rows[0] instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)rows[0];
                    Device device = (Device)info.getDatasource();
                    menu.setEnabled(device.canRemove());
                } else {
                    menu.setEnabled(false);
                }
            }
        };
        this.remove_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    Device device = (Device)info.getDatasource();
                    device.remove();
                }
            }
        };
        this.will_browse_listener = new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object targets) {
                menu.removeAllChildItems();
                boolean enabled = false;
                Object[] rows = targets instanceof Object[] ? (Object[])targets : new Object[]{targets};
                if (rows.length > 0 && rows[0] instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)rows[0];
                    Device device = (Device)info.getDatasource();
                    Device.browseLocation[] locs = device.getBrowseLocations();
                    enabled = locs.length > 0;
                    MenuManager menuManager = DeviceManagerUI.this.ui_manager.getMenuManager();
                    for (final Device.browseLocation loc : locs) {
                        MenuItem loc_menu = menuManager.addMenuItem(menu, loc.getName());
                        loc_menu.addListener(new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                Utils.launch(loc.getURL().toExternalForm());
                            }
                        });
                    }
                }
                menu.setEnabled(enabled);
            }
        };
        this.show_listener = new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    Object ds = info.getDatasource();
                    if (ds instanceof Device) {
                        Device device = (Device)ds;
                        device.setHidden(true);
                    } else {
                        Device[] devices;
                        int category_type = ds == null ? 0 : (Integer)ds;
                        for (Device device : devices = DeviceManagerUI.this.device_manager.getDevices()) {
                            if (category_type != 0 && (device.getType() != category_type || !device.isHidden())) continue;
                            device.setHidden(false);
                        }
                    }
                }
            }
        };
        this.show_fill_listener = new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object targets) {
                boolean enabled = false;
                Object[] rows = targets instanceof Object[] ? (Object[])targets : new Object[]{targets};
                for (Object row : rows) {
                    Device[] devices;
                    MdiEntry info;
                    Object ds;
                    if (!(row instanceof MdiEntry) || (ds = (info = (MdiEntry)row).getDatasource()) instanceof Device) continue;
                    int category_type = ds == null ? 0 : (Integer)ds;
                    for (Device device : devices = DeviceManagerUI.this.device_manager.getDevices()) {
                        if (category_type != 0 && (device.getType() != category_type || !device.isHidden()) || !device.isHidden()) continue;
                        enabled = true;
                    }
                }
                menu.setEnabled(enabled);
            }
        };
    }

    private void export(final Device device) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                FileDialog dialog = new FileDialog(Utils.findAnyShell(), 139264);
                dialog.setFilterPath(TorrentOpener.getFilterPathData());
                dialog.setText(MessageText.getString("device.export.select.template.file"));
                dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                String path = TorrentOpener.setFilterPathData(dialog.open());
                if (path != null) {
                    String lc = path.toLowerCase();
                    if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                        path = path + ".vuze";
                    }
                    try {
                        VuzeFile vf = device.getVuzeFile();
                        vf.write(new File(path));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected void setupListeners() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{CONFIG_VIEW_TYPE, CONFIG_VIEW_HIDE_REND_GENERIC}, new org.gudy.azureus2.core3.config.ParameterListener(){

            public void parameterChanged(String parameterName) {
                DeviceManagerUI.this.side_bar_view_type = COConfigurationManager.getIntParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, 0);
                DeviceManagerUI.this.side_bar_hide_rend_gen = COConfigurationManager.getBooleanParameter(DeviceManagerUI.CONFIG_VIEW_HIDE_REND_GENERIC, true);
                DeviceManagerUI.this.rebuildSideBarIfExists();
            }
        });
    }

    protected static void hideIcon(MdiEntryVitalityImage x) {
        if (x == null) {
            return;
        }
        x.setVisible(false);
        x.setToolTip("");
    }

    protected static void showIcon(MdiEntryVitalityImage x, String t) {
        if (x == null) {
            return;
        }
        x.setToolTip(t);
        x.setVisible(true);
    }

    protected void rebuildSideBarIfExists() {
        MdiEntry entry;
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi != null && (entry = mdi.getEntry("header.devices")) != null) {
            this.rebuildSideBar();
        }
    }

    protected void rebuildSideBar() {
        if (this.sidebar_built) {
            this.removeAllDevices();
            this.buildSideBar(true);
        } else {
            this.buildSideBar(false);
        }
        this.addAllDevices();
    }

    protected MdiEntry buildSideBar(boolean rebuild) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return null;
        }
        if (this.entryHeader == null) {
            this.entryHeader = mdi.getEntry("header.devices");
            if (this.entryHeader != null) {
                this.setupHeader(mdi, this.entryHeader);
            }
        }
        this.mdiEntryOverview = mdi.getEntry("Devices");
        if (this.mdiEntryOverview == null) {
            this.mdiEntryOverview = mdi.createEntryFromSkinRef("header.devices", "Devices", "devicesview", MessageText.getString("mdi.entry.about.devices"), null, null, false, "");
            this.mdiEntryOverview.setImageLeftID("image.sidebar.aboutdevices");
        }
        if (rebuild) {
            for (categoryView category : this.categories) {
                category.destroy();
            }
        }
        this.categories.clear();
        if (this.side_bar_view_type == Integer.MAX_VALUE) {
            this.buildCategories();
        }
        this.sidebar_built = true;
        return this.mdiEntryOverview;
    }

    private void buildCategories() {
        MenuManager menu_manager = this.ui_manager.getMenuManager();
        categoryView renderers_category = this.addDeviceCategory(3, "device.renderer.view.title", "image.sidebar.device.renderer");
        this.categories.add(renderers_category);
        MenuItem re_menu_item = menu_manager.addMenuItem("sidebar." + renderers_category.getKey(), "device.show");
        re_menu_item.addListener(this.show_listener);
        re_menu_item.addFillListener(this.show_fill_listener);
        categoryView media_servers_category = this.addDeviceCategory(2, "device.mediaserver.view.title", "image.sidebar.device.mediaserver");
        this.categories.add(media_servers_category);
        MenuItem ms_menu_item = menu_manager.addMenuItem("sidebar." + media_servers_category.getKey(), "device.show");
        ms_menu_item.addListener(this.show_listener);
        ms_menu_item.addFillListener(this.show_fill_listener);
        ms_menu_item = menu_manager.addMenuItem("sidebar." + media_servers_category.getKey(), "device.mediaserver.configure");
        ms_menu_item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.openView(4, "upnpmediaserver.name");
                }
            }
        });
        categoryView routers_category = this.addDeviceCategory(1, "device.router.view.title", "image.sidebar.device.router");
        this.categories.add(routers_category);
        MenuItem rt_menu_item = menu_manager.addMenuItem("sidebar." + routers_category.getKey(), "device.show");
        rt_menu_item.addListener(this.show_listener);
        rt_menu_item.addFillListener(this.show_fill_listener);
        rt_menu_item = menu_manager.addMenuItem("sidebar." + routers_category.getKey(), "device.router.configure");
        rt_menu_item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.openView(4, "UPnP");
                }
            }
        });
        if (this.device_manager.getOfflineDownlaoderManager().isOfflineDownloadingEnabled()) {
            categoryView od_category = this.addDeviceCategory(5, "device.offlinedownloader.view.title", "image.sidebar.device.offlinedownloader");
            this.categories.add(od_category);
        }
        categoryView internet_category = this.addDeviceCategory(4, "MainWindow.about.section.internet", "image.sidebar.device.internet");
        this.categories.add(internet_category);
    }

    private void setupHeader(MultipleDocumentInterface mdi, final MdiEntry entryHeader) {
        this.addDefaultDropListener(entryHeader);
        entryHeader.setViewTitleInfo(new ViewTitleInfo(){
            private int last_indicator = 0;
            MdiEntryVitalityImage spinner = entryHeader.addVitalityImage("image.sidebar.vitality.dl");
            MdiEntryVitalityImage warning = entryHeader.addVitalityImage("image.sidebar.vitality.alert");
            MdiEntryVitalityImage info = entryHeader.addVitalityImage("image.sidebar.vitality.info");
            {
                DeviceManagerUI.hideIcon(this.spinner);
                DeviceManagerUI.hideIcon(this.warning);
                DeviceManagerUI.hideIcon(this.info);
            }

            public Object getTitleInfoProperty(int propertyID) {
                boolean expanded = entryHeader.isExpanded();
                if (propertyID == 0) {
                    this.spinner.setVisible(!expanded && DeviceManagerUI.this.device_manager.isBusy());
                    if (!expanded) {
                        Device[] devices = DeviceManagerUI.this.device_manager.getDevices();
                        this.last_indicator = 0;
                        String all_errors = "";
                        String all_infos = "";
                        for (Device device : devices) {
                            String info;
                            String error = device.getError();
                            if (error != null) {
                                all_errors = all_errors + (all_errors.length() == 0 ? "" : "; ") + error;
                            }
                            if ((info = device.getInfo()) != null) {
                                all_infos = all_infos + (all_infos.length() == 0 ? "" : "; ") + info;
                            }
                            if (device instanceof DeviceMediaRenderer || !(device instanceof DeviceOfflineDownloader)) continue;
                            DeviceOfflineDownloader dod = (DeviceOfflineDownloader)device;
                            this.last_indicator += dod.getTransferingCount();
                        }
                        if (all_errors.length() > 0) {
                            DeviceManagerUI.hideIcon(this.info);
                            DeviceManagerUI.showIcon(this.warning, all_errors);
                        } else {
                            DeviceManagerUI.hideIcon(this.warning);
                            if (all_infos.length() > 0) {
                                DeviceManagerUI.showIcon(this.info, all_infos);
                            } else {
                                DeviceManagerUI.hideIcon(this.info);
                            }
                        }
                        if (this.last_indicator > 0) {
                            return String.valueOf(this.last_indicator);
                        }
                    } else {
                        DeviceManagerUI.hideIcon(this.warning);
                        DeviceManagerUI.hideIcon(this.info);
                    }
                } else if (propertyID == 8) {
                    // empty if block
                }
                return null;
            }
        });
        this.device_manager.addListener(new DeviceManagerListener(){

            public void deviceRemoved(Device device) {
            }

            public void deviceManagerLoaded() {
                DeviceManagerUI.this.device_manager.removeListener(this);
                if (entryHeader == null || entryHeader.isDisposed()) {
                    return;
                }
                PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
                PluginInterface pi = pm.getPluginInterfaceByID("vuzexcode");
                if (DeviceManagerUI.this.device_manager.getTranscodeManager().getProviders().length == 0 || pi == null) {
                    final MdiEntryVitalityImage turnon = entryHeader.addVitalityImage("image.sidebar.turnon");
                    if (turnon != null) {
                        turnon.addListener(new MdiEntryVitalityImageListener(){

                            public void mdiEntryVitalityImage_clicked(int x, int y) {
                                DevicesFTUX.ensureInstalled(null);
                            }
                        });
                        DeviceManagerUI.this.device_manager.getTranscodeManager().addListener(new TranscodeManagerListener(){

                            public void providerAdded(TranscodeProvider provider2) {
                                turnon.setVisible(false);
                            }

                            public void providerUpdated(TranscodeProvider provider2) {
                            }

                            public void providerRemoved(TranscodeProvider provider2) {
                            }
                        });
                    }
                } else {
                    DevicesFTUX.alreadyInstalledFixup();
                }
            }

            public void deviceChanged(Device device) {
            }

            public void deviceAttentionRequest(Device device) {
            }

            public void deviceAdded(Device device) {
            }
        });
        MdiEntryVitalityImage beta = entryHeader.addVitalityImage("image.sidebar.beta");
        if (beta != null) {
            beta.setAlignment(16384);
        }
        MenuManager menu_manager = this.ui_manager.getMenuManager();
        this.createOverallMenu(menu_manager, "sidebar.header.devices");
        this.createOverallMenu(menu_manager, "sidebar.Devices");
    }

    private void createOverallMenu(MenuManager menu_manager, String parentID) {
        MenuItem de_menu_item = menu_manager.addMenuItem(parentID, "device.search");
        de_menu_item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                DeviceManagerUI.this.search();
            }
        });
        de_menu_item = menu_manager.addMenuItem(parentID, "device.showGeneric");
        de_menu_item.setStyle(2);
        de_menu_item.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(!COConfigurationManager.getBooleanParameter(DeviceManagerUI.CONFIG_VIEW_HIDE_REND_GENERIC, true));
            }
        });
        de_menu_item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(DeviceManagerUI.CONFIG_VIEW_HIDE_REND_GENERIC, !COConfigurationManager.getBooleanParameter(DeviceManagerUI.CONFIG_VIEW_HIDE_REND_GENERIC, true));
            }
        });
        de_menu_item = menu_manager.addMenuItem(parentID, "device.show");
        de_menu_item.addListener(this.show_listener);
        de_menu_item.addFillListener(this.show_fill_listener);
        de_menu_item = menu_manager.addMenuItem(parentID, "devices.sidebar.simple");
        de_menu_item.setStyle(2);
        de_menu_item.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(COConfigurationManager.getIntParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, 0) == 0);
            }
        });
        de_menu_item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, (Boolean)menu.getData() != false ? 0 : Integer.MAX_VALUE);
            }
        });
        de_menu_item = menu_manager.addMenuItem(parentID, "sep");
        de_menu_item.setStyle(4);
        de_menu_item = menu_manager.addMenuItem(parentID, "MainWindow.menu.view.configuration");
        de_menu_item.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.openView(4, "Devices");
                }
            }
        });
        if (Constants.isCVSVersion()) {
            de_menu_item = menu_manager.addMenuItem(parentID, "!(CVS Only)Show FTUX!");
            de_menu_item.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    DevicesFTUX.showForDebug();
                }
            });
        }
    }

    protected void addNewDevice() {
        ManufacturerChooser mfChooser = new ManufacturerChooser();
        mfChooser.open(new ManufacturerChooser.ClosedListener(){

            public void MfChooserClosed(DeviceManager.DeviceManufacturer mf) {
                if (mf == null) {
                    return;
                }
                DeviceTemplateChooser deviceTemplateChooser = new DeviceTemplateChooser(mf);
                deviceTemplateChooser.open(new DeviceTemplateChooser.DeviceTemplateClosedListener(){

                    public void deviceTemplateChooserClosed(DeviceTemplate deviceTemplate) {
                        if (deviceTemplate == null) {
                            return;
                        }
                        try {
                            Device device = deviceTemplate.createInstance(deviceTemplate.getName() + " test!");
                            device.requestAttention();
                        }
                        catch (DeviceManagerException e) {
                            Debug.out(e);
                        }
                    }
                });
            }
        });
    }

    private void setupTranscodeMenus() {
        String[] tables = new String[]{"MyTorrents", "MyTorrents.big", "MySeeders", "MySeeders.big", "Files", "Unopened", "Unopened.big", "MyLibrary.big"};
        TableManager table_manager = this.plugin_interface.getUIManager().getTableManager();
        MenuItemFillListener menu_fill_listener = new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object _target) {
                final TableRow[] target = _target instanceof TableRow ? new TableRow[]{(TableRow)_target} : (TableRow[])_target;
                boolean enabled = target.length > 0;
                for (TableRow row : target) {
                    Object obj = row.getDataSource();
                    if (obj instanceof Download) {
                        Download download = (Download)obj;
                        if (download.getState() != 8) continue;
                        enabled = false;
                        continue;
                    }
                    DiskManagerFileInfo file = (DiskManagerFileInfo)obj;
                    try {
                        if (file.getDownload().getState() != 8) continue;
                        enabled = false;
                    }
                    catch (Throwable e) {
                        enabled = false;
                    }
                }
                menu.setEnabled(enabled);
                menu.removeAllChildItems();
                if (enabled) {
                    Device[] devices = DeviceManagerUI.this.device_manager.getDevices();
                    int devices_added = 0;
                    for (Device device : devices) {
                        if (device.isHidden() || !(device instanceof TranscodeTarget)) continue;
                        ++devices_added;
                        final TranscodeTarget renderer = (TranscodeTarget)((Object)device);
                        TranscodeProfile[] profiles = renderer.getTranscodeProfiles();
                        TableContextMenuItem device_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem((TableContextMenuItem)menu, "!" + device.getName() + (profiles.length == 0 ? " (No Profiles)" : "") + "!");
                        device_item.setStyle(5);
                        if (profiles.length == 0) {
                            device_item.setEnabled(false);
                            continue;
                        }
                        Arrays.sort(profiles, new Comparator<TranscodeProfile>(){

                            @Override
                            public int compare(TranscodeProfile o1, TranscodeProfile o2) {
                                int i2;
                                int i1 = o1.getIconIndex();
                                if (i1 == (i2 = o2.getIconIndex())) {
                                    return o1.getName().compareToIgnoreCase(o2.getName());
                                }
                                return i1 - i2;
                            }
                        });
                        for (final TranscodeProfile profile : profiles) {
                            TableContextMenuItem profile_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem(device_item, "!" + profile.getName() + "!");
                            profile_item.addMultiListener(new MenuItemListener(){

                                public void selected(MenuItem menu, Object x) {
                                    for (TableRow row : target) {
                                        Object obj = row.getDataSource();
                                        try {
                                            if (obj instanceof Download) {
                                                Download download = (Download)obj;
                                                DeviceManagerUI.addDownload(renderer, profile, -1, download);
                                                continue;
                                            }
                                            DiskManagerFileInfo file = (DiskManagerFileInfo)obj;
                                            DeviceManagerUI.addFile(renderer, profile, -1, file);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                            });
                        }
                    }
                    if (devices_added == 0) {
                        TableContextMenuItem device_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem((TableContextMenuItem)menu, "!(No Devices)!");
                        device_item.setEnabled(false);
                    }
                }
            }
        };
        for (String table : tables) {
            TableContextMenuItem menu = table_manager.addContextMenuItem(table, "devices.contextmenu.xcode");
            menu.setStyle(5);
            menu.addFillListener(menu_fill_listener);
        }
    }

    private void setupOfflineDownloadingMenus() {
        String[] tables = new String[]{"MyTorrents", "MyTorrents.big", "MyLibrary.big"};
        TableManager table_manager = this.plugin_interface.getUIManager().getTableManager();
        final DeviceOfflineDownloaderManager dodm = this.device_manager.getOfflineDownlaoderManager();
        MenuItemFillListener menu_fill_listener = new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object _target) {
                menu.removeAllChildItems();
                if (dodm.getOfflineDownloadingIsAuto()) {
                    menu.setEnabled(true);
                    TableContextMenuItem auto_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem((TableContextMenuItem)menu, "devices.contextmenu.od.auto");
                    auto_item.setEnabled(false);
                    return;
                }
                TableRow[] target = _target instanceof TableRow ? new TableRow[]{(TableRow)_target} : (TableRow[])_target;
                boolean all_non_manual = true;
                boolean all_manual = true;
                final ArrayList<Download> downloads = new ArrayList<Download>();
                for (TableRow row : target) {
                    Object obj = row.getDataSource();
                    if (!(obj instanceof Download)) continue;
                    Download download = (Download)obj;
                    downloads.add(download);
                    if (dodm.isManualDownload(download)) {
                        all_non_manual = false;
                        continue;
                    }
                    all_manual = false;
                }
                boolean enabled = downloads.size() > 0;
                menu.setEnabled(enabled);
                if (enabled) {
                    TableContextMenuItem manual_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem((TableContextMenuItem)menu, "devices.contextmenu.od.enable" + (all_manual ? "d" : ""));
                    final boolean f_all_manual = all_manual;
                    manual_item.setData(new Boolean(f_all_manual));
                    manual_item.setStyle(2);
                    manual_item.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            Download[] d = downloads.toArray(new Download[downloads.size()]);
                            if (f_all_manual) {
                                dodm.removeManualDownloads(d);
                            } else {
                                dodm.addManualDownloads(d);
                            }
                        }
                    });
                }
            }
        };
        for (String table : tables) {
            TableContextMenuItem menu = table_manager.addContextMenuItem(table, "devices.contextmenu.od");
            menu.setStyle(5);
            menu.addFillListener(menu_fill_listener);
        }
    }

    protected void search() {
        this.device_manager.search(10000, new DeviceSearchListener(){

            public void deviceFound(Device device) {
            }

            public void complete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOrChangeDevice(Device device) {
        DeviceMediaRenderer rend;
        int type = device.getType();
        if (!this.device_manager.getOfflineDownlaoderManager().isOfflineDownloadingEnabled() && type == 5) {
            return;
        }
        String parent_key = null;
        if (this.side_bar_view_type == Integer.MAX_VALUE) {
            for (categoryView view : this.categories) {
                if (view.getDeviceType() != type) continue;
                parent_key = view.getKey();
                break;
            }
        } else {
            if (type != 3 && type != 5) {
                return;
            }
            parent_key = "header.devices";
        }
        if (parent_key == null) {
            Debug.out("Unknown device type: " + device.getString());
            return;
        }
        boolean hide_device = device.isHidden();
        if (type == 3 && this.side_bar_hide_rend_gen && (rend = (DeviceMediaRenderer)device).isNonSimple()) {
            hide_device = true;
        }
        if (hide_device) {
            this.removeDevice(device);
            return;
        }
        String parent = parent_key;
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            deviceItem existing_di = (deviceItem)device.getTransientProperty(DEVICE_IVIEW_KEY);
            if (existing_di == null) {
                if (type == 5) {
                    DeviceOfflineDownloader dod;
                    if (!this.offline_menus_setup) {
                        this.offline_menus_setup = true;
                        this.setupOfflineDownloadingMenus();
                    }
                    if (!(dod = (DeviceOfflineDownloader)device).hasShownFTUX()) {
                        try {
                            new DevicesODFTUX(dod);
                        }
                        catch (Throwable e) {
                            Debug.out("Failed to show offline downloader FTUX", e);
                        }
                    }
                }
                if (!device.isHidden()) {
                    deviceItem new_di = new deviceItem();
                    device.setTransientProperty(DEVICE_IVIEW_KEY, new_di);
                    this.setupEntry(new_di, device, parent);
                }
            } else {
                ViewTitleInfoManager.refreshTitleInfo(existing_di.getView());
                this.setStatus(device, existing_di);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupEntry(deviceItem new_di, final Device device, String parent) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            DeviceMediaRenderer renderer;
            MdiEntry entry;
            if (new_di.isDestroyed()) {
                return;
            }
            deviceView view = new deviceView(parent, device);
            new_di.setView(view);
            String key = parent + "/" + device.getID() + ":" + this.nextSidebarID();
            int device_type = device.getType();
            if (device_type == 3) {
                entry = this.mdi.createEntryFromSkinRef(parent, key, "devicerendererview", device.getName(), (ViewTitleInfo)view, null, false, null);
                String id = DeviceManagerUI.getDeviceImageID(device);
                if (id != null) {
                    id = "image.sidebar.device." + id + ".small";
                    entry.setImageLeftID(id);
                }
            } else if (device_type == 5) {
                entry = this.mdi.createEntryFromSkinRef(parent, key, "devicesodview", device.getName(), (ViewTitleInfo)view, null, false, null);
                entry.setExpanded(true);
                DeviceOfflineDownloader dod = (DeviceOfflineDownloader)device;
                String manufacturer = dod.getManufacturer();
                String id = manufacturer.toLowerCase().contains("vuze") ? "vuze" : (manufacturer.toLowerCase().contains("belkin") ? "bel" : "other");
                entry.setImageLeftID("image.sidebar.device.od." + id + ".small");
            } else {
                entry = this.mdi.createEntryFromIView(parent, view, key, device, false, false, true);
                entry.setExpanded(true);
            }
            entry.setDatasource(device);
            entry.setLogID(parent + "-" + device.getName());
            new_di.setMdiEntry(entry);
            this.setStatus(device, new_di);
            if (device instanceof TranscodeTarget) {
                entry.addListener(new MdiEntryDropListener(){

                    public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                        return DeviceManagerUI.handleDrop((TranscodeTarget)((Object)device), payload);
                    }
                });
            }
            final MenuManager menu_manager = this.ui_manager.getMenuManager();
            boolean need_sep = false;
            if (device instanceof TranscodeTarget) {
                need_sep = true;
                MenuItem explore_menu_item = menu_manager.addMenuItem("sidebar." + key, "v3.menu.device.exploreTranscodes");
                explore_menu_item.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        ManagerUtils.open(((TranscodeTarget)((Object)device)).getWorkingDirectory());
                    }
                });
            }
            if (device instanceof DeviceMediaRenderer) {
                need_sep = true;
                renderer = (DeviceMediaRenderer)device;
                if (renderer.canFilterFilesView()) {
                    MenuItem filterfiles_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.only.show");
                    filterfiles_menu_item.setStyle(2);
                    filterfiles_menu_item.addFillListener(new MenuItemFillListener(){

                        public void menuWillBeShown(MenuItem menu, Object data) {
                            menu.setData(new Boolean(renderer.getFilterFilesView()));
                        }
                    });
                    filterfiles_menu_item.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            renderer.setFilterFilesView((Boolean)menu.getData());
                        }
                    });
                }
                if (renderer.canShowCategories()) {
                    MenuItem showcat_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.show.cat");
                    showcat_menu_item.setStyle(2);
                    showcat_menu_item.addFillListener(new MenuItemFillListener(){

                        public void menuWillBeShown(MenuItem menu, Object data) {
                            menu.setData(new Boolean(renderer.getShowCategories()));
                        }
                    });
                    showcat_menu_item.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            renderer.setShowCategories((Boolean)menu.getData());
                        }
                    });
                }
                MenuItem alwayscache_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.always.cache");
                alwayscache_menu_item.setStyle(2);
                alwayscache_menu_item.addFillListener(new MenuItemFillListener(){

                    public void menuWillBeShown(MenuItem menu, Object data) {
                        menu.setData(new Boolean(renderer.getAlwaysCacheFiles()));
                    }
                });
                alwayscache_menu_item.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        renderer.setAlwaysCacheFiles((Boolean)menu.getData());
                    }
                });
            }
            if (need_sep) {
                menu_manager.addMenuItem("sidebar." + key, "1").setStyle(4);
            }
            need_sep = false;
            if (device instanceof DeviceMediaRenderer) {
                TranscodeProfile[] transcodeProfiles;
                renderer = (DeviceMediaRenderer)device;
                if (renderer.canCopyToFolder()) {
                    need_sep = true;
                    MenuItem autocopy_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.autoCopy");
                    autocopy_menu_item.setStyle(2);
                    autocopy_menu_item.addFillListener(new MenuItemFillListener(){

                        public void menuWillBeShown(MenuItem menu, Object data) {
                            menu.setData(new Boolean(renderer.getAutoCopyToFolder()));
                        }
                    });
                    autocopy_menu_item.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            renderer.setAutoCopyToFolder((Boolean)menu.getData());
                        }
                    });
                    final MenuItem mancopy_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.mancopy");
                    mancopy_menu_item.setStyle(1);
                    mancopy_menu_item.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            try {
                                renderer.manualCopy();
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                    mancopy_menu_item.addFillListener(new MenuItemFillListener(){

                        public void menuWillBeShown(MenuItem menu, Object data) {
                            File target;
                            boolean enabled = false;
                            if (!renderer.getAutoCopyToFolder() && (target = renderer.getCopyToFolder()) != null && target.exists()) {
                                enabled = renderer.getCopyToFolderPending() > 0;
                            }
                            mancopy_menu_item.setEnabled(enabled);
                        }
                    });
                    MenuItem setcopyto_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.setcopyto");
                    setcopyto_menu_item.setStyle(1);
                    setcopyto_menu_item.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            Shell shell = Utils.findAnyShell();
                            DirectoryDialog dd = new DirectoryDialog(shell);
                            File existing = renderer.getCopyToFolder();
                            if (existing != null) {
                                dd.setFilterPath(existing.getAbsolutePath());
                            }
                            dd.setText(MessageText.getString("devices.xcode.setcopyto.title"));
                            String path = dd.open();
                            if (path != null) {
                                renderer.setCopyToFolder(new File(path));
                            }
                        }
                    });
                }
                if (renderer.canAutoStartDevice()) {
                    need_sep = true;
                    MenuItem autostart_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.autoStart");
                    autostart_menu_item.setStyle(2);
                    autostart_menu_item.addFillListener(new MenuItemFillListener(){

                        public void menuWillBeShown(MenuItem menu, Object data) {
                            menu.setData(new Boolean(renderer.getAutoStartDevice()));
                        }
                    });
                    autostart_menu_item.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            renderer.setAutoStartDevice((Boolean)menu.getData());
                        }
                    });
                }
                if (renderer.canAssociate()) {
                    need_sep = true;
                    final MenuItem menu_associate = menu_manager.addMenuItem("sidebar." + key, "devices.associate");
                    menu_associate.setStyle(5);
                    menu_associate.addFillListener(new MenuItemFillListener(){

                        public void menuWillBeShown(MenuItem menu, Object data) {
                            menu_associate.removeAllChildItems();
                            if (renderer.isAlive()) {
                                InetAddress a = renderer.getAddress();
                                String address = a == null ? "" : a.getHostAddress();
                                MenuItem menu_none = menu_manager.addMenuItem(menu_associate, "!" + MessageText.getString("devices.associate.already") + ": " + address + "!");
                                menu_none.setEnabled(false);
                                menu_associate.setEnabled(true);
                            } else {
                                DeviceManager.UnassociatedDevice[] unassoc = DeviceManagerUI.this.device_manager.getUnassociatedDevices();
                                if (unassoc.length == 0) {
                                    menu_associate.setEnabled(false);
                                } else {
                                    menu_associate.setEnabled(true);
                                    for (final DeviceManager.UnassociatedDevice un : unassoc) {
                                        MenuItem menu_un = menu_manager.addMenuItem(menu_associate, "!" + un.getAddress().getHostAddress() + ": " + un.getDescription() + "!");
                                        menu_un.addListener(new MenuItemListener(){

                                            public void selected(MenuItem menu, Object target) {
                                                renderer.associate(un);
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    });
                }
                if (renderer.canRestrictAccess()) {
                    need_sep = true;
                    MenuItem menu_ra = menu_manager.addMenuItem("sidebar." + key, "devices.restrict_access");
                    menu_ra.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            if (target instanceof MdiEntry) {
                                UISWTInputReceiver entry = (UISWTInputReceiver)DeviceManagerUI.this.swt_ui.getInputReceiver();
                                entry.setMessage("devices.restrict_access.msg");
                                entry.setPreenteredText(renderer.getAccessRestriction(), false);
                                entry.maintainWhitespace(false);
                                entry.allowEmptyInput(true);
                                entry.setLocalisedTitle(MessageText.getString("devices.restrict_access.prompt", new String[]{device.getName()}));
                                entry.prompt(new UIInputReceiverListener(){

                                    public void UIInputReceiverClosed(UIInputReceiver entry) {
                                        if (!entry.hasSubmittedInput()) {
                                            return;
                                        }
                                        String input = entry.getSubmittedInput().trim();
                                        renderer.setAccessRestriction(input);
                                    }
                                });
                            }
                        }
                    });
                }
                if ((transcodeProfiles = renderer.getTranscodeProfiles()).length > 0) {
                    Arrays.sort(transcodeProfiles, new Comparator<TranscodeProfile>(){

                        @Override
                        public int compare(TranscodeProfile o1, TranscodeProfile o2) {
                            int i2;
                            int i1 = o1.getIconIndex();
                            if (i1 == (i2 = o2.getIconIndex())) {
                                return o1.getName().compareToIgnoreCase(o2.getName());
                            }
                            return i1 - i2;
                        }
                    });
                    need_sep = true;
                    MenuItem menu_default_profile = menu_manager.addMenuItem("sidebar." + key, "v3.menu.device.defaultprofile");
                    menu_default_profile.setStyle(5);
                    MenuItem menu_profile_never = menu_manager.addMenuItem(menu_default_profile, "v3.menu.device.defaultprofile.never");
                    menu_profile_never.setStyle(2);
                    menu_profile_never.setData(Boolean.TRUE);
                    menu_profile_never.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            renderer.setTranscodeRequirement((Boolean)menu.getData() != false ? 1 : 2);
                        }
                    });
                    menu_profile_never.addFillListener(new MenuItemFillListener(){

                        public void menuWillBeShown(MenuItem menu, Object data) {
                            boolean never = renderer.getTranscodeRequirement() == 1;
                            menu.setData(never);
                        }
                    });
                    MenuItem menu_profile_none = menu_manager.addMenuItem(menu_default_profile, "option.askeverytime");
                    menu_profile_none.setStyle(3);
                    menu_profile_none.setData(Boolean.FALSE);
                    menu_profile_none.addListener(new MenuItemListener(){

                        public void selected(MenuItem menu, Object target) {
                            renderer.setDefaultTranscodeProfile(null);
                        }
                    });
                    menu_profile_none.addFillListener(new MenuItemFillListener(){

                        public void menuWillBeShown(MenuItem menu, Object data) {
                            if (transcodeProfiles.length <= 1) {
                                menu.setData(Boolean.FALSE);
                                menu.setEnabled(false);
                            } else {
                                TranscodeProfile profile = null;
                                try {
                                    profile = renderer.getDefaultTranscodeProfile();
                                }
                                catch (TranscodeException e) {
                                    // empty catch block
                                }
                                menu.setData(profile == null ? Boolean.TRUE : Boolean.FALSE);
                                menu.setEnabled(renderer.getTranscodeRequirement() != 1);
                            }
                        }
                    });
                    for (final TranscodeProfile profile : transcodeProfiles) {
                        MenuItem menuItem = menu_manager.addMenuItem(menu_default_profile, "!" + profile.getName() + "!");
                        menuItem.setStyle(3);
                        menuItem.setData(Boolean.FALSE);
                        menuItem.addListener(new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                renderer.setDefaultTranscodeProfile(profile);
                            }
                        });
                        menuItem.addFillListener(new MenuItemFillListener(){

                            public void menuWillBeShown(MenuItem menu, Object data) {
                                if (transcodeProfiles.length <= 1) {
                                    menu.setData(Boolean.TRUE);
                                    menu.setEnabled(false);
                                } else {
                                    TranscodeProfile dprofile = null;
                                    try {
                                        dprofile = renderer.getDefaultTranscodeProfile();
                                    }
                                    catch (TranscodeException e) {
                                        // empty catch block
                                    }
                                    menu.setData(profile.equals(dprofile) ? Boolean.TRUE : Boolean.FALSE);
                                    menu.setEnabled(renderer.getTranscodeRequirement() != 1);
                                }
                            }
                        });
                    }
                }
                need_sep = true;
                final MenuItem rss_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.xcode.rsspub");
                rss_menu_item.setStyle(2);
                rss_menu_item.addFillListener(new MenuItemFillListener(){

                    public void menuWillBeShown(MenuItem menu, Object data) {
                        rss_menu_item.setEnabled(DeviceManagerUI.this.device_manager.isRSSPublishEnabled());
                        menu.setData(new Boolean(DeviceManagerUI.this.device_manager.isRSSPublishEnabled() && renderer.isRSSPublishEnabled()));
                    }
                });
                rss_menu_item.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        renderer.setRSSPublishEnabled((Boolean)menu.getData());
                    }
                });
                rss_menu_item.setEnabled(this.device_manager.isRSSPublishEnabled());
            }
            if (device instanceof DeviceOfflineDownloader) {
                final DeviceOfflineDownloader dod = (DeviceOfflineDownloader)device;
                need_sep = true;
                MenuItem configure_menu_item = menu_manager.addMenuItem("sidebar." + key, "device.configure");
                configure_menu_item.addFillListener(new MenuItemFillListener(){

                    public void menuWillBeShown(MenuItem menu, Object data) {
                        menu.setEnabled(dod.isAlive());
                    }
                });
                configure_menu_item.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        try {
                            new DevicesODFTUX(dod);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                MenuItem enabled_menu_item = menu_manager.addMenuItem("sidebar." + key, "devices.contextmenu.od.enable");
                enabled_menu_item.setStyle(2);
                enabled_menu_item.addFillListener(new MenuItemFillListener(){

                    public void menuWillBeShown(MenuItem menu, Object data) {
                        menu.setData(new Boolean(dod.isEnabled()));
                    }
                });
                enabled_menu_item.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        dod.setEnabled((Boolean)menu.getData());
                    }
                });
            }
            if (device.isBrowsable()) {
                need_sep = true;
                MenuItem browse_menu_item = menu_manager.addMenuItem("sidebar." + key, "device.browse");
                browse_menu_item.setStyle(5);
                browse_menu_item.addFillListener(this.will_browse_listener);
            }
            if (need_sep) {
                menu_manager.addMenuItem("sidebar." + key, "s2").setStyle(4);
            }
            MenuItem rename_menu_item = menu_manager.addMenuItem("sidebar." + key, "MyTorrentsView.menu.rename");
            rename_menu_item.addListener(this.rename_listener);
            if (device.isExportable()) {
                MenuItem export_item = menu_manager.addMenuItem("sidebar." + key, "Subscription.menu.export");
                export_item.addListener(this.export_listener);
            }
            MenuItem hide_menu_item = menu_manager.addMenuItem("sidebar." + key, "device.hide");
            hide_menu_item.addListener(this.hide_listener);
            MenuItem remove_menu_item = menu_manager.addMenuItem("sidebar." + key, "MySharesView.menu.remove");
            remove_menu_item.addFillListener(this.will_remove_listener);
            remove_menu_item.addListener(this.remove_listener);
            menu_manager.addMenuItem("sidebar." + key, "s3").setStyle(4);
            MenuItem menu_item = menu_manager.addMenuItem("sidebar." + key, "Subscription.menu.properties");
            menu_item.addListener(this.properties_listener);
        }
    }

    protected static String getDeviceImageID(Device device) {
        String classification;
        String imageID = device.getImageID();
        if (imageID != null) {
            return imageID;
        }
        int species = ((DeviceMediaRenderer)device).getRendererSpecies();
        String id = species != 6 ? String.valueOf(species) : ((classification = device.getClassification()).equals("sony.PSP") ? "psp" : (classification.startsWith("tivo.") ? "tivo" : (classification.startsWith("samsung.") ? "samsung" : (classification.startsWith("western.digital.") ? "wdtv" : (classification.startsWith("boxee.") ? "boxee" : (classification.startsWith("sony.bravia") ? "bravia" : (classification.startsWith("ms_wmp.") ? "mswmp" : (classification.toLowerCase().contains("android") ? "android" : (device.isGenericUSB() ? "usb" : String.valueOf(species))))))))));
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDevice(Device device) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            MultipleDocumentInterface mdi;
            deviceItem existing_di = (deviceItem)device.getTransientProperty(DEVICE_IVIEW_KEY);
            if (existing_di != null && (mdi = UIFunctionsManager.getUIFunctions().getMDI()) != null) {
                mdi.showEntry(existing_di.getMdiEntry());
            }
        }
    }

    public static boolean handleDrop(TranscodeTarget target, Object payload) {
        return DeviceManagerUI.handleDropSupport(target, payload, true);
    }

    private static boolean handleDropSupport(final TranscodeTarget target, final Object payload, final boolean allow_retry) {
        if (!(payload instanceof String[]) && !(payload instanceof String)) {
            return false;
        }
        TranscodeChooser deviceChooser = new TranscodeChooser(target){

            public void closed() {
                if (this.selectedTranscodeTarget != null && this.selectedProfile != null) {
                    DeviceManagerUI.handleDrop(this.selectedTranscodeTarget, this.selectedProfile, payload, this.getTranscodeRequirement());
                }
            }
        };
        deviceChooser.show(new Runnable(){

            public void run() {
                if (allow_retry) {
                    DeviceManagerUI.handleDropSupport(target, payload, false);
                }
            }
        });
        return true;
    }

    protected static void addDownload(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, byte[] hash) {
        try {
            DeviceManagerUI.addDownload(target, profile, transcode_requirement, AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(hash));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected static void addDownload(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, Download download) {
        DiskManagerFileInfo[] dm_files = download.getDiskManagerFileInfo();
        int num_added = 0;
        for (DiskManagerFileInfo dm_file : dm_files) {
            if (num_added > 64) break;
            if (dm_files.length != 1 && dm_file.getLength() < 131072L) continue;
            DeviceManagerUI.addFile(target, profile, transcode_requirement, dm_file);
            ++num_added;
        }
    }

    protected static void addFile(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, DiskManagerFileInfo file) {
        try {
            DeviceManagerFactory.getSingleton().getTranscodeManager().getQueue().add(target, profile, file, transcode_requirement, false);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected static void addDirectory(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, File file) {
        if (!file.isDirectory()) {
            return;
        }
        File[] files = file.listFiles();
        int num_added = 0;
        for (File f : files) {
            if (num_added > 64) break;
            if (f.isDirectory() || f.length() <= 131072L) continue;
            DeviceManagerUI.addFile(target, profile, transcode_requirement, f);
            ++num_added;
        }
    }

    protected static void addFile(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, File file) {
        if (file.exists() && file.isFile()) {
            try {
                DeviceManagerFactory.getSingleton().getTranscodeManager().getQueue().add(target, profile, new DiskManagerFileInfoFile(file), transcode_requirement, false);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        } else {
            Debug.out("Drop to " + target.getDevice().getName() + " for " + file + " failed, file doesn't exist");
        }
    }

    protected static void handleDrop(TranscodeTarget target, TranscodeProfile profile, Object payload, int transcode_requirement) {
        block9: {
            String stuff;
            block10: {
                block8: {
                    String[] files;
                    if (!(payload instanceof String[])) break block8;
                    for (String file : files = (String[])payload) {
                        File f = new File(file);
                        if (f.isFile()) {
                            DeviceManagerUI.addFile(target, profile, transcode_requirement, f);
                            continue;
                        }
                        DeviceManagerUI.addDirectory(target, profile, transcode_requirement, f);
                    }
                    break block9;
                }
                if (!(payload instanceof String)) break block9;
                stuff = (String)payload;
                if (!stuff.startsWith("DownloadManager\n") && !stuff.startsWith("DiskManagerFileInfo\n")) break block10;
                String[] bits = Constants.PAT_SPLIT_SLASH_N.split(stuff);
                for (int i = 1; i < bits.length; ++i) {
                    String hash_str = bits[i];
                    int pos = hash_str.indexOf(59);
                    try {
                        if (pos == -1) {
                            byte[] hash = Base32.decode(bits[i]);
                            DeviceManagerUI.addDownload(target, profile, transcode_requirement, hash);
                            continue;
                        }
                        String[] files = hash_str.split(";");
                        byte[] hash = Base32.decode(files[0].trim());
                        DiskManagerFileInfo[] dm_files = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(hash).getDiskManagerFileInfo();
                        for (int j = 1; j < files.length; ++j) {
                            DiskManagerFileInfo dm_file = dm_files[Integer.parseInt(files[j].trim())];
                            DeviceManagerUI.addFile(target, profile, transcode_requirement, dm_file);
                        }
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to get download for hash " + bits[1]);
                    }
                }
                break block9;
            }
            if (!stuff.startsWith("TranscodeFile\n")) break block9;
            String[] bits = Constants.PAT_SPLIT_SLASH_N.split(stuff);
            for (int i = 1; i < bits.length; ++i) {
                File f = new File(bits[i]);
                if (!f.isFile()) continue;
                DeviceManagerUI.addFile(target, profile, transcode_requirement, f);
            }
        }
    }

    protected void setStatus(Device device, deviceItem sbi) {
        sbi.setStatus(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAllDevices() {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            if (this.device_manager_listener == null) {
                this.needsAddAllDevices = true;
                return;
            }
            if (!this.device_manager_listener_added) {
                this.device_manager_listener_added = true;
                this.device_manager.addListener(this.device_manager_listener);
            }
        }
        Device[] devices = this.device_manager.getDevices();
        Arrays.sort(devices, new Comparator<Device>(){

            @Override
            public int compare(Device o1, Device o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        for (Device device : devices) {
            this.addOrChangeDevice(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllDevices() {
        Device[] devices;
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            if (this.device_manager_listener_added) {
                this.device_manager_listener_added = false;
                this.device_manager.removeListener(this.device_manager_listener);
            }
        }
        for (Device device : devices = this.device_manager.getDevices()) {
            this.removeDevice(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDevice(Device device) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            deviceItem existing_di = (deviceItem)device.getTransientProperty(DEVICE_IVIEW_KEY);
            if (existing_di != null) {
                device.setTransientProperty(DEVICE_IVIEW_KEY, null);
                existing_di.destroy();
            }
        }
    }

    protected categoryView addDeviceCategory(int device_type, String category_title, String category_image_id) {
        String key = "Device_" + category_title + ":" + this.nextSidebarID();
        categoryView view = device_type == 4 ? new DeviceInternetView(this, category_title) : new categoryViewGeneric(this, device_type, category_title);
        MdiEntry entry = this.mdi.createEntryFromIView("header.devices", view, key, new Integer(device_type), false, false, true);
        this.addDefaultDropListener(entry);
        entry.setImageLeftID(category_image_id);
        view.setDetails(entry, key);
        return view;
    }

    protected void addDefaultDropListener(MdiEntry mainSbEntry) {
        mainSbEntry.addListener(new MdiEntryDropListener(){

            public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                return DeviceManagerUI.handleDrop(null, payload);
            }
        });
    }

    protected void showProperties(Device device) {
        String[][] props = device.getDisplayProperties();
        new PropertiesWindow(device.getName(), props[0], props[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int nextSidebarID() {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            return this.next_sidebar_id++;
        }
    }

    static {
        DEVICE_IVIEW_KEY = new Object();
        try {
            String arch;
            DISABLED = Constants.isOSX ? (arch = System.getProperty("os.arch", "")).equalsIgnoreCase("powerpc") || arch.equalsIgnoreCase("ppc") : Constants.isUnix;
            DISABLED |= Utils.isAZ2UI();
        }
        catch (Throwable t) {
            DISABLED = false;
        }
    }

    protected static abstract class categoryView
    extends AbstractIView
    implements ViewTitleInfo {
        private DeviceManagerUI ui;
        private int device_type;
        private String title;
        private String key;
        private MdiEntryVitalityImage spinner;
        private MdiEntryVitalityImage warning;
        private MdiEntryVitalityImage info;
        private int last_indicator;
        private MdiEntry mdiEntry;

        protected categoryView(DeviceManagerUI _ui, int _device_type, String _title) {
            this.ui = _ui;
            this.device_type = _device_type;
            this.title = _title;
        }

        protected void setDetails(MdiEntry entry, String _key) {
            this.mdiEntry = entry;
            this.key = _key;
            this.spinner = entry.addVitalityImage(DeviceManagerUI.SPINNER_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.spinner);
            this.warning = entry.addVitalityImage(DeviceManagerUI.ALERT_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.warning);
            this.info = entry.addVitalityImage(DeviceManagerUI.INFO_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.info);
        }

        protected int getDeviceType() {
            return this.device_type;
        }

        protected String getKey() {
            return this.key;
        }

        protected String getTitle() {
            return MessageText.getString(this.title);
        }

        public Object getTitleInfoProperty(int propertyID) {
            boolean expanded;
            boolean bl = expanded = this.mdiEntry != null && this.mdiEntry.isExpanded();
            if (propertyID == 5) {
                return this.getTitle();
            }
            if (propertyID == 0) {
                if (this.device_type == 3 || this.device_type == 5) {
                    if (this.spinner != null) {
                        this.spinner.setVisible(!expanded && this.ui.getDeviceManager().isBusy());
                    }
                    if (!expanded) {
                        Device[] devices = this.ui.getDeviceManager().getDevices();
                        this.last_indicator = 0;
                        String all_errors = "";
                        String all_infos = "";
                        for (Device device : devices) {
                            String info;
                            String error = device.getError();
                            if (error != null) {
                                all_errors = all_errors + (all_errors.length() == 0 ? "" : "; ") + error;
                            }
                            if ((info = device.getInfo()) != null) {
                                all_infos = all_infos + (all_infos.length() == 0 ? "" : "; ") + info;
                            }
                            if (device instanceof DeviceMediaRenderer || !(device instanceof DeviceOfflineDownloader)) continue;
                            DeviceOfflineDownloader dod = (DeviceOfflineDownloader)device;
                            this.last_indicator += dod.getTransferingCount();
                        }
                        if (all_errors.length() > 0) {
                            DeviceManagerUI.showIcon(this.warning, all_errors);
                        } else {
                            DeviceManagerUI.hideIcon(this.warning);
                            if (all_infos.length() > 0) {
                                DeviceManagerUI.showIcon(this.info, all_infos);
                            } else {
                                DeviceManagerUI.hideIcon(this.info);
                            }
                        }
                        if (this.last_indicator > 0) {
                            return String.valueOf(this.last_indicator);
                        }
                    } else {
                        DeviceManagerUI.hideIcon(this.warning);
                        DeviceManagerUI.hideIcon(this.info);
                    }
                }
            } else if (propertyID == 8) {
                // empty if block
            }
            return null;
        }

        protected void destroy() {
            if (Utils.isThisThreadSWT()) {
                this.mdiEntry.close(false);
                this.delete();
            } else {
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        categoryView.this.mdiEntry.close(false);
                        categoryView.this.delete();
                    }
                });
            }
        }
    }

    protected static class categoryViewGeneric
    extends categoryView {
        private Composite composite;

        protected categoryViewGeneric(DeviceManagerUI _ui, int _device_type, String _title) {
            super(_ui, _device_type, _title);
        }

        public void initialize(Composite parent_composite) {
            this.composite = new Composite(parent_composite, 0);
            FormLayout layout = new FormLayout();
            layout.marginTop = 4;
            layout.marginLeft = 4;
            layout.marginRight = 4;
            layout.marginBottom = 4;
            this.composite.setLayout(layout);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(this.composite, 0);
            data.bottom = new FormAttachment(100, 0);
            Label label = new Label(this.composite, 0);
            label.setText("Nothing to show for " + this.getTitle());
            label.setLayoutData(data);
        }

        public Composite getComposite() {
            return this.composite;
        }

        public void delete() {
            super.delete();
        }
    }

    public class deviceItem {
        private deviceView view;
        private MdiEntry sb_entry;
        private boolean destroyed;
        private MdiEntryVitalityImage warning;
        private MdiEntryVitalityImage spinner;
        private MdiEntryVitalityImage info;

        protected deviceItem() {
        }

        protected void setMdiEntry(MdiEntry _sb_entry) {
            this.sb_entry = _sb_entry;
            this.warning = this.sb_entry.addVitalityImage(DeviceManagerUI.ALERT_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.warning);
            this.spinner = this.sb_entry.addVitalityImage(DeviceManagerUI.SPINNER_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.spinner);
            this.info = this.sb_entry.addVitalityImage(DeviceManagerUI.INFO_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.info);
        }

        protected MdiEntry getMdiEntry() {
            return this.sb_entry;
        }

        protected void setView(deviceView _view) {
            this.view = _view;
        }

        protected deviceView getView() {
            return this.view;
        }

        protected void setStatus(Device device) {
            if (this.warning != null && this.info != null) {
                String error = device.getError();
                if (error != null) {
                    DeviceManagerUI.hideIcon(this.info);
                    this.warning.setToolTip(error);
                    this.warning.setImageID(DeviceManagerUI.ALERT_IMAGE_ID);
                    this.warning.setVisible(true);
                } else {
                    DeviceManagerUI.hideIcon(this.warning);
                    String info_str = device.getInfo();
                    if (info_str != null) {
                        DeviceManagerUI.showIcon(this.info, info_str);
                    } else {
                        DeviceManagerUI.hideIcon(this.info);
                    }
                }
            }
            if (this.spinner != null) {
                this.spinner.setVisible(device.isBusy());
            }
            if (this.view != null) {
                this.view.refreshTitles();
            }
        }

        protected boolean isDestroyed() {
            return this.destroyed;
        }

        protected void destroy() {
            this.destroyed = true;
            if (this.sb_entry != null) {
                this.sb_entry.close(false);
            }
        }

        public void activate() {
            MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
            if (mdi != null && this.sb_entry != null) {
                mdi.showEntryByID(this.sb_entry.getId());
            }
        }
    }

    protected static class deviceView
    extends AbstractIView
    implements ViewTitleInfo,
    TranscodeTargetListener {
        private String parent_key;
        private Device device;
        private Composite parent_composite;
        private Composite composite;
        private int last_indicator;

        protected deviceView(String _parent_key, Device _device) {
            this.parent_key = _parent_key;
            this.device = _device;
            if (this.device instanceof DeviceMediaRenderer) {
                DeviceMediaRenderer renderer = (DeviceMediaRenderer)this.device;
                renderer.addListener(this);
            }
        }

        public void initialize(Composite _parent_composite) {
            this.parent_composite = _parent_composite;
            this.composite = new Composite(this.parent_composite, 0);
            FormLayout layout = new FormLayout();
            layout.marginTop = 4;
            layout.marginLeft = 4;
            layout.marginRight = 4;
            layout.marginBottom = 4;
            this.composite.setLayout(layout);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment(this.composite, 0);
            data.bottom = new FormAttachment(100, 0);
            Label label = new Label(this.composite, 0);
            label.setText("Nothing to show for " + this.device.getName());
            label.setLayoutData(data);
        }

        public Composite getComposite() {
            return this.composite;
        }

        public Object getTitleInfoProperty(int propertyID) {
            if (propertyID == 5) {
                return this.getTitle();
            }
            if (propertyID == 0) {
                if (!(this.device instanceof DeviceMediaRenderer) && this.device instanceof DeviceOfflineDownloader) {
                    DeviceOfflineDownloader dod = (DeviceOfflineDownloader)this.device;
                    this.last_indicator = dod.getTransferingCount();
                }
                if (this.last_indicator > 0) {
                    return String.valueOf(this.last_indicator);
                }
            } else if (propertyID != 8) {
                if (propertyID == 9) {
                    if (this.device.isLivenessDetectable()) {
                        return new Long(this.device.isAlive() ? 1L : 2L);
                    }
                } else if (propertyID == 1) {
                    return this.device.getStatus();
                }
            }
            return null;
        }

        public String getTitle() {
            return this.device.getName();
        }

        public void fileAdded(TranscodeFile file) {
        }

        public void fileChanged(TranscodeFile file, int type, Object data) {
            if (type == 1 && data == "comp") {
                this.refreshTitles();
            }
        }

        protected void refreshTitles() {
            MultipleDocumentInterface mdi;
            ViewTitleInfoManager.refreshTitleInfo(this);
            String key = this.parent_key;
            while (key != null && (mdi = UIFunctionsManager.getUIFunctions().getMDI()) != null) {
                MdiEntry parent = mdi.getEntry(key);
                if (parent != null) {
                    ViewTitleInfoManager.refreshTitleInfo(parent.getViewTitleInfo());
                    key = parent.getParentID();
                    continue;
                }
                key = null;
            }
        }

        public void fileRemoved(TranscodeFile file) {
        }

        public void delete() {
            super.delete();
            if (this.device instanceof DeviceMediaRenderer) {
                DeviceMediaRenderer renderer = (DeviceMediaRenderer)this.device;
                renderer.removeListener(this);
            }
        }
    }
}

