/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import com.aelitis.azureus.util.PlayUtils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class ColumnStream
extends CoreTableColumn
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "TorrentStream";
    public static final Class[] DATASOURCE_TYPES = new Class[]{DownloadTypeIncomplete.class, DiskManagerFileInfo.class};
    private static int WIDTH = 62;
    private static Image imgEnabled;
    private static Image imgDisabled;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "content"});
        info.setProficiency((byte)0);
    }

    public ColumnStream(String tableID) {
        super(COLUMN_ID, tableID);
        this.addDataSourceTypes(DATASOURCE_TYPES);
        this.initializeAsGraphic(WIDTH);
        this.setAlignment(3);
        imgEnabled = ImageLoader.getInstance().getImage("image.stream.small.on");
        imgDisabled = ImageLoader.getInstance().getImage("image.stream.small.off");
    }

    public void preAdd() {
        int position;
        TableColumn column;
        if (!this.isFirstLoad() || this.getPosition() >= 0 || this.getColumnAdded()) {
            return;
        }
        TableColumnManager tcManager = TableColumnManager.getInstance();
        TableColumnInfo columnInfoTAN = tcManager.getColumnInfo(null, this.getTableID(), "name");
        if (columnInfoTAN != null && (column = columnInfoTAN.getColumn()) != null && (position = column.getPosition()) >= 0) {
            this.setPosition(position + 1);
        }
    }

    private boolean noIconForYou(Object ds, TableCell cell) {
        if (!(ds instanceof DownloadManager)) {
            return false;
        }
        if (!(cell instanceof TableCellCore)) {
            return false;
        }
        DownloadManager dm = (DownloadManager)ds;
        TableRowCore rowCore = ((TableCellCore)cell).getTableRowCore();
        if (rowCore == null) {
            return false;
        }
        return dm.getAssumedComplete() || dm.getNumFileInfos() > 1 && rowCore.isExpanded();
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        Image img;
        Object ds = cell.getDataSource();
        if (this.noIconForYou(ds, cell)) {
            return;
        }
        boolean canStream = PlayUtils.canStreamDS(ds, -1);
        Image image = img = canStream ? imgEnabled : imgDisabled;
        if (!canStream && PlayUtils.canPlayDS(ds, -1)) {
            return;
        }
        Rectangle cellBounds = cell.getBounds();
        if (img != null && !img.isDisposed()) {
            Rectangle imgBounds = img.getBounds();
            gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
        }
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        int sortVal;
        Object ds = cell.getDataSource();
        if (this.noIconForYou(ds, cell)) {
            sortVal = 0;
        } else {
            boolean canStream = PlayUtils.canStreamDS(ds, -1);
            boolean canPlay = PlayUtils.canPlayDS(ds, -1);
            sortVal = (canStream ? 2 : 0) + (canPlay ? 0 : 1);
        }
        if (cell.setSortValue(sortVal)) {
            cell.invalidate();
        }
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        Object ds;
        if (event2.eventType == 0 && event2.button == 1 && PlayUtils.canStreamDS(ds = event2.cell.getDataSource(), -1)) {
            TorrentListViewsUtils.playOrStreamDataSource(ds, "column", true, false);
        }
    }

    public void cellHover(TableCell cell) {
        Object ds = cell.getDataSource();
        if (this.noIconForYou(ds, cell)) {
            cell.setToolTip(null);
            return;
        }
        if (PlayUtils.canStreamDS(ds, -1) || PlayUtils.canPlayDS(ds, -1)) {
            cell.setToolTip(null);
            return;
        }
        String id = "TableColumn.TorrentStream.tooltip.disabled";
        if (ds instanceof DownloadManager && ((DownloadManager)ds).getNumFileInfos() > 1) {
            id = "TableColumn.TorrentStream.tooltip.expand";
        }
        cell.setToolTip(MessageText.getString(id));
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

