/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.common.table;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableStructureModificationListener;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public class TableStructureEventDispatcher
implements TableStructureModificationListener {
    private static Map<String, TableStructureEventDispatcher> instances = new HashMap<String, TableStructureEventDispatcher>();
    private static AEMonitor class_mon = new AEMonitor("TableStructureEventDispatcher:class");
    private CopyOnWriteList listeners;
    private AEMonitor listeners_mon = new AEMonitor("TableStructureEventDispatcher:L");

    private TableStructureEventDispatcher() {
        this.listeners = new CopyOnWriteList(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableStructureEventDispatcher getInstance(String tableID) {
        try {
            class_mon.enter();
            TableStructureEventDispatcher instance = instances.get(tableID);
            if (instance == null) {
                instance = new TableStructureEventDispatcher();
                instances.put(tableID, instance);
            }
            TableStructureEventDispatcher tableStructureEventDispatcher = instance;
            Object var4_3 = null;
            class_mon.exit();
            return tableStructureEventDispatcher;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TableStructureModificationListener listener) {
        try {
            this.listeners_mon.enter();
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
            }
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TableStructureModificationListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    public void tableStructureChanged(boolean columnAddedOrRemoved, Class forPluginDataSourceType) {
        for (TableStructureModificationListener listener : this.listeners) {
            try {
                listener.tableStructureChanged(columnAddedOrRemoved, forPluginDataSourceType);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void columnSizeChanged(TableColumnCore tableColumn) {
        for (TableStructureModificationListener listener : this.listeners) {
            listener.columnSizeChanged(tableColumn);
        }
    }

    public void columnInvalidate(TableColumnCore tableColumn) {
        for (TableStructureModificationListener listener : this.listeners) {
            listener.columnInvalidate(tableColumn);
        }
    }

    public void cellInvalidate(TableColumnCore tableColumn, Object data_source) {
        for (TableStructureModificationListener listener : this.listeners) {
            listener.cellInvalidate(tableColumn, data_source);
        }
    }

    public void columnOrderChanged(int[] iPositions) {
        for (TableStructureModificationListener listener : this.listeners) {
            listener.columnOrderChanged(iPositions);
        }
    }
}

